/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class ThreadMetrics {
    private static final String COMMIT = "commit";
    private static final String COMMIT_LATENCY = "commit-latency";
    private static final String POLL = "poll";
    private static final String PROCESS = "process";
    private static final String PUNCTUATE = "punctuate";
    private static final String CREATE_TASK = "task-created";
    private static final String CLOSE_TASK = "task-closed";
    private static final String SKIP_RECORD = "skipped-records";
    private static final String COMMIT_DESCRIPTION = "calls to commit";
    private static final String COMMIT_TOTAL_DESCRIPTION = "The total number of calls to commit";
    private static final String COMMIT_RATE_DESCRIPTION = "The average per-second number of calls to commit";
    private static final String COMMIT_AVG_LATENCY_DESCRIPTION = "The average commit latency";
    private static final String COMMIT_MAX_LATENCY_DESCRIPTION = "The maximum commit latency";
    private static final String CREATE_TASK_DESCRIPTION = "newly created tasks";
    private static final String CREATE_TASK_TOTAL_DESCRIPTION = "The total number of newly created tasks";
    private static final String CREATE_TASK_RATE_DESCRIPTION = "The average per-second number of newly created tasks";
    private static final String CLOSE_TASK_DESCRIPTION = "closed tasks";
    private static final String CLOSE_TASK_TOTAL_DESCRIPTION = "The total number of closed tasks";
    private static final String CLOSE_TASK_RATE_DESCRIPTION = "The average per-second number of closed tasks";
    private static final String POLL_DESCRIPTION = "calls to poll";
    private static final String POLL_TOTAL_DESCRIPTION = "The total number of calls to poll";
    private static final String POLL_RATE_DESCRIPTION = "The average per-second number of calls to poll";
    private static final String POLL_AVG_LATENCY_DESCRIPTION = "The average poll latency";
    private static final String POLL_MAX_LATENCY_DESCRIPTION = "The maximum poll latency";
    private static final String PROCESS_DESCRIPTION = "calls to process";
    private static final String PROCESS_TOTAL_DESCRIPTION = "The total number of calls to process";
    private static final String PROCESS_RATE_DESCRIPTION = "The average per-second number of calls to process";
    private static final String PROCESS_AVG_LATENCY_DESCRIPTION = "The average process latency";
    private static final String PROCESS_MAX_LATENCY_DESCRIPTION = "The maximum process latency";
    private static final String PUNCTUATE_DESCRIPTION = "calls to punctuate";
    private static final String PUNCTUATE_TOTAL_DESCRIPTION = "The total number of calls to punctuate";
    private static final String PUNCTUATE_RATE_DESCRIPTION = "The average per-second number of calls to punctuate";
    private static final String PUNCTUATE_AVG_LATENCY_DESCRIPTION = "The average punctuate latency";
    private static final String PUNCTUATE_MAX_LATENCY_DESCRIPTION = "The maximum punctuate latency";
    private static final String SKIP_RECORDS_DESCRIPTION = "skipped records";
    private static final String SKIP_RECORD_TOTAL_DESCRIPTION = "The total number of skipped records";
    private static final String SKIP_RECORD_RATE_DESCRIPTION = "The average per-second number of skipped records";
    private static final String COMMIT_OVER_TASKS_DESCRIPTION = "calls to commit over all tasks assigned to one stream thread";
    private static final String COMMIT_OVER_TASKS_TOTAL_DESCRIPTION = "The total number of calls to commit over all tasks assigned to one stream thread";
    private static final String COMMIT_OVER_TASKS_RATE_DESCRIPTION = "The average per-second number of calls to commit over all tasks assigned to one stream thread";
    private static final String COMMIT_OVER_TASKS_AVG_LATENCY_DESCRIPTION = "The average commit latency over all tasks assigned to one stream thread";
    private static final String COMMIT_OVER_TASKS_MAX_LATENCY_DESCRIPTION = "The maximum commit latency over all tasks assigned to one stream thread";

    private ThreadMetrics() {
    }

    public static Sensor createTaskSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountSensor(threadId, CREATE_TASK, CREATE_TASK_RATE_DESCRIPTION, CREATE_TASK_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor closeTaskSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountSensor(threadId, CLOSE_TASK, CLOSE_TASK_RATE_DESCRIPTION, CLOSE_TASK_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor skipRecordSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountSensor(threadId, SKIP_RECORD, SKIP_RECORD_RATE_DESCRIPTION, SKIP_RECORD_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor commitSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, COMMIT, COMMIT_RATE_DESCRIPTION, COMMIT_TOTAL_DESCRIPTION, COMMIT_AVG_LATENCY_DESCRIPTION, COMMIT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor pollSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, POLL, POLL_RATE_DESCRIPTION, POLL_TOTAL_DESCRIPTION, POLL_AVG_LATENCY_DESCRIPTION, POLL_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor processSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION, PROCESS_AVG_LATENCY_DESCRIPTION, PROCESS_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor punctuateSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, PUNCTUATE, PUNCTUATE_RATE_DESCRIPTION, PUNCTUATE_TOTAL_DESCRIPTION, PUNCTUATE_AVG_LATENCY_DESCRIPTION, PUNCTUATE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor commitOverTasksSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor commitOverTasksSensor = streamsMetrics.threadLevelSensor(threadId, COMMIT, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.taskLevelTagMap(threadId, "all");
        StreamsMetricsImpl.addAvgAndMaxToSensor(commitOverTasksSensor, "stream-task-metrics", tagMap, COMMIT_LATENCY, COMMIT_OVER_TASKS_AVG_LATENCY_DESCRIPTION, COMMIT_OVER_TASKS_MAX_LATENCY_DESCRIPTION);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(commitOverTasksSensor, "stream-task-metrics", tagMap, COMMIT, COMMIT_OVER_TASKS_RATE_DESCRIPTION, COMMIT_OVER_TASKS_TOTAL_DESCRIPTION);
        return commitOverTasksSensor;
    }

    private static Sensor invocationRateAndCountSensor(String threadId, String metricName, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, metricName, recordingLevel, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, ThreadMetrics.threadLevelGroup(streamsMetrics), streamsMetrics.threadLevelTagMap(threadId), metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor invocationRateAndCountAndAvgAndMaxLatencySensor(String threadId, String metricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, metricName, recordingLevel, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        String threadLevelGroup = ThreadMetrics.threadLevelGroup(streamsMetrics);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, threadLevelGroup, tagMap, metricName + "-latency", descriptionOfAvg, descriptionOfMax);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, threadLevelGroup, tagMap, metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static String threadLevelGroup(StreamsMetricsImpl streamsMetrics) {
        return streamsMetrics.version() == StreamsMetricsImpl.Version.LATEST ? "stream-thread-metrics" : "stream-metrics";
    }
}

