/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.assignment.AssignorError;
import org.slf4j.Logger;

public class StreamsRebalanceListener
implements ConsumerRebalanceListener {
    private final Time time;
    private final TaskManager taskManager;
    private final StreamThread streamThread;
    private final Logger log;
    private final AtomicInteger assignmentErrorCode;

    StreamsRebalanceListener(Time time, TaskManager taskManager, StreamThread streamThread, Logger log, AtomicInteger assignmentErrorCode) {
        this.time = time;
        this.taskManager = taskManager;
        this.streamThread = streamThread;
        this.log = log;
        this.assignmentErrorCode = assignmentErrorCode;
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        if (this.assignmentErrorCode.get() == AssignorError.INCOMPLETE_SOURCE_TOPIC_METADATA.code()) {
            this.log.error("Received error code {} - shutdown", (Object)this.assignmentErrorCode.get());
            this.streamThread.shutdown();
        } else {
            this.streamThread.setState(StreamThread.State.PARTITIONS_ASSIGNED);
        }
        this.taskManager.handleRebalanceComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        this.log.debug("Current state {}: revoked partitions {} because of consumer rebalance.\n\tcurrently assigned active tasks: {}\n\tcurrently assigned standby tasks: {}\n", new Object[]{this.streamThread.state(), partitions, this.taskManager.activeTaskIds(), this.taskManager.standbyTaskIds()});
        if (!(this.streamThread.setState(StreamThread.State.PARTITIONS_REVOKED) == null && this.streamThread.state() != StreamThread.State.PENDING_SHUTDOWN || partitions.isEmpty())) {
            long start = this.time.milliseconds();
            try {
                this.taskManager.handleRevocation(partitions);
            }
            finally {
                this.log.info("partition revocation took {} ms.", (Object)(this.time.milliseconds() - start));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartitionsLost(Collection<TopicPartition> partitions) {
        this.log.info("at state {}: partitions {} lost due to missed rebalance.\n\tlost active tasks: {}\n\tlost assigned standby tasks: {}\n", new Object[]{this.streamThread.state(), partitions, this.taskManager.activeTaskIds(), this.taskManager.standbyTaskIds()});
        long start = this.time.milliseconds();
        try {
            this.taskManager.handleLostAll();
        }
        finally {
            this.log.info("partitions lost took {} ms.", (Object)(this.time.milliseconds() - start));
        }
    }
}

