/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerde;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;

public class WrappingNullableUtils {
    private static <T> Deserializer<T> prepareDeserializer(Deserializer<T> specificDeserializer, Deserializer<?> contextKeyDeserializer, Deserializer<?> contextValueDeserializer, boolean isKey) {
        Object deserializerToUse = specificDeserializer;
        if (deserializerToUse == null) {
            deserializerToUse = isKey ? contextKeyDeserializer : contextValueDeserializer;
        } else {
            WrappingNullableUtils.initNullableDeserializer(deserializerToUse, contextKeyDeserializer, contextValueDeserializer);
        }
        return deserializerToUse;
    }

    private static <T> Serializer<T> prepareSerializer(Serializer<T> specificSerializer, Serializer<?> contextKeySerializer, Serializer<?> contextValueSerializer, boolean isKey) {
        Object serializerToUse = specificSerializer;
        if (serializerToUse == null) {
            serializerToUse = isKey ? contextKeySerializer : contextValueSerializer;
        } else {
            WrappingNullableUtils.initNullableSerializer(serializerToUse, contextKeySerializer, contextValueSerializer);
        }
        return serializerToUse;
    }

    private static <T> Serde<T> prepareSerde(Serde<T> specificSerde, Serde<?> contextKeySerde, Serde<?> contextValueSerde, boolean isKey) {
        Object serdeToUse = specificSerde;
        if (serdeToUse == null) {
            serdeToUse = isKey ? contextKeySerde : contextValueSerde;
        } else if (serdeToUse instanceof WrappingNullableSerde) {
            ((WrappingNullableSerde)serdeToUse).setIfUnset(contextKeySerde, contextValueSerde);
        }
        return serdeToUse;
    }

    public static <K> Deserializer<K> prepareKeyDeserializer(Deserializer<K> specificDeserializer, Deserializer<?> contextKeyDeserializer, Deserializer<?> contextValueDeserializer) {
        return WrappingNullableUtils.prepareDeserializer(specificDeserializer, contextKeyDeserializer, contextValueDeserializer, true);
    }

    public static <V> Deserializer<V> prepareValueDeserializer(Deserializer<V> specificDeserializer, Deserializer<?> contextKeyDeserializer, Deserializer<?> contextValueDeserializer) {
        return WrappingNullableUtils.prepareDeserializer(specificDeserializer, contextKeyDeserializer, contextValueDeserializer, false);
    }

    public static <K> Serializer<K> prepareKeySerializer(Serializer<K> specificSerializer, Serializer<?> contextKeySerializer, Serializer<?> contextValueSerializer) {
        return WrappingNullableUtils.prepareSerializer(specificSerializer, contextKeySerializer, contextValueSerializer, true);
    }

    public static <V> Serializer<V> prepareValueSerializer(Serializer<V> specificSerializer, Serializer<?> contextKeySerializer, Serializer<?> contextValueSerializer) {
        return WrappingNullableUtils.prepareSerializer(specificSerializer, contextKeySerializer, contextValueSerializer, false);
    }

    public static <K> Serde<K> prepareKeySerde(Serde<K> specificSerde, Serde<?> keySerde, Serde<?> valueSerde) {
        return WrappingNullableUtils.prepareSerde(specificSerde, keySerde, valueSerde, true);
    }

    public static <V> Serde<V> prepareValueSerde(Serde<V> specificSerde, Serde<?> keySerde, Serde<?> valueSerde) {
        return WrappingNullableUtils.prepareSerde(specificSerde, keySerde, valueSerde, false);
    }

    public static <T> void initNullableSerializer(Serializer<T> specificSerializer, Serializer<?> contextKeySerializer, Serializer<?> contextValueSerializer) {
        if (specificSerializer instanceof WrappingNullableSerializer) {
            ((WrappingNullableSerializer)specificSerializer).setIfUnset(contextKeySerializer, contextValueSerializer);
        }
    }

    public static <T> void initNullableDeserializer(Deserializer<T> specificDeserializer, Deserializer<?> contextKeyDeserializer, Deserializer<?> contextValueDeserializer) {
        if (specificDeserializer instanceof WrappingNullableDeserializer) {
            ((WrappingNullableDeserializer)specificDeserializer).setIfUnset(contextKeyDeserializer, contextValueDeserializer);
        }
    }
}

