/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;

public abstract class AbstractProcessorContext
implements InternalProcessorContext {
    public static final String NONEXIST_TOPIC = "__null_topic__";
    private final TaskId taskId;
    private final String applicationId;
    private final StreamsConfig config;
    private final StreamsMetricsImpl metrics;
    private final Serde<?> keySerde;
    private final Serde<?> valueSerde;
    private boolean initialized;
    protected ProcessorRecordContext recordContext;
    protected ProcessorNode<?, ?> currentNode;
    private long currentSystemTimeMs;
    final StateManager stateManager;
    protected ThreadCache cache;

    public AbstractProcessorContext(TaskId taskId, StreamsConfig config, StreamsMetricsImpl metrics, StateManager stateManager, ThreadCache cache) {
        this.taskId = taskId;
        this.applicationId = config.getString("application.id");
        this.config = config;
        this.metrics = metrics;
        this.stateManager = stateManager;
        this.valueSerde = config.defaultValueSerde();
        this.keySerde = config.defaultKeySerde();
        this.cache = cache;
    }

    @Override
    public void setSystemTimeMs(long timeMs) {
        this.currentSystemTimeMs = timeMs;
    }

    @Override
    public long currentSystemTimeMs() {
        return this.currentSystemTimeMs;
    }

    @Override
    public String applicationId() {
        return this.applicationId;
    }

    @Override
    public TaskId taskId() {
        return this.taskId;
    }

    @Override
    public Serde<?> keySerde() {
        return this.keySerde;
    }

    @Override
    public Serde<?> valueSerde() {
        return this.valueSerde;
    }

    @Override
    public File stateDir() {
        return this.stateManager.baseDir();
    }

    @Override
    public StreamsMetricsImpl metrics() {
        return this.metrics;
    }

    @Override
    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        if (this.initialized) {
            throw new IllegalStateException("Can only create state stores during initialization.");
        }
        Objects.requireNonNull(store, "store must not be null");
        this.stateManager.registerStore(store, stateRestoreCallback);
    }

    @Override
    public String topic() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as topic() should only be called while a record is processed");
        }
        String topic = this.recordContext.topic();
        if (topic.equals(NONEXIST_TOPIC)) {
            return null;
        }
        return topic;
    }

    @Override
    public int partition() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as partition() should only be called while a record is processed");
        }
        return this.recordContext.partition();
    }

    @Override
    public long offset() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as offset() should only be called while a record is processed");
        }
        return this.recordContext.offset();
    }

    @Override
    public Headers headers() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as headers() should only be called while a record is processed");
        }
        return this.recordContext.headers();
    }

    @Override
    public long timestamp() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as timestamp() should only be called while a record is processed");
        }
        return this.recordContext.timestamp();
    }

    @Override
    public Map<String, Object> appConfigs() {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        combined.putAll(this.config.originals());
        combined.putAll(this.config.values());
        return combined;
    }

    @Override
    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.config.originalsWithPrefix(prefix);
    }

    @Override
    public void setRecordContext(ProcessorRecordContext recordContext) {
        this.recordContext = recordContext;
    }

    @Override
    public ProcessorRecordContext recordContext() {
        return this.recordContext;
    }

    @Override
    public void setCurrentNode(ProcessorNode<?, ?> currentNode) {
        this.currentNode = currentNode;
    }

    @Override
    public ProcessorNode<?, ?> currentNode() {
        return this.currentNode;
    }

    @Override
    public ThreadCache cache() {
        return this.cache;
    }

    @Override
    public void initialize() {
        this.initialized = true;
    }

    @Override
    public void uninitialize() {
        this.initialized = false;
    }

    @Override
    public Task.TaskType taskType() {
        return this.stateManager.taskType();
    }
}

