/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamAggregate<K, V, T>
implements KStreamAggProcessorSupplier<K, K, V, T> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamAggregate.class);
    private final String storeName;
    private final Initializer<T> initializer;
    private final Aggregator<? super K, ? super V, T> aggregator;
    private boolean sendOldValues = false;

    KStreamAggregate(String storeName, Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator) {
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamAggregateProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<K, T> view() {
        return new KTableValueGetterSupplier<K, T>(){

            @Override
            public KTableValueGetter<K, T> get() {
                return new KStreamAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamAggregate.this.storeName};
            }
        };
    }

    private class KStreamAggregateValueGetter
    implements KTableValueGetter<K, T> {
        private TimestampedKeyValueStore<K, T> store;

        private KStreamAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (TimestampedKeyValueStore)context.getStateStore(KStreamAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<T> get(K key) {
            return (ValueAndTimestamp)this.store.get(key);
        }
    }

    private class KStreamAggregateProcessor
    extends AbstractProcessor<K, V> {
        private TimestampedKeyValueStore<K, T> store;
        private Sensor droppedRecordsSensor;
        private TimestampedTupleForwarder<K, T> tupleForwarder;

        private KStreamAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), (StreamsMetricsImpl)context.metrics());
            this.store = (TimestampedKeyValueStore)context.getStateStore(KStreamAggregate.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KStreamAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            long newTimestamp;
            if (key == null || value == null) {
                LOG.warn("Skipping record due to null key or value. key=[{}] value=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{key, value, this.context().topic(), this.context().partition(), this.context().offset()});
                this.droppedRecordsSensor.record();
                return;
            }
            ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.store.get(key);
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            if (oldAgg == null) {
                oldAgg = KStreamAggregate.this.initializer.apply();
                newTimestamp = this.context().timestamp();
            } else {
                oldAgg = oldAggAndTimestamp.value();
                newTimestamp = Math.max(this.context().timestamp(), oldAggAndTimestamp.timestamp());
            }
            Object newAgg = KStreamAggregate.this.aggregator.apply(key, value, oldAgg);
            this.store.put(key, ValueAndTimestamp.make(newAgg, newTimestamp));
            this.tupleForwarder.maybeForward(key, newAgg, KStreamAggregate.this.sendOldValues ? oldAgg : null, newTimestamp);
        }
    }
}

