/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class ValueAndTimestampDeserializer<V>
implements WrappingNullableDeserializer<ValueAndTimestamp<V>, Void, V> {
    private static final LongDeserializer LONG_DESERIALIZER = new LongDeserializer();
    public final Deserializer<V> valueDeserializer;
    private final Deserializer<Long> timestampDeserializer;

    ValueAndTimestampDeserializer(Deserializer<V> valueDeserializer) {
        Objects.requireNonNull(valueDeserializer);
        this.valueDeserializer = valueDeserializer;
        this.timestampDeserializer = new LongDeserializer();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.valueDeserializer.configure(configs, isKey);
        this.timestampDeserializer.configure(configs, isKey);
    }

    public ValueAndTimestamp<V> deserialize(String topic, byte[] valueAndTimestamp) {
        if (valueAndTimestamp == null) {
            return null;
        }
        long timestamp = (Long)this.timestampDeserializer.deserialize(topic, ValueAndTimestampDeserializer.rawTimestamp(valueAndTimestamp));
        Object value = this.valueDeserializer.deserialize(topic, ValueAndTimestampDeserializer.rawValue(valueAndTimestamp));
        return ValueAndTimestamp.make(value, timestamp);
    }

    public void close() {
        this.valueDeserializer.close();
        this.timestampDeserializer.close();
    }

    static byte[] rawValue(byte[] rawValueAndTimestamp) {
        int rawValueLength = rawValueAndTimestamp.length - 8;
        return ByteBuffer.allocate(rawValueLength).put(rawValueAndTimestamp, 8, rawValueLength).array();
    }

    private static byte[] rawTimestamp(byte[] rawValueAndTimestamp) {
        return ByteBuffer.allocate(8).put(rawValueAndTimestamp, 0, 8).array();
    }

    static long timestamp(byte[] rawValueAndTimestamp) {
        return LONG_DESERIALIZER.deserialize(null, ValueAndTimestampDeserializer.rawTimestamp(rawValueAndTimestamp));
    }

    @Override
    public void setIfUnset(Deserializer<Void> defaultKeyDeserializer, Deserializer<V> defaultValueDeserializer) {
        WrappingNullableUtils.initNullableDeserializer(this.valueDeserializer, defaultKeyDeserializer, defaultValueDeserializer);
    }
}

