/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Optional;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamJoin;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;

class KStreamKStreamJoinRightSide<K, VLeft, VRight, VOut>
extends KStreamKStreamJoin<K, VLeft, VRight, VOut, VRight, VLeft> {
    KStreamKStreamJoinRightSide(String otherWindowName, JoinWindowsInternal windows, ValueJoinerWithKey<? super K, ? super VRight, ? super VLeft, ? extends VOut> joiner, boolean outer, Optional<String> outerJoinWindowName, KStreamImplJoin.TimeTrackerSupplier sharedTimeTrackerSupplier) {
        super(otherWindowName, windows, joiner, outer, outerJoinWindowName, windows.afterMs, windows.beforeMs, sharedTimeTrackerSupplier);
    }

    @Override
    public Processor<K, VRight, K, VOut> get() {
        return new KStreamKStreamRightJoinProcessor();
    }

    private class KStreamKStreamRightJoinProcessor
    extends KStreamKStreamJoin.KStreamKStreamJoinProcessor {
        private KStreamKStreamRightJoinProcessor() {
            super(KStreamKStreamJoinRightSide.this);
        }

        @Override
        public TimestampedKeyAndJoinSide<K> makeThisKey(K key, long timestamp) {
            return TimestampedKeyAndJoinSide.makeRight(key, timestamp);
        }

        public LeftOrRightValue<VLeft, VRight> makeThisValue(VRight thisValue) {
            return LeftOrRightValue.makeRightValue(thisValue);
        }

        @Override
        public TimestampedKeyAndJoinSide<K> makeOtherKey(K key, long timestamp) {
            return TimestampedKeyAndJoinSide.makeLeft(key, timestamp);
        }

        public VRight getThisValue(LeftOrRightValue<? extends VLeft, ? extends VRight> leftOrRightValue) {
            return leftOrRightValue.getRightValue();
        }

        public VLeft getOtherValue(LeftOrRightValue<? extends VLeft, ? extends VRight> leftOrRightValue) {
            return leftOrRightValue.getLeftValue();
        }
    }
}

