/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public final class WorkerUtils {
    private static final int CREATE_TOPICS_REQUEST_TIMEOUT = 25000;
    private static final int CREATE_TOPICS_CALL_TIMEOUT = 90000;
    private static final int MAX_CREATE_TOPICS_BATCH_SIZE = 10;

    public static void abort(Logger log, String what, Throwable exception, KafkaFutureImpl<String> doneFuture) throws KafkaException {
        log.warn("{} caught an exception: ", (Object)what, (Object)exception);
        doneFuture.complete((Object)exception.getMessage());
        throw new KafkaException(exception);
    }

    public static int perSecToPerPeriod(float perSec, long periodMs) {
        float period = (float)periodMs / 1000.0f;
        float perPeriod = perSec * period;
        perPeriod = Math.max(1.0f, perPeriod);
        return (int)perPeriod;
    }

    public static void createTopics(Logger log, String bootstrapServers, Collection<NewTopic> topics) throws Throwable {
        block20: {
            Properties props = new Properties();
            props.put("bootstrap.servers", bootstrapServers);
            props.put("request.timeout.ms", (Object)25000);
            try (AdminClient adminClient = AdminClient.create((Properties)props);){
                long startMs = Time.SYSTEM.milliseconds();
                int tries = 0;
                HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
                for (NewTopic newTopic : topics) {
                    newTopics.put(newTopic.name(), newTopic);
                }
                ArrayList topicsToCreate = new ArrayList(newTopics.keySet());
                do {
                    String topicName;
                    log.info("Attemping to create {} topics (try {})...", (Object)topicsToCreate.size(), (Object)(++tries));
                    HashMap creations = new HashMap();
                    while (!topicsToCreate.isEmpty()) {
                        ArrayList newTopicsBatch = new ArrayList();
                        for (int i = 0; i < 10 && !topicsToCreate.isEmpty(); ++i) {
                            topicName = (String)topicsToCreate.remove(0);
                            newTopicsBatch.add(newTopics.get(topicName));
                        }
                        creations.putAll(adminClient.createTopics(newTopicsBatch).values());
                    }
                    for (Map.Entry entry : creations.entrySet()) {
                        topicName = (String)entry.getKey();
                        Future future = (Future)entry.getValue();
                        try {
                            future.get();
                            log.debug("Successfully created {}.", (Object)topicName);
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof TimeoutException) {
                                log.warn("Timed out attempting to create {}: {}", (Object)topicName, (Object)e.getCause().getMessage());
                                topicsToCreate.add(topicName);
                                continue;
                            }
                            log.warn("Failed to create {}", (Object)topicName, (Object)e.getCause());
                            throw e.getCause();
                        }
                    }
                    if (!topicsToCreate.isEmpty()) continue;
                    break block20;
                } while (Time.SYSTEM.milliseconds() <= startMs + 90000L);
                String str = "Unable to create topic(s): " + Utils.join(topicsToCreate, (String)", ") + "after " + tries + " attempt(s)";
                log.warn(str);
                throw new TimeoutException(str);
            }
        }
    }
}

