/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;

public class TrogdorMetrics
implements AutoCloseable {
    private final Sensor createdTasks;
    private final Sensor runningTasks;
    private final Sensor doneTasks;
    private final Sensor activeAgents;
    private final Metrics metrics;
    private final List<Sensor> sensors = new ArrayList<Sensor>();

    public TrogdorMetrics(Metrics metrics, String metricGrpPrefix) {
        this.metrics = metrics;
        String metricGroupName = metricGrpPrefix + "-metrics";
        this.createdTasks = this.sensor("tasks-created", new Sensor[0]);
        MetricName createdTasksMetricName = metrics.metricName("created-task-count", metricGroupName, "The total number of created tasks in the Trogdor cluster");
        this.createdTasks.add(createdTasksMetricName, (MeasurableStat)new CumulativeSum());
        this.runningTasks = this.sensor("tasks-running", new Sensor[0]);
        MetricName runningTasksMetricName = metrics.metricName("running-task-count", metricGroupName, "The total number of running tasks in the Trogdor cluster");
        this.runningTasks.add(runningTasksMetricName, (MeasurableStat)new CumulativeSum());
        this.doneTasks = this.sensor("tasks-done", new Sensor[0]);
        MetricName doneTasksMetricName = metrics.metricName("done-task-count", metricGroupName, "The total number of done tasks in the Trogdor cluster");
        this.doneTasks.add(doneTasksMetricName, (MeasurableStat)new CumulativeSum());
        this.activeAgents = this.sensor("active-agents", new Sensor[0]);
        MetricName activeAgentsMetricName = metrics.metricName("active-agents-count", metricGroupName, "The total number of active agents in the Trogdor cluster");
        this.activeAgents.add(activeAgentsMetricName, (MeasurableStat)new CumulativeSum());
    }

    private Sensor sensor(String name, Sensor ... parents) {
        Sensor sensor = this.metrics.sensor(name, parents);
        this.sensors.add(sensor);
        return sensor;
    }

    @Override
    public void close() {
        for (Sensor sensor : this.sensors) {
            this.metrics.removeSensor(sensor.name());
        }
        this.metrics.close();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void recordCreatedTask() {
        this.createdTasks.record(1.0);
    }

    public void recordRunningTask() {
        this.runningTasks.record(1.0);
    }

    public void recordDoneTask() {
        this.doneTasks.record(1.0);
    }

    public void recordActiveAgent() {
        this.activeAgents.record(1.0);
    }
}

