/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.AclBenchWorker;

public class AclWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String bootstrapServers;
    private final int noOfThreads;
    private final int targetOperationsPerSec;
    private final int minSupportedOpsPerSec;
    private final boolean aclDeletes;
    private final String adminJaasConfig;
    private final String securityProtocol;
    private final String saslMechanism;

    @JsonCreator
    public AclWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetOperationsPerSec") int targetOperationsPerSec, @JsonProperty(value="minSupportedOpsPerSec") int minSupportedOpsPerSec, @JsonProperty(value="aclDeletes") boolean aclDeletes, @JsonProperty(value="noOfThreads") int noOfThreads, @JsonProperty(value="adminJaasConfig") String adminJaasConfig, @JsonProperty(value="securityProtocol") String securityProtocol, @JsonProperty(value="saslMechanism") String saslMechanism) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetOperationsPerSec = targetOperationsPerSec;
        this.minSupportedOpsPerSec = minSupportedOpsPerSec;
        this.aclDeletes = aclDeletes;
        this.noOfThreads = noOfThreads;
        this.adminJaasConfig = adminJaasConfig;
        this.saslMechanism = saslMechanism;
        this.securityProtocol = securityProtocol;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetOperationsPerSec() {
        return this.targetOperationsPerSec;
    }

    @JsonProperty
    public int minSupportedOpsPerSec() {
        return this.minSupportedOpsPerSec;
    }

    @JsonProperty
    public int noOfThreads() {
        return this.noOfThreads;
    }

    @JsonProperty
    public boolean aclDeletes() {
        return this.aclDeletes;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @JsonProperty
    public String adminJaasConfig() {
        return this.adminJaasConfig;
    }

    @JsonProperty
    public String saslMechanism() {
        return this.saslMechanism;
    }

    @JsonProperty
    public String securityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new AclBenchWorker(id, this);
    }
}

