/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.SchemaRegistryWorker;

public class SchemaRegistryWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String schemaRegistryUrl;
    private final boolean parseResult;
    private final int numSchemas;
    private final int targetCallsPerSec;

    @JsonCreator
    public SchemaRegistryWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="schemaRegistryUrl") String schemaRegistryUrl, @JsonProperty(value="parseResult") boolean parseResult, @JsonProperty(value="numSchemas") int numSchemas, @JsonProperty(value="targetCallsPerSec") int targetCallsPerSec) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.parseResult = parseResult;
        this.numSchemas = numSchemas;
        this.targetCallsPerSec = targetCallsPerSec;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public int targetCallsPerSec() {
        return this.targetCallsPerSec;
    }

    @JsonProperty
    public boolean parseResult() {
        return this.parseResult;
    }

    @JsonProperty
    public int numSchemas() {
        return this.numSchemas;
    }

    @JsonProperty
    public String schemaRegistryUrl() {
        return this.schemaRegistryUrl;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new SchemaRegistryWorker(id, this);
    }
}

