/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001\u001d\u0011QCQ;gM\u0016\u0014\u0018N\\4PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\t!![8\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u0005Y1/Z4nK:$8+\u001b>f!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\rIe\u000e\u001e\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mi\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"B\t\u0019\u0001\u0004\u0011b\u0001B\u0010\u0001\u0015\u0001\u0012qaU3h[\u0016tGo\u0005\u0002\u001fCA\u00111CI\u0005\u0003GQ\u0011a!\u00118z%\u00164\u0007\u0002C\u0013\u001f\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\tML'0\u001a\u0005\u00063y!\ta\n\u000b\u0003Q)\u0002\"!\u000b\u0010\u000e\u0003\u0001AQ!\n\u0014A\u0002IAq\u0001\f\u0010C\u0002\u0013\u0005Q&A\u0003csR,7/F\u0001/!\r\u0019r&M\u0005\u0003aQ\u0011Q!\u0011:sCf\u0004\"a\u0005\u001a\n\u0005M\"\"\u0001\u0002\"zi\u0016Da!\u000e\u0010!\u0002\u0013q\u0013A\u00022zi\u0016\u001c\b\u0005C\u00048=\u0001\u0007I\u0011\u0001\u001d\u0002\u000f]\u0014\u0018\u000e\u001e;f]V\t!\u0003C\u0004;=\u0001\u0007I\u0011A\u001e\u0002\u0017]\u0014\u0018\u000e\u001e;f]~#S-\u001d\u000b\u0003y}\u0002\"aE\u001f\n\u0005y\"\"\u0001B+oSRDq\u0001Q\u001d\u0002\u0002\u0003\u0007!#A\u0002yIEBaA\u0011\u0010!B\u0013\u0011\u0012\u0001C<sSR$XM\u001c\u0011\t\u000f\u0011s\u0002\u0019!C\u0001\u000b\u0006!a.\u001a=u+\u0005A\u0003bB$\u001f\u0001\u0004%\t\u0001S\u0001\t]\u0016DHo\u0018\u0013fcR\u0011A(\u0013\u0005\b\u0001\u001a\u000b\t\u00111\u0001)\u0011\u0019Ye\u0004)Q\u0005Q\u0005)a.\u001a=uA!)QJ\bC\u0001q\u0005IaM]3f'B\f7-\u001a\u0004\u0005\u001f\u0002A\u0001K\u0001\bSKN,'O^3e\u001fV$\b/\u001e;\u0014\u00059C\u0001\u0002\u0003*O\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0007M,w\r\u0003\u0005U\u001d\n\u0005\t\u0015!\u0003\u0013\u0003\u0019ygMZ:fi\"AaK\u0014B\u0001B\u0003%!#\u0001\u0004mK:<G\u000f\u001b\u0005\u000639#\t\u0001\u0017\u000b\u00053j[F\f\u0005\u0002*\u001d\")!k\u0016a\u0001Q!)Ak\u0016a\u0001%!)ak\u0016a\u0001%!1aL\u0014Q!\n!\n1aY;s\u0011\u0019\u0001g\n)Q\u0005%\u0005\u0019qN\u001a4\t\r\tt\u0005\u0015)\u0003\u0013\u0003\raWM\u001c\u0005\u0006I:#\t%Z\u0001\u0006oJLG/\u001a\u000b\u0003y\u0019DQaZ2A\u0002I\tQA^1mk\u0016Dq!\u001b\u0001A\u0002\u0013EQ)\u0001\bdkJ\u0014XM\u001c;TK\u001elWM\u001c;\t\u000f-\u0004\u0001\u0019!C\tY\u0006\u00112-\u001e:sK:$8+Z4nK:$x\fJ3r)\taT\u000eC\u0004AU\u0006\u0005\t\u0019\u0001\u0015\t\r=\u0004\u0001\u0015)\u0003)\u0003=\u0019WO\u001d:f]R\u001cVmZ7f]R\u0004\u0003BB9\u0001A\u0003%\u0001&A\u0006iK\u0006$7+Z4nK:$\bBB:\u0001A\u0003&!#\u0001\u0004gS2dW\r\u001a\u0005\u0006K\u0001!\t!\u001e\u000b\u0002%!)A\r\u0001C!oR\u0011A\b\u001f\u0005\u0006sZ\u0004\rAE\u0001\u0002E\")A\r\u0001C!wR!A\b`?\u007f\u0011\u0015I(\u00101\u0001/\u0011\u0015\u0001'\u00101\u0001\u0013\u0011\u0015\u0011'\u00101\u0001\u0013\u0011\u0019!\u0007\u0001\"\u0001\u0002\u0002Q\u0019A(a\u0001\t\u000f\u0005\u0015q\u00101\u0001\u0002\b\u0005\u0011\u0011N\u001c\t\u0004\u0013\u0005%\u0011bAA\u0006\u0015\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\ty\u0001\u0001C\u0005\u0003#\t!\"\u00193e'\u0016<W.\u001a8u)\u0005a\u0004bBA\u000b\u0001\u0011%\u0011qC\u0001\u0005g.L\u0007\u000fF\u0002=\u00033AaAYA\n\u0001\u0004\u0011\u0002bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\be\u0016\u001cXM\u001d<f)\rI\u0016\u0011\u0005\u0005\u0007E\u0006m\u0001\u0019\u0001\n\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u00059qO]5uKR{Gc\u0001\u001f\u0002*!A\u00111FA\u0012\u0001\u0004\ti#\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0007\u0002\u00079Lw.\u0003\u0003\u00028\u0005E\"A\u0003\"zi\u0016\u0014UO\u001a4fe\u0002")
public class BufferingOutputStream
extends OutputStream {
    private final int segmentSize;
    private Segment currentSegment;
    private final Segment headSegment;
    private int filled;

    public Segment currentSegment() {
        return this.currentSegment;
    }

    public void currentSegment_$eq(Segment x$1) {
        this.currentSegment = x$1;
    }

    public int size() {
        return this.filled + this.currentSegment().written();
    }

    @Override
    public void write(int b) {
        if (this.currentSegment().freeSpace() <= 0) {
            this.addSegment();
        }
        this.currentSegment().bytes()[this.currentSegment().written()] = (byte)b;
        Segment segment = this.currentSegment();
        segment.written_$eq(segment.written() + 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off >= 0 && off <= b.length && len >= 0 && off + len <= b.length) {
            int amount;
            int offset = off;
            for (int remaining = len; remaining > 0; remaining -= amount) {
                if (this.currentSegment().freeSpace() <= 0) {
                    this.addSegment();
                }
                amount = package$.MODULE$.min(this.currentSegment().freeSpace(), remaining);
                System.arraycopy(b, offset, this.currentSegment().bytes(), this.currentSegment().written(), amount);
                Segment segment = this.currentSegment();
                segment.written_$eq(segment.written() + amount);
                offset += amount;
            }
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    public void write(InputStream in) {
        int amount = 0;
        while (amount >= 0) {
            Segment segment = this.currentSegment();
            segment.written_$eq(segment.written() + amount);
            if (this.currentSegment().freeSpace() <= 0) {
                this.addSegment();
            }
            amount = in.read(this.currentSegment().bytes(), this.currentSegment().written(), this.currentSegment().freeSpace());
        }
    }

    private void addSegment() {
        this.filled += this.currentSegment().written();
        Segment newSeg = new Segment(this, this.segmentSize);
        this.currentSegment().next_$eq(newSeg);
        this.currentSegment_$eq(newSeg);
    }

    private void skip(int len) {
        if (len >= 0) {
            int amount;
            for (int remaining = len; remaining > 0; remaining -= amount) {
                if (this.currentSegment().freeSpace() <= 0) {
                    this.addSegment();
                }
                amount = package$.MODULE$.min(this.currentSegment().freeSpace(), remaining);
                Segment segment = this.currentSegment();
                segment.written_$eq(segment.written() + amount);
            }
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    public ReservedOutput reserve(int len) {
        void var2_2;
        ReservedOutput out = new ReservedOutput(this.currentSegment(), this.currentSegment().written(), len);
        this.skip(len);
        return var2_2;
    }

    public void writeTo(ByteBuffer buffer) {
        Segment seg = this.headSegment;
        while (seg != null) {
            buffer.put(seg.bytes(), 0, seg.written());
            seg = seg.next();
        }
        return;
    }

    public BufferingOutputStream(int segmentSize) {
        this.segmentSize = segmentSize;
        this.currentSegment = new Segment(this, segmentSize);
        this.headSegment = this.currentSegment();
        this.filled = 0;
    }

    public final class Segment {
        private final byte[] bytes;
        private int written;
        private Segment next;

        public byte[] bytes() {
            return this.bytes;
        }

        public int written() {
            return this.written;
        }

        public void written_$eq(int x$1) {
            this.written = x$1;
        }

        public Segment next() {
            return this.next;
        }

        public void next_$eq(Segment x$1) {
            this.next = x$1;
        }

        public int freeSpace() {
            return this.bytes().length - this.written();
        }

        public Segment(BufferingOutputStream $outer, int size2) {
            this.bytes = new byte[size2];
            this.written = 0;
            this.next = null;
        }
    }

    public class ReservedOutput
    extends OutputStream {
        private Segment cur;
        private int off;
        private int len;

        @Override
        public void write(int value2) {
            if (this.len <= 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.cur.bytes().length <= this.off) {
                this.cur = this.cur.next();
                this.off = 0;
            }
            this.cur.bytes()[this.off] = (byte)value2;
            ++this.off;
            --this.len;
        }

        public /* synthetic */ BufferingOutputStream kafka$message$BufferingOutputStream$ReservedOutput$$$outer() {
            return BufferingOutputStream.this;
        }

        public ReservedOutput(Segment seg, int offset, int length) {
            if (BufferingOutputStream.this == null) {
                throw new NullPointerException();
            }
            this.cur = seg;
            this.off = offset;
            this.len = length;
        }
    }
}

