/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$;
import kafka.api.BaseProducerSendTest$callback$2$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005]!\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0003y\u0012aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0015\u0003\u0001\u00022!I\u0016/\u001d\t\u0011\u0003F\u0004\u0002$M5\tAE\u0003\u0002&\r\u00051AH]8pizJ\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S)\nq\u0001]1dW\u0006<WMC\u0001(\u0013\taSFA\u0002TKFT!!\u000b\u0016\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011AB:feZ,'/\u0003\u00024a\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d)\u0004\u00011A\u0005\nY\n\u0011bY8ogVlWM]\u0019\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0003\u0002\u0011\r|gn];nKJL!\u0001P\u001d\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe\"9a\b\u0001a\u0001\n\u0013y\u0014!D2p]N,X.\u001a:2?\u0012*\u0017\u000f\u0006\u0002A\tB\u0011\u0011IQ\u0007\u0002U%\u00111I\u000b\u0002\u0005+:LG\u000fC\u0004F{\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004H\u0001\u0001\u0006KaN\u0001\u000bG>t7/^7feF\u0002\u0003bB%\u0001\u0001\u0004%IAN\u0001\nG>t7/^7feJBqa\u0013\u0001A\u0002\u0013%A*A\u0007d_:\u001cX/\\3se}#S-\u001d\u000b\u0003\u00016Cq!\u0012&\u0002\u0002\u0003\u0007q\u0007\u0003\u0004P\u0001\u0001\u0006KaN\u0001\u000bG>t7/^7feJ\u0002\u0003bB)\u0001\u0005\u0004%IAU\u0001\u0006i>\u0004\u0018nY\u000b\u0002'B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0005Y\u0006twMC\u0001Y\u0003\u0011Q\u0017M^1\n\u0005i+&AB*ue&tw\r\u0003\u0004]\u0001\u0001\u0006IaU\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000fy\u0003!\u0019!C\u0005?\u0006Qa.^7SK\u000e|'\u000fZ:\u0016\u0003\u0001\u0004\"!Q1\n\u0005\tT#aA%oi\"1A\r\u0001Q\u0001\n\u0001\f1B\\;n%\u0016\u001cwN\u001d3tA!)a\r\u0001C!O\u0006)1/\u001a;VaR\t\u0001\t\u000b\u0002fSB\u0011!\u000e\\\u0007\u0002W*\u00111BD\u0005\u0003[.\u0014aAQ3g_J,\u0007\"B8\u0001\t\u0003:\u0017\u0001\u0003;fCJ$un\u001e8)\u00059\f\bC\u00016s\u0013\t\u00198NA\u0003BMR,'\u000fC\u0003v\u0001\u0011%a/\u0001\bde\u0016\fG/\u001a)s_\u0012,8-\u001a:\u0015\u0013]\f\t\"!\t\u0002&\u0005=\u0002c\u0002=\u0002\u0002\u0005\u0015\u0011QA\u0007\u0002s*\u0011!p_\u0001\taJ|G-^2fe*\u0011A0`\u0001\bG2LWM\u001c;t\u0015\t)aP\u0003\u0002\u0000\u001d\u00051\u0011\r]1dQ\u0016L1!a\u0001z\u00055Y\u0015MZ6b!J|G-^2feB)\u0011)a\u0002\u0002\f%\u0019\u0011\u0011\u0002\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0005\u000bi!C\u0002\u0002\u0010)\u0012AAQ=uK\"9\u00111\u0003;A\u0002\u0005U\u0011A\u00032s_.,'\u000fT5tiB!\u0011qCA\u000f\u001d\r\t\u0015\u0011D\u0005\u0004\u00037Q\u0013A\u0002)sK\u0012,g-C\u0002[\u0003?Q1!a\u0007+\u0011!\t\u0019\u0003\u001eI\u0001\u0002\u0004\u0001\u0017a\u0002:fiJLWm\u001d\u0005\n\u0003O!\b\u0013!a\u0001\u0003S\t\u0001\u0002\\5oO\u0016\u0014Xj\u001d\t\u0004\u0003\u0006-\u0012bAA\u0017U\t!Aj\u001c8h\u0011%\t\t\u0004\u001eI\u0001\u0002\u0004\t\u0019$A\u0003qe>\u00048\u000fE\u0003B\u0003k\tI$C\u0002\u00028)\u0012aa\u00149uS>t\u0007\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}r+\u0001\u0003vi&d\u0017\u0002BA\"\u0003{\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\t9\u0005\u0001C\u0001O\u0006qA/Z:u'\u0016tGm\u00144gg\u0016$\b\u0006BA#\u0003\u0017\u00022A[A'\u0013\r\tye\u001b\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002T\u0001!\taZ\u0001\u0014i\u0016\u001cHo\u0016:p]\u001e\u001cVM]5bY&TXM\u001d\u0015\u0005\u0003#\nY\u0005C\u0004\u0002Z\u0001!I!a\u0017\u0002C\r\u0014X-\u0019;f!J|G-^2fe^KG\u000f[,s_:<7+\u001a:jC2L'0\u001a:\u0015\u0007]\fi\u0006\u0003\u0005\u0002\u0014\u0005]\u0003\u0019AA\u000b\u0011\u0019\t\t\u0007\u0001C\u0001O\u0006IA/Z:u\u00072|7/\u001a\u0015\u0005\u0003?\nY\u0005\u0003\u0004\u0002h\u0001!\taZ\u0001\u0014i\u0016\u001cHoU3oIR{\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003K\nY\u0005\u0003\u0004\u0002n\u0001!\taZ\u0001\u0014i\u0016\u001cH/Q;u_\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u0015\u0005\u0003W\nY\u0005\u0003\u0004\u0002t\u0001!\taZ\u0001\ni\u0016\u001cHO\u00127vg\"DC!!\u001d\u0002L!1\u0011\u0011\u0010\u0001\u0005\u0002\u001d\f\u0001\u0006^3ti\u000ecwn]3XSRD',\u001a:p)&lWm\\;u\rJ|WnQ1mY\u0016\u0014H\u000b\u001b:fC\u0012DC!a\u001e\u0002L!1\u0011q\u0010\u0001\u0005\u0002\u001d\f\u0001\u0006^3ti\u000ecwn]3XSRD',\u001a:p)&lWm\\;u\rJ|WnU3oI\u0016\u0014H\u000b\u001b:fC\u0012DC!! \u0002L!I\u0011Q\u0011\u0001\u0012\u0002\u0013%\u0011qQ\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u0012TCAAEU\r\u0001\u00171R\u0016\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0013\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0006E%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0014\u0001\u0012\u0002\u0013%\u0011\u0011U\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u001aTCAARU\u0011\tI#a#\t\u0013\u0005\u001d\u0006!%A\u0005\n\u0005%\u0016\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0016\u0016\u0005\u0003g\tY\t")
public abstract class BaseProducerSendTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private SimpleConsumer kafka$api$BaseProducerSendTest$$consumer1;
    private SimpleConsumer kafka$api$BaseProducerSendTest$$consumer2;
    private final String kafka$api$BaseProducerSendTest$$topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$2$ kafka$api$BaseProducerSendTest$$callback$1$lzycompute(Integer x$1, VolatileObjectRef x$2) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$2.elem != null) return (BaseProducerSendTest$callback$2$)x$2.elem;
            x$2.elem = new BaseProducerSendTest$callback$2$(this, x$1);
            return (BaseProducerSendTest$callback$2$)x$2.elem;
        }
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$9 = numServers;
        String x$10 = this.zkConnect();
        boolean x$11 = false;
        Some x$12 = new Some((Object)this.securityProtocol());
        Option<File> x$13 = this.trustStoreFile();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$9, x$10, x$11, x$14, (Option<SecurityProtocol>)x$12, x$13, x$15, x$16, x$17, x$18).map((Function1)new Serializable(this, overridingProps){
            public static final long serialVersionUID = 0L;
            private final Properties overridingProps$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps$1);
            }
            {
                this.overridingProps$1 = overridingProps$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public SimpleConsumer kafka$api$BaseProducerSendTest$$consumer1() {
        return this.kafka$api$BaseProducerSendTest$$consumer1;
    }

    private void kafka$api$BaseProducerSendTest$$consumer1_$eq(SimpleConsumer x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer1 = x$1;
    }

    public SimpleConsumer kafka$api$BaseProducerSendTest$$consumer2() {
        return this.kafka$api$BaseProducerSendTest$$consumer2;
    }

    private void kafka$api$BaseProducerSendTest$$consumer2_$eq(SimpleConsumer x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer2 = x$1;
    }

    public String kafka$api$BaseProducerSendTest$$topic() {
        return this.kafka$api$BaseProducerSendTest$$topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        KafkaServer qual$1 = (KafkaServer)this.servers().apply(0);
        SecurityProtocol x$19 = qual$1.boundPort$default$1();
        this.kafka$api$BaseProducerSendTest$$consumer1_$eq(new SimpleConsumer("localhost", qual$1.boundPort(x$19), 100, 0x100000, ""));
        KafkaServer qual$2 = (KafkaServer)this.servers().apply(1);
        SecurityProtocol x$20 = qual$2.boundPort$default$1();
        this.kafka$api$BaseProducerSendTest$$consumer2_$eq(new SimpleConsumer("localhost", qual$2.boundPort(x$20), 100, 0x100000, ""));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$api$BaseProducerSendTest$$consumer1().close();
        this.kafka$api$BaseProducerSendTest$$consumer2().close();
        KafkaServerTestHarness$class.tearDown(this);
    }

    public KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$$createProducer(String brokerList, int retries, long lingerMs, Option<Properties> props) {
        String x$21 = brokerList;
        SecurityProtocol x$22 = this.securityProtocol();
        Option<File> x$23 = this.trustStoreFile();
        int x$24 = retries;
        long x$25 = lingerMs;
        Option<Properties> x$26 = props;
        int x$27 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$28 = TestUtils$.MODULE$.createNewProducer$default$3();
        boolean x$29 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$30 = TestUtils$.MODULE$.createNewProducer$default$5();
        return TestUtils$.MODULE$.createNewProducer(x$21, x$27, x$28, x$29, x$30, x$24, x$25, x$22, x$23, x$26);
    }

    public int kafka$api$BaseProducerSendTest$$createProducer$default$2() {
        return 0;
    }

    private long createProducer$default$3() {
        return 0L;
    }

    public Option<Properties> kafka$api$BaseProducerSendTest$$createProducer$default$4() {
        return None$.MODULE$;
    }

    @Test
    public void testSendOffset() {
        VolatileObjectRef callback$module = new VolatileObjectRef(null);
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        Integer partition = new Integer(0);
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), partition, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), partition, (Object)"key".getBytes(), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), partition, null, (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, partition, (Object)"key".getBytes(), (Object)"value".getBytes());
                producer.send(record4, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic");
            }
            catch (Throwable throwable) {
                throw this.fail("Only expecting IllegalArgumentException", throwable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, partition, record0, callback$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$1;
                    private final Integer partition$1;
                    private final ProducerRecord record0$1;
                    private final VolatileObjectRef callback$module$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$1.send(this.record0$1, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$1(this.partition$1, this.callback$module$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.partition$1 = partition$1;
                        this.record0$1 = record0$1;
                        this.callback$module$1 = callback$module$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.kafka$api$BaseProducerSendTest$$numRecords() + 4))).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testWrongSerializer() {
        try {
            KafkaProducer<byte[], byte[]> producer = this.createProducerWithWrongSerializer(this.brokerList());
            ProducerRecord record5 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), new Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            producer.send(record5);
            throw this.fail("Should have gotten a SerializationException");
        }
        catch (SerializationException serializationException) {
            return;
        }
    }

    private KafkaProducer<byte[], byte[]> createProducerWithWrongSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        String x$31 = brokerList;
        Some x$32 = new Some((Object)producerProps);
        int x$33 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        long x$34 = this.createProducer$default$3();
        return this.kafka$api$BaseProducerSendTest$$createProducer(x$31, x$33, x$34, (Option<Properties>)x$32);
    }

    @Test
    public void testClose() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$2;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$2.send(this.record0$2);
                }
                {
                    this.producer$2 = producer$2;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendToPartition() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        try {
            Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 1;
            Option leader1 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)partition));
            Assert.assertTrue((String)"Leader for topic \"topic\" partition 1 should exist", (boolean)leader1.isDefined());
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$3;
                private final int partition$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$3.send(new ProducerRecord(this.$outer.kafka$api$BaseProducerSendTest$$topic(), Predef$.MODULE$.int2Integer(this.partition$2), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$3 = producer$3;
                    this.partition$2 = partition$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                    return x$2.get();
                }
            });
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Future<RecordMetadata> future) {
                    Assert.assertTrue((String)"Request should have completed", (boolean)future.isDone());
                }
            });
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Future<RecordMetadata>, Object> check$ifrefutable$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$2;

                public final void apply(Tuple2<Future<RecordMetadata>, Object> x$3) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        Future future = (Future)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)((RecordMetadata)future.get()).offset());
                        Assert.assertEquals((Object)this.$outer.kafka$api$BaseProducerSendTest$$topic(), (Object)((RecordMetadata)future.get()).topic());
                        Assert.assertEquals((long)this.partition$2, (long)((RecordMetadata)future.get()).partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.partition$2 = partition$2;
                }
            });
            FetchResponse fetchResponse1 = BoxesRunTime.unboxToInt((Object)leader1.get()) == ((KafkaConfig)this.configs().apply(0)).brokerId() ? this.kafka$api$BaseProducerSendTest$$consumer1().fetch(new FetchRequestBuilder().addFetch(this.kafka$api$BaseProducerSendTest$$topic(), partition, 0L, Integer.MAX_VALUE).build()) : this.kafka$api$BaseProducerSendTest$$consumer2().fetch(new FetchRequestBuilder().addFetch(this.kafka$api$BaseProducerSendTest$$topic(), partition, 0L, Integer.MAX_VALUE).build());
            Buffer messageSet1 = fetchResponse1.messageSet(this.kafka$api$BaseProducerSendTest$$topic(), partition).iterator().toBuffer();
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).append((Object)" messages").toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)messageSet1.size());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords() - 1).foreach$mVc$sp((Function1)new Serializable(this, messageSet1){
                public static final long serialVersionUID = 0L;
                private final Buffer messageSet1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Assert.assertEquals((Object)new Message(new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString().getBytes()), (Object)((MessageAndOffset)this.messageSet1$1.apply(i)).message());
                    Assert.assertEquals((long)i, (long)((MessageAndOffset)this.messageSet1$1.apply(i)).offset());
                }
                {
                    this.messageSet1$1 = messageSet1$1;
                }
            });
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testAutoCreateTopic() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), 5, this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        try {
            ProducerRecord record = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record).get()).offset());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testFlush() {
        String x$35 = this.brokerList();
        long x$36 = Long.MAX_VALUE;
        int x$37 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        Option<Properties> x$38 = this.kafka$api$BaseProducerSendTest$$createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(x$35, x$37, x$36, x$38);
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), (Object)"value".getBytes());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, producer, record){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                public final KafkaProducer producer$4;
                public final ProducerRecord record$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFlush$1 $outer;

                        public final Future<RecordMetadata> apply(int i) {
                            return this.$outer.producer$4.send(this.$outer.record$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$4) {
                            return !x$4.isDone();
                        }
                    }));
                    this.producer$4.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$5) {
                            return x$5.isDone();
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$4 = producer$4;
                    this.record$1 = record$1;
                }
            });
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Option leader0 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0));
        Option leader1 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)1));
        ProducerRecord record0 = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), Predef$.MODULE$.int2Integer(0), null, (Object)"value".getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, leader0, record0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final Option leader0$1;
            public final ProducerRecord record0$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String x$39 = this.$outer.brokerList();
                long x$40 = Long.MAX_VALUE;
                int x$41 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$2();
                Option<Properties> x$42 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.kafka$api$BaseProducerSendTest$$createProducer(x$39, x$41, x$40, x$42);
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;
                    private final KafkaProducer producer$5;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$5.send(this.$outer.record0$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.producer$5 = producer$5;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$6) {
                        return !x$6.isDone();
                    }
                }));
                producer.close(0L, TimeUnit.MILLISECONDS);
                responses.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;

                    public final void apply(Future<RecordMetadata> future) {
                        try {
                            future.get();
                            throw this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer().fail("No message should be sent successfully.");
                        }
                        catch (Exception exception) {
                            Assert.assertEquals((Object)"java.lang.IllegalStateException: Producer is closed forcefully.", (Object)exception.getMessage());
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                FetchResponse fetchResponse = BoxesRunTime.unboxToInt((Object)this.leader0$1.get()) == ((KafkaConfig)this.$outer.configs().apply(0)).brokerId() ? this.$outer.kafka$api$BaseProducerSendTest$$consumer1().fetch(new FetchRequestBuilder().addFetch(this.$outer.kafka$api$BaseProducerSendTest$$topic(), 0, 0L, Integer.MAX_VALUE).build()) : this.$outer.kafka$api$BaseProducerSendTest$$consumer2().fetch(new FetchRequestBuilder().addFetch(this.$outer.kafka$api$BaseProducerSendTest$$topic(), 0, 0L, Integer.MAX_VALUE).build());
                Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)fetchResponse.messageSet(this.$outer.kafka$api$BaseProducerSendTest$$topic(), 0).size());
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leader0$1 = leader0$1;
                this.record0$3 = record0$3;
            }
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseProducerSendTest$$topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Option leader = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0));
        ProducerRecord record = new ProducerRecord(this.kafka$api$BaseProducerSendTest$$topic(), Predef$.MODULE$.int2Integer(0), null, (Object)"value".getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, leader, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final Option leader$1;
            public final ProducerRecord record$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String x$43 = this.$outer.brokerList();
                long x$44 = Long.MAX_VALUE;
                int x$45 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$2();
                Option<Properties> x$46 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.kafka$api$BaseProducerSendTest$$createProducer(x$43, x$45, x$44, x$46);
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromSenderThread$1 $outer;
                    private final KafkaProducer producer$6;

                    public final Future<RecordMetadata> apply(int i) {
                        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
                        implements Callback {
                            public final KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$CloseCallback$$producer;
                            public final /* synthetic */ BaseProducerSendTest $outer;
                            public final ProducerRecord record$2;

                            public void onCompletion(RecordMetadata metadata, Exception exception) {
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$CloseCallback$$$outer().kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Kafka_api_BaseProducerSendTest$CloseCallback$1 $outer;

                                    public final Future<RecordMetadata> apply(int i) {
                                        return this.$outer.kafka$api$BaseProducerSendTest$CloseCallback$$producer.send(this.$outer.record$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                                this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(0L, TimeUnit.MILLISECONDS);
                                this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
                            }

                            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$CloseCallback$$$outer() {
                                return this.$outer;
                            }

                            public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest producer, KafkaProducer<byte[], byte[]> record$2) {
                                this.kafka$api$BaseProducerSendTest$CloseCallback$$producer = producer;
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.record$2 = record$2;
                            }
                        }
                        return this.producer$6.send(this.$outer.record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1(this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer(), this.producer$6, this.$outer.record$2));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.producer$6 = producer$6;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$7) {
                        return !x$7.isDone();
                    }
                }));
                producer.flush();
                Assert.assertTrue((String)"All request are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$8) {
                        return x$8.isDone();
                    }
                }));
                FetchResponse fetchResponse = BoxesRunTime.unboxToInt((Object)this.leader$1.get()) == ((KafkaConfig)this.$outer.configs().apply(0)).brokerId() ? this.$outer.kafka$api$BaseProducerSendTest$$consumer1().fetch(new FetchRequestBuilder().addFetch(this.$outer.kafka$api$BaseProducerSendTest$$topic(), 0, 0L, Integer.MAX_VALUE).build()) : this.$outer.kafka$api$BaseProducerSendTest$$consumer2().fetch(new FetchRequestBuilder().addFetch(this.$outer.kafka$api$BaseProducerSendTest$$topic(), 0, 0L, Integer.MAX_VALUE).build());
                int expectedNumRecords = (i + 1) * this.$outer.kafka$api$BaseProducerSendTest$$numRecords();
                Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Fetch response to partition 0 should have %d messages.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumRecords)})), (long)expectedNumRecords, (long)fetchResponse.messageSet(this.$outer.kafka$api$BaseProducerSendTest$$topic(), 0).size());
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leader$1 = leader$1;
                this.record$2 = record$2;
            }
        });
    }

    public final BaseProducerSendTest$callback$2$ kafka$api$BaseProducerSendTest$$callback$1(Integer partition$1, VolatileObjectRef callback$module$1) {
        return callback$module$1.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$1$lzycompute(partition$1, callback$module$1) : (BaseProducerSendTest$callback$2$)callback$module$1.elem;
    }

    public BaseProducerSendTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.kafka$api$BaseProducerSendTest$$consumer1 = null;
        this.kafka$api$BaseProducerSendTest$$consumer2 = null;
        this.kafka$api$BaseProducerSendTest$$topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

