/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.test.ProducerCompressionTest$;
import kafka.consumer.SimpleConsumer;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001%\u0011q\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u0002;fgRT!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018NC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0006\u0015!\tY!#D\u0001\r\u0015\tia\"A\u0003kk:LGO\u0003\u0002\u0010!\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002#\u0005\u0019qN]4\n\u0005Ma!A\u0003&V]&$8+^5uKB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0003u.L!!\u0007\f\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011!Y\u0002A!A!\u0002\u0013a\u0012aC2p[B\u0014Xm]:j_:\u0004\"!H\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003E}AQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015Yb\u00051\u0001\u001d\u0011\u001di\u0003A1A\u0005\n9\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002_A\u0011a\u0004M\u0005\u0003c}\u00111!\u00138u\u0011\u0019\u0019\u0004\u0001)A\u0005_\u0005I!M]8lKJLE\r\t\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003\u0019\u0019XM\u001d<feV\tq\u0007\u0005\u00029u5\t\u0011H\u0003\u00026\r%\u00111(\u000f\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004>\u0001\u0001\u0007I\u0011\u0002 \u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011a\u0004Q\u0005\u0003\u0003~\u0011A!\u00168ji\"91\tPA\u0001\u0002\u00049\u0014a\u0001=%c!1Q\t\u0001Q!\n]\nqa]3sm\u0016\u0014\b\u0005C\u0004H\u0001\t\u0007I\u0011\u0002%\u0002\u000bQ|\u0007/[2\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t!3\n\u0003\u0004R\u0001\u0001\u0006I!S\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000fM\u0003!\u0019!C\u0005]\u0005Qa.^7SK\u000e|'\u000fZ:\t\rU\u0003\u0001\u0015!\u00030\u0003-qW/\u001c*fG>\u0014Hm\u001d\u0011\t\u000b]\u0003A\u0011\t-\u0002\u000bM,G/\u00169\u0015\u0003}B#A\u0016.\u0011\u0005mkV\"\u0001/\u000b\u00055\u0001\u0012B\u00010]\u0005\u0019\u0011UMZ8sK\")\u0001\r\u0001C!1\u0006AA/Z1s\t><h\u000e\u000b\u0002`EB\u00111lY\u0005\u0003Ir\u0013Q!\u00114uKJDQA\u001a\u0001\u0005\u0002a\u000bq\u0002^3ti\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0003K\"\u0004\"aW5\n\u0005)d&\u0001\u0002+fgRDC\u0001\u00017sgB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eX\u0001\u0007eVtg.\u001a:\n\u0005Et'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fX\u0001\beVtg.\u001a:t\u0013\tIhOA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\u0006w\nA\t\u0001`\u0001\u0018!J|G-^2fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgR\u0004\"AK?\u0007\u000b\u0005\u0011\u0001\u0012\u0001@\u0014\tu|\u0018Q\u0001\t\u0004=\u0005\u0005\u0011bAA\u0002?\t1\u0011I\\=SK\u001a\u00042AHA\u0004\u0013\r\tIa\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0007Ou$\t!!\u0004\u0015\u0003qDq!!\u0005~\t\u0003\t\u0019\"\u0001\u0006qCJ\fW.\u001a;feN,\"!!\u0006\u0011\r\u0005]\u0011QDA\u0011\u001b\t\tIBC\u0002\u0002\u001c5\u000bA!\u001e;jY&!\u0011qDA\r\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0005=\u0005\rB$C\u0002\u0002&}\u0011Q!\u0011:sCfDC!a\u0004\u0002*A!\u00111FA\"\u001d\u0011\ti#a\u0010\u000f\t\u0005=\u0012Q\b\b\u0005\u0003c\tYD\u0004\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004C\u0001\u0007yI|w\u000e\u001e \n\u0003EI!!\u0004\t\n\u0005]d\u0016bAA!m\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!!\u0012\u0002H\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\u0007\u0005\u0005c\u000fC\u0005\u0002Lu\f\t\u0011\"\u0003\u0002N\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0005E\u0002K\u0003#J1!a\u0015L\u0005\u0019y%M[3di\u0002")
public class ProducerCompressionTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final String compression;
    private final int brokerId;
    private KafkaServer server;
    private final String kafka$api$test$ProducerCompressionTest$$topic;
    private final int numRecords;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerCompressionTest producerCompressionTest = this;
        synchronized (producerCompressionTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public String kafka$api$test$ProducerCompressionTest$$topic() {
        return this.kafka$api$test$ProducerCompressionTest$$topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.server_$eq(TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    @After
    public void tearDown() {
        this.server().shutdown();
        CoreUtils$.MODULE$.rm(this.server().config().logDirs());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testCompression() {
        Properties props = new Properties();
        props.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        props.put("compression.type", this.compression);
        props.put("batch.size", "66000");
        props.put("linger.ms", "200");
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        ObjectRef producer = new ObjectRef((Object)new KafkaProducer(props));
        KafkaServer qual$1 = this.server();
        SecurityProtocol x$2 = qual$1.boundPort$default$1();
        SimpleConsumer consumer = new SimpleConsumer("localhost", qual$1.boundPort(x$2), 100, 0x100000, "");
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$test$ProducerCompressionTest$$topic(), 1, 1, (Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()})), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 0;
            IndexedSeq messages2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(int i) {
                    return new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq responses = (IndexedSeq)messages2.map((Function1)new Serializable(this, producer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerCompressionTest $outer;
                private final ObjectRef producer$1;

                public final Future<RecordMetadata> apply(byte[] message) {
                    return ((KafkaProducer)this.producer$1.elem).send(new ProducerRecord(this.$outer.kafka$api$test$ProducerCompressionTest$$topic(), null, null, (Object)message));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$1 = producer$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()), List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Future<RecordMetadata>, Object> check$ifrefutable$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Future<RecordMetadata>, Object> x$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = x$1;
                    if (tuple2 != null) {
                        Future future = (Future)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)((RecordMetadata)future.get()).offset());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            FetchResponse fetchResponse = consumer.fetch(new FetchRequestBuilder().addFetch(this.kafka$api$test$ProducerCompressionTest$$topic(), partition, 0L, Integer.MAX_VALUE).build());
            Buffer messageSet = fetchResponse.messageSet(this.kafka$api$test$ProducerCompressionTest$$topic(), partition).iterator().toBuffer();
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.numRecords())).append((Object)" messages").toString(), (long)this.numRecords(), (long)messageSet.size());
            IntRef index = new IntRef(0);
            messages2.foreach((Function1)new Serializable(this, messageSet, index){
                public static final long serialVersionUID = 0L;
                private final Buffer messageSet$1;
                private final IntRef index$1;

                public final void apply(byte[] message) {
                    Assert.assertEquals((Object)new Message(message), (Object)((MessageAndOffset)this.messageSet$1.apply(this.index$1.elem)).message());
                    Assert.assertEquals((long)this.index$1.elem, (long)((MessageAndOffset)this.messageSet$1.apply(this.index$1.elem)).offset());
                    ++this.index$1.elem;
                }
                {
                    this.messageSet$1 = messageSet$1;
                    this.index$1 = index$1;
                }
            });
            return;
        }
        finally {
            if ((KafkaProducer)producer.elem != null) {
                ((KafkaProducer)producer.elem).close();
                producer.elem = null;
            }
            if (consumer != null) {
                consumer.close();
            }
        }
    }

    public ProducerCompressionTest(String compression) {
        this.compression = compression;
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId = 0;
        this.server = null;
        this.kafka$api$test$ProducerCompressionTest$$topic = "topic";
        this.numRecords = 2000;
    }
}

