/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import kafka.admin.AdminUtils$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A!\u0003\u0007\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011aC5oi\u0016<'/\u0019;j_:L!a\u0006\u000b\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005uQ\"a\u0002'pO\u001eLgn\u001a\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003\tAq\u0001\n\u0001C\u0002\u0013\u0005Q%\u0001\u0005ok6tu\u000eZ3t+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\"1Q\u0006\u0001Q\u0001\n\u0019\n\u0011B\\;n\u001d>$Wm\u001d\u0011\t\u000f=\u0002!\u0019!C\u0001K\u0005Aa.^7QCJ$8\u000f\u0003\u00042\u0001\u0001\u0006IAJ\u0001\n]Vl\u0007+\u0019:ug\u0002Bqa\r\u0001C\u0002\u0013\u0005A'A\u0003u_BL7-F\u00016!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003mC:<'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003y]\u0012aa\u0015;sS:<\u0007B\u0002 \u0001A\u0003%Q'\u0001\u0004u_BL7\r\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015K\u0014\u0001B;uS2L!a\u0012#\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004J\u0001\u0001\u0006IAQ\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002BQa\u0013\u0001\u0005\u00021\u000bqbZ3oKJ\fG/Z\"p]\u001aLwm\u001d\u000b\u0002\u001bB\u0019aJV-\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*\u0007\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002VQ\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005\r\u0019V-\u001d\u0006\u0003+\"\u0002\"AW/\u000e\u0003mS!\u0001\u0018\u0003\u0002\rM,'O^3s\u0013\tq6LA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u00021\u0001\u0005\u0004%\t!J\u0001\n]6+7o]1hKNDaA\u0019\u0001!\u0002\u00131\u0013A\u00038NKN\u001c\u0018mZ3tA!)A\r\u0001C!K\u0006AA/Z1s\t><h\u000eF\u0001g!\t9s-\u0003\u0002iQ\t!QK\\5uQ\t\u0019'\u000e\u0005\u0002l[6\tAN\u0003\u0002\f\u001d%\u0011a\u000e\u001c\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006a\u0002!\t!Z\u0001\u0010i\u0016\u001cH/T3ue&\u001c7\u000fT3bW\"\u0012qN\u001d\t\u0003WNL!\u0001\u001e7\u0003\tQ+7\u000f\u001e\u0005\u0006m\u0002!\t!Z\u0001&i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000eD#!\u001e:\t\u000be\u0004A\u0011\u0001>\u0002+\r\u0014X-\u0019;f\u0003:$7\u000b[;uI><hn\u0015;faR1am_A\u0004\u0003\u0017AQ\u0001 =A\u0002u\fQa\u001a:pkB\u00042A`A\u0002\u001d\t9s0C\u0002\u0002\u0002!\na\u0001\u0015:fI\u00164\u0017b\u0001\u001f\u0002\u0006)\u0019\u0011\u0011\u0001\u0015\t\r\u0005%\u0001\u00101\u0001~\u0003)\u0019wN\\:v[\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003\u001bA\b\u0019A?\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0004\u0002\u0012\u0001!I!a\u0005\u0002/\rDWmY6U_BL7-T3ue&\u001c7/\u0012=jgR\u001cH\u0003BA\u000b\u00037\u00012aJA\f\u0013\r\tI\u0002\u000b\u0002\b\u0005>|G.Z1o\u0011\u0019\u0019\u0014q\u0002a\u0001{\u0002")
public class MetricsTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final Properties overridingProps;
    private final int nMessages;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    @TraitSetter
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    @TraitSetter
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetricsTest metricsTest = this;
        synchronized (metricsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$2 = this.numNodes();
        String x$3 = this.zkConnect();
        boolean x$4 = true;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$2, x$3, x$5, x$4, x$6, x$7, x$8, x$9, x$10, x$11).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testMetricsLeak() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.createAndShutdownStep("group0", "consumer0", "producer0");
        int countOfStaticMetrics = Metrics.defaultRegistry().allMetrics().keySet().size();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, countOfStaticMetrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final int countOfStaticMetrics$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.createAndShutdownStep(new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToInteger((int)(i % 3))).toString(), new StringBuilder().append((Object)"consumer").append((Object)BoxesRunTime.boxToInteger((int)(i % 2))).toString(), new StringBuilder().append((Object)"producer").append((Object)BoxesRunTime.boxToInteger((int)(i % 2))).toString());
                Assert.assertEquals((long)this.countOfStaticMetrics$1, (long)Metrics.defaultRegistry().allMetrics().keySet().size());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.countOfStaticMetrics$1 = countOfStaticMetrics$1;
            }
        });
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertFalse((String)"Topic metrics exists after deleteTopic", (boolean)this.checkTopicMetricsExists(topic));
    }

    public void createAndShutdownStep(String group, String consumerId, String producerId) {
        List<String> sentMessages1 = TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), TestUtils$.MODULE$.sendMessages$default$4(), TestUtils$.MODULE$.sendMessages$default$5());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages());
        zkConsumerConnector1.shutdown();
    }

    private boolean checkTopicMetricsExists(String topic) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                Regex topicMetricRegex = new Regex(new StringBuilder().append((Object)".*(").append((Object)topic).append((Object)")$").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                Set metricGroups = Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).entrySet();
                JavaConversions$.MODULE$.asScalaSet(metricGroups).foreach((Function1)new Serializable(this, topicMetricRegex, object){
                    public static final long serialVersionUID = 0L;
                    private final Regex topicMetricRegex$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Map.Entry<String, SortedMap<MetricName, Metric>> metricGroup) {
                        if (this.topicMetricRegex$1.pattern().matcher(metricGroup.getKey()).matches()) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                    }
                    {
                        this.topicMetricRegex$1 = topicMetricRegex$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public MetricsTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.numNodes = 2;
        this.numParts = 2;
        this.topic = "topic1";
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

