/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.log.BrokerCompressionTest$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001\u001d\u0011QC\u0011:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016D\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0013[\u0016\u001c8/Y4f\u0007>l\u0007O]3tg&|g\u000e\u0005\u0002\u001679\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\u00051\u0001K]3eK\u001aL!\u0001H\u000f\u0003\rM#(/\u001b8h\u0015\tQr\u0003\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003\u0015\u0003E\u0011'o\\6fe\u000e{W\u000e\u001d:fgNLwN\u001c\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r*c\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u0014A\u0001\u0007A\u0003C\u0003 A\u0001\u0007A\u0003C\u0004)\u0001\u0001\u0007I\u0011A\u0015\u0002\r1|w\rR5s+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\tIwNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#\u0001\u0002$jY\u0016Dqa\r\u0001A\u0002\u0013\u0005A'\u0001\u0006m_\u001e$\u0015N]0%KF$\"!\u000e\u001d\u0011\u0005Y1\u0014BA\u001c\u0018\u0005\u0011)f.\u001b;\t\u000fe\u0012\u0014\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u0003+\u0003\u001dawn\u001a#je\u0002Bq!\u0010\u0001C\u0002\u0013\u0005a(\u0001\u0003uS6,W#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t#\u0011!B;uS2\u001c\u0018B\u0001#B\u0005!iunY6US6,\u0007B\u0002$\u0001A\u0003%q(A\u0003uS6,\u0007\u0005C\u0004I\u0001\t\u0007I\u0011A%\u0002\u00131|wmQ8oM&<W#\u0001&\u0011\u0005\u0011Z\u0015B\u0001'\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004O\u0001\u0001\u0006IAS\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003\"\u0002)\u0001\t\u0003\t\u0016!B:fiV\u0003H#A\u001b)\u0005=\u001b\u0006C\u0001+W\u001b\u0005)&BA\u0006\u000f\u0013\t9VK\u0001\u0004CK\u001a|'/\u001a\u0005\u00063\u0002!\t!U\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0001l\u0017\t\u0003)rK!!X+\u0003\u000b\u00053G/\u001a:\t\u000b}\u0003A\u0011A)\u00023Q,7\u000f\u001e\"s_.,'oU5eK\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0003=\u0006\u0004\"\u0001\u00162\n\u0005\r,&\u0001\u0002+fgRDC\u0001A3lYB\u0011a-[\u0007\u0002O*\u0011\u0001.V\u0001\u0007eVtg.\u001a:\n\u0005)<'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001/V\u0001\beVtg.\u001a:t\u0013\t\u0011xNA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\u0006i\nA\t!^\u0001\u0016\u0005J|7.\u001a:D_6\u0004(/Z:tS>tG+Z:u!\t!cOB\u0003\u0002\u0005!\u0005qoE\u0002wqn\u0004\"AF=\n\u0005i<\"AB!osJ+g\r\u0005\u0002\u0017y&\u0011Qp\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006CY$\ta \u000b\u0002k\"9\u00111\u0001<\u0005\u0002\u0005\u0015\u0011A\u00039be\u0006lW\r^3sgV\u0011\u0011q\u0001\t\u0007\u0003\u0013\ty!a\u0005\u000e\u0005\u0005-!bAA\u0007]\u0005!Q\u000f^5m\u0013\u0011\t\t\"a\u0003\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0017\u0003+!\u0012bAA\f/\t)\u0011I\u001d:bs\"\"\u0011\u0011AA\u000e!\u0011\ti\"!\u000e\u000f\t\u0005}\u0011\u0011\u0007\b\u0005\u0003C\tyC\u0004\u0003\u0002$\u00055b\u0002BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%b!\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u00111BD\u0005\u0003aVK1!a\rp\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011qGA\u001d\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0004\u0003gy\u0007\"CA\u001fm\u0006\u0005I\u0011BA \u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dc&\u0001\u0003mC:<\u0017\u0002BA&\u0003\u000b\u0012aa\u00142kK\u000e$\b")
public class BrokerCompressionTest
extends JUnitSuite {
    private final String messageCompression;
    private final String brokerCompression;
    private File logDir;
    private final MockTime time;
    private final LogConfig logConfig;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void tearDown() {
        CoreUtils$.MODULE$.rm(this.logDir());
    }

    @Test
    public void testBrokerSideCompression() {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(this.messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), this.brokerCompression);
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet(messageCompressionCode, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())})), log.append$default$2());
        if (this.brokerCompression.equals("producer")) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Compression at offset 0 should produce ").append((Object)messageCompressionCode.name()).toString(), (Object)messageCompressionCode, (Object)this.readMessage$1(0, log).compressionCodec());
        } else {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(this.brokerCompression);
            Assert.assertEquals((String)new StringBuilder().append((Object)"Compression at offset 0 should produce ").append((Object)brokerCompressionCode.name()).toString(), (Object)brokerCompressionCode, (Object)this.readMessage$1(0, log).compressionCodec());
        }
    }

    private final Message readMessage$1(int offset, Log log$1) {
        return ((MessageAndOffset)log$1.read((long)offset, 4096, log$1.read$default$3()).messageSet().head()).message();
    }

    public BrokerCompressionTest(String messageCompression, String brokerCompression) {
        this.messageCompression = messageCompression;
        this.brokerCompression = brokerCompression;
        this.logDir = null;
        this.time = new MockTime(0L);
        this.logConfig = LogConfig$.MODULE$.apply();
    }
}

