/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0001\u0003\u0001\u001d\u00111b\u00117fC:,'\u000fV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0004I&\u0014X#\u0001\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012AA5p\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\t\u0019KG.\u001a\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000e\u0002\t\u0011L'\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003!awn\u001a)s_B\u001cX#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)r\u0012\u0001B;uS2L!\u0001L\u0015\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004/\u0001\u0001\u0006IaJ\u0001\nY><\u0007K]8qg\u0002Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011'A\u0005m_\u001e\u001cuN\u001c4jOV\t!\u0007\u0005\u0002\u0017g%\u0011AG\u0001\u0002\n\u0019><7i\u001c8gS\u001eDaA\u000e\u0001!\u0002\u0013\u0011\u0014A\u00037pO\u000e{gNZ5hA!9\u0001\b\u0001b\u0001\n\u0003I\u0014\u0001\u0002;j[\u0016,\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\u0011\tQ!\u001e;jYNL!a\u0010\u001f\u0003\u00115{7m\u001b+j[\u0016Da!\u0011\u0001!\u0002\u0013Q\u0014!\u0002;j[\u0016\u0004\u0003bB\"\u0001\u0005\u0004%\t\u0001R\u0001\ni\"\u0014x\u000e\u001e;mKJ,\u0012!\u0012\t\u0003w\u0019K!a\u0012\u001f\u0003\u0013QC'o\u001c;uY\u0016\u0014\bBB%\u0001A\u0003%Q)\u0001\u0006uQJ|G\u000f\u001e7fe\u0002BQa\u0013\u0001\u0005\u00021\u000b\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n!QK\\5uQ\tQE\u000b\u0005\u0002V/6\taK\u0003\u0002\f\u001d%\u0011\u0001L\u0016\u0002\u0006\u0003\u001a$XM\u001d\u0005\u00065\u0002!\t\u0001T\u0001\u0012i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001c\bFA-]!\t)V,\u0003\u0002_-\n!A+Z:u\u0011\u0015\u0001\u0007\u0001\"\u0001M\u0003]!Xm\u001d;DY\u0016\fg.\u001b8h/&$\b\u000eR3mKR,7\u000f\u000b\u0002`9\")1\r\u0001C\u0001I\u0006qA/Z:u\u0019><Gk\\\"mK\u0006tW#A')\u0005\td\u0006\"B4\u0001\t\u0003!\u0017a\b;fgR\u001cE.Z1oS:<w+\u001b;i+:\\W-_3e\u001b\u0016\u001c8/Y4fg\"\u0012a\r\u0018\u0005\u0006U\u0002!\ta[\u0001\nW\u0016L8/\u00138M_\u001e$\"\u0001\\;\u0011\u00075\u0004(/D\u0001o\u0015\tyw*\u0001\u0006d_2dWm\u0019;j_:L!!\u001d8\u0003\u0011%#XM]1cY\u0016\u0004\"AT:\n\u0005Q|%aA%oi\")1!\u001ba\u0001mB\u0011ac^\u0005\u0003q\n\u00111\u0001T8h\u0011\u0015Q\b\u0001\"\u0001|\u0003a)hn[3zK\u0012lUm]:bO\u0016\u001cu.\u001e8u\u0013:dun\u001a\u000b\u0003erDQaA=A\u0002YDQA \u0001\u0005\u0002}\fa\"\u00192peR\u001c\u0005.Z2l\t>tW\rF\u0002N\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017!\u0011AB2p[6|g.\u0003\u0003\u0002\u0010\u0005%!!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"1\u00111\u0003\u0001\u0005\u00021\u000b!\u0004^3ti\u000ecW-\u00198TK\u001elWM\u001c;t/&$\b.\u00112peRD3!!\u0005]\u0011\u0019\tI\u0002\u0001C\u0001\u0019\u0006\u0019B/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO\"\u001a\u0011q\u0003/\t\r\u0005}\u0001\u0001\"\u0001M\u0003\u0011\"Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8h/&$\bn\u00159beN,wJ\u001a4tKR\u001c\bfAA\u000f9\"9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0012!E2iK\u000e\\7+Z4nK:$xJ\u001d3feR\u0019Q*!\u000b\t\u0011\u0005-\u00121\u0005a\u0001\u0003[\taa\u001a:pkB\u001c\b#B7\u00020\u0005M\u0012bAA\u0019]\n\u00191+Z9\u0011\u000b5\fy#!\u000e\u0011\u0007Y\t9$C\u0002\u0002:\t\u0011!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019\ti\u0004\u0001C\u0001\u0019\u0006\u0011B/Z:u\u0005VLG\u000eZ(gMN,G/T1qQ\r\tY\u0004\u0018\u0005\u0007\u0003\u0007\u0002A\u0011\u0001'\u0002-Q,7\u000f\u001e*fG>4XM]=BMR,'o\u0011:bg\"D3!!\u0011]\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nq!\\1lK2{w\rF\u0003w\u0003\u001b\ny\u0005\u0003\u0005\u0019\u0003\u000f\u0002\n\u00111\u0001\u001b\u0011%\t\t&a\u0012\u0011\u0002\u0003\u0007!'\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003+\u0002A\u0011AA,\u00035qwn\u00149DQ\u0016\u001c7\u000eR8oKR\u0019Q*!\u0017\t\u0011\u0005\r\u00111\u000ba\u0001\u0003\u000bAq!!\u0018\u0001\t\u0003\ty&A\u0006nC.,7\t\\3b]\u0016\u0014HCBA1\u0003O\nY\u0007E\u0002\u0017\u0003GJ1!!\u001a\u0003\u0005\u001d\u0019E.Z1oKJDq!!\u001b\u0002\\\u0001\u0007!/\u0001\u0005dCB\f7-\u001b;z\u0011)\ti'a\u0017\u0011\u0002\u0003\u0007\u0011qN\u0001\nG\",7m\u001b#p]\u0016\u0004bATA9\u0003\u000bi\u0015bAA:\u001f\nIa)\u001e8di&|g.\r\u0005\b\u0003o\u0002A\u0011AA=\u0003)9(/\u001b;f)>dun\u001a\u000b\u0007\u0003w\n\u0019)!\"\u0011\t5\u0004\u0018Q\u0010\t\u0004\u001d\u0006}\u0014bAAA\u001f\n!Aj\u001c8h\u0011\u0019\u0019\u0011Q\u000fa\u0001m\"A\u0011qQA;\u0001\u0004\tI)A\u0002tKF\u0004B!\u001c9\u0002\fB)a*!$se&\u0019\u0011qR(\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u000b1a[3z)\u0011\t9*a)\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(\u001f\u0003\rq\u0017n\\\u0005\u0005\u0003C\u000bYJ\u0001\u0006CsR,')\u001e4gKJDq!!*\u0002\u0012\u0002\u0007!/\u0001\u0002jI\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0016aB7fgN\fw-\u001a\u000b\u0007\u0003[\u000b9,!/\u0011\t\u0005=\u00161W\u0007\u0003\u0003cS1!!+\u0005\u0013\u0011\t),!-\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u001d\t\u0019*a*A\u0002IDq!a/\u0002(\u0002\u0007!/A\u0003wC2,X\rC\u0004\u0002@\u0002!\t!!1\u0002\u001dUt7.Z=fI6+7o]1hKR!\u0011QVAb\u0011\u001d\tY,!0A\u0002IDq!a2\u0001\t\u0003\tI-A\u0007eK2,G/Z'fgN\fw-\u001a\u000b\u0005\u0003[\u000bY\rC\u0004\u0002\u0014\u0006\u0015\u0007\u0019\u0001:\t\u0013\u0005=\u0007!%A\u0005\u0002\u0005E\u0017!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003'TC!a\u001c\u0002V.\u0012\u0011q\u001b\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003%)hn\u00195fG.,GMC\u0002\u0002b>\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)/a7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002j\u0002\t\n\u0011\"\u0001\u0002l\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055(f\u0001\u000e\u0002V\"I\u0011\u0011\u001f\u0001\u0012\u0002\u0013\u0005\u00111_\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\u0012TCAA{U\r\u0011\u0014Q\u001b")
public class CleanerTest
extends JUnitSuite {
    private final File dir = TestUtils$.MODULE$.tempDir();
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        CoreUtils$.MODULE$.rm(this.dir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$21 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        Log log = this.makeLog(x$22, x$21);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$25 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$26 = this.makeLog$default$1();
        Log log = this.makeLog(x$26, x$25);
        while (log.numberOfSegments() < 2) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$1;

            public final LogAppendInfo apply(int key) {
                return this.log$1.append(this.$outer.deleteMessage(key), this.log$1.append$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$2;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$2 = keys$2;
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$29 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$30 = this.makeLog$default$1();
        Log log = this.makeLog(x$30, x$29);
        byte[] x$31 = (byte[])Array$.MODULE$.fill(50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte());
        byte[] x$32 = ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes();
        CompressionCodec x$33 = TestUtils$.MODULE$.singleMessageSet$default$2();
        ByteBufferMessageSet messageSet = TestUtils$.MODULE$.singleMessageSet(x$31, x$33, x$32);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log, messageSet){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final ByteBufferMessageSet messageSet$1;

            public final LogAppendInfo apply(int i) {
                return this.log$2.append(this.messageSet$1, true);
            }
            {
                this.log$2 = log$2;
                this.messageSet$1 = messageSet$1;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicAndPartition("test", 0), log, log.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - log.activeSegment().size()));
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$34 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$35 = this.makeLog$default$1();
        Log log = this.makeLog(x$35, x$34);
        while (log.numberOfSegments() < 2) {
            log.append(this.unkeyedMessage((int)log.logEndOffset()), log.append$default$2());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)cleaner.stats().invalidMessagesRead());
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$3) {
                        return !x$3.message().isNull();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$4) {
                        return x$4.message().hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MessageAndOffset m) {
                        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(m.message().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$5) {
                        return !x$5.message().isNull();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset m) {
                        return !m.message().hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicAndPartition topicAndPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicAndPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.abortCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$36 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$37 = this.makeLog$default$1();
        Log log = this.makeLog(x$37, x$36);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$3;
            private final FakeOffsetMap map$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$3, ((TraversableOnce)this.log$3.logSegments().take(3)).toSeq(), (OffsetMap)this.map$2, 0L);
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$3 = log$3;
                this.map$2 = map$2;
            }
        }, ManifestFactory$.MODULE$.classType(LogCleaningAbortedException.class));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$38 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$39 = this.makeLog$default$1();
        Log log = this.makeLog(x$39, x$38);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            byte[] x$40 = "hello".getBytes();
            byte[] x$41 = "hello".getBytes();
            CompressionCodec x$42 = TestUtils$.MODULE$.singleMessageSet$default$2();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$40, x$42, x$41), log.append$default$2());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.apply(0)).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$6) {
                return x$6.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$7) {
                return x$7.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = (int)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$9) {
                return x$9.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$10) {
                return x$10.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$11) {
                return x$11.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$43 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$44 = this.makeLog$default$1();
        Log log = this.makeLog(x$44, x$43);
        while (log.numberOfSegments() == 1) {
            byte[] x$45 = "hello".getBytes();
            byte[] x$46 = "hello".getBytes();
            CompressionCodec x$47 = TestUtils$.MODULE$.singleMessageSet$default$2();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$45, x$47, x$46), log.append$default$2());
        }
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new AtomicLong(0x7FFFFFFEL), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), "hello".getBytes())}));
        log.append(messageSet, false);
        byte[] x$48 = "hello".getBytes();
        byte[] x$49 = "hello".getBytes();
        CompressionCodec x$50 = TestUtils$.MODULE$.singleMessageSet$default$2();
        log.append(TestUtils$.MODULE$.singleMessageSet(x$48, x$50, x$49), log.append$default$2());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        byte[] x$51 = "hello".getBytes();
        byte[] x$52 = "hello".getBytes();
        CompressionCodec x$53 = TestUtils$.MODULE$.singleMessageSet$default$2();
        log.append(TestUtils$.MODULE$.singleMessageSet(x$51, x$53, x$52), log.append$default$2());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            byte[] x$54 = "hello".getBytes();
            byte[] x$55 = "hello".getBytes();
            CompressionCodec x$56 = TestUtils$.MODULE$.singleMessageSet$default$2();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$54, x$56, x$55), log.append$default$2());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$12) {
                return (Seq)x$12.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$13) {
                        return x$13.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        int start = 0;
        int end = 500;
        Iterable<Object> offsets = this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$59 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$60 = this.makeLog$default$1();
        Log log = this.makeLog(x$60, x$59);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            Log qual$1 = log;
            ByteBufferMessageSet x$61 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$62 = qual$1.append$default$2();
            qual$1.append(x$61, x$62);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        Iterable<Object> cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), "")));
            }
        });
        log = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), "")));
            }
        });
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$2 = log;
            ByteBufferMessageSet x$63 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$64 = qual$2.append$default$2();
            qual$2.append(x$63, x$64);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$3 = log;
            ByteBufferMessageSet x$65 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$66 = qual$3.append$default$2();
            qual$3.append(x$65, x$66);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    public Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    public File makeLog$default$1() {
        return this.dir();
    }

    public LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    public void noOpCheckDone(TopicAndPartition topicAndPartition) {
    }

    public Cleaner makeCleaner(int capacity, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), 65536, 65536, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    public Function1<TopicAndPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.noOpCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$5;

            public final long apply(Tuple2<Object, Object> x$14) {
                Tuple2<Object, Object> tuple2 = x$14;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$5.append(this.$outer.message(key, value), this.log$5.append$default$2()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$5 = log$5;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public ByteBufferMessageSet message(int key, int value) {
        Message[] messageArray = new Message[1];
        byte[] x$23 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$24 = ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes();
        messageArray[0] = new Message(x$24, x$23);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    public ByteBufferMessageSet unkeyedMessage(int value) {
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())}));
    }

    public ByteBufferMessageSet deleteMessage(int key) {
        Message[] messageArray = new Message[1];
        byte[] x$27 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        Object x$28 = null;
        messageArray[0] = new Message(null, x$27);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Log log$4, Cleaner cleaner$2) {
        long endOffset = cleaner$2.buildOffsetMap(log$4, (long)start, (long)end, (OffsetMap)map) + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$3.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_5;
        LogConfig x$57 = config;
        File x$58 = this.makeLog$default$1();
        Log recoveredLog = this.makeLog(x$58, x$57);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_5;
    }

    public CleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime();
        double x$15 = Double.MAX_VALUE;
        long x$16 = Long.MAX_VALUE;
        MockTime x$17 = this.time();
        boolean x$18 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$19 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$20 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$15, x$16, x$18, x$19, x$20, (Time)x$17);
    }
}

