/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.server.FetchDataInfo;
import kafka.server.IsrExpirationTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003E!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]\u000b\u0002-A!q\u0003\b\u0010,\u001b\u0005A\"BA\r\u001b\u0003\u001diW\u000f^1cY\u0016T!a\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001e1\t\u0019Q*\u00199\u0011\t%y\u0012\u0005K\u0005\u0003A)\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0012&\u001d\tI1%\u0003\u0002%\u0015\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!#\u0002\u0005\u0002\nS%\u0011!F\u0003\u0002\u0004\u0013:$\bc\u0001\u00175Q9\u0011QF\r\b\u0003]Ej\u0011a\f\u0006\u0003a\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005MR\u0011a\u00029bG.\fw-Z\u0005\u0003kY\u00121aU3r\u0015\t\u0019$\u0002C\u00049\u0001\u0001\u0007I\u0011A\u001d\u0002+Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(o\u0018\u0013fcR\u0011!(\u0010\t\u0003\u0013mJ!\u0001\u0010\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b}]\n\t\u00111\u0001\u0017\u0003\rAH%\r\u0005\u0007\u0001\u0002\u0001\u000b\u0015\u0002\f\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003M\u0011X\r\u001d7jG\u0006d\u0015m\u001a+j[\u0016l\u0015\r_'t+\u0005!\u0005CA\u0005F\u0013\t1%B\u0001\u0003M_:<\u0007B\u0002%\u0001A\u0003%A)\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003U\u0011X\r\u001d7jG\u00064U\r^2i/\u0006LG/T1y\u001bN,\u0012\u0001\u000b\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u0015\u0002-I,\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=Ng\u0002Bqa\u0014\u0001C\u0002\u0013\u0005\u0001+A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002.\u0001A\u0003%\u0011+\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!9A\f\u0001b\u0001\n\u0003i\u0016aB2p]\u001aLwm]\u000b\u0002=B\u0019q\fY1\u000e\u0003iI!!\u000e\u000e\u0011\u0005I\u0011\u0017BA2\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0015\u0004\u0001\u0015!\u0003_\u0003!\u0019wN\u001c4jON\u0004\u0003bB4\u0001\u0005\u0004%\t\u0001[\u0001\u0006i>\u0004\u0018nY\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A.V\u0001\u0005Y\u0006tw-\u0003\u0002'W\"1q\u000e\u0001Q\u0001\n%\fa\u0001^8qS\u000e\u0004\u0003bB9\u0001\u0005\u0004%\tA]\u0001\u0005i&lW-F\u0001t!\t!x/D\u0001v\u0015\t1H!A\u0003vi&d7/\u0003\u0002yk\nAQj\\2l)&lW\r\u0003\u0004{\u0001\u0001\u0006Ia]\u0001\u0006i&lW\r\t\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0003\u0015QG+[7f+\u0005q\bcA@\u0002\u00125\u0011\u0011\u0011\u0001\u0006\u0004m\u0006\r!\u0002BA\u0003\u0003\u000f\taaY8n[>t'bA\u0003\u0002\n)!\u00111BA\u0007\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qB\u0001\u0004_J<\u0017b\u0001=\u0002\u0002!9\u0011Q\u0003\u0001!\u0002\u0013q\u0018A\u00026US6,\u0007\u0005C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u001c\u00059Q.\u001a;sS\u000e\u001cXCAA\u000f!\u0011\ty\"a\t\u000e\u0005\u0005\u0005\"\u0002BA\r\u0003\u0007IA!!\n\u0002\"\t9Q*\u001a;sS\u000e\u001c\b\u0002CA\u0015\u0001\u0001\u0006I!!\b\u0002\u00115,GO]5dg\u0002B\u0011\"!\f\u0001\u0001\u0004%\t!a\f\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011\u0011\u0007\t\u0004%\u0005M\u0012bAA\u001b\u0005\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"CA\u001d\u0001\u0001\u0007I\u0011AA\u001e\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007i\ni\u0004C\u0005?\u0003o\t\t\u00111\u0001\u00022!A\u0011\u0011\t\u0001!B\u0013\t\t$A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\nQa]3u+B$\u0012A\u000f\u0015\u0005\u0003\u0007\nY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\u0011\t\t&!\u0004\u0002\u000b),h.\u001b;\n\t\u0005U\u0013q\n\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005e\u0003\u0001\"\u0001\u0002H\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002X\u0005u\u0003\u0003BA'\u0003?JA!!\u0019\u0002P\t)\u0011I\u001a;fe\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0013A\t;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'o\u0015;vG.4u\u000e\u001c7po\u0016\u00148\u000f\u000b\u0003\u0002d\u0005%\u0004\u0003BA'\u0003WJA!!\u001c\u0002P\t!A+Z:u\u0011\u001d\t\t\b\u0001C\u0001\u0003\u000f\nQ\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\u0013\u001atuNR3uG\"\u0014V-];fgRl\u0015\rZ3)\t\u0005=\u0014\u0011\u000e\u0005\b\u0003o\u0002A\u0011AA$\u0003\u0005\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$peNcwn\u001e$pY2|w/\u001a:tQ\u0011\t)(!\u001b\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\u0005\u0001s-\u001a;QCJ$\u0018\u000e^5p]^KG\u000f[!mYJ+\u0007\u000f\\5dCNLe.S:s)1\t\t)!$\u0002\u0010\u0006M\u00151TAP!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD\t\u000591\r\\;ti\u0016\u0014\u0018\u0002BAF\u0003\u000b\u0013\u0011\u0002U1si&$\u0018n\u001c8\t\r\u001d\fY\b1\u0001\"\u0011\u001d\t\t*a\u001fA\u0002!\n1\u0002]1si&$\u0018n\u001c8JI\"9\u0011/a\u001fA\u0002\u0005U\u0005c\u0001;\u0002\u0018&\u0019\u0011\u0011T;\u0003\tQKW.\u001a\u0005\b\u0003;\u000bY\b1\u0001b\u0003\u0019\u0019wN\u001c4jO\"A\u0011\u0011UA>\u0001\u0004\t\u0019+\u0001\u0005m_\u000e\fG\u000eT8h!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAU\t\u0005\u0019An\\4\n\t\u00055\u0016q\u0015\u0002\u0004\u0019><\u0007bBAY\u0001\u0011%\u00111W\u0001\u0017O\u0016$Hj\\4XSRDGj\\4F]\u0012|eMZ:fiR1\u00111UA[\u0003sCq!a.\u00020\u0002\u0007A)\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0002<\u0006=\u0006\u0019\u0001\u0015\u0002\u001b\u0015D\b/Z2uK\u0012\u001c\u0015\r\u001c7t\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003\f1cZ3u\r>dGn\\<feJ+\u0007\u000f\\5dCN$\u0002\"a1\u0002L\u0006=\u00171\u001b\t\u0005YQ\n)\r\u0005\u0003\u0002\u0004\u0006\u001d\u0017\u0002BAe\u0003\u000b\u0013qAU3qY&\u001c\u0017\r\u0003\u0005\u0002N\u0006u\u0006\u0019AAA\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0002R\u0006u\u0006\u0019\u0001\u0015\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!]A_\u0001\u0004\t)\n")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final kafka.utils.MockTime time;
    private final MockTime jTime;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public kafka.utils.MockTime time() {
        return this.time;
    }

    public MockTime jTime() {
        return this.jTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), null, null, null, new AtomicBoolean(false), ReplicaManager$.MODULE$.$lessinit$greater$default$9()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log = this.getLogWithLogEndOffset(15L, 2);
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$2) {
                return x$2.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$3) {
                return x$3.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (MessageSet)MessageSet$.MODULE$.Empty()), -1L, -1, true, LogReadResult$.MODULE$.$lessinit$greater$default$5()));
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$4) {
                return x$4.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log = this.getLogWithLogEndOffset(15L, 1);
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$6) {
                return x$6.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$7) {
                return x$7.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$8) {
                return x$8.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log = this.getLogWithLogEndOffset(15L, 4);
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$9) {
                return x$9.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$10) {
                return x$10.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (MessageSet)MessageSet$.MODULE$.Empty()), -1L, -1, false, LogReadResult$.MODULE$.$lessinit$greater$default$5()));
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$11) {
                return x$11.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(11L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (MessageSet)MessageSet$.MODULE$.Empty()), -1L, -1, false, LogReadResult$.MODULE$.$lessinit$greater$default$5()));
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$12) {
                return x$12.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$13) {
                return x$13.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (MessageSet)MessageSet$.MODULE$.Empty()), -1L, -1, true, LogReadResult$.MODULE$.$lessinit$greater$default$5()));
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$14) {
                return x$14.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, kafka.utils.Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        Partition partition = this.replicaManager().getOrCreatePartition(topic, partitionId);
        Replica leaderReplica = new Replica(leaderId, partition, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica r) {
                return this.partition$1.addReplicaIfNotExists(r);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    private Log getLogWithLogEndOffset(long logEndOffset, int expectedCalls) {
        Log log1 = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log1.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(logEndOffset, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).times(expectedCalls);
        EasyMock.replay((Object[])new Object[]{log1});
        return log1;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, kafka.utils.Time time) {
        return (Seq)((TraversableLike)this.configs().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaConfig x$15) {
                return x$15.brokerId() != this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this, partition, time){
            public static final long serialVersionUID = 0L;
            private final Partition partition$2;
            private final kafka.utils.Time time$1;

            public final Replica apply(KafkaConfig config) {
                return new Replica(config.brokerId(), this.partition$2, this.time$1, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.partition$2 = partition$2;
                this.time$1 = time$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new kafka.utils.MockTime();
        this.jTime = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

