/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.security.auth;

import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.utils.Json$;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u0017\t9\u0011i\u00197UKN$(BA\u0002\u0005\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u001dA\u0011!B6bM.\f'\"A\u0005\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e)5\taB\u0003\u0002\u0010!\u0005)!.\u001e8ji*\u0011\u0011CE\u0001\ng\u000e\fG.\u0019;fgRT\u0011aE\u0001\u0004_J<\u0017BA\u000b\u000f\u0005)QUK\\5u'VLG/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAq\u0001\b\u0001C\u0002\u0013\u0005Q$A\u0004BG2T5o\u001c8\u0016\u0003y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0010\u0002\u0011\u0005\u001bGNS:p]\u0002BQ!\u000b\u0001\u0005\u0002)\nQ\u0003^3ti\u0006\u001bGNS:p]\u000e{gN^3sg&|g\u000eF\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0011)f.\u001b;)\u0005!\u0012\u0004CA\u001a6\u001b\u0005!$BA\b\u0013\u0013\t1DG\u0001\u0003UKN$\b")
public class AclTest
extends JUnitSuite {
    private final String AclJson;

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3}));
        String jsonAcls = Json$.MODULE$.encode((Object)Acl$.MODULE$.toJsonCompatibleMap(acls));
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromJson(jsonAcls));
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromJson(this.AclJson()));
    }

    public AclTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },  {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },  {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}  ]}";
    }
}

