/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.util.HashMap;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.InvalidMessageException;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageTest$;
import kafka.message.MessageTest$$anonfun$setUp$1$;
import kafka.message.MessageTest$$anonfun$setUp$1$$anonfun$apply$2$;
import kafka.message.MessageTest$$anonfun$setUp$1$$anonfun$apply$2$$anonfun$apply$3$;
import kafka.message.MessageTestVal;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u000f\tYQ*Z:tC\u001e,G+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00013\u0005AQ.Z:tC\u001e,7/F\u0001\u001b!\rY\"\u0005J\u0007\u00029)\u0011QDH\u0001\b[V$\u0018M\u00197f\u0015\ty\u0002%\u0001\u0006d_2dWm\u0019;j_:T\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003Gq\u00111\"\u0011:sCf\u0014UO\u001a4feB\u0011a#J\u0005\u0003M\t\u0011a\"T3tg\u0006<W\rV3tiZ\u000bG\u000eC\u0004)\u0001\u0001\u0007I\u0011A\u0015\u0002\u00195,7o]1hKN|F%Z9\u0015\u0005)r\u0003CA\u0016-\u001b\u0005\u0001\u0013BA\u0017!\u0005\u0011)f.\u001b;\t\u000f=:\u0013\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003\u001b\u0003%iWm]:bO\u0016\u001c\b\u0005C\u00034\u0001\u0011\u0005A'A\u0003tKR,\u0006\u000fF\u0001+Q\t\u0011d\u0007\u0005\u00028s5\t\u0001H\u0003\u0002\f\u001d%\u0011!\b\u000f\u0002\u0007\u0005\u00164wN]3\t\u000bq\u0002A\u0011A\u001f\u0002\u001fQ,7\u000f\u001e$jK2$g+\u00197vKN,\u0012A\u000b\u0015\u0003w}\u0002\"a\u000e!\n\u0005\u0005C$\u0001\u0002+fgRDQa\u0011\u0001\u0005\u0002Q\nA\u0002^3ti\u000eCWmY6tk6D#AQ \t\u000b\u0019\u0003A\u0011\u0001\u001b\u0002\u0019Q,7\u000f^#rk\u0006d\u0017\u000e^=)\u0005\u0015{\u0004\"B%\u0001\t\u0003!\u0014a\u0007;fgRlUm]:bO\u00164uN]7bi\u000e{gN^3sg&|g\u000e\u000b\u0002I\u007f!)A\n\u0001C\u0001i\u0005aC/Z:u\u0013:4\u0018\r\\5e)&lWm\u001d;b[B\fe\u000eZ'bO&\u001cg+\u00197vK\u000e{WNY5oCRLwN\u001c\u0015\u0005\u0017~ru*\u0001\u0005fqB,7\r^3eG\u0005\u0001\u0006CA)Z\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V\r\u00051AH]8pizJ\u0011!I\u0005\u00031\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002[7\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005a\u0003\u0003\"B/\u0001\t\u0003!\u0014\u0001\u0006;fgRLeN^1mS\u0012$\u0016.\\3ti\u0006l\u0007\u000f\u000b\u0003]\u007f9{\u0005\"\u00021\u0001\t\u0003!\u0014\u0001\u0006;fgRLeN^1mS\u0012l\u0015mZ5d\u0005f$X\r\u000b\u0003`\u007f9{\u0005\"B2\u0001\t\u0003!\u0014A\u0004;fgRL5\u000fS1tQ\u0006\u0014G.\u001a\u0015\u0003E~BQA\u001a\u0001\u0005\u0002Q\nA\u0003^3ti\u0016C8-\u001a9uS>tW*\u00199qS:<\u0007FA3@\u0001")
public class MessageTest
extends JUnitSuite {
    private ArrayBuffer<MessageTestVal> messages = new ArrayBuffer();

    public ArrayBuffer<MessageTestVal> messages() {
        return this.messages;
    }

    public void messages_$eq(ArrayBuffer<MessageTestVal> x$1) {
        this.messages = x$1;
    }

    @Before
    public void setUp() {
        byte[][] keys = (byte[][])((Object[])new byte[][]{null, "key".getBytes(), "".getBytes()});
        byte[][] vals = (byte[][])((Object[])new byte[][]{"value".getBytes(), "".getBytes(), null});
        Product[] codecs = (Product[])((Object[])new Product[]{NoCompressionCodec$.MODULE$, GZIPCompressionCodec$.MODULE$, SnappyCompressionCodec$.MODULE$, LZ4CompressionCodec$.MODULE$});
        long[] timestamps = new long[]{Message$.MODULE$.NoTimestamp(), 0L, 1L};
        byte[] magicValues = new byte[]{Message$.MODULE$.MagicValue_V0(), Message$.MODULE$.MagicValue_V1()};
        Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new Serializable(this, vals, codecs, timestamps, magicValues){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageTest $outer;
            private final byte[][] vals$1;
            public final Product[] codecs$1;
            public final long[] timestamps$1;
            public final byte[] magicValues$1;

            public final void apply(byte[] k) {
                Predef$.MODULE$.refArrayOps((Object[])this.vals$1).foreach((Function1)new Serializable(this, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$setUp$1 $outer;
                    public final byte[] k$1;

                    public final void apply(byte[] v) {
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.codecs$1).foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$setUp$1$$anonfun$apply$2 $outer;
                            public final byte[] v$1;

                            public final void apply(Product codec) {
                                Predef$.MODULE$.longArrayOps(this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$$outer().timestamps$1).foreach((Function1)new Serializable(this, codec){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$setUp$1$$anonfun$apply$2$$anonfun$apply$3 $outer;
                                    public final Product codec$1;

                                    public final void apply(long t) {
                                        this.apply$mcVJ$sp(t);
                                    }

                                    public void apply$mcVJ$sp(long t) {
                                        Predef$.MODULE$.byteArrayOps(this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$$outer().magicValues$1).foreach((Function1)new Serializable(this, t){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$setUp$1$$anonfun$apply$2$$anonfun$apply$3$$anonfun$apply$1 $outer;
                                            private final long t$1;

                                            public final ArrayBuffer<MessageTestVal> apply(byte mv) {
                                                long timestamp = this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$$outer().kafka$message$MessageTest$$ensureValid$1(mv, this.t$1);
                                                return this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$$outer().messages().$plus$eq((Object)new MessageTestVal(this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$$outer().k$1, this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().v$1, (CompressionCodec)this.$outer.codec$1, timestamp, mv, new Message(this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().v$1, this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$$outer().k$1, timestamp, (CompressionCodec)this.$outer.codec$1, mv)));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.t$1 = t$1;
                                            }
                                        });
                                    }

                                    public /* synthetic */ $anonfun$setUp$1$$anonfun$apply$2$$anonfun$apply$3 kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.codec$1 = codec$1;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$setUp$1$$anonfun$apply$2 kafka$message$MessageTest$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.v$1 = v$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$setUp$1 kafka$message$MessageTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.k$1 = k$1;
                    }
                });
            }

            public /* synthetic */ MessageTest kafka$message$MessageTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.vals$1 = vals$1;
                this.codecs$1 = codecs$1;
                this.timestamps$1 = timestamps$1;
                this.magicValues$1 = magicValues$1;
            }
        });
    }

    @Test
    public void testFieldValues() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                if (v.payload() == null) {
                    Assert.assertTrue((boolean)v.message().isNull());
                    Assert.assertEquals((String)"Payload should be null", null, (Object)v.message().payload());
                } else {
                    TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.payload()), v.message().payload());
                }
                if (v.magicValue() > Message$.MODULE$.MagicValue_V0()) {
                    Assert.assertEquals((String)"Timestamp should be the same", (long)v.timestamp(), (long)v.message().timestamp());
                } else {
                    Assert.assertEquals((String)"Timestamp should be the NoTimestamp", (long)Message$.MODULE$.NoTimestamp(), (long)v.message().timestamp());
                }
                Assert.assertEquals((long)v.magicValue(), (long)v.message().magic());
                if (v.message().hasKey()) {
                    TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.key()), v.message().key());
                } else {
                    Assert.assertEquals(null, (Object)v.message().key());
                }
                Assert.assertEquals((Object)v.codec(), (Object)v.message().compressionCodec());
            }
        });
    }

    @Test
    public void testChecksum() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                Assert.assertTrue((String)"Auto-computed checksum should be valid", (boolean)v.message().isValid());
                int badChecksum = (int)(v.message().checksum() + 1L);
                Utils.writeUnsignedInt((ByteBuffer)v.message().buffer(), (int)Message$.MODULE$.CrcOffset(), (long)badChecksum);
                Assert.assertFalse((String)"Message with invalid checksum should be invalid", (boolean)v.message().isValid());
            }
        });
    }

    @Test
    public void testEquality() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                Assert.assertFalse((String)"Should not equal null", (boolean)v.message().equals(null));
                Assert.assertFalse((String)"Should not equal a random string", (boolean)v.message().equals((Object)"asdf"));
                Assert.assertTrue((String)"Should equal itself", (boolean)v.message().equals((Object)v.message()));
                Message copy = new Message(v.payload(), v.key(), v.timestamp(), v.codec(), v.magicValue());
                Assert.assertTrue((String)"Should equal another message with the same content.", (boolean)v.message().equals((Object)copy));
            }
        });
    }

    @Test
    public void testMessageFormatConversion() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageTest $outer;

            public final void apply(MessageTestVal v) {
                if (v.magicValue() == Message$.MODULE$.MagicValue_V0()) {
                    this.$outer.kafka$message$MessageTest$$convertAndVerify$1(v, Message$.MODULE$.MagicValue_V0(), Message$.MODULE$.MagicValue_V1());
                } else if (v.magicValue() == Message$.MODULE$.MagicValue_V1()) {
                    this.$outer.kafka$message$MessageTest$$convertAndVerify$1(v, Message$.MODULE$.MagicValue_V1(), Message$.MODULE$.MagicValue_V0());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTimestampAndMagicValueCombination() {
        new Message("hello".getBytes(), 0L, Message$.MODULE$.MagicValue_V0());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTimestamp() {
        new Message("hello".getBytes(), -3L, Message$.MODULE$.MagicValue_V1());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMagicByte() {
        new Message("hello".getBytes(), 0L, (byte)2);
    }

    @Test
    public void testIsHashable() {
        HashMap m = new HashMap();
        this.messages().foreach((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final HashMap m$1;

            public final Message apply(MessageTestVal v) {
                return this.m$1.put(v.message(), v.message());
            }
            {
                this.m$1 = m$1;
            }
        });
        this.messages().foreach((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final HashMap m$1;

            public final void apply(MessageTestVal v) {
                Assert.assertEquals((Object)v.message(), this.m$1.get(v.message()));
            }
            {
                this.m$1 = m$1;
            }
        });
    }

    @Test
    public void testExceptionMapping() {
        Errors expected = Errors.CORRUPT_MESSAGE;
        Errors actual = Errors.forException((Throwable)new InvalidMessageException());
        Assert.assertEquals((String)"InvalidMessageException should map to a corrupt message error", (Object)expected, (Object)actual);
    }

    public final long kafka$message$MessageTest$$ensureValid$1(byte magicValue, long timestamp) {
        return magicValue > Message$.MODULE$.MagicValue_V0() ? timestamp : Message$.MODULE$.NoTimestamp();
    }

    public final void kafka$message$MessageTest$$convertAndVerify$1(MessageTestVal v, byte fromMessageFormat, byte toMessageFormat) {
        Assert.assertEquals((String)"Message should be the same when convert to the same version.", (Object)v.message().toFormatVersion(fromMessageFormat), (Object)v.message());
        Message convertedMessage = v.message().toFormatVersion(toMessageFormat);
        Assert.assertEquals((String)"Size difference is not expected value", (long)(convertedMessage.size() - v.message().size()), (long)Message$.MODULE$.headerSizeDiff(fromMessageFormat, toMessageFormat));
        Assert.assertTrue((String)"Message should still be valid", (boolean)convertedMessage.isValid());
        Assert.assertEquals((String)"Timestamp should be NoTimestamp", (long)convertedMessage.timestamp(), (long)Message$.MODULE$.NoTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Magic value should be ", " now"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)toMessageFormat)})), (long)convertedMessage.magic(), (long)toMessageFormat);
        if (convertedMessage.hasKey()) {
            Assert.assertEquals((String)"Message key should not change", (Object)convertedMessage.key(), (Object)ByteBuffer.wrap(v.key()));
        } else {
            Assert.assertNull((Object)convertedMessage.key());
        }
        if (v.payload() == null) {
            Assert.assertTrue((boolean)convertedMessage.isNull());
            Assert.assertEquals((String)"Payload should be null", null, (Object)convertedMessage.payload());
        } else {
            Assert.assertEquals((String)"Message payload should not change", (Object)convertedMessage.payload(), (Object)ByteBuffer.wrap(v.payload()));
        }
        Assert.assertEquals((String)"Compression codec should not change", (Object)convertedMessage.compressionCodec(), (Object)v.codec());
    }
}

