/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.api.SaslTestHarness;
import kafka.api.SaslTestHarness$class;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001\u001d\u0011!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\bCA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003\r\t\u0007/[\u0005\u0003#9\u0011qbU1tYR+7\u000f\u001e%be:,7o\u001d\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"!\u0003\u0001\t\u000b]\u0001A\u0011\u000b\r\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A\r\u0011\u0005i!S\"A\u000e\u000b\u0005qi\u0012\u0001\u00039s_R|7m\u001c7\u000b\u0005yy\u0012AB2p[6|gN\u0003\u0002\u0006A)\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0013\t)3D\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"9q\u0005\u0001b\u0001\n#B\u0013\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\rM#(/\u001b8h\u0011\u0019\u0011\u0004\u0001)A\u0005S\u0005I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0011\u001d!\u0004A1A\u0005RU\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\ta\u0007E\u00028}%j\u0011\u0001\u000f\u0006\u0003si\n\u0011\"[7nkR\f'\r\\3\u000b\u0005mb\u0014AC2pY2,7\r^5p]*\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@q\t!A*[:u\u0011\u0019\t\u0005\u0001)A\u0005m\u0005Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA!91\t\u0001b\u0001\n#\"\u0015AD:bg2\u0004&o\u001c9feRLWm]\u000b\u0002\u000bB\u0019aiR%\u000e\u0003qJ!\u0001\u0013\u001f\u0003\tM{W.\u001a\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u00196\nA!\u001e;jY&\u0011aj\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002)\u0001A\u0003%Q)A\btCNd\u0007K]8qKJ$\u0018.Z:!\u0011\u001d\u0011\u0006A1A\u0005RM\u000bQB_6TCNdWI\\1cY\u0016$W#\u0001+\u0011\u0005\u0019+\u0016B\u0001,=\u0005\u001d\u0011un\u001c7fC:Da\u0001\u0017\u0001!\u0002\u0013!\u0016A\u0004>l'\u0006\u001cH.\u00128bE2,G\r\t\u0005\u00065\u0002!\teW\u0001\u000b]Vl'I]8lKJ\u001cX#\u0001/\u0011\u0005\u0019k\u0016B\u00010=\u0005\rIe\u000e\u001e\u0005\u0006A\u0002!\t!Y\u00011i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\n+gm\u001c:f'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;\u0015\u0003\t\u0004\"AR2\n\u0005\u0011d$\u0001B+oSRD#a\u00184\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u0014\u0013!\u00026v]&$\u0018BA6i\u0005\u0011!Vm\u001d;\t\u000b5\u0004A\u0011A1\u0002_Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR\fe\r^3s'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;)\u000514\u0007\"\u00029\u0001\t\u0003\t\u0017\u0001\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;XSRDWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ\tyg\rC\u0003t\u0001\u0011%A/\u0001\ftK:$\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0019)80a\u0002\u0002\u0012A\u0011a/_\u0007\u0002o*\u0011\u00010H\u0001\te\u0016\fX/Z:ug&\u0011!p\u001e\u0002\u0014\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a\u0005\u0006yJ\u0004\r!`\u0001\u0007g>\u001c7.\u001a;\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!L\u0001\u0004]\u0016$\u0018bAA\u0003\u007f\n11k\\2lKRDq!!\u0003s\u0001\u0004\tY!A\u0004sKF,Xm\u001d;\u0011\u0007Y\fi!C\u0002\u0002\u0010]\u0014!#\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\"9\u00111\u0003:A\u0002\u0005U\u0011a\u0002<feNLwN\u001c\t\u0004\r\u0006]\u0011bAA\ry\t)1\u000b[8si\"9\u0011Q\u0004\u0001\u0005\n\u0005}\u0011\u0001K:f]\u0012\u001c\u0016m\u001d7IC:$7\u000f[1lKJ+\u0017/^3tiZ\u000bG.\u001b3bi\u0016\u0014Vm\u001d9p]N,Gc\u00012\u0002\"!1A0a\u0007A\u0002u\u0004")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslTestHarness {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> saslProperties;
    private final boolean zkSaslEnabled;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;

    @Override
    public /* synthetic */ void kafka$api$SaslTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$api$SaslTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$SaslTestHarness$_setter_$kafkaClientSaslMechanism_$eq(String x$1) {
    }

    @Override
    public void kafka$api$SaslTestHarness$_setter_$kafkaServerSaslMechanisms_$eq(List x$1) {
    }

    @Override
    public List<String> allKafkaClientSaslMechanisms() {
        return SaslTestHarness$class.allKafkaClientSaslMechanisms(this);
    }

    @Override
    @Before
    public void setUp() {
        SaslTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        SaslTestHarness$class.tearDown(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(SaslSetupMode mode, List<String> kafkaServerSaslMechanisms, List<String> kafkaClientSaslMechanisms) {
        SaslSetup$class.startSasl(this, mode, kafkaServerSaslMechanisms, kafkaClientSaslMechanisms);
    }

    @Override
    public void setJaasConfiguration(SaslSetupMode mode, List<String> kafkaServerSaslMechanisms, List<String> kafkaClientSaslMechanisms, Option<File> serverKeytabFile, Option<File> clientKeytabFile) {
        SaslSetup$class.setJaasConfiguration(this, mode, kafkaServerSaslMechanisms, kafkaClientSaslMechanisms, serverKeytabFile, clientKeytabFile);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaSaslProperties(String clientSaslMechanism, Option<Seq<String>> serverSaslMechanisms) {
        return SaslSetup$class.kafkaSaslProperties(this, clientSaslMechanism, serverSaslMechanisms);
    }

    @Override
    public Option<Seq<String>> kafkaSaslProperties$default$2() {
        return SaslSetup$class.kafkaSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode startSasl$default$1() {
        return SaslSetup$class.startSasl$default$1(this);
    }

    @Override
    public Option<File> setJaasConfiguration$default$4() {
        return SaslSetup$class.setJaasConfiguration$default$4(this);
    }

    @Override
    public Option<File> setJaasConfiguration$default$5() {
        return SaslSetup$class.setJaasConfiguration$default$5(this);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    @Override
    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    @Override
    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> saslProperties() {
        return this.saslProperties;
    }

    @Override
    public boolean zkSaslEnabled() {
        return this.zkSaslEnabled;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$2, x$1);
        try {
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest(), (short)0);
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$3 = this.securityProtocol();
        SocketServer x$4 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$4, x$3);){
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            try {
                this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest(), (short)0);
                throw this.fail("Versions Request during Sasl handshake did not fail");
            }
            catch (IOException iOException) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$5 = this.securityProtocol();
        SocketServer x$6 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$6, x$5);
        try {
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest(), (short)Short.MAX_VALUE);
            Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.errorCode());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest(), (short)0);
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request, short version) {
        ByteBuffer response = this.send(socket, (AbstractRequest)request, ApiKeys.API_VERSIONS, version);
        return ApiVersionsResponse.parse((ByteBuffer)response);
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        ByteBuffer response = this.send(socket, (AbstractRequest)new SaslHandshakeRequest("PLAIN"), ApiKeys.SASL_HANDSHAKE, (short)0);
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)response);
        Assert.assertEquals((long)Errors.NONE.code(), (long)handshakeResponse.errorCode());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup$class.$init$(this);
        SaslTestHarness$class.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAIN"}));
        this.saslProperties = new Some((Object)this.kafkaSaslProperties(this.kafkaClientSaslMechanism(), (Option<Seq<String>>)new Some(this.kafkaServerSaslMechanisms())));
        this.zkSaslEnabled = false;
    }
}

