/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.api.ControlledShutdownRequest;
import kafka.api.ControlledShutdownResponse;
import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponseSend;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetMetadata;
import kafka.common.OffsetMetadata$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.controller.KafkaController;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberSummary;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.RequestChannel;
import kafka.network.RequestOrResponseSend;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.Write$;
import kafka.server.BecomeLeaderOrFollowerResult;
import kafka.server.BrokerTopicStats$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.KafkaApis$;
import kafka.server.KafkaApis$$anonfun$kafka$server$KafkaApis$;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Protocol;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.ResponseSend;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011bS1gW\u0006\f\u0005/[:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tqA\\3uo>\u00148.\u0003\u0002\u001d3\tq!+Z9vKN$8\t[1o]\u0016d\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002B\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0003CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0006d_>\u0014H-\u001b8bi>\u0014X#A\u0016\u0011\u00051rS\"A\u0017\u000b\u0005%\"\u0011BA\u0018.\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u0003,\u00031\u0019wn\u001c:eS:\fGo\u001c:!\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0014AC2p]R\u0014x\u000e\u001c7feV\tQ\u0007\u0005\u00027q5\tqG\u0003\u00024\t%\u0011\u0011h\u000e\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A1\b\u0001B\u0001B\u0003%Q'A\u0006d_:$(o\u001c7mKJ\u0004\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \u0002\u000fi\\W\u000b^5mgV\tq\b\u0005\u0002\u0010\u0001&\u0011\u0011\t\u0005\u0002\b5.,F/\u001b7t\u0011!\u0019\u0005A!A!\u0002\u0013y\u0014\u0001\u0003>l+RLGn\u001d\u0011\t\u0011\u0015\u0003!Q1A\u0005\u0002\u0019\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002\u000fB\u0011\u0011\u0002S\u0005\u0003\u0013*\u00111!\u00138u\u0011!Y\u0005A!A!\u0002\u00139\u0015!\u00032s_.,'/\u00133!\u0011!i\u0005A!b\u0001\n\u0003q\u0015AB2p]\u001aLw-F\u0001P!\t\u0019\u0003+\u0003\u0002R\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011!\u0019\u0006A!A!\u0002\u0013y\u0015aB2p]\u001aLw\r\t\u0005\t+\u0002\u0011)\u0019!C\u0001-\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012a\u0016\t\u0003GaK!!\u0017\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Y\u0006A!A!\u0002\u00139\u0016AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\t;\u0002\u0011)\u0019!C\u0001=\u00069Q.\u001a;sS\u000e\u001cX#A0\u0011\u0005\u0001LW\"A1\u000b\u0005u\u0013'BA2e\u0003\u0019\u0019w.\\7p]*\u0011Q!\u001a\u0006\u0003M\u001e\fa!\u00199bG\",'\"\u00015\u0002\u0007=\u0014x-\u0003\u0002kC\n9Q*\u001a;sS\u000e\u001c\b\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B0\u0002\u00115,GO]5dg\u0002B\u0001B\u001c\u0001\u0003\u0006\u0004%\ta\\\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#\u00019\u0011\u0007%\t8/\u0003\u0002s\u0015\t1q\n\u001d;j_:\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t\u0005,H\u000f\u001b\u0006\u0003q\u0012\t\u0001b]3dkJLG/_\u0005\u0003uV\u0014!\"Q;uQ>\u0014\u0018N_3s\u0011!a\bA!A!\u0002\u0013\u0001\u0018aC1vi\"|'/\u001b>fe\u0002BQA \u0001\u0005\u0002}\fa\u0001P5oSRtDCFA\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0011\u0005\r\u0002\u0001\"B\u000b~\u0001\u00049\u0002\"\u0002\u0011~\u0001\u0004\u0011\u0003\"B\u0015~\u0001\u0004Y\u0003\"B\u001a~\u0001\u0004)\u0004\"B\u001f~\u0001\u0004y\u0004\"B#~\u0001\u00049\u0005\"B'~\u0001\u0004y\u0005\"B+~\u0001\u00049\u0006\"B/~\u0001\u0004y\u0006\"\u00028~\u0001\u0004\u0001\b\"CA\r\u0001\t\u0007I\u0011AA\u000e\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\u0011\u0011Q\u0004\t\t\u0003?\t)#!\u000b\u000205\u0011\u0011\u0011\u0005\u0006\u0004\u0003GQ\u0011AC2pY2,7\r^5p]&!\u0011qEA\u0011\u0005\ri\u0015\r\u001d\t\u0004\u0013\u0005-\u0012bAA\u0017\u0015\t)1\u000b[8siB\u00191%!\r\n\u0007\u0005M\"A\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\u0002CA\u001c\u0001\u0001\u0006I!!\b\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA!9\u00111\b\u0001\u0005\u0002\u0005u\u0012A\u00025b]\u0012dW\r\u0006\u0003\u0002@\u0005\u0015\u0003cA\u0005\u0002B%\u0019\u00111\t\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000f\nI\u00041\u0001\u0002J\u00059!/Z9vKN$\b\u0003BA&\u0003#r1\u0001GA'\u0013\r\ty%G\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t\u0019&!\u0016\u0003\u000fI+\u0017/^3ti*\u0019\u0011qJ\r\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005I\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\u0011\ty$!\u0018\t\u0011\u0005\u001d\u0013q\u000ba\u0001\u0003\u0013Bq!!\u0019\u0001\t\u0003\t\u0019'\u0001\riC:$G.Z*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR$B!a\u0010\u0002f!A\u0011qIA0\u0001\u0004\tI\u0005C\u0004\u0002j\u0001!\t!a\u001b\u00027!\fg\u000e\u001a7f+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0011\ty$!\u001c\t\u0011\u0005\u001d\u0013q\ra\u0001\u0003\u0013Bq!!\u001d\u0001\t\u0003\t\u0019(A\u0010iC:$G.Z\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V-];fgR$B!a\u0010\u0002v!A\u0011qIA8\u0001\u0004\tI\u0005C\u0004\u0002z\u0001!\t!a\u001f\u00023!\fg\u000e\u001a7f\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u000b\u0005\u0003\u007f\ti\b\u0003\u0005\u0002H\u0005]\u0004\u0019AA%\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b\u0011\"Y;uQ>\u0014\u0018N_3\u0015\u0011\u0005\u0015\u00151RAS\u0003_\u00032!CAD\u0013\r\tII\u0003\u0002\b\u0005>|G.Z1o\u0011!\ti)a A\u0002\u0005=\u0015aB:fgNLwN\u001c\t\u0005\u0003#\u000b\tK\u0004\u0003\u0002\u0014\u00065c\u0002BAK\u0003?sA!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u000373\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\tQB!\u0003\u0003\u0002$\u0006U#aB*fgNLwN\u001c\u0005\t\u0003O\u000by\b1\u0001\u0002*\u0006Iq\u000e]3sCRLwN\u001c\t\u0004i\u0006-\u0016bAAWk\nIq\n]3sCRLwN\u001c\u0005\t\u0003c\u000by\b1\u0001\u00024\u0006A!/Z:pkJ\u001cW\rE\u0002u\u0003kK1!a.v\u0005!\u0011Vm]8ve\u000e,\u0007bBA^\u0001\u0011\u0005\u0011QX\u0001\u0016Q\u0006tG\r\\3Qe>$WoY3s%\u0016\fX/Z:u)\u0011\ty$a0\t\u0011\u0005\u001d\u0013\u0011\u0018a\u0001\u0003\u0013Bq!a1\u0001\t\u0003\t)-\u0001\niC:$G.\u001a$fi\u000eD'+Z9vKN$H\u0003BA \u0003\u000fD\u0001\"a\u0012\u0002B\u0002\u0007\u0011\u0011\n\u0005\b\u0003\u0017\u0004A\u0011AAg\u0003MA\u0017M\u001c3mK>3gm]3u%\u0016\fX/Z:u)\u0011\ty$a4\t\u0011\u0005\u001d\u0013\u0011\u001aa\u0001\u0003\u0013Bq!a5\u0001\t\u0003\t).\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$8\u000f\u0006\u0006\u0002X\u0006\r\u00181_A\u0000\u0005\u0007\u0001b!a\b\u0002Z\u0006u\u0017\u0002BAn\u0003C\u00111aU3r!\rI\u0011q\\\u0005\u0004\u0003CT!\u0001\u0002'p]\u001eD\u0001\"!:\u0002R\u0002\u0007\u0011q]\u0001\u000bY><W*\u00198bO\u0016\u0014\b\u0003BAu\u0003_l!!a;\u000b\u0007\u00055H!A\u0002m_\u001eLA!!=\u0002l\nQAj\\4NC:\fw-\u001a:\t\u0011\u0005U\u0018\u0011\u001ba\u0001\u0003o\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002z\u0006mX\"\u00012\n\u0007\u0005u(M\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\t\u0005\u0011\u0011\u001ba\u0001\u0003;\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\t\u0015\u0011\u0011\u001ba\u0001\u000f\u0006iQ.\u0019=Ok6|eMZ:fiND\u0001B!\u0003\u0001\t\u0003\u0011!1B\u0001\u0013M\u0016$8\r[(gMN,Go\u001d\"fM>\u0014X\r\u0006\u0005\u0002X\n5!Q\u0003B\f\u0011!\tiOa\u0002A\u0002\t=\u0001\u0003BAu\u0005#IAAa\u0005\u0002l\n\u0019Aj\\4\t\u0011\t\u0005!q\u0001a\u0001\u0003;DqA!\u0002\u0003\b\u0001\u0007q\tC\u0004\u0003\u001c\u0001!IA!\b\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u000b\u0005?\u0011\u0019D!\u0012\u0003J\t5\u0003\u0003\u0002B\u0011\u0005[qAAa\t\u0003*5\u0011!Q\u0005\u0006\u0004\u0005O\u0011\u0017\u0001\u0003:fcV,7\u000f^:\n\t\t-\"QE\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016LAAa\f\u00032\tiAk\u001c9jG6+G/\u00193bi\u0006TAAa\u000b\u0003&!A!Q\u0007B\r\u0001\u0004\u00119$A\u0003u_BL7\r\u0005\u0003\u0003:\t}bbA\u0005\u0003<%\u0019!Q\b\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tEa\u0011\u0003\rM#(/\u001b8h\u0015\r\u0011iD\u0003\u0005\b\u0005\u000f\u0012I\u00021\u0001H\u00035qW/\u001c)beRLG/[8og\"9!1\nB\r\u0001\u00049\u0015!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\"Q!q\nB\r!\u0003\u0005\rA!\u0015\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00057\nAA[1wC&!!q\fB+\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0005G\u0002A\u0011\u0002B3\u0003a\u0019'/Z1uK\u001e\u0013x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u000b\u0003\u0005?AqA!\u001b\u0001\t\u0013\u0011Y'A\u000fhKR|%o\u0011:fCR,wI]8va6+G/\u00193bi\u0006$v\u000e]5d)\u0011\u0011yB!\u001c\t\u0011\t=$q\ra\u0001\u0005c\n\u0001c]3dkJLG/\u001f)s_R|7m\u001c7\u0011\t\tM$\u0011P\u0007\u0003\u0005kR1Aa\u001ec\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B>\u0005k\u0012\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\t\u0005\u0007\u0013)Ia$\u0003\u0012B1\u0011qDAm\u0005?A\u0001Ba\"\u0003~\u0001\u0007!\u0011R\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005}!1\u0012B\u001c\u0013\u0011\u0011i)!\t\u0003\u0007M+G\u000f\u0003\u0005\u0003p\tu\u0004\u0019\u0001B9\u0011!\u0011\u0019J! A\u0002\u0005\u0015\u0015!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiNDqAa&\u0001\t\u0003\u0011I*\u0001\u000eiC:$G.\u001a+pa&\u001cW*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\tm\u0005\u0002CA$\u0005+\u0003\r!!\u0013\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\u0006A\u0002.\u00198eY\u0016|eMZ:fi\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\u0005}\"1\u0015\u0005\t\u0003\u000f\u0012i\n1\u0001\u0002J!9!q\u0015\u0001\u0005\u0002\t%\u0016!\b5b]\u0012dWm\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:SKF,Xm\u001d;\u0015\t\u0005}\"1\u0016\u0005\t\u0003\u000f\u0012)\u000b1\u0001\u0002J!9!q\u0016\u0001\u0005\u0002\tE\u0016A\u00075b]\u0012dW\rR3tGJL'-Z$s_V\u0004(+Z9vKN$H\u0003BA \u0005gC\u0001\"a\u0012\u0003.\u0002\u0007\u0011\u0011\n\u0005\b\u0005o\u0003A\u0011\u0001B]\u0003]A\u0017M\u001c3mK2K7\u000f^$s_V\u00048OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\tm\u0006\u0002CA$\u0005k\u0003\r!!\u0013\t\u000f\t}\u0006\u0001\"\u0001\u0003B\u00061\u0002.\u00198eY\u0016Tu.\u001b8He>,\bOU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\t\r\u0007\u0002CA$\u0005{\u0003\r!!\u0013\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003J\u00061\u0002.\u00198eY\u0016\u001c\u0016P\\2He>,\bOU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\t-\u0007\u0002CA$\u0005\u000b\u0004\r!!\u0013\t\u000f\t=\u0007\u0001\"\u0001\u0003R\u00061\u0002.\u00198eY\u0016DU-\u0019:uE\u0016\fGOU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\tM\u0007\u0002CA$\u0005\u001b\u0004\r!!\u0013\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\u0006A\u0012N\\:uC:$\u0018.\u0019;f#V|G/Y'b]\u0006<WM]:\u0015\t\u0005u!1\u001c\u0005\b\u0005;\u0014)\u000e1\u0001P\u0003\r\u0019gm\u001a\u0005\b\u0005C\u0004A\u0011\u0001Br\u0003]A\u0017M\u001c3mK2+\u0017M^3He>,\bOU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\t\u0015\b\u0002CA$\u0005?\u0004\r!!\u0013\t\u000f\t%\b\u0001\"\u0001\u0003l\u0006Q\u0002.\u00198eY\u0016\u001c\u0016m\u001d7IC:$7\u000f[1lKJ+\u0017/^3tiR!\u0011q\bBw\u0011!\t9Ea:A\u0002\u0005%\u0003b\u0002By\u0001\u0011\u0005!1_\u0001\u0019Q\u0006tG\r\\3Ba&4VM]:j_:\u001c(+Z9vKN$H\u0003BA \u0005kD\u0001\"a\u0012\u0003p\u0002\u0007\u0011\u0011\n\u0005\b\u0005s\u0004A\u0011\u0001B~\u0003\u0015\u0019Gn\\:f)\t\ty\u0004C\u0004\u0003\u0000\u0002!\ta!\u0001\u0002-\u0005,H\u000f[8sSj,7\t\\;ti\u0016\u0014\u0018i\u0019;j_:$B!a\u0010\u0004\u0004!A\u0011q\tB\u007f\u0001\u0004\tI\u0005C\u0005\u0004\b\u0001\t\n\u0011\"\u0003\u0004\n\u0005)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\"TCAB\u0006U\u0011\u0011\tf!\u0004,\u0005\r=\u0001\u0003BB\t\u00077i!aa\u0005\u000b\t\rU1qC\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0007\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007;\u0019\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class KafkaApis
implements Logging {
    private final RequestChannel requestChannel;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator coordinator;
    private final KafkaController controller;
    private final ZkUtils zkUtils;
    private final int brokerId;
    private final KafkaConfig config;
    private final MetadataCache metadataCache;
    private final Metrics metrics;
    private final Option<Authorizer> authorizer;
    private final Map<Object, ClientQuotaManager> quotaManagers;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaApis kafkaApis = this;
        synchronized (kafkaApis) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public GroupCoordinator coordinator() {
        return this.coordinator;
    }

    public KafkaController controller() {
        return this.controller;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public Map<Object, ClientQuotaManager> quotaManagers() {
        return this.quotaManagers;
    }

    public void handle(RequestChannel.Request request) {
        block27: {
            try {
                try {
                    this.trace((Function0<String>)new Serializable(this, request){
                        public static final long serialVersionUID = 0L;
                        private final RequestChannel.Request request$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Handling request:%s from connection %s;securityProtocol:%s,principal:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.requestDesc(true), this.request$1.connectionId(), this.request$1.securityProtocol(), this.request$1.session().principal()}));
                        }
                        {
                            this.request$1 = request$1;
                        }
                    });
                    ApiKeys apiKeys = ApiKeys.forId((int)request.requestId());
                    if (ApiKeys.PRODUCE.equals(apiKeys)) {
                        this.handleProducerRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
                        this.handleOffsetRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.METADATA.equals(apiKeys)) {
                        this.handleTopicMetadataRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.LEADER_AND_ISR.equals(apiKeys)) {
                        this.handleLeaderAndIsrRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.STOP_REPLICA.equals(apiKeys)) {
                        this.handleStopReplicaRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.UPDATE_METADATA_KEY.equals(apiKeys)) {
                        this.handleUpdateMetadataRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.CONTROLLED_SHUTDOWN_KEY.equals(apiKeys)) {
                        this.handleControlledShutdownRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
                        this.handleOffsetCommitRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
                        this.handleOffsetFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.GROUP_COORDINATOR.equals(apiKeys)) {
                        this.handleGroupCoordinatorRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
                        this.handleJoinGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
                        this.handleHeartbeatRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
                        this.handleLeaveGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
                        this.handleSyncGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
                        this.handleDescribeGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
                        this.handleListGroupsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                        this.handleSaslHandshakeRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersionsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)"Unknown api code ").append((Object)apiKeys).toString());
                }
                catch (Throwable throwable) {
                    if (request.requestObj() == null) {
                        AbstractRequestResponse response = request.body().getErrorResponse((int)request.header().apiVersion(), throwable);
                        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
                        if (response == null) {
                            this.requestChannel().closeConnection(request.processor(), request);
                        } else {
                            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, response)));
                        }
                        this.error((Function0<String>)new Serializable(this, request){
                            public static final long serialVersionUID = 0L;
                            private final RequestChannel.Request request$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.body()}));
                            }
                            {
                                this.request$1 = request$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$1;

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = e$1;
                            }
                        });
                        break block27;
                    }
                    request.requestObj().handleError(throwable, this.requestChannel(), request);
                    this.error((Function0<String>)new Serializable(this, request){
                        public static final long serialVersionUID = 0L;
                        private final RequestChannel.Request request$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.requestObj()}));
                        }
                        {
                            this.request$1 = request$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            finally {
                request.apiLocalCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
            }
        }
    }

    public void handleLeaderAndIsrRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)request.body();
        try {
            LeaderAndIsrResponse leaderAndIsrResponse;
            ResponseHeader responseHeader = new ResponseHeader(correlationId);
            if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                BecomeLeaderOrFollowerResult result = this.replicaManager().becomeLeaderOrFollower(correlationId, leaderAndIsrRequest, this.metadataCache(), (Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;

                    public final void apply(Iterable<Partition> updatedLeaders, Iterable<Partition> updatedFollowers) {
                        this.$outer.kafka$server$KafkaApis$$onLeadershipChange$1(updatedLeaders, updatedFollowers);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                leaderAndIsrResponse = new LeaderAndIsrResponse(result.errorCode(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(result.responseMap().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Short apply(short x$1) {
                        return new Short(x$1);
                    }
                })).asJava());
            } else {
                scala.collection.immutable.Map result = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, Short> apply(TopicPartition x$2) {
                        return new Tuple2((Object)x$2, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                leaderAndIsrResponse = new LeaderAndIsrResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
            }
            LeaderAndIsrResponse leaderAndIsrResponse2 = leaderAndIsrResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)leaderAndIsrResponse2)));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disk error during leadership change.";
                }
            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$2;

                public final KafkaStorageException apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStopReplicaRequest(RequestChannel.Request request) {
        StopReplicaResponse stopReplicaResponse;
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Tuple2 tuple2;
            Tuple2<scala.collection.mutable.Map<TopicPartition, Object>, Object> tuple22 = this.replicaManager().stopReplicas(stopReplicaRequest);
            if (tuple22 == null) throw new MatchError(tuple22);
            scala.collection.mutable.Map result = (scala.collection.mutable.Map)tuple22._1();
            short error = BoxesRunTime.unboxToShort((Object)tuple22._2());
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToShort((short)error));
            scala.collection.mutable.Map result2 = (scala.collection.mutable.Map)tuple23._1();
            short error2 = BoxesRunTime.unboxToShort((Object)tuple23._2());
            stopReplicaResponse = new StopReplicaResponse(error2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result2).asJava());
        } else {
            scala.collection.immutable.Map result = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(stopReplicaRequest.partitions()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Short> apply(TopicPartition x$4) {
                    return new Tuple2((Object)x$4, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            stopReplicaResponse = new StopReplicaResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
        }
        StopReplicaResponse response = stopReplicaResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)response)));
        this.replicaManager().replicaFetcherManager().shutdownIdleFetcherThreads();
    }

    public void handleUpdateMetadataRequest(RequestChannel.Request request) {
        UpdateMetadataResponse updateMetadataResponse;
        int correlationId = request.header().correlationId();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)request.body();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            this.replicaManager().maybeUpdateMetadataCache(correlationId, updateMetadataRequest, this.metadataCache());
            updateMetadataResponse = new UpdateMetadataResponse(Errors.NONE.code());
        } else {
            updateMetadataResponse = new UpdateMetadataResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        }
        UpdateMetadataResponse updateMetadataResponse2 = updateMetadataResponse;
        ResponseHeader responseHeader = new ResponseHeader(correlationId);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)updateMetadataResponse2)));
    }

    public void handleControlledShutdownRequest(RequestChannel.Request request) {
        ControlledShutdownRequest controlledShutdownRequest = (ControlledShutdownRequest)request.requestObj();
        this.authorizeClusterAction(request);
        scala.collection.Set<TopicAndPartition> partitionsRemaining = this.controller().shutdownBroker(controlledShutdownRequest.brokerId());
        ControlledShutdownResponse controlledShutdownResponse = new ControlledShutdownResponse(controlledShutdownRequest.correlationId(), Errors.NONE.code(), partitionsRemaining);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), controlledShutdownResponse)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleOffsetCommitRequest(RequestChannel.Request request) {
        RequestHeader header = request.header();
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)request.body();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetCommitRequest.groupId()))) {
            Tuple2 tuple2;
            scala.collection.mutable.Map invalidRequestsInfo = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetCommitRequest.offsetData()).asScala()).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;

                public final boolean apply(Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> x0$1) {
                    Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        boolean bl = !this.$outer.metadataCache().contains(topicPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            scala.collection.immutable.Map filteredRequestInfo = (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetCommitRequest.offsetData()).asScala()).toMap(Predef$.MODULE$.$conforms()).$minus$minus((GenTraversableOnce)invalidRequestsInfo.keys());
            Tuple2 tuple22 = filteredRequestInfo.partition((Function1)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$6;

                public final boolean apply(Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> x0$2) {
                    Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        boolean bl = this.$outer.kafka$server$KafkaApis$$authorize(this.request$6.session(), Read$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$6 = request$6;
                }
            });
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            scala.collection.immutable.Map authorizedRequestInfo = (scala.collection.immutable.Map)tuple22._1();
            scala.collection.immutable.Map unauthorizedRequestInfo = (scala.collection.immutable.Map)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.immutable.Map authorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map unauthorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._2();
            if (authorizedRequestInfo2.isEmpty()) {
                this.kafka$server$KafkaApis$$sendResponseCallback$1(scala.collection.Map$.MODULE$.empty(), request, header, invalidRequestsInfo, unauthorizedRequestInfo2);
                return;
            } else if (header.apiVersion() == 0) {
                scala.collection.immutable.Map responseInfo = (scala.collection.immutable.Map)authorizedRequestInfo2.map((Function1)new Serializable(this, offsetCommitRequest){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final OffsetCommitRequest offsetCommitRequest$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> x0$4) {
                        Tuple2 tuple2;
                        Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> tuple22 = x0$4;
                        if (tuple22 == null) throw new MatchError(tuple22);
                        TopicPartition topicPartition = (TopicPartition)tuple22._1();
                        OffsetCommitRequest.PartitionData partitionData = (OffsetCommitRequest.PartitionData)tuple22._2();
                        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.offsetCommitRequest$1.groupId(), topicPartition.topic());
                        try {
                            if (this.$outer.metadataCache().hasTopicMetadata(topicPartition.topic())) {
                                if (partitionData.metadata != null && partitionData.metadata.length() > Predef$.MODULE$.Integer2int(this.$outer.config().offsetMetadataMaxSize())) {
                                    tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.OFFSET_METADATA_TOO_LARGE.code()));
                                    return tuple2;
                                } else {
                                    this.$outer.zkUtils().updatePersistentPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicDirs.consumerOffsetDir(), BoxesRunTime.boxToInteger((int)topicPartition.partition())})), ((Object)BoxesRunTime.boxToLong((long)partitionData.offset)).toString(), this.$outer.zkUtils().updatePersistentPath$default$3());
                                    tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                                }
                                return tuple2;
                            } else {
                                tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
                            }
                            return tuple2;
                        }
                        catch (Throwable throwable) {
                            tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.forException((Throwable)throwable).code()));
                        }
                        return tuple2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.offsetCommitRequest$1 = offsetCommitRequest$1;
                    }
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                this.kafka$server$KafkaApis$$sendResponseCallback$1(responseInfo, request, header, invalidRequestsInfo, unauthorizedRequestInfo2);
                return;
            } else {
                long offsetRetention = header.apiVersion() <= 1 || offsetCommitRequest.retentionTime() == -1L ? this.coordinator().offsetConfig().offsetsRetentionMs() : offsetCommitRequest.retentionTime();
                long currentTimestamp = SystemTime$.MODULE$.milliseconds();
                long defaultExpireTimestamp = offsetRetention + currentTimestamp;
                scala.collection.immutable.Map partitionData = authorizedRequestInfo2.mapValues((Function1)new Serializable(this, offsetRetention, currentTimestamp, defaultExpireTimestamp){
                    public static final long serialVersionUID = 0L;
                    private final long offsetRetention$1;
                    private final long currentTimestamp$1;
                    private final long defaultExpireTimestamp$1;

                    public final OffsetAndMetadata apply(OffsetCommitRequest.PartitionData partitionData) {
                        String metadata = partitionData.metadata == null ? OffsetMetadata$.MODULE$.NoMetadata() : partitionData.metadata;
                        return new OffsetAndMetadata(new OffsetMetadata(partitionData.offset, metadata), this.currentTimestamp$1, partitionData.timestamp == -1L ? this.defaultExpireTimestamp$1 : this.offsetRetention$1 + partitionData.timestamp);
                    }
                    {
                        this.offsetRetention$1 = offsetRetention$1;
                        this.currentTimestamp$1 = currentTimestamp$1;
                        this.defaultExpireTimestamp$1 = defaultExpireTimestamp$1;
                    }
                });
                this.coordinator().handleCommitOffsets(offsetCommitRequest.groupId(), offsetCommitRequest.memberId(), offsetCommitRequest.generationId(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)partitionData, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)new Serializable(this, request, header, invalidRequestsInfo, unauthorizedRequestInfo2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final RequestChannel.Request request$6;
                    private final RequestHeader header$1;
                    private final scala.collection.mutable.Map invalidRequestsInfo$1;
                    private final scala.collection.immutable.Map unauthorizedRequestInfo$1;

                    public final void apply(scala.collection.immutable.Map<TopicPartition, Object> commitStatus) {
                        this.$outer.kafka$server$KafkaApis$$sendResponseCallback$1(commitStatus, this.request$6, this.header$1, this.invalidRequestsInfo$1, this.unauthorizedRequestInfo$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.request$6 = request$6;
                        this.header$1 = header$1;
                        this.invalidRequestsInfo$1 = invalidRequestsInfo$1;
                        this.unauthorizedRequestInfo$1 = unauthorizedRequestInfo$1;
                    }
                });
            }
            return;
        } else {
            Short errorCode = new Short(Errors.GROUP_AUTHORIZATION_FAILED.code());
            scala.collection.immutable.Map results = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(offsetCommitRequest.offsetData().keySet()).asScala()).map((Function1)new Serializable(this, errorCode){
                public static final long serialVersionUID = 0L;
                private final Short errorCode$1;

                public final Tuple2<TopicPartition, Short> apply(TopicPartition topicPartition) {
                    return new Tuple2((Object)topicPartition, (Object)this.errorCode$1);
                }
                {
                    this.errorCode$1 = errorCode$1;
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            ResponseHeader responseHeader = new ResponseHeader(header.correlationId());
            OffsetCommitResponse responseBody = new OffsetCommitResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)results).asJava());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        }
    }

    public boolean kafka$server$KafkaApis$$authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        return BoxesRunTime.unboxToBoolean((Object)this.authorizer().map((Function1)new Serializable(this, session, operation, resource){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Session session$1;
            private final Operation operation$1;
            private final Resource resource$1;

            public final boolean apply(Authorizer x$9) {
                return x$9.authorize(this.session$1, this.operation$1, this.resource$1);
            }
            {
                this.session$1 = session$1;
                this.operation$1 = operation$1;
                this.resource$1 = resource$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    public void handleProducerRequest(RequestChannel.Request request) {
        ProduceRequest produceRequest = (ProduceRequest)request.body();
        int numBytesAppended = request.header().sizeOf() + produceRequest.sizeOf();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceRequest.partitionRecords()).asScala()).partition((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$2;

            public final boolean apply(Tuple2<TopicPartition, ByteBuffer> x0$5) {
                Tuple2<TopicPartition, ByteBuffer> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    boolean bl = this.$outer.kafka$server$KafkaApis$$authorize(this.request$2.session(), Write$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
            scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
            scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
            if (authorizedRequestInfo2.isEmpty()) {
                this.kafka$server$KafkaApis$$sendResponseCallback$2((Map)scala.collection.Map$.MODULE$.empty(), request, produceRequest, numBytesAppended, unauthorizedRequestInfo2);
            } else {
                String string = request.header().clientId();
                String string2 = AdminUtils$.MODULE$.AdminClientId();
                boolean internalTopicsAllowed = !(string != null ? !string.equals(string2) : string2 != null);
                scala.collection.mutable.Map authorizedMessagesPerPartition = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, ByteBufferMessageSet> apply(Tuple2<TopicPartition, ByteBuffer> x0$8) {
                        Tuple2<TopicPartition, ByteBuffer> tuple2 = x0$8;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            ByteBuffer buffer = (ByteBuffer)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)new ByteBufferMessageSet(buffer));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                this.replicaManager().appendMessages(produceRequest.timeout(), produceRequest.acks(), internalTopicsAllowed, (Map<TopicPartition, MessageSet>)authorizedMessagesPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)new Serializable(this, request, produceRequest, numBytesAppended, unauthorizedRequestInfo2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final RequestChannel.Request request$2;
                    private final ProduceRequest produceRequest$1;
                    private final int numBytesAppended$1;
                    private final scala.collection.mutable.Map unauthorizedRequestInfo$2;

                    public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                        this.$outer.kafka$server$KafkaApis$$sendResponseCallback$2(responseStatus, this.request$2, this.produceRequest$1, this.numBytesAppended$1, this.unauthorizedRequestInfo$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.request$2 = request$2;
                        this.produceRequest$1 = produceRequest$1;
                        this.numBytesAppended$1 = numBytesAppended$1;
                        this.unauthorizedRequestInfo$2 = unauthorizedRequestInfo$2;
                    }
                });
                produceRequest.clearPartitionRecords();
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void handleFetchRequest(RequestChannel.Request request) {
        FetchRequest fetchRequest = (FetchRequest)request.requestObj();
        Tuple2 tuple2 = fetchRequest.requestInfo().partition((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$3;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionFetchInfo> x0$9) {
                Tuple2<TopicAndPartition, PartitionFetchInfo> tuple2 = x0$9;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    boolean bl = this.$outer.kafka$server$KafkaApis$$authorize(this.request$3.session(), Read$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicAndPartition.topic()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$3 = request$3;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map authorizedRequestInfo = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map unauthorizedRequestInfo = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.immutable.Map authorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map unauthorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._2();
            scala.collection.immutable.Map unauthorizedPartitionData = unauthorizedRequestInfo2.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final FetchResponsePartitionData apply(PartitionFetchInfo x$13) {
                    return new FetchResponsePartitionData(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L, MessageSet$.MODULE$.Empty());
                }
            });
            if (authorizedRequestInfo2.isEmpty()) {
                this.kafka$server$KafkaApis$$sendResponseCallback$3((Map)scala.collection.Map$.MODULE$.empty(), request, fetchRequest, unauthorizedPartitionData);
            } else {
                this.replicaManager().fetchMessages(fetchRequest.maxWait(), fetchRequest.replicaId(), fetchRequest.minBytes(), (scala.collection.immutable.Map<TopicAndPartition, PartitionFetchInfo>)authorizedRequestInfo2, (Function1<Map<TopicAndPartition, FetchResponsePartitionData>, BoxedUnit>)new Serializable(this, request, fetchRequest, unauthorizedPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final RequestChannel.Request request$3;
                    private final FetchRequest fetchRequest$1;
                    private final scala.collection.immutable.Map unauthorizedPartitionData$1;

                    public final void apply(Map<TopicAndPartition, FetchResponsePartitionData> responsePartitionData) {
                        this.$outer.kafka$server$KafkaApis$$sendResponseCallback$3(responsePartitionData, this.request$3, this.fetchRequest$1, this.unauthorizedPartitionData$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.request$3 = request$3;
                        this.fetchRequest$1 = fetchRequest$1;
                        this.unauthorizedPartitionData$1 = unauthorizedPartitionData$1;
                    }
                });
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void handleOffsetRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        String clientId = request.header().clientId();
        ListOffsetRequest offsetRequest = (ListOffsetRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetRequest.offsetData()).asScala()).partition((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$4;

            public final boolean apply(Tuple2<TopicPartition, ListOffsetRequest.PartitionData> x0$12) {
                Tuple2<TopicPartition, ListOffsetRequest.PartitionData> tuple2 = x0$12;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    boolean bl = this.$outer.kafka$server$KafkaApis$$authorize(this.request$4.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$4 = request$4;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
            scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
            scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
            Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ListOffsetResponse.PartitionData apply(ListOffsetRequest.PartitionData x$18) {
                    return new ListOffsetResponse.PartitionData(Errors.TOPIC_AUTHORIZATION_FAILED.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
                }
            });
            scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1)new Serializable(this, correlationId, clientId, offsetRequest){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                public final int correlationId$1;
                public final String clientId$1;
                private final ListOffsetRequest offsetRequest$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Tuple2<TopicPartition, ListOffsetResponse.PartitionData> apply(Tuple2<TopicPartition, ListOffsetRequest.PartitionData> elem) {
                    Tuple2 tuple2;
                    Tuple2 tuple23;
                    Tuple2<TopicPartition, ListOffsetRequest.PartitionData> tuple22 = elem;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    TopicPartition topicPartition2 = (TopicPartition)tuple22._1();
                    ListOffsetRequest.PartitionData partitionData = (ListOffsetRequest.PartitionData)tuple22._2();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)topicPartition2, (Object)partitionData);
                    TopicPartition topicPartition = (TopicPartition)tuple24._1();
                    ListOffsetRequest.PartitionData partitionData2 = (ListOffsetRequest.PartitionData)tuple24._2();
                    try {
                        Seq seq;
                        Replica localReplica = this.offsetRequest$1.replicaId() != -2 ? this.$outer.replicaManager().getLeaderReplicaIfLocal(topicPartition.topic(), topicPartition.partition()) : this.$outer.replicaManager().getReplicaOrException(topicPartition.topic(), topicPartition.partition());
                        Seq allOffsets = this.$outer.fetchOffsets(this.$outer.replicaManager().logManager(), topicPartition, partitionData2.timestamp, partitionData2.maxNumOffsets);
                        if (this.offsetRequest$1.replicaId() != -1) {
                            seq = allOffsets;
                        } else {
                            long hw = localReplica.highWatermark().messageOffset();
                            if (allOffsets.exists((Function1)new Serializable(this, hw){
                                public static final long serialVersionUID = 0L;
                                private final long hw$1;

                                public final boolean apply(long x$20) {
                                    return this.apply$mcZJ$sp(x$20);
                                }

                                public boolean apply$mcZJ$sp(long x$20) {
                                    return x$20 > this.hw$1;
                                }
                                {
                                    this.hw$1 = hw$1;
                                }
                            })) {
                                long l = hw;
                                seq = (Seq)((SeqLike)allOffsets.dropWhile((Function1)new Serializable(this, hw){
                                    public static final long serialVersionUID = 0L;
                                    private final long hw$1;

                                    public final boolean apply(long x$21) {
                                        return this.apply$mcZJ$sp(x$21);
                                    }

                                    public boolean apply$mcZJ$sp(long x$21) {
                                        return x$21 > this.hw$1;
                                    }
                                    {
                                        this.hw$1 = hw$1;
                                    }
                                })).$plus$colon((Object)BoxesRunTime.boxToLong((long)l), Seq$.MODULE$.canBuildFrom());
                            } else {
                                seq = allOffsets;
                            }
                        }
                        Seq offsets = seq;
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.NONE.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offsets.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Long apply(long x$23) {
                                return new Long(x$23);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava()));
                        return tuple2;
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Error while responding to offset request";
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$3;

                            public final Throwable apply() {
                                return this.e$3;
                            }
                            {
                                this.e$3 = e$3;
                            }
                        });
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                        return tuple2;
                    }
                    catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, notLeaderForPartitionException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$27 $outer;
                            private final TopicPartition topicPartition$3;
                            private final NotLeaderForPartitionException nle$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), this.$outer.clientId$1, this.topicPartition$3, this.nle$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.topicPartition$3 = topicPartition$3;
                                this.nle$1 = nle$1;
                            }
                        });
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)notLeaderForPartitionException).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                        return tuple2;
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, unknownTopicOrPartitionException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$27 $outer;
                            private final TopicPartition topicPartition$3;
                            private final UnknownTopicOrPartitionException utpe$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), this.$outer.clientId$1, this.topicPartition$3, this.utpe$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.topicPartition$3 = topicPartition$3;
                                this.utpe$1 = utpe$1;
                            }
                        });
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)unknownTopicOrPartitionException).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                    }
                    return tuple2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.correlationId$1 = correlationId$1;
                    this.clientId$1 = clientId$1;
                    this.offsetRequest$1 = offsetRequest$1;
                }
            }, Map$.MODULE$.canBuildFrom());
            scala.collection.mutable.Map mergedResponseMap = responseMap.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus);
            ResponseHeader responseHeader = new ResponseHeader(correlationId);
            ListOffsetResponse response = new ListOffsetResponse((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(mergedResponseMap).asJava());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)response)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<Object> fetchOffsets(LogManager logManager, TopicPartition topicPartition, long timestamp2, int maxNumOffsets) {
        Option<Log> option;
        block4: {
            Nil$ nil$;
            block3: {
                block2: {
                    option = logManager.getLog(new TopicAndPartition(topicPartition.topic(), topicPartition.partition()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Log log = (Log)some.x();
                    nil$ = this.fetchOffsetsBefore(log, timestamp2, maxNumOffsets);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                nil$ = timestamp2 == -1L || timestamp2 == -2L ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})) : Nil$.MODULE$;
            }
            return nil$;
        }
        throw new MatchError(option);
    }

    public Seq<Object> fetchOffsetsBefore(Log log, long timestamp2, int maxNumOffsets) {
        LogSegment[] segsArray = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        ObjectRef offsetTimeArray = ObjectRef.create(null);
        boolean lastSegmentHasSize = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray).last()).size() > 0L;
        offsetTimeArray.elem = lastSegmentHasSize ? new Tuple2[segsArray.length + 1] : new Tuple2[segsArray.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segsArray.length).foreach$mVc$sp((Function1)new Serializable(this, segsArray, offsetTimeArray){
            public static final long serialVersionUID = 0L;
            private final LogSegment[] segsArray$1;
            private final ObjectRef offsetTimeArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((Tuple2[])this.offsetTimeArray$1.elem)[i] = new Tuple2.mcJJ.sp(this.segsArray$1[i].baseOffset(), this.segsArray$1[i].lastModified());
            }
            {
                this.segsArray$1 = segsArray$1;
                this.offsetTimeArray$1 = offsetTimeArray$1;
            }
        });
        if (lastSegmentHasSize) {
            ((Tuple2[])offsetTimeArray.elem)[segsArray.length] = new Tuple2.mcJJ.sp(log.logEndOffset(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex = IntRef.create((int)-1);
        long l = timestamp2;
        if (-1L == l) {
            startIndex.elem = ((Tuple2[])offsetTimeArray.elem).length - 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (-2L == l) {
            startIndex.elem = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)new Serializable(this, offsetTimeArray){
                public static final long serialVersionUID = 0L;
                private final ObjectRef offsetTimeArray$1;

                public final String apply() {
                    StringBuilder stringBuilder = new StringBuilder().append((Object)"Offset time array = ");
                    Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])this.offsetTimeArray$1.elem)).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, Object> o) {
                            return new StringOps(Predef$.MODULE$.augmentString("%d, %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)o._1$mcJ$sp()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())}));
                        }
                    });
                    return stringBuilder.append((Object)BoxedUnit.UNIT).toString();
                }
                {
                    this.offsetTimeArray$1 = offsetTimeArray$1;
                }
            });
            startIndex.elem = ((Tuple2[])offsetTimeArray.elem).length - 1;
            while (startIndex.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray.elem)[startIndex.elem]._2$mcJ$sp() <= timestamp2) {
                    isFound = true;
                    continue;
                }
                --startIndex.elem;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        int retSize = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxNumOffsets), startIndex.elem + 1);
        long[] ret = new long[retSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), retSize).foreach$mVc$sp((Function1)new Serializable(this, offsetTimeArray, startIndex, ret){
            public static final long serialVersionUID = 0L;
            private final ObjectRef offsetTimeArray$1;
            private final IntRef startIndex$1;
            private final long[] ret$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                this.ret$1[j] = ((Tuple2[])this.offsetTimeArray$1.elem)[this.startIndex$1.elem]._1$mcJ$sp();
                --this.startIndex$1.elem;
            }
            {
                this.offsetTimeArray$1 = offsetTimeArray$1;
                this.startIndex$1 = startIndex$1;
                this.ret$1 = ret$1;
            }
        });
        return (Seq)Predef$.MODULE$.longArrayOps(ret).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$24) {
                return this.apply$mcJJ$sp(x$24);
            }

            public long apply$mcJJ$sp(long x$24) {
                return -x$24;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    public MetadataResponse.TopicMetadata kafka$server$KafkaApis$$createTopic(String topic, int numPartitions, int replicationFactor, Properties properties) {
        MetadataResponse.TopicMetadata topicMetadata;
        try {
            AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, numPartitions, replicationFactor, properties, RackAwareMode$Safe$.MODULE$);
            this.info((Function0<String>)new Serializable(this, topic, numPartitions, replicationFactor){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int numPartitions$1;
                private final int replicationFactor$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.numPartitions$1), BoxesRunTime.boxToInteger((int)this.replicationFactor$1)}));
                }
                {
                    this.topic$1 = topic$1;
                    this.numPartitions$1 = numPartitions$1;
                    this.replicationFactor$1 = replicationFactor$1;
                }
            });
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        catch (InvalidTopicException invalidTopicException) {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.INVALID_TOPIC_EXCEPTION, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        catch (TopicExistsException topicExistsException) {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        return topicMetadata;
    }

    public Properties kafka$server$KafkaApis$$createTopic$default$4() {
        return new Properties();
    }

    public MetadataResponse.TopicMetadata kafka$server$KafkaApis$$createGroupMetadataTopic() {
        Seq<Broker> aliveBrokers = this.metadataCache().getAliveBrokers();
        int offsetsTopicReplicationFactor = aliveBrokers.nonEmpty() ? Math.min(Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()), aliveBrokers.length()) : Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor());
        return this.kafka$server$KafkaApis$$createTopic("__consumer_offsets", Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), offsetsTopicReplicationFactor, this.coordinator().offsetsTopicConfigs());
    }

    private MetadataResponse.TopicMetadata getOrCreateGroupMetadataTopic(SecurityProtocol securityProtocol) {
        Seq<MetadataResponse.TopicMetadata> topicMetadata = this.metadataCache().getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"__consumer_offsets"}))), securityProtocol, this.metadataCache().getTopicMetadata$default$3());
        return (MetadataResponse.TopicMetadata)topicMetadata.headOption().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;

            public final MetadataResponse.TopicMetadata apply() {
                return this.$outer.kafka$server$KafkaApis$$createGroupMetadataTopic();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private Seq<MetadataResponse.TopicMetadata> getTopicMetadata(scala.collection.Set<String> topics, SecurityProtocol securityProtocol, boolean errorUnavailableEndpoints) {
        Seq seq;
        Seq topicResponses = this.metadataCache().getTopicMetadata(topics, securityProtocol, errorUnavailableEndpoints);
        if (topics.isEmpty() || topicResponses.size() == topics.size()) {
            seq = topicResponses;
        } else {
            scala.collection.Set nonExistentTopics = (scala.collection.Set)topics.$minus$minus((GenTraversableOnce)((TraversableOnce)topicResponses.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MetadataResponse.TopicMetadata x$25) {
                    return x$25.topic();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet());
            scala.collection.Set responsesForNonExistentTopics = (scala.collection.Set)nonExistentTopics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;

                public final MetadataResponse.TopicMetadata apply(String topic) {
                    String string = topic;
                    String string2 = "__consumer_offsets";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? this.$outer.kafka$server$KafkaApis$$createGroupMetadataTopic() : (Predef$.MODULE$.Boolean2boolean(this.$outer.config().autoCreateTopicsEnable()) ? this.$outer.kafka$server$KafkaApis$$createTopic(topic, Predef$.MODULE$.Integer2int(this.$outer.config().numPartitions()), this.$outer.config().defaultReplicationFactor(), this.$outer.kafka$server$KafkaApis$$createTopic$default$4()) : new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom());
            seq = (Seq)topicResponses.$plus$plus((GenTraversableOnce)responsesForNonExistentTopics, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public void handleTopicMetadataRequest(RequestChannel.Request request) {
        MetadataRequest metadataRequest = (MetadataRequest)request.body();
        short requestVersion = request.header().apiVersion();
        Set topics = requestVersion == 0 ? (metadataRequest.topics() == null || metadataRequest.topics().isEmpty() ? this.metadataCache().getAllTopics() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataRequest.topics()).asScala()).toSet()) : (metadataRequest.isAllTopics() ? this.metadataCache().getAllTopics() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataRequest.topics()).asScala()).toSet());
        Tuple2 tuple2 = topics.partition((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$5;

            public final boolean apply(String topic) {
                return this.$outer.kafka$server$KafkaApis$$authorize(this.request$5.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$5 = request$5;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.Set authorizedTopics = (scala.collection.Set)tuple2._1();
            scala.collection.Set unauthorizedTopics = (scala.collection.Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedTopics);
            ObjectRef authorizedTopics2 = ObjectRef.create((Object)((scala.collection.Set)tuple23._1()));
            ObjectRef unauthorizedTopics2 = ObjectRef.create((Object)((scala.collection.Set)tuple23._2()));
            if (((scala.collection.Set)authorizedTopics2.elem).nonEmpty()) {
                scala.collection.Set<String> nonExistingTopics = this.metadataCache().getNonExistingTopics((scala.collection.Set<String>)((scala.collection.Set)authorizedTopics2.elem));
                if (Predef$.MODULE$.Boolean2boolean(this.config().autoCreateTopicsEnable()) && nonExistingTopics.nonEmpty()) {
                    this.authorizer().foreach((Function1)new Serializable(this, request, authorizedTopics2, unauthorizedTopics2, nonExistingTopics){
                        public static final long serialVersionUID = 0L;
                        private final RequestChannel.Request request$5;
                        private final ObjectRef authorizedTopics$1;
                        private final ObjectRef unauthorizedTopics$1;
                        private final scala.collection.Set nonExistingTopics$1;

                        public final void apply(Authorizer az) {
                            if (!az.authorize(this.request$5.session(), Create$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                                this.authorizedTopics$1.elem = (scala.collection.Set)((scala.collection.Set)this.authorizedTopics$1.elem).$minus$minus((GenTraversableOnce)this.nonExistingTopics$1);
                                this.unauthorizedTopics$1.elem = ((scala.collection.Set)this.unauthorizedTopics$1.elem).$plus$plus((GenTraversableOnce)this.nonExistingTopics$1);
                            }
                        }
                        {
                            this.request$5 = request$5;
                            this.authorizedTopics$1 = authorizedTopics$1;
                            this.unauthorizedTopics$1 = unauthorizedTopics$1;
                            this.nonExistingTopics$1 = nonExistingTopics$1;
                        }
                    });
                }
            }
            scala.collection.Set unauthorizedTopicMetadata = (scala.collection.Set)((scala.collection.Set)unauthorizedTopics2.elem).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final MetadataResponse.TopicMetadata apply(String topic) {
                    return new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
                }
            }, Set$.MODULE$.canBuildFrom());
            boolean errorUnavailableEndpoints = requestVersion == 0;
            Seq<MetadataResponse.TopicMetadata> topicMetadata = ((scala.collection.Set)authorizedTopics2.elem).isEmpty() ? (Seq<MetadataResponse.TopicMetadata>)Seq$.MODULE$.empty() : this.getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)authorizedTopics2.elem), request.securityProtocol(), errorUnavailableEndpoints);
            Seq completeTopicMetadata = (Seq)topicMetadata.$plus$plus((GenTraversableOnce)unauthorizedTopicMetadata, Seq$.MODULE$.canBuildFrom());
            Seq<Broker> brokers = this.metadataCache().getAliveBrokers();
            this.trace((Function0<String>)new Serializable(this, request, completeTopicMetadata, brokers){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$5;
                private final Seq completeTopicMetadata$1;
                private final Seq brokers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sending topic metadata %s and brokers %s for correlation id %d to client %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.completeTopicMetadata$1.mkString(","), this.brokers$1.mkString(","), BoxesRunTime.boxToInteger((int)this.request$5.header().correlationId()), this.request$5.header().clientId()}));
                }
                {
                    this.request$5 = request$5;
                    this.completeTopicMetadata$1 = completeTopicMetadata$1;
                    this.brokers$1 = brokers$1;
                }
            });
            ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
            MetadataResponse responseBody = new MetadataResponse((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers.map((Function1)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$5;

                public final Node apply(Broker x$27) {
                    return x$27.getNode(this.request$5.securityProtocol());
                }
                {
                    this.request$5 = request$5;
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava(), BoxesRunTime.unboxToInt((Object)this.metadataCache().getControllerId().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return -1;
                }
            })), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(completeTopicMetadata).asJava(), (int)requestVersion);
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleOffsetFetchRequest(RequestChannel.Request request) {
        OffsetFetchResponse offsetFetchResponse;
        RequestHeader header = request.header();
        OffsetFetchRequest offsetFetchRequest = (OffsetFetchRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(header.correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetFetchRequest.groupId()))) {
            Tuple2 tuple2;
            Tuple2 tuple22 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetFetchRequest.partitions()).asScala()).partition((Function1)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$7;

                public final boolean apply(TopicPartition topicPartition) {
                    return this.$outer.kafka$server$KafkaApis$$authorize(this.request$7.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$7 = request$7;
                }
            });
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Buffer authorizedTopicPartitions = (Buffer)tuple22._1();
            Buffer unauthorizedTopicPartitions = (Buffer)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)authorizedTopicPartitions, (Object)unauthorizedTopicPartitions);
            Buffer authorizedTopicPartitions2 = (Buffer)tuple23._1();
            Buffer unauthorizedTopicPartitions2 = (Buffer)tuple23._2();
            OffsetFetchResponse.PartitionData unauthorizedTopicResponse = new OffsetFetchResponse.PartitionData(-1L, "", Errors.TOPIC_AUTHORIZATION_FAILED.code());
            scala.collection.immutable.Map unauthorizedStatus = ((TraversableOnce)unauthorizedTopicPartitions2.map((Function1)new Serializable(this, unauthorizedTopicResponse){
                public static final long serialVersionUID = 0L;
                private final OffsetFetchResponse.PartitionData unauthorizedTopicResponse$1;

                public final Tuple2<TopicPartition, OffsetFetchResponse.PartitionData> apply(TopicPartition topicPartition) {
                    return new Tuple2((Object)topicPartition, (Object)this.unauthorizedTopicResponse$1);
                }
                {
                    this.unauthorizedTopicResponse$1 = unauthorizedTopicResponse$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            OffsetFetchResponse.PartitionData unknownTopicPartitionResponse = new OffsetFetchResponse.PartitionData(-1L, "", Errors.UNKNOWN_TOPIC_OR_PARTITION.code());
            if (header.apiVersion() == 0) {
                scala.collection.immutable.Map responseInfo = ((TraversableOnce)authorizedTopicPartitions2.map((Function1)new Serializable(this, offsetFetchRequest, unknownTopicPartitionResponse){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final OffsetFetchRequest offsetFetchRequest$1;
                    private final OffsetFetchResponse.PartitionData unknownTopicPartitionResponse$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Tuple2<TopicPartition, OffsetFetchResponse.PartitionData> apply(TopicPartition topicPartition) {
                        Tuple2 tuple2;
                        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.offsetFetchRequest$1.groupId(), topicPartition.topic());
                        try {
                            if (this.$outer.metadataCache().hasTopicMetadata(topicPartition.topic())) {
                                Tuple2 tuple22;
                                Option payloadOpt = (Option)this.$outer.zkUtils().readDataMaybeNull(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicDirs.consumerOffsetDir(), BoxesRunTime.boxToInteger((int)topicPartition.partition())})))._1();
                                Option option = payloadOpt;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    String payload = (String)some.x();
                                    tuple22 = new Tuple2((Object)topicPartition, (Object)new OffsetFetchResponse.PartitionData(new StringOps(Predef$.MODULE$.augmentString(payload)).toLong(), "", Errors.NONE.code()));
                                } else {
                                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                    tuple22 = new Tuple2((Object)topicPartition, (Object)this.unknownTopicPartitionResponse$1);
                                }
                                tuple2 = tuple22;
                                return tuple2;
                            } else {
                                tuple2 = new Tuple2((Object)topicPartition, (Object)this.unknownTopicPartitionResponse$1);
                            }
                            return tuple2;
                        }
                        catch (Throwable throwable) {
                            tuple2 = new Tuple2((Object)topicPartition, (Object)new OffsetFetchResponse.PartitionData(-1L, "", Errors.forException((Throwable)throwable).code()));
                        }
                        return tuple2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.offsetFetchRequest$1 = offsetFetchRequest$1;
                        this.unknownTopicPartitionResponse$1 = unknownTopicPartitionResponse$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                offsetFetchResponse = new OffsetFetchResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)responseInfo.$plus$plus((GenTraversableOnce)unauthorizedStatus)).asJava());
            } else {
                scala.collection.immutable.Map offsets = this.coordinator().handleFetchOffsets(offsetFetchRequest.groupId(), (Seq<TopicPartition>)authorizedTopicPartitions2).toMap(Predef$.MODULE$.$conforms());
                offsetFetchResponse = new OffsetFetchResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets.$plus$plus((GenTraversableOnce)unauthorizedStatus)).asJava());
            }
        } else {
            OffsetFetchResponse.PartitionData unauthorizedGroupResponse = new OffsetFetchResponse.PartitionData(-1L, "", Errors.GROUP_AUTHORIZATION_FAILED.code());
            scala.collection.immutable.Map results = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetFetchRequest.partitions()).asScala()).map((Function1)new Serializable(this, unauthorizedGroupResponse){
                public static final long serialVersionUID = 0L;
                private final OffsetFetchResponse.PartitionData unauthorizedGroupResponse$1;

                public final Tuple2<TopicPartition, OffsetFetchResponse.PartitionData> apply(TopicPartition topicPartition) {
                    return new Tuple2((Object)topicPartition, (Object)this.unauthorizedGroupResponse$1);
                }
                {
                    this.unauthorizedGroupResponse$1 = unauthorizedGroupResponse$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            offsetFetchResponse = new OffsetFetchResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)results).asJava());
        }
        OffsetFetchResponse offsetFetchResponse2 = offsetFetchResponse;
        this.trace((Function0<String>)new Serializable(this, header, offsetFetchResponse2){
            public static final long serialVersionUID = 0L;
            private final RequestHeader header$2;
            private final OffsetFetchResponse offsetFetchResponse$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending offset fetch response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offsetFetchResponse$1, BoxesRunTime.boxToInteger((int)this.header$2.correlationId()), this.header$2.clientId()}));
            }
            {
                this.header$2 = header$2;
                this.offsetFetchResponse$1 = offsetFetchResponse$1;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)offsetFetchResponse2)));
    }

    public void handleGroupCoordinatorRequest(RequestChannel.Request request) {
        GroupCoordinatorRequest groupCoordinatorRequest = (GroupCoordinatorRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, groupCoordinatorRequest.groupId()))) {
            GroupCoordinatorResponse groupCoordinatorResponse;
            int partition = this.coordinator().partitionFor(groupCoordinatorRequest.groupId());
            MetadataResponse.TopicMetadata offsetsTopicMetadata = this.getOrCreateGroupMetadataTopic(request.securityProtocol());
            Errors errors = offsetsTopicMetadata.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                Some some;
                Node endpoint;
                Option coordinatorEndpoint = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetsTopicMetadata.partitionMetadata()).asScala()).find((Function1)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final int partition$1;

                    public final boolean apply(MetadataResponse.PartitionMetadata x$29) {
                        return x$29.partition() == this.partition$1;
                    }
                    {
                        this.partition$1 = partition$1;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Node apply(MetadataResponse.PartitionMetadata x$30) {
                        return x$30.leader();
                    }
                });
                Option option = coordinatorEndpoint;
                GroupCoordinatorResponse groupCoordinatorResponse2 = option instanceof Some && !(endpoint = (Node)(some = (Some)option).x()).isEmpty() ? new GroupCoordinatorResponse(Errors.NONE.code(), endpoint) : new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
                groupCoordinatorResponse = groupCoordinatorResponse2;
            } else {
                groupCoordinatorResponse = new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
            }
            GroupCoordinatorResponse responseBody = groupCoordinatorResponse;
            this.trace((Function0<String>)new Serializable(this, request, responseBody){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$8;
                private final GroupCoordinatorResponse responseBody$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sending consumer metadata %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.responseBody$1, BoxesRunTime.boxToInteger((int)this.request$8.header().correlationId()), this.request$8.header().clientId()}));
                }
                {
                    this.request$8 = request$8;
                    this.responseBody$1 = responseBody$1;
                }
            });
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        } else {
            GroupCoordinatorResponse responseBody = new GroupCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED.code(), Node.noNode());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        }
    }

    public void handleDescribeGroupRequest(RequestChannel.Request request) {
        DescribeGroupsRequest describeRequest = (DescribeGroupsRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        scala.collection.immutable.Map groups = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeRequest.groupIds()).asScala()).map((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$13;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<String, DescribeGroupsResponse.GroupMetadata> apply(String x0$13) {
                Tuple2 tuple2;
                String string = x0$13;
                if (this.$outer.kafka$server$KafkaApis$$authorize(this.request$13.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, string))) {
                    Tuple2 tuple22;
                    Tuple2<Errors, GroupSummary> tuple23 = this.$outer.coordinator().handleDescribeGroup(string);
                    if (tuple23 == null) throw new MatchError(tuple23);
                    Errors error = (Errors)tuple23._1();
                    GroupSummary summary = (GroupSummary)tuple23._2();
                    Tuple2 tuple24 = tuple22 = new Tuple2((Object)error, (Object)summary);
                    Errors error2 = (Errors)tuple24._1();
                    GroupSummary summary2 = (GroupSummary)tuple24._2();
                    List members = (List)summary2.members().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DescribeGroupsResponse.GroupMember apply(MemberSummary member) {
                            ByteBuffer metadata = ByteBuffer.wrap(member.metadata());
                            ByteBuffer assignment = ByteBuffer.wrap(member.assignment());
                            return new DescribeGroupsResponse.GroupMember(member.memberId(), member.clientId(), member.clientHost(), metadata, assignment);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)new DescribeGroupsResponse.GroupMetadata(error2.code(), summary2.state(), summary2.protocolType(), summary2.protocol(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)members).asJava()));
                    return tuple2;
                } else {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)DescribeGroupsResponse.GroupMetadata.forError((Errors)Errors.GROUP_AUTHORIZATION_FAILED));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$13 = request$13;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DescribeGroupsResponse responseBody = new DescribeGroupsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)groups).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleListGroupsRequest(RequestChannel.Request request) {
        ListGroupsResponse listGroupsResponse;
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Describe$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Tuple2 tuple2;
            Tuple2<Errors, List<GroupOverview>> tuple22 = this.coordinator().handleListGroups();
            if (tuple22 == null) throw new MatchError(tuple22);
            Errors error = (Errors)tuple22._1();
            List groups = (List)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            List allGroups = (List)groups2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ListGroupsResponse.Group apply(GroupOverview group) {
                    return new ListGroupsResponse.Group(group.groupId(), group.protocolType());
                }
            }, List$.MODULE$.canBuildFrom());
            listGroupsResponse = new ListGroupsResponse(error2.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allGroups).asJava());
        } else {
            listGroupsResponse = ListGroupsResponse.fromError((Errors)Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        ListGroupsResponse responseBody = listGroupsResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void handleJoinGroupRequest(RequestChannel.Request request) {
        JoinGroupRequest joinGroupRequest = (JoinGroupRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, joinGroupRequest.groupId()))) {
            List protocols2 = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(joinGroupRequest.groupProtocols()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, byte[]> apply(JoinGroupRequest.ProtocolMetadata protocol) {
                    return new Tuple2((Object)protocol.name(), (Object)Utils.toArray((ByteBuffer)protocol.metadata()));
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            this.coordinator().handleJoinGroup(joinGroupRequest.groupId(), joinGroupRequest.memberId(), request.header().clientId(), request.session().clientAddress().toString(), joinGroupRequest.sessionTimeout(), joinGroupRequest.protocolType(), (List<Tuple2<String, byte[]>>)protocols2, (Function1<JoinGroupResult, BoxedUnit>)new Serializable(this, request, responseHeader){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$9;
                private final ResponseHeader responseHeader$1;

                public final void apply(JoinGroupResult joinResult) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$4(joinResult, this.request$9, this.responseHeader$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$9 = request$9;
                    this.responseHeader$1 = responseHeader$1;
                }
            });
        } else {
            JoinGroupResponse responseBody = new JoinGroupResponse(Errors.GROUP_AUTHORIZATION_FAILED.code(), -1, "", "", "", JavaConversions$.MODULE$.mapAsJavaMap((Map)scala.collection.Map$.MODULE$.empty()));
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        }
    }

    public void handleSyncGroupRequest(RequestChannel.Request request) {
        SyncGroupRequest syncGroupRequest = (SyncGroupRequest)request.body();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, syncGroupRequest.groupId()))) {
            this.coordinator().handleSyncGroup(syncGroupRequest.groupId(), syncGroupRequest.generationId(), syncGroupRequest.memberId(), (Map<String, byte[]>)JavaConversions$.MODULE$.mapAsScalaMap(syncGroupRequest.groupAssignment()).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(ByteBuffer x$33) {
                    return Utils.toArray((ByteBuffer)x$33);
                }
            }), (Function2<byte[], Object, BoxedUnit>)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$12;

                public final void apply(byte[] memberState, short errorCode) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$5(memberState, errorCode, this.request$12);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$12 = request$12;
                }
            });
        } else {
            this.kafka$server$KafkaApis$$sendResponseCallback$5((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.GROUP_AUTHORIZATION_FAILED.code(), request);
        }
    }

    public void handleHeartbeatRequest(RequestChannel.Request request) {
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)request.body();
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, heartbeatRequest.groupId()))) {
            this.coordinator().handleHeartbeat(heartbeatRequest.groupId(), heartbeatRequest.memberId(), heartbeatRequest.groupGenerationId(), (Function1<Object, BoxedUnit>)new Serializable(this, request, respHeader){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$10;
                private final ResponseHeader respHeader$1;

                public final void apply(short errorCode) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$6(errorCode, this.request$10, this.respHeader$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$10 = request$10;
                    this.respHeader$1 = respHeader$1;
                }
            });
        } else {
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)heartbeatResponse)));
        }
    }

    private Map<Object, ClientQuotaManager> instantiateQuotaManagers(KafkaConfig cfg) {
        ClientQuotaManagerConfig producerQuotaManagerCfg = new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.producerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
        ClientQuotaManagerConfig consumerQuotaManagerCfg = new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.consumerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
        Map quotaManagers = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)ApiKeys.PRODUCE.id)), (Object)new ClientQuotaManager(producerQuotaManagerCfg, this.metrics(), ApiKeys.PRODUCE.name, (Time)new SystemTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)ApiKeys.FETCH.id)), (Object)new ClientQuotaManager(consumerQuotaManagerCfg, this.metrics(), ApiKeys.FETCH.name, (Time)new SystemTime()))}));
        return quotaManagers;
    }

    public void handleLeaveGroupRequest(RequestChannel.Request request) {
        LeaveGroupRequest leaveGroupRequest = (LeaveGroupRequest)request.body();
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, leaveGroupRequest.groupId()))) {
            this.coordinator().handleLeaveGroup(leaveGroupRequest.groupId(), leaveGroupRequest.memberId(), (Function1<Object, BoxedUnit>)new Serializable(this, request, respHeader){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$11;
                private final ResponseHeader respHeader$2;

                public final void apply(short errorCode) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$7(errorCode, this.request$11, this.respHeader$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$11 = request$11;
                    this.respHeader$2 = respHeader$2;
                }
            });
        } else {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)leaveGroupResponse)));
        }
    }

    public void handleSaslHandshakeRequest(RequestChannel.Request request) {
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        SaslHandshakeResponse response = new SaslHandshakeResponse(Errors.ILLEGAL_SASL_STATE.code(), this.config().saslEnabledMechanisms());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)response)));
    }

    public void handleApiVersionsRequest(RequestChannel.Request request) {
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        ApiVersionsResponse responseBody = Protocol.apiVersionSupported((short)ApiKeys.API_VERSIONS.id, (short)request.header().apiVersion()) ? ApiVersionsResponse.apiVersionsResponse() : ApiVersionsResponse.fromError((Errors)Errors.UNSUPPORTED_VERSION);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void close() {
        this.quotaManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, ClientQuotaManager> x0$15) {
                Tuple2<Object, ClientQuotaManager> tuple2 = x0$15;
                if (tuple2 != null) {
                    ClientQuotaManager quotaManager = (ClientQuotaManager)tuple2._2();
                    quotaManager.shutdown();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown complete.";
            }
        });
    }

    public void authorizeClusterAction(RequestChannel.Request request) {
        if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            return;
        }
        throw new ClusterAuthorizationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " is not authorized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request})));
    }

    public final void kafka$server$KafkaApis$$onLeadershipChange$1(Iterable updatedLeaders, Iterable updatedFollowers) {
        updatedLeaders.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;

            public final void apply(Partition partition) {
                String string = partition.topic();
                String string2 = "__consumer_offsets";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.coordinator().handleGroupImmigration(partition.partitionId());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        updatedFollowers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;

            public final void apply(Partition partition) {
                String string = partition.topic();
                String string2 = "__consumer_offsets";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.coordinator().handleGroupEmigration(partition.partitionId());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$1(scala.collection.immutable.Map commitStatus, RequestChannel.Request request$6, RequestHeader header$1, scala.collection.mutable.Map invalidRequestsInfo$1, scala.collection.immutable.Map unauthorizedRequestInfo$1) {
        scala.collection.immutable.Map mergedCommitStatus = commitStatus.$plus$plus((GenTraversableOnce)unauthorizedRequestInfo$1.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(OffsetCommitRequest.PartitionData x$6) {
                return Errors.TOPIC_AUTHORIZATION_FAILED.code();
            }
        }));
        mergedCommitStatus.foreach((Function1)new Serializable(this, header$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final RequestHeader header$1;

            public final void apply(Tuple2<TopicPartition, Object> x0$3) {
                Tuple2<TopicPartition, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    short errorCode = BoxesRunTime.unboxToShort((Object)tuple2._2());
                    if (errorCode != Errors.NONE.code()) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, errorCode){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$KafkaApis$$sendResponseCallback$1$1 $outer;
                            private final TopicPartition topicPartition$1;
                            private final short errorCode$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset commit request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.header$1.correlationId()), this.$outer.header$1.clientId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, Errors.forCode((short)this.errorCode$2).exceptionName()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.topicPartition$1 = topicPartition$1;
                                this.errorCode$2 = errorCode$2;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.header$1 = header$1;
            }
        });
        scala.collection.immutable.Map combinedCommitStatus = mergedCommitStatus.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Short apply(short x$7) {
                return new Short(x$7);
            }
        }).$plus$plus((GenTraversableOnce)invalidRequestsInfo$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, Short> apply(Tuple2<TopicPartition, OffsetCommitRequest.PartitionData> x$8) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8._1()), (Object)new Short(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
            }
        }, Map$.MODULE$.canBuildFrom()));
        ResponseHeader responseHeader = new ResponseHeader(header$1.correlationId());
        OffsetCommitResponse responseBody = new OffsetCommitResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)combinedCommitStatus).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$6, (Send)new ResponseSend(request$6.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public final void kafka$server$KafkaApis$$produceResponseCallback$1(int delayTimeMs, RequestChannel.Request request$2, ProduceRequest produceRequest$1, Map mergedResponseStatus$1, BooleanRef errorInResponse$1) {
        if (produceRequest$1.acks() == 0) {
            if (errorInResponse$1.elem) {
                String exceptionsSummary = ((TraversableOnce)mergedResponseStatus$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, String> apply(Tuple2<TopicPartition, ProduceResponse.PartitionResponse> x0$7) {
                        Tuple2<TopicPartition, ProduceResponse.PartitionResponse> tuple2 = x0$7;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.forCode((short)status.errorCode).exceptionName());
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, scala.collection.Map$.MODULE$.canBuildFrom())).mkString(", ");
                this.info((Function0<String>)new Serializable(this, request$2, exceptionsSummary){
                    public static final long serialVersionUID = 0L;
                    private final RequestChannel.Request request$2;
                    private final String exceptionsSummary$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing connection due to error during produce request with correlation id ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.request$2.header().correlationId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from client id ", " with ack=0\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$2.header().clientId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic and partition to exceptions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exceptionsSummary$1}))).toString();
                    }
                    {
                        this.request$2 = request$2;
                        this.exceptionsSummary$1 = exceptionsSummary$1;
                    }
                });
                this.requestChannel().closeConnection(request$2.processor(), request$2);
            } else {
                this.requestChannel().noOperation(request$2.processor(), request$2);
            }
        } else {
            ProduceResponse produceResponse;
            ResponseHeader respHeader = new ResponseHeader(request$2.header().correlationId());
            short s = request$2.header().apiVersion();
            switch (s) {
                default: {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Version `", "` of ProduceRequest is not handled. Code must be updated."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)s)})));
                }
                case 1: 
                case 2: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava(), delayTimeMs, (int)s);
                    break;
                }
                case 0: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava());
                }
            }
            ProduceResponse respBody = produceResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request$2, (Send)new ResponseSend(request$2.connectionId(), respHeader, (AbstractRequestResponse)respBody)));
        }
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$2(Map responseStatus, RequestChannel.Request request$2, ProduceRequest produceRequest$1, int numBytesAppended$1, scala.collection.mutable.Map unauthorizedRequestInfo$2) {
        Map mergedResponseStatus = responseStatus.$plus$plus((GenTraversableOnce)unauthorizedRequestInfo$2.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ProduceResponse.PartitionResponse apply(ByteBuffer x$11) {
                return new ProduceResponse.PartitionResponse(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L, Message$.MODULE$.NoTimestamp());
            }
        }));
        BooleanRef errorInResponse = BooleanRef.create((boolean)false);
        mergedResponseStatus.foreach((Function1)new Serializable(this, request$2, errorInResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final RequestChannel.Request request$2;
            private final BooleanRef errorInResponse$1;

            public final void apply(Tuple2<TopicPartition, ProduceResponse.PartitionResponse> x0$6) {
                Tuple2<TopicPartition, ProduceResponse.PartitionResponse> tuple2 = x0$6;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
                    if (status.errorCode != Errors.NONE.code()) {
                        this.errorInResponse$1.elem = true;
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, status){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$KafkaApis$$sendResponseCallback$2$2 $outer;
                            private final TopicPartition topicPartition$2;
                            private final ProduceResponse.PartitionResponse status$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.request$2.header().correlationId()), this.$outer.request$2.header().clientId(), this.topicPartition$2, Errors.forCode((short)this.status$1.errorCode).exceptionName()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.topicPartition$2 = topicPartition$2;
                                this.status$1 = status$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                this.errorInResponse$1 = errorInResponse$1;
            }
        });
        request$2.apiRemoteCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        ((ClientQuotaManager)this.quotaManagers().apply((Object)BoxesRunTime.boxToShort((short)ApiKeys.PRODUCE.id))).recordAndMaybeThrottle(request$2.header().clientId(), numBytesAppended$1, (Function1<Object, BoxedUnit>)new Serializable(this, request$2, produceRequest$1, mergedResponseStatus, errorInResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$2;
            private final ProduceRequest produceRequest$1;
            private final Map mergedResponseStatus$1;
            private final BooleanRef errorInResponse$1;

            public final void apply(int delayTimeMs) {
                this.apply$mcVI$sp(delayTimeMs);
            }

            public void apply$mcVI$sp(int delayTimeMs) {
                this.$outer.kafka$server$KafkaApis$$produceResponseCallback$1(delayTimeMs, this.request$2, this.produceRequest$1, this.mergedResponseStatus$1, this.errorInResponse$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                this.produceRequest$1 = produceRequest$1;
                this.mergedResponseStatus$1 = mergedResponseStatus$1;
                this.errorInResponse$1 = errorInResponse$1;
            }
        });
    }

    public final void kafka$server$KafkaApis$$fetchResponseCallback$1(int delayTimeMs, RequestChannel.Request request$3, FetchRequest fetchRequest$1, Map convertedPartitionData$1, Map mergedPartitionData$1) {
        this.trace((Function0<String>)new Serializable(this, fetchRequest$1, convertedPartitionData$1){
            public static final long serialVersionUID = 0L;
            private final FetchRequest fetchRequest$1;
            private final Map convertedPartitionData$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending fetch response to client ", " of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fetchRequest$1.clientId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.convertedPartitionData$1.values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(FetchResponsePartitionData x$15) {
                        return x$15.messages().sizeInBytes();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)}))).toString();
            }
            {
                this.fetchRequest$1 = fetchRequest$1;
                this.convertedPartitionData$1 = convertedPartitionData$1;
            }
        });
        FetchResponse response = new FetchResponse(fetchRequest$1.correlationId(), (Map<TopicAndPartition, FetchResponsePartitionData>)mergedPartitionData$1, fetchRequest$1.versionId(), delayTimeMs);
        this.requestChannel().sendResponse(new RequestChannel.Response(request$3, new FetchResponseSend(request$3.connectionId(), response)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$3(Map responsePartitionData, RequestChannel.Request request$3, FetchRequest fetchRequest$1, scala.collection.immutable.Map unauthorizedPartitionData$1) {
        Map convertedPartitionData = fetchRequest$1.versionId() <= 1 ? (Map)responsePartitionData.map((Function1)new Serializable(this, fetchRequest$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final FetchRequest fetchRequest$1;

            public final Tuple2<TopicAndPartition, FetchResponsePartitionData> apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x0$10) {
                Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2 = x0$10;
                if (tuple2 != null) {
                    FetchResponsePartitionData fetchResponsePartitionData;
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    FetchResponsePartitionData data = (FetchResponsePartitionData)tuple2._2();
                    if (this.$outer.replicaManager().getMessageFormatVersion(tp).exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(byte x$14) {
                            return x$14 > Message$.MODULE$.MagicValue_V0();
                        }
                    }) && !data.messages().isMagicValueInAllWrapperMessages(Message$.MODULE$.MagicValue_V0())) {
                        this.$outer.trace((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$22 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Down converting message to V0 for fetch request from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.fetchRequest$1.clientId()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        fetchResponsePartitionData = new FetchResponsePartitionData(data.error(), data.hw(), ((FileMessageSet)data.messages()).toMessageFormat(Message$.MODULE$.MagicValue_V0()));
                    } else {
                        fetchResponsePartitionData = data;
                    }
                    FetchResponsePartitionData convertedData = fetchResponsePartitionData;
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)convertedData);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchRequest$1 = fetchRequest$1;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom()) : responsePartitionData;
        Map mergedPartitionData = convertedPartitionData.$plus$plus((GenTraversableOnce)unauthorizedPartitionData$1);
        mergedPartitionData.foreach((Function1)new Serializable(this, fetchRequest$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final FetchRequest fetchRequest$1;

            public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x0$11) {
                Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2 = x0$11;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    FetchResponsePartitionData data = (FetchResponsePartitionData)tuple2._2();
                    if (data.error() != Errors.NONE.code()) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition, data){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$KafkaApis$$sendResponseCallback$3$2 $outer;
                            private final TopicAndPartition topicAndPartition$1;
                            private final FetchResponsePartitionData data$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.fetchRequest$1.correlationId()), this.$outer.fetchRequest$1.clientId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, Errors.forCode((short)this.data$1.error()).exceptionName()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.data$1 = data$1;
                            }
                        });
                    }
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicAndPartition.topic()).bytesOutRate().mark((long)data.messages().sizeInBytes());
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesOutRate().mark((long)data.messages().sizeInBytes());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchRequest$1 = fetchRequest$1;
            }
        });
        request$3.apiRemoteCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        if (fetchRequest$1.isFromFollower()) {
            this.kafka$server$KafkaApis$$fetchResponseCallback$1(0, request$3, fetchRequest$1, convertedPartitionData, mergedPartitionData);
        } else {
            ((ClientQuotaManager)this.quotaManagers().apply((Object)BoxesRunTime.boxToShort((short)ApiKeys.FETCH.id))).recordAndMaybeThrottle(fetchRequest$1.clientId(), FetchResponse$.MODULE$.responseSize((Map<String, Map<TopicAndPartition, FetchResponsePartitionData>>)mergedPartitionData.groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x$16) {
                    return ((TopicAndPartition)x$16._1()).topic();
                }
            }), fetchRequest$1.versionId()), (Function1<Object, BoxedUnit>)new Serializable(this, request$3, fetchRequest$1, convertedPartitionData, mergedPartitionData){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$3;
                private final FetchRequest fetchRequest$1;
                private final Map convertedPartitionData$1;
                private final Map mergedPartitionData$1;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.kafka$server$KafkaApis$$fetchResponseCallback$1(delayTimeMs, this.request$3, this.fetchRequest$1, this.convertedPartitionData$1, this.mergedPartitionData$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$3 = request$3;
                    this.fetchRequest$1 = fetchRequest$1;
                    this.convertedPartitionData$1 = convertedPartitionData$1;
                    this.mergedPartitionData$1 = mergedPartitionData$1;
                }
            });
        }
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$4(JoinGroupResult joinResult, RequestChannel.Request request$9, ResponseHeader responseHeader$1) {
        Map members = (Map)joinResult.members().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ByteBuffer> apply(Tuple2<String, byte[]> x0$14) {
                Tuple2<String, byte[]> tuple2 = x0$14;
                if (tuple2 != null) {
                    String memberId = (String)tuple2._1();
                    byte[] metadataArray = (byte[])tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)ByteBuffer.wrap(metadataArray));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        JoinGroupResponse responseBody = new JoinGroupResponse(joinResult.errorCode(), joinResult.generationId(), joinResult.subProtocol(), joinResult.memberId(), joinResult.leaderId(), JavaConversions$.MODULE$.mapAsJavaMap(members));
        this.trace((Function0<String>)new Serializable(this, request$9, responseBody){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$9;
            private final JoinGroupResponse responseBody$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending join group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.responseBody$2, BoxesRunTime.boxToInteger((int)this.request$9.header().correlationId()), this.request$9.header().clientId()}));
            }
            {
                this.request$9 = request$9;
                this.responseBody$2 = responseBody$2;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request$9, (Send)new ResponseSend(request$9.connectionId(), responseHeader$1, (AbstractRequestResponse)responseBody)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$5(byte[] memberState, short errorCode, RequestChannel.Request request$12) {
        SyncGroupResponse responseBody = new SyncGroupResponse(errorCode, ByteBuffer.wrap(memberState));
        ResponseHeader responseHeader = new ResponseHeader(request$12.header().correlationId());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$12, (Send)new ResponseSend(request$12.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$6(short errorCode, RequestChannel.Request request$10, ResponseHeader respHeader$1) {
        HeartbeatResponse response = new HeartbeatResponse(errorCode);
        this.trace((Function0<String>)new Serializable(this, request$10, response){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$10;
            private final HeartbeatResponse response$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending heartbeat response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1, BoxesRunTime.boxToInteger((int)this.request$10.header().correlationId()), this.request$10.header().clientId()}));
            }
            {
                this.request$10 = request$10;
                this.response$1 = response$1;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request$10, (Send)new ResponseSend(request$10.connectionId(), respHeader$1, (AbstractRequestResponse)response)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$7(short errorCode, RequestChannel.Request request$11, ResponseHeader respHeader$2) {
        LeaveGroupResponse response = new LeaveGroupResponse(errorCode);
        this.trace((Function0<String>)new Serializable(this, request$11, response){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$11;
            private final LeaveGroupResponse response$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending leave group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2, BoxesRunTime.boxToInteger((int)this.request$11.header().correlationId()), this.request$11.header().clientId()}));
            }
            {
                this.request$11 = request$11;
                this.response$2 = response$2;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request$11, (Send)new ResponseSend(request$11.connectionId(), respHeader$2, (AbstractRequestResponse)response)));
    }

    public KafkaApis(RequestChannel requestChannel, ReplicaManager replicaManager, GroupCoordinator coordinator, KafkaController controller, ZkUtils zkUtils, int brokerId, KafkaConfig config, MetadataCache metadataCache, Metrics metrics, Option<Authorizer> authorizer) {
        this.requestChannel = requestChannel;
        this.replicaManager = replicaManager;
        this.coordinator = coordinator;
        this.controller = controller;
        this.zkUtils = zkUtils;
        this.brokerId = brokerId;
        this.config = config;
        this.metadataCache = metadataCache;
        this.metrics = metrics;
        this.authorizer = authorizer;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[KafkaApi-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        this.quotaManagers = this.instantiateQuotaManagers(config);
    }
}

