/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-a!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\tu\u0011\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\t\u0015)\u0003\u0018\u0003\u0015yf-\u001b7f!\tAR$D\u0001\u001a\u0015\tQ2$\u0001\u0002j_*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u00111\u0015\u000e\\3)\u0005U\u0001\u0003C\u0001\u0006\"\u0013\t\u00113B\u0001\u0005w_2\fG/\u001b7f\u0011!!\u0003A!b\u0001\n\u0003)\u0013A\u00032bg\u0016|eMZ:fiV\ta\u0005\u0005\u0002\u000bO%\u0011\u0001f\u0003\u0002\u0005\u0019>tw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003'\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u00111\u0002!Q1A\u0005\u00025\nA\"\\1y\u0013:$W\r_*ju\u0016,\u0012A\f\t\u0003\u0015=J!\u0001M\u0006\u0003\u0007%sG\u000f\u0003\u00053\u0001\t\u0005\t\u0015!\u0003/\u00035i\u0017\r_%oI\u0016D8+\u001b>fA!)A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"BA\u000e$H\u0011B!q\u0007\u0001\u001dD\u001b\u0005\u0011\u0001CA\u001d;\u0019\u0001!Qa\u000f\u0001C\u0002q\u0012\u0011aS\t\u0003{\u0001\u0003\"A\u0003 \n\u0005}Z!a\u0002(pi\"Lgn\u001a\t\u0003\u0015\u0005K!AQ\u0006\u0003\u0007\u0005s\u0017\u0010\u0005\u0002:\t\u0012)Q\t\u0001b\u0001y\t\ta\u000bC\u0003\u0017g\u0001\u0007q\u0003C\u0003%g\u0001\u0007a\u0005C\u0004-gA\u0005\t\u0019\u0001\u0018\t\u000b)\u0003a\u0011C\u0017\u0002\u0013\u0015tGO]=TSj,\u0007b\u0002'\u0001\u0005\u0004%\t\"T\u0001\u0005Y>\u001c7.F\u0001O!\tye+D\u0001Q\u0015\t\t&+A\u0003m_\u000e\\7O\u0003\u0002T)\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U[\u0012\u0001B;uS2L!a\u0016)\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019I\u0006\u0001)A\u0005\u001d\u0006)An\\2lA!91\f\u0001a\u0001\n#a\u0016\u0001B7nCB,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003An\t1A\\5p\u0013\t\u0011wL\u0001\tNCB\u0004X\r\u001a\"zi\u0016\u0014UO\u001a4fe\"9A\r\u0001a\u0001\n#)\u0017\u0001C7nCB|F%Z9\u0015\u0005\u0019L\u0007C\u0001\u0006h\u0013\tA7B\u0001\u0003V]&$\bb\u00026d\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\n\u0004B\u00027\u0001A\u0003&Q,A\u0003n[\u0006\u0004\b\u0005\u000b\u0002lA!1q\u000e\u0001Q!\n9\n1bX7bq\u0016sGO]5fg\"\u0012a\u000e\t\u0005\be\u0002\u0001\r\u0011\"\u0005.\u0003!yVM\u001c;sS\u0016\u001c\bb\u0002;\u0001\u0001\u0004%\t\"^\u0001\r?\u0016tGO]5fg~#S-\u001d\u000b\u0003MZDqA[:\u0002\u0002\u0003\u0007a\u0006\u0003\u0004y\u0001\u0001\u0006KAL\u0001\n?\u0016tGO]5fg\u0002B#a\u001e\u0011\t\u000bm\u0004A\u0011\u0001?\u0002\r%\u001ch)\u001e7m+\u0005i\bC\u0001\u0006\u007f\u0013\ty8BA\u0004C_>dW-\u00198\t\r\u0005\r\u0001\u0001\"\u0001.\u0003)i\u0017\r_#oiJLWm\u001d\u0005\u0007\u0003\u000f\u0001A\u0011A\u0017\u0002\u000f\u0015tGO]5fg\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011\u0001\u00024jY\u0016,\u0012a\u0006\u0005\b\u0003#\u0001A\u0011AA\n\u0003\u0019\u0011Xm]5{KR\u0019a-!\u0006\t\u000f\u0005]\u0011q\u0002a\u0001]\u00059a.Z<TSj,\u0007bBA\u000e\u0001\u0011\u0005\u0011QD\u0001\te\u0016t\u0017-\\3U_R\u0019a-a\b\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001/\u0005\ta\rC\u0004\u0002&\u0001!\t!a\n\u0002\u000b\u0019dWo\u001d5\u0015\u0003\u0019Dq!a\u000b\u0001\t\u0003\ti#\u0001\u0004eK2,G/\u001a\u000b\u0002{\"9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u001d\u0012a\u0004;sS6$vNV1mS\u0012\u001c\u0016N_3\t\r\u0005U\u0002\u0001\"\u0001.\u0003-\u0019\u0018N_3J]\nKH/Z:\t\u000f\u0005e\u0002\u0001\"\u0001\u0002(\u0005)1\r\\8tK\"9\u0011Q\b\u0001\u0007\u0002\u0005\u001d\u0012aC:b]&$\u0018p\u00115fG.Dq!!\u0011\u0001\r\u0003\t9#\u0001\u0005ueVt7-\u0019;f\u0011\u001d\t)\u0005\u0001D\u0001\u0003\u000f\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\r1\u0017\u0011\n\u0005\b\u0003\u0017\n\u0019\u00051\u0001'\u0003\u0019ygMZ:fi\"9\u0011q\n\u0001\u0005\u0012\u0005E\u0013A\u00034pe\u000e,WK\\7baR\u0019a-a\u0015\t\u000f\u0005U\u0013Q\na\u0001;\u0006\tQ\u000eC\u0004\u0002Z\u0001!\t\"a\u0017\u0002\u00135\f\u0017PY3M_\u000e\\W\u0003BA/\u0003G\"B!a\u0018\u0002rQ!\u0011\u0011MA4!\rI\u00141\r\u0003\b\u0003K\n9F1\u0001=\u0005\u0005!\u0006\"CA5\u0003/\"\t\u0019AA6\u0003\r1WO\u001c\t\u0006\u0015\u00055\u0014\u0011M\u0005\u0004\u0003_Z!\u0001\u0003\u001fcs:\fW.\u001a \t\u000f1\u000b9\u00061\u0001\u0002tA\u0019q*!\u001e\n\u0007\u0005]\u0004K\u0001\u0003M_\u000e\\\u0007bBA>\u0001\u0019E\u0011QP\u0001\u000ba\u0006\u00148/Z#oiJLHCBA@\u0003\u000b\u000by\tE\u00028\u0003\u0003K1!a!\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\t\u0003\u000f\u000bI\b1\u0001\u0002\n\u00061!-\u001e4gKJ\u00042AXAF\u0013\r\tii\u0018\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBAI\u0003s\u0002\rAL\u0001\u0002]\"9\u0011Q\u0013\u0001\u0005\u0012\u0005]\u0015\u0001D5oI\u0016D8\u000b\\8u\r>\u0014Hc\u0002\u0018\u0002\u001a\u0006u\u0015\u0011\u0015\u0005\t\u00037\u000b\u0019\n1\u0001\u0002\n\u0006\u0019\u0011\u000e\u001a=\t\u000f\u0005}\u00151\u0013a\u0001M\u00051A/\u0019:hKRD\u0001\"a)\u0002\u0014\u0002\u0007\u0011QU\u0001\rg\u0016\f'o\u00195F]RLG/\u001f\t\u0005\u0003O\u000bYL\u0004\u0003\u0002*\u0006]f\u0002BAV\u0003ksA!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003c3\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019A!C\u0002\u0002:\n\tq\"\u00138eKb\u001cV-\u0019:dQRK\b/Z\u0005\u0005\u0003{\u000byLA\tJ]\u0012,\u0007pU3be\u000eDWI\u001c;jifT1!!/\u0003\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000b\f\u0011cY8na\u0006\u0014X-\u00138eKb,e\u000e\u001e:z)\u001dq\u0013qYAf\u0003\u001bD\u0001\"!3\u0002B\u0002\u0007\u0011qP\u0001\u000bS:$W\r_#oiJL\bbBAP\u0003\u0003\u0004\rA\n\u0005\t\u0003G\u000b\t\r1\u0001\u0002&\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0017\u0001\u0007:pk:$Gi\\<o)>,\u00050Y2u\u001bVdG/\u001b9mKR)a&!6\u0002Z\"9\u0011q[Ah\u0001\u0004q\u0013A\u00028v[\n,'\u000fC\u0004\u0002\\\u0006=\u0007\u0019\u0001\u0018\u0002\r\u0019\f7\r^8s\u000f%\tyNAA\u0001\u0012\u0003\t\t/A\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0004o\u0005\rh\u0001C\u0001\u0003\u0003\u0003E\t!!:\u0014\u0007\u0005\r\u0018\u0002C\u00045\u0003G$\t!!;\u0015\u0005\u0005\u0005\bBCAw\u0003G\f\n\u0011\"\u0001\u0002p\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*b!!=\u0003\b\t%QCAAzU\rq\u0013Q_\u0016\u0003\u0003o\u0004B!!?\u0003\u00045\u0011\u00111 \u0006\u0005\u0003{\fy0A\u0005v]\u000eDWmY6fI*\u0019!\u0011A\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\u0005m(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001211(a;C\u0002q\"a!RAv\u0005\u0004a\u0004")
public abstract class AbstractIndex<K, V>
implements Logging {
    public volatile File kafka$log$AbstractIndex$$_file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public File file() {
        return this.kafka$log$AbstractIndex$$_file;
    }

    public void resize(int newSize) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            /*
             * WARNING - void declaration
             */
            public final Buffer apply() {
                Buffer buffer;
                RandomAccessFile raf = new RandomAccessFile(this.$outer.kafka$log$AbstractIndex$$_file, "rw");
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                int position = this.$outer.mmap().position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.forceUnmap(this.$outer.mmap());
                }
                try {
                    raf.setLength(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    buffer = this.$outer.mmap().position(position);
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var1_1;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                return buffer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.kafka$log$AbstractIndex$$_file.toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.kafka$log$AbstractIndex$$_file = f;
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$_file.getAbsolutePath()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (Os$.MODULE$.isWindows()) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.forceUnmap(this.$outer.mmap());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.kafka$log$AbstractIndex$$_file.delete();
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void forceUnmap(MappedByteBuffer m) {
        try {
            MappedByteBuffer mappedByteBuffer = m;
            if (mappedByteBuffer instanceof DirectBuffer) {
                BoxedUnit boxedUnit;
                MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
                Cleaner bufferCleaner = ((DirectBuffer)((Object)mappedByteBuffer2)).cleaner();
                if (bufferCleaner == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    bufferCleaner.clean();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int indexSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return -1;
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return -1;
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return mid;
        }
        return lo;
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File _file, long baseOffset, int maxIndexSize) {
        this.kafka$log$AbstractIndex$$_file = _file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = _file.createNewFile();
        RandomAccessFile raf = new RandomAccessFile(_file, "rw");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            long len = raf.length();
            MappedByteBuffer idx = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len);
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            });
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var6_5;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

