/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.common.Topic$;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\u0005e!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\f\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\t9\"$D\u0001\u0019\u0015\tIB!A\u0003vi&d7/\u0003\u0002\u001c1\t9Aj\\4hS:<\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0019\u0002\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#aA%oi\"1!\u0006\u0001Q\u0001\n\r\na\u0002\u001d:pIV\u001cWM]\"pk:$\b\u0005C\u0004-\u0001\t\u0007I\u0011\u0001\u0012\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u0011\u0019q\u0003\u0001)A\u0005G\u0005q1m\u001c8tk6,'oQ8v]R\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\tAI\u0001\fg\u0016\u0014h/\u001a:D_VtG\u000f\u0003\u00043\u0001\u0001\u0006IaI\u0001\rg\u0016\u0014h/\u001a:D_VtG\u000f\t\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0003\u0015!x\u000e]5d+\u00051\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0011a\u0017M\\4\u000b\u0003m\nAA[1wC&\u0011Q\b\u000f\u0002\u0007'R\u0014\u0018N\\4\t\r}\u0002\u0001\u0015!\u00037\u0003\u0019!x\u000e]5dA!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0013\u0001\u00029beRDaa\u0011\u0001!\u0002\u0013\u0019\u0013!\u00029beR\u0004\u0003bB#\u0001\u0005\u0004%\tAR\u0001\u0003iB,\u0012a\u0012\t\u0003\u0011:k\u0011!\u0013\u0006\u0003\u0015.\u000baaY8n[>t'BA\u0003M\u0015\tie\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001f&\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004R\u0001\u0001\u0006IaR\u0001\u0004iB\u0004\u0003bB*\u0001\u0005\u0004%\tAI\u0001\u0006a\u0006\u0014HO\r\u0005\u0007+\u0002\u0001\u000b\u0011B\u0012\u0002\rA\f'\u000f\u001e\u001a!\u0011\u001d9\u0006A1A\u0005\u0002\u0019\u000b1\u0001\u001e93\u0011\u0019I\u0006\u0001)A\u0005\u000f\u0006!A\u000f\u001d\u001a!\u0011\u0015Y\u0006\u0001\"\u0011]\u0003\u0015\u0019X\r^+q)\u0005i\u0006C\u0001\u0013_\u0013\tyVE\u0001\u0003V]&$\bF\u0001.b!\t\u0011G-D\u0001d\u0015\tYa\"\u0003\u0002fG\n1!)\u001a4pe\u0016DQa\u001a\u0001\u0005\u0002q\u000bQ\u0003^3tiNKW\u000e\u001d7f\u0007>t7/^7qi&|g\u000e\u000b\u0002gSB\u0011!M[\u0005\u0003W\u000e\u0014A\u0001V3ti\")Q\u000e\u0001C\u00019\u00069B/Z:u\u0007>|'\u000fZ5oCR|'OR1jY>4XM\u001d\u0015\u0003Y&4A\u0001\u001d\u0001\tc\n\u0001C+Z:u\u0007>t7/^7feJ+\u0017m]:jO:lWM\u001c;MSN$XM\\3s'\ry'/\u001e\t\u0003oML!\u0001\u001e\u001d\u0003\r=\u0013'.Z2u!\t180D\u0001x\u0015\tA\u00180\u0001\u0005d_:\u001cX/\\3s\u0015\tQ8*A\u0004dY&,g\u000e^:\n\u0005q<(!G\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJDQ!H8\u0005\u0002y$\u0012a \t\u0004\u0003\u0003yW\"\u0001\u0001\t\u0011\u0005\u0015q\u000e1A\u0005\u0002\t\nqbY1mYN$v.Q:tS\u001etW\r\u001a\u0005\n\u0003\u0013y\u0007\u0019!C\u0001\u0003\u0017\t1cY1mYN$v.Q:tS\u001etW\rZ0%KF$2!XA\u0007\u0011%\ty!a\u0002\u0002\u0002\u0003\u00071%A\u0002yIEBq!a\u0005pA\u0003&1%\u0001\tdC2d7\u000fV8BgNLwM\\3eA!A\u0011qC8A\u0002\u0013\u0005!%\u0001\bdC2d7\u000fV8SKZ|7.\u001a3\t\u0013\u0005mq\u000e1A\u0005\u0002\u0005u\u0011AE2bY2\u001cHk\u001c*fm>\\W\rZ0%KF$2!XA\u0010\u0011%\ty!!\u0007\u0002\u0002\u0003\u00071\u0005C\u0004\u0002$=\u0004\u000b\u0015B\u0012\u0002\u001f\r\fG\u000e\\:U_J+go\\6fI\u0002Bq!a\np\t\u0003\tI#\u0001\u000bp]B\u000b'\u000f^5uS>t7/Q:tS\u001etW\r\u001a\u000b\u0004;\u0006-\u0002\u0002CA\u0017\u0003K\u0001\r!a\f\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003\u00022\u0005]r)\u0004\u0002\u00024)\u0019\u0011Q\u0007\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\u0006D_2dWm\u0019;j_:Dq!!\u0010p\t\u0003\ty$A\np]B\u000b'\u000f^5uS>t7OU3w_.,G\rF\u0002^\u0003\u0003B\u0001\"!\f\u0002<\u0001\u0007\u0011q\u0006\u0005\b\u0003\u000b\u0002A\u0011CA$\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\t\u0005%\u0013\u0011\u0010\t\u0007\u0003\u0017\nY&!\u0019\u000f\t\u00055\u0013q\u000b\b\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013bAA-K\u00059\u0001/Y2lC\u001e,\u0017\u0002BA/\u0003?\u00121aU3r\u0015\r\tI&\n\t\t\u0003G\nI'!\u001c\u0002n5\u0011\u0011Q\r\u0006\u0004\u0003OJ\u0018\u0001\u00039s_\u0012,8-\u001a:\n\t\u0005-\u0014Q\r\u0002\u000f!J|G-^2feJ+7m\u001c:e!\u0015!\u0013qNA:\u0013\r\t\t(\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004I\u0005U\u0014bAA<K\t!!)\u001f;f\u0011\u001d\tY(a\u0011A\u0002\r\n!B\\;n%\u0016\u001cwN\u001d3t\u0011\u001d\t)\u0005\u0001C\t\u0003\u007f\"b!!\u0013\u0002\u0002\u0006\r\u0005bBA>\u0003{\u0002\ra\t\u0005\u0007\u000b\u0006u\u0004\u0019A$\t\u000f\u0005\u0015\u0003\u0001\"\u0005\u0002\bRA\u0011\u0011JAE\u0003#\u000b\u0019\n\u0003\u0005\u0002h\u0005\u0015\u0005\u0019AAF!!\t\u0019'!$\u0002n\u00055\u0014\u0002BAH\u0003K\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bbBA>\u0003\u000b\u0003\ra\t\u0005\u0007\u000b\u0006\u0015\u0005\u0019A$\t\u000f\u0005]\u0005\u0001\"\u0005\u0002\u001a\u000692m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u000b\u0012;\u0006m\u00151UAS\u0003S\u000bi+a.\u0002H\u0006%\u0007b\u0002=\u0002\u0016\u0002\u0007\u0011Q\u0014\t\bm\u0006}\u0015QNA7\u0013\r\t\tk\u001e\u0002\t\u0007>t7/^7fe\"9\u00111PAK\u0001\u0004\u0019\u0003bBAT\u0003+\u0003\raI\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011%\tY+!&\u0011\u0002\u0003\u00071%\u0001\rti\u0006\u0014H/\u001b8h\u0017\u0016L\u0018I\u001c3WC2,X-\u00138eKbD!\"a,\u0002\u0016B\u0005\t\u0019AAY\u0003E\u0019H/\u0019:uS:<G+[7fgR\fW\u000e\u001d\t\u0004I\u0005M\u0016bAA[K\t!Aj\u001c8h\u0011)\tI,!&\u0011\u0002\u0003\u0007\u00111X\u0001\u000ei&lWm\u001d;b[B$\u0016\u0010]3\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fS1!!1J\u0003\u0019\u0011XmY8sI&!\u0011QYA`\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\"AQ)!&\u0011\u0002\u0003\u0007q\tC\u0005\u0002L\u0006U\u0005\u0013!a\u0001G\u0005qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\bbBAh\u0001\u0011E\u0011\u0011[\u0001\u000fG>t7/^7f%\u0016\u001cwN\u001d3t+\u0019\t\u0019.a<\u0003\u0004QA\u0011Q\u001bB\u0004\u0005\u0017\u0011i\u0001\u0005\u0004\u0002X\u0006\u0005\u0018Q]\u0007\u0003\u00033TA!a7\u0002^\u00069Q.\u001e;bE2,'bAApK\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018\u0011\u001c\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0004w\u0003O\fYO!\u0001\n\u0007\u0005%xO\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\t\u00055\u0018q\u001e\u0007\u0001\t!\t\t0!4C\u0002\u0005M(!A&\u0012\t\u0005U\u00181 \t\u0004I\u0005]\u0018bAA}K\t9aj\u001c;iS:<\u0007c\u0001\u0013\u0002~&\u0019\u0011q`\u0013\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002n\n\rA\u0001\u0003B\u0003\u0003\u001b\u0014\r!a=\u0003\u0003YCq\u0001_Ag\u0001\u0004\u0011I\u0001E\u0004w\u0003?\u000bYO!\u0001\t\u000f\u0005m\u0014Q\u001aa\u0001G!I\u00111ZAg!\u0003\u0005\ra\t\u0005\b\u0005#\u0001A\u0011\u0003B\n\u0003M\tw/Y5u\u0007>lW.\u001b;DC2d'-Y2l+\u0019\u0011)B!\b\u0003\"Q9QLa\u0006\u0003$\te\u0004b\u0002=\u0003\u0010\u0001\u0007!\u0011\u0004\t\bm\u0006}%1\u0004B\u0010!\u0011\tiO!\b\u0005\u0011\u0005E(q\u0002b\u0001\u0003g\u0004B!!<\u0003\"\u0011A!Q\u0001B\b\u0005\u0004\t\u0019\u0010\u0003\u0005\u0003&\t=\u0001\u0019\u0001B\u0014\u00039\u0019w.\\7ji\u000e\u000bG\u000e\u001c2bG.\u0004B!!\u0001\u0003*\u00191!1\u0006\u0001\t\u0005[\u00111dQ8v]R\u001cuN\\:v[\u0016\u00148i\\7nSR\u001c\u0015\r\u001c7cC\u000e\\7#\u0002B\u0015e\n=\u0002c\u0001<\u00032%\u0019!1G<\u0003)=3gm]3u\u0007>lW.\u001b;DC2d'-Y2l\u0011\u001di\"\u0011\u0006C\u0001\u0005o!\"Aa\n\t\u0013\tm\"\u0011\u0006a\u0001\n\u0003\u0011\u0013\u0001D:vG\u000e,7o]\"pk:$\bB\u0003B \u0005S\u0001\r\u0011\"\u0001\u0003B\u0005\u00012/^2dKN\u001c8i\\;oi~#S-\u001d\u000b\u0004;\n\r\u0003\"CA\b\u0005{\t\t\u00111\u0001$\u0011!\u00119E!\u000b!B\u0013\u0019\u0013!D:vG\u000e,7o]\"pk:$\b\u0005C\u0005\u0003L\t%\u0002\u0019!C\u0001E\u0005Ia-Y5m\u0007>,h\u000e\u001e\u0005\u000b\u0005\u001f\u0012I\u00031A\u0005\u0002\tE\u0013!\u00044bS2\u001cu.\u001e8u?\u0012*\u0017\u000fF\u0002^\u0005'B\u0011\"a\u0004\u0003N\u0005\u0005\t\u0019A\u0012\t\u0011\t]#\u0011\u0006Q!\n\r\n!BZ1jY\u000e{WO\u001c;!\u0011!\u0011YF!\u000b\u0005B\tu\u0013AC8o\u0007>l\u0007\u000f\\3uKR)QLa\u0018\u0003p!A!\u0011\rB-\u0001\u0004\u0011\u0019'A\u0004pM\u001a\u001cX\r^:\u0011\u000f\u0005E\"QM$\u0003j%!!qMA\u001a\u0005\ri\u0015\r\u001d\t\u0004m\n-\u0014b\u0001B7o\n\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u0011\tE$\u0011\fa\u0001\u0005g\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\u0005-#QO\u0005\u0005\u0005o\nyFA\u0005Fq\u000e,\u0007\u000f^5p]\"I!1\u0010B\b!\u0003\u0005\raI\u0001\u0006G>,h\u000e\u001e\u0004\u0007\u0005\u007f\u0002\u0001B!!\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'o\u0005\u0003\u0003~\t\r\u0005cA\f\u0003\u0006&\u0019!q\u0011\r\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\u000bq\nu$\u0011!Q\u0001\n\u0005u\u0005b\u0003BG\u0005{\u0012\t\u0011)A\u0005\u0005\u001f\u000b\u0011\u0003^8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f!\u0019\tYE!%\u0003\u0016&!!1SA0\u0005\u0011a\u0015n\u001d;\u0011\t\t]%Q\u0014\b\u0004I\te\u0015b\u0001BNK\u00051\u0001K]3eK\u001aL1!\u0010BP\u0015\r\u0011Y*\n\u0005\b;\tuD\u0011\u0001BR)\u0019\u0011)Ka*\u0003*B!\u0011\u0011\u0001B?\u0011\u001dA(\u0011\u0015a\u0001\u0003;C\u0001B!$\u0003\"\u0002\u0007!q\u0012\u0005\u000b\u0005[\u0013i\b1A\u0005\n\t=\u0016a\u00059beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$XC\u0001BY!\u0015\u00119Ja-H\u0013\u0011\u0011)La(\u0003\u0007M+G\u000f\u0003\u0006\u0003:\nu\u0004\u0019!C\u0005\u0005w\u000bq\u0003]1si&$\u0018n\u001c8BgNLwM\\7f]R|F%Z9\u0015\u0007u\u0013i\f\u0003\u0006\u0002\u0010\t]\u0016\u0011!a\u0001\u0005cC\u0011B!1\u0003~\u0001\u0006KA!-\u0002)A\f'\u000f^5uS>t\u0017i]:jO:lWM\u001c;!Q\u0011\u0011yL!2\u0011\u0007\u0011\u00129-C\u0002\u0003J\u0016\u0012\u0001B^8mCRLG.\u001a\u0005\u000b\u0005\u001b\u0014i\b1A\u0005\n\t=\u0017A\u0005;pa&\u001c7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:,\"Aa$\t\u0015\tM'Q\u0010a\u0001\n\u0013\u0011).\u0001\fu_BL7m]*vEN\u001c'/\u001b9uS>tw\fJ3r)\ri&q\u001b\u0005\u000b\u0003\u001f\u0011\t.!AA\u0002\t=\u0005\"\u0003Bn\u0005{\u0002\u000b\u0015\u0002BH\u0003M!x\u000e]5dgN+(m]2sSB$\u0018n\u001c8!\u0011)\u0011yN! A\u0002\u0013%!\u0011]\u0001\u0014gV\u00147o\u0019:jaRLwN\\\"iC:<W\rZ\u000b\u0003\u0005G\u00042\u0001\nBs\u0013\r\u00119/\n\u0002\b\u0005>|G.Z1o\u0011)\u0011YO! A\u0002\u0013%!Q^\u0001\u0018gV\u00147o\u0019:jaRLwN\\\"iC:<W\rZ0%KF$2!\u0018Bx\u0011)\tyA!;\u0002\u0002\u0003\u0007!1\u001d\u0005\n\u0005g\u0014i\b)Q\u0005\u0005G\fAc];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012\u0004\u0003\u0006\u0002By\u0005\u000bD!B!?\u0003~\t\u0007I\u0011\u0001B~\u0003E\u0011XMY1mC:\u001cW\rT5ti\u0016tWM]\u000b\u0003\u0005{\u0014BAa@sk\u001a91\u0011AB\u0002\u0001\tu(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\"CB\u0003\u0005{\u0002\u000b\u0011\u0002B\u007f\u0003I\u0011XMY1mC:\u001cW\rT5ti\u0016tWM\u001d\u0011\t\u0011\r%!Q\u0010C\u0001\u0007\u0017\t!cY8ogVlWM]!tg&<g.\\3oiR\u0011!\u0011\u0017\u0005\t\u0007\u001f\u0011i\b\"\u0001\u0004\u0012\u0005I1/\u001e2tGJL'-\u001a\u000b\u0004;\u000eM\u0001\u0002CB\u000b\u0007\u001b\u0001\rAa$\u0002)9,w\u000fV8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f\u0011!\u0019IB! \u0005\u0002\rm\u0011aG5t'V\u00147o\u0019:jE\u0016\u0014V-];fgR\u0004&o\\2fgN,G\r\u0006\u0002\u0003d\"A1q\u0004B?\t\u0003\u001aY\"\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]\"911\u0005B?\t\u0003b\u0016A\u00023p/>\u00148\u000eC\u0004\u0004(\u0001!\ta!\u000b\u00025%\u001c\b+\u0019:uSRLwN\\!tg&<g.\\3oiZ\u000bG.\u001b3\u0015\r\t\r81FB\u001b\u0011!\u0019ic!\nA\u0002\r=\u0012aC1tg&<g.\\3oiN\u0004b!a6\u00042\tE\u0016\u0002BB\u001a\u00033\u0014aAQ;gM\u0016\u0014\b\u0002CA\u0017\u0007K\u0001\rA!-\t\u0013\re\u0002!%A\u0005\u0012\rm\u0012!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TCAB\u001fU\r\u00193qH\u0016\u0003\u0007\u0003\u0002Baa\u0011\u0004N5\u00111Q\t\u0006\u0005\u0007\u000f\u001aI%A\u0005v]\u000eDWmY6fI*\u001911J\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004P\r\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I11\u000b\u0001\u0012\u0002\u0013E1QK\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007/RC!!-\u0004@!I11\f\u0001\u0012\u0002\u0013E1QL\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HEN\u000b\u0003\u0007?RC!a/\u0004@!I11\r\u0001\u0012\u0002\u0013E1QM\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0007OR3aRB \u0011%\u0019Y\u0007AI\u0001\n#\u0019Y$A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$\u0003\bC\u0005\u0004p\u0001\t\n\u0011\"\u0005\u0004r\u0005i\u0012m^1ji\u000e{W.\\5u\u0007\u0006dGNY1dW\u0012\"WMZ1vYR$3'\u0006\u0004\u0004<\rM4Q\u000f\u0003\t\u0003c\u001ciG1\u0001\u0002t\u0012A!QAB7\u0005\u0004\t\u0019\u0010C\u0005\u0004z\u0001\t\n\u0011\"\u0005\u0004|\u0005A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\r\rm2QPB@\t!\t\tpa\u001eC\u0002\u0005MH\u0001\u0003B\u0003\u0007o\u0012\r!a=")
public abstract class BaseConsumerTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int part2;
    private final TopicPartition tp2;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        return IntegrationTestHarness$class.createNewProducer(this);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> createNewConsumer() {
        return IntegrationTestHarness$class.createNewConsumer(this);
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(2000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer0.partitionsFor(Topic$.MODULE$.GroupMetadataTopicName())).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        consumer0.poll(5000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords) {
        return this.sendRecords(numRecords, this.tp());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords, TopicPartition tp) {
        return this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords, tp);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            /*
             * WARNING - void declaration
             */
            public final ProducerRecord<byte[], byte[]> apply(int i) {
                void var2_2;
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.producer$1.send(record);
                return var2_2;
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayBuffer records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1)new Serializable(this, records){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer records$2;

                public final ArrayBuffer<ConsumerRecord<K, V>> apply(ConsumerRecord<K, V> record) {
                    return this.records$2.$plus$eq(record);
                }
                {
                    this.records$2 = records$2;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Set<TopicPartition> assignment) {
                return assignment.nonEmpty();
            }
        });
        if (allNonEmptyAssignments) {
            Set uniqueAssignedPartitions;
            int n = 0;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<TopicPartition> apply(Set<TopicPartition> x$5, Set<TopicPartition> x$6) {
                    return (Set)x$5.$plus$plus(x$6);
                }
            });
            Set<TopicPartition> set3 = partitions;
            return !(set2 != null ? !set2.equals(set3) : set3 != null);
        }
        return false;
    }

    public BaseConsumerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.part2 = 1;
        this.tp2 = new TopicPartition(this.topic(), this.part2());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subsribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
            }
            catch (WakeupException wakeupException) {
                // empty catch block
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

