/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_9_0$;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\t\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005E!bBA\u0005\u0013\u0013\t\u0019\"\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Y\u0011aa\u0015;sS:<'BA\n\u000b\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\b\t\u00037\u0001i\u0011A\u0001\u0005\u0006\u001f]\u0001\r\u0001\u0005\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0015\u0019w\u000eZ3d+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0005\u0003\u001diWm]:bO\u0016L!!\n\u0012\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007BB\u0014\u0001A\u0003%\u0001%\u0001\u0004d_\u0012,7\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0003\u0011!\u0018.\\3\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#\u0001C'pG.$\u0016.\\3\t\rI\u0002\u0001\u0015!\u0003,\u0003\u0015!\u0018.\\3!\u0011\u001d!\u0004A1A\u0005\u0002U\n1b]3h[\u0016tGoU5{KV\ta\u0007\u0005\u0002\no%\u0011\u0001H\u0003\u0002\u0004\u0013:$\bB\u0002\u001e\u0001A\u0003%a'\u0001\u0007tK\u001elWM\u001c;TSj,\u0007\u0005C\u0004=\u0001\t\u0007I\u0011A\u001b\u0002\u0017\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001c\u0002\u0019\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0011\t\u000f\u0001\u0003!\u0019!C\u0001\u0003\u00069An\\4OC6,W#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00027b]\u001eT\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016\t\"1!\n\u0001Q\u0001\n\t\u000b\u0001\u0002\\8h\u001d\u0006lW\r\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0003\u0019awn\u001a#jeV\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002R\r\u0006\u0011\u0011n\\\u0005\u0003'B\u0013AAR5mK\"1Q\u000b\u0001Q\u0001\n9\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004X\u0001\u0001\u0007I\u0011A\u001b\u0002\u000f\r|WO\u001c;fe\"9\u0011\f\u0001a\u0001\n\u0003Q\u0016aC2pk:$XM]0%KF$\"a\u00170\u0011\u0005%a\u0016BA/\u000b\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u00037\u0003!\u0019w.\u001e8uKJ\u0004\u0003\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0001e\u0003\u001d\u0019G.Z1oKJ,\u0012!\u001a\t\u00037\u0019L!a\u001a\u0002\u0003\u00151{wm\u00117fC:,'\u000fC\u0005j\u0001\u0001\u0007\t\u0019!C\u0001U\u0006Y1\r\\3b]\u0016\u0014x\fJ3r)\tY6\u000eC\u0004`Q\u0006\u0005\t\u0019A3\t\r5\u0004\u0001\u0015)\u0003f\u0003!\u0019G.Z1oKJ\u0004\u0003bB8\u0001\u0005\u0004%\t\u0001]\u0001\u0007i>\u0004\u0018nY:\u0016\u0003E\u00042!\u0003:u\u0013\t\u0019(BA\u0003BeJ\f\u0017\u0010\u0005\u0002vq6\taO\u0003\u0002x\t\u000511m\\7n_:L!!\u001f<\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004|\u0001\u0001\u0006I!]\u0001\bi>\u0004\u0018nY:!\u0011\u0015i\b\u0001\"\u0001\u007f\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u0003mC3\u0001`A\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tQA[;oSRT!!a\u0003\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0010\u0005\u0015!\u0001\u0002+fgRDa!a\u0005\u0001\t\u0003q\u0018a\n;fgR\u001cE.Z1og\u000e{WNY5oK\u0012\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\rV8qS\u000eDC!!\u0005\u0002\u0002!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011aG2sK\u0006$X\rT1sO\u0016\u001c\u0016N\\4mK6+7o]1hKN+G\u000f\u0006\u0004\u0002\u001e\u0005%\u0012Q\u0006\t\u0007\u0013\u0005}\u0001#a\t\n\u0007\u0005\u0005\"B\u0001\u0004UkBdWM\r\t\u0004C\u0005\u0015\u0012bAA\u0014E\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDq!a\u000b\u0002\u0018\u0001\u0007a'A\u0002lKfD\u0001\"a\f\u0002\u0018\u0001\u0007\u0011\u0011G\u0001\u0015[\u0016\u001c8/Y4f\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0011\u0007%\t\u0019$C\u0002\u00026)\u0011AAQ=uK\"1\u0011\u0011\b\u0001\u0005\u0002y\fa\u0004^3ti\u000ecW-\u00198fe^KG\u000f['fgN\fw-\u001a$pe6\fGO\u0016\u0019)\t\u0005]\u0012\u0011\u0001\u0005\u0007\u0003\u007f\u0001A\u0011\u0001@\u0002]Q,7\u000f^\"mK\u0006t\u0017N\\4OKN$X\rZ'fgN\fw-Z:XSRDW*\u001e7uSBdWMV3sg&|gn\u001d\u0015\u0005\u0003{\t\t\u0001C\u0004\u0002F\u0001!I!a\u0012\u0002!\rDWmY6MCN$8\t\\3b]\u0016$GcB.\u0002J\u00055\u0013\u0011\u000b\u0005\b\u0003\u0017\n\u0019\u00051\u0001\u0011\u0003\u0015!x\u000e]5d\u0011\u001d\ty%a\u0011A\u0002Y\n1\u0002]1si&$\u0018n\u001c8JI\"A\u00111KA\"\u0001\u0004\t)&\u0001\u0006gSJ\u001cH\u000fR5sif\u00042!CA,\u0013\r\tIF\u0003\u0002\u0005\u0019>tw\rC\u0004\u0002^\u0001!I!a\u0018\u00025\rDWmY6M_\u001e\fe\r^3s\u0003B\u0004XM\u001c3j]\u001e$U\u000f]:\u0015\u000fm\u000b\t'!\u001b\u0002n!91!a\u0017A\u0002\u0005\r\u0004cA\u000e\u0002f%\u0019\u0011q\r\u0002\u0003\u00071{w\r\u0003\u0005\u0002l\u0005m\u0003\u0019AA+\u0003%\u0019H/\u0019:u'&TX\r\u0003\u0005\u0002p\u0005m\u0003\u0019AA9\u0003\u001d\t\u0007\u000f]3oIN\u0004b!a\u001d\u0002\u0004\u0006%e\u0002BA;\u0003\u007frA!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003w2\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\r\t\tIC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t))a\"\u0003\u0007M+\u0017OC\u0002\u0002\u0002*\u0001R!CA\u0010mAAq!!$\u0001\t\u0013\ty)A\u0006sK\u0006$gI]8n\u0019><G\u0003BAI\u0003;\u0003b!a%\u0002\u001a\u0006%UBAAK\u0015\r\t9JC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAN\u0003+\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0007\u0005-\u0005\u0019AA2\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u000b\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u001d\u0005E\u0014QUAU\u0003[\u000by+!-\u00026\"9\u0011qUAP\u0001\u00041\u0014a\u00028v[.+\u0017p\u001d\u0005\b\u0003W\u000by\n1\u00017\u0003\u001dqW/\u001c#vaNDqaAAP\u0001\u0004\t\u0019\u0007\u0003\u0004\u001f\u0003?\u0003\r\u0001\t\u0005\n\u0003g\u000by\n%AA\u0002Y\n\u0001b\u001d;beR\\U-\u001f\u0005\u000b\u0003o\u000by\n%AA\u0002\u0005E\u0012AC7bO&\u001cg+\u00197vK\"9\u00111\u0018\u0001\u0005\n\u0005u\u0016!G<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$b\"!\u001d\u0002@\u0006\u0005\u00171YAc\u0003\u000f\fI\rC\u0004\u0002(\u0006e\u0006\u0019\u0001\u001c\t\u000f\u0005-\u0016\u0011\u0018a\u0001m!91!!/A\u0002\u0005\r\u0004B\u0002\u0010\u0002:\u0002\u0007\u0001\u0005C\u0005\u00024\u0006e\u0006\u0013!a\u0001m!Q\u0011qWA]!\u0003\u0005\r!!\r\t\r\u00055\u0007\u0001\"\u0001\u007f\u0003!!X-\u0019:E_^t\u0007\u0006BAf\u0003#\u0004B!a\u0001\u0002T&!\u0011Q[A\u0003\u0005\u0015\te\r^3s\u0011\u001d\tI\u000e\u0001C\u0005\u00037\f1\u0003\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$\u0002\"!8\u0002j\u00065\u0018\u0011\u001f\t\u0005\u0003?\f)/\u0004\u0002\u0002b*\u0019\u00111\u001d$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003O\f\tO\u0001\u0006Qe>\u0004XM\u001d;jKND!\"a;\u0002XB\u0005\t\u0019AAo\u0003E\u0001(o\u001c9feRLxJ^3se&$Wm\u001d\u0005\b\u0003_\f9\u000e1\u00017\u00039i\u0017\r_'fgN\fw-Z*ju\u0016D!\"a=\u0002XB\u0005\t\u0019AA{\u0003Yi\u0017N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|\u0007cA\u0005\u0002x&\u0019\u0011\u0011 \u0006\u0003\u000b\u0019cw.\u0019;\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\u0006YQ.Y6f\u00072,\u0017M\\3s)5)'\u0011\u0001B\u0003\u0005\u000f\u0011YA!\u0004\u0003\u0012!9!1AA~\u0001\u00041\u0014!\u00029beR\u001c\bBCAz\u0003w\u0004\n\u00111\u0001\u0002v\"I!\u0011BA~!\u0003\u0005\rAN\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\b\"CAx\u0003w\u0004\n\u00111\u00017\u0011)\u0011y!a?\u0011\u0002\u0003\u0007\u0011QK\u0001\u0018Y><7\t\\3b]\u0016\u0014()Y2l\u001f\u001a4W*\u001b7mSND!\"a;\u0002|B\u0005\t\u0019AAo\u0011%\u0011)\u0002AI\u0001\n\u0013\u00119\"A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te!\u0006BA{\u00057Y#A!\b\u0011\t\t}!\u0011F\u0007\u0003\u0005CQAAa\t\u0003&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005OQ\u0011AC1o]>$\u0018\r^5p]&!!1\u0006B\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005_\u0001\u0011\u0013!C\u0005\u0005c\tQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$3'\u0006\u0002\u00034)\u001aaGa\u0007\t\u0013\t]\u0002!%A\u0005\n\tE\u0012!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005w\u0001\u0011\u0013!C\u0005\u0005{\tQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0003@)\"\u0011Q\u000bB\u000e\u0011%\u0011\u0019\u0005AI\u0001\n\u0013\u0011)%A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\u001d#\u0006BAo\u00057A\u0011Ba\u0013\u0001#\u0003%IA!\r\u0002']\u0014\u0018\u000e^3EkB\u001cH\u0005Z3gCVdG\u000fJ\u001b\t\u0013\t=\u0003!%A\u0005\n\tE\u0013aE<sSR,G)\u001e9tI\u0011,g-Y;mi\u00122TC\u0001B*U\u0011\t\tDa\u0007\t\u0013\t]\u0003!%A\u0005\n\t\u0015\u0013!\b7pO\u000e{gNZ5h!J|\u0007/\u001a:uS\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\t\u0013\tm\u0003!%A\u0005\n\t]\u0011!\b7pO\u000e{gNZ5h!J|\u0007/\u001a:uS\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\t}\u0003!%A\u0005\n\tE\u0012aI<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$C-\u001a4bk2$H%\u000e\u0005\n\u0005G\u0002\u0011\u0013!C\u0005\u0005#\n1e\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fi\u0012\"WMZ1vYR$c\u0007K\u0004\u0001\u0005O\u0012\u0019H!\u001e\u0011\t\t%$qN\u0007\u0003\u0005WRAA!\u001c\u0002\u0006\u00051!/\u001e8oKJLAA!\u001d\u0003l\t9!+\u001e8XSRD\u0017!\u0002<bYV,7E\u0001B<!\u0011\u0011IHa \u000e\u0005\tm$\u0002\u0002B?\u0003\u000b\tqA];o]\u0016\u00148/\u0003\u0003\u0003\u0002\nm$!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0003\u0006\nA\tAa\"\u000231{wm\u00117fC:,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u00047\t%eAB\u0001\u0003\u0011\u0003\u0011YiE\u0002\u0003\n\"Aq\u0001\u0007BE\t\u0003\u0011y\t\u0006\u0002\u0003\b\"A!1\u0013BE\t\u0003\u0011)*\u0001\u0006qCJ\fW.\u001a;feN,\"Aa&\u0011\r\u0005}'\u0011\u0014BO\u0013\u0011\u0011Y*!9\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002\neBACA!%\u0003\"B!!1\u0015B[\u001d\u0011\u0011)K!-\u000f\t\t\u001d&q\u0016\b\u0005\u0005S\u0013iK\u0004\u0003\u0002x\t-\u0016BAA\u0006\u0013\u0011\t9!!\u0003\n\t\tu\u0014QA\u0005\u0005\u0005g\u0013Y(A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0005o\u0013IL\u0001\u0006QCJ\fW.\u001a;feNTAAa-\u0003|\u0001")
public class LogCleanerIntegrationTest {
    private final CompressionCodec codec;
    private final MockTime time;
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir;
    private int counter;
    private LogCleaner cleaner;
    private final TopicAndPartition[] topics;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public CompressionCodec codec() {
        return this.codec;
    }

    public MockTime time() {
        return this.time;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public TopicAndPartition[] topics() {
        return this.topics;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, ByteBufferMessageSet> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, Message$.MODULE$.MagicValue_V1());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            ByteBufferMessageSet largeMessageSet = (ByteBufferMessageSet)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            ByteBufferMessageSet largeMessageSet2 = (ByteBufferMessageSet)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            int x$9 = 3;
            int x$10 = maxMessageSize;
            float x$11 = this.makeCleaner$default$2();
            int x$12 = this.makeCleaner$default$3();
            long x$13 = this.makeCleaner$default$5();
            Properties x$14 = this.makeCleaner$default$6();
            this.cleaner_$eq(this.makeCleaner(x$9, x$11, x$12, x$10, x$13, x$14));
            Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
            Seq<Tuple2<Object, String>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log.size();
            this.cleaner().startup();
            long firstDirty = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log, startSize, appends);
            log.append(largeMessageSet2, true);
            int x$15 = largeMessageKey + 1;
            int x$16 = 100;
            int x$17 = 3;
            Log x$18 = log;
            CompressionCodec x$19 = this.codec();
            byte x$20 = this.writeDups$default$6();
            Seq<Tuple2<Object, String>> dups = this.writeDups(x$16, x$17, x$18, x$19, x$15, x$20);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)largeMessageKey)), (Object)largeMessageValue2)})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple2<Object, String>>)appends2);
            this.cleaner().logs().remove((Object)this.topics()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile())).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topics()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 != null) {
            Log log;
            Log log2;
            Log log3 = log2 = (log = (Log)tuple2._1());
            log3.logSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final boolean apply(LogSegment x$4) {
                    return x$4.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log3){
                public static final long serialVersionUID = 0L;
                private final Log log$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$2.numberOfSegments() == 1;
                }
                {
                    this.log$2 = log$2;
                }
            }, "There should only be 1 segment remaining", 10000L);
            Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
            this.cleaner().shutdown();
            Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
            if (tuple22 != null) {
                Tuple2 tuple23;
                Log log22 = (Log)tuple22._1();
                Seq messages2 = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)log22, (Object)messages2);
                Log log23 = (Log)tuple24._1();
                Seq messages3 = (Seq)tuple24._2();
                Iterable<Tuple2<Object, String>> read = this.readFromLog(log23);
                Assert.assertEquals((String)"Contents of the map shouldn't change", (Object)messages3.toMap(Predef$.MODULE$.$conforms()), (Object)read.toMap(Predef$.MODULE$.$conforms()));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, ByteBufferMessageSet> createLargeSingleMessageSet(int key, byte messageFormatVersion) {
        String value = this.messageValue$1(128);
        byte[] x$27 = value.getBytes();
        CompressionCodec x$28 = this.codec();
        byte[] x$29 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$30 = messageFormatVersion;
        long x$31 = TestUtils$.MODULE$.singleMessageSet$default$4();
        ByteBufferMessageSet messageSet = TestUtils$.MODULE$.singleMessageSet(x$27, x$28, x$29, x$31, x$30);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        int largeMessageKey = 20;
        Tuple2<String, ByteBufferMessageSet> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, Message$.MODULE$.MagicValue_V0());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            ByteBufferMessageSet largeMessageSet = (ByteBufferMessageSet)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            ByteBufferMessageSet largeMessageSet2 = (ByteBufferMessageSet)tuple23._2();
            CompressionCodec compressionCodec = this.codec();
            int n = NoCompressionCodec$.MODULE$.equals(compressionCodec) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            int x$32 = 3;
            int x$33 = maxMessageSize;
            float x$34 = this.makeCleaner$default$2();
            int x$35 = this.makeCleaner$default$3();
            long x$36 = this.makeCleaner$default$5();
            Properties x$37 = this.makeCleaner$default$6();
            this.cleaner_$eq(this.makeCleaner(x$32, x$34, x$35, x$33, x$36, x$37));
            Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
            int x$38 = maxMessageSize;
            Properties x$39 = this.logConfigProperties$default$1();
            float x$40 = this.logConfigProperties$default$3();
            Properties props = this.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(x$39, x$38, x$40);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log.config_$eq(new LogConfig((java.util.Map)props));
            int x$41 = 100;
            int x$42 = 3;
            Log x$43 = log;
            CompressionCodec x$44 = this.codec();
            byte x$45 = Message$.MODULE$.MagicValue_V0();
            int x$46 = this.writeDups$default$5();
            Seq<Tuple2<Object, String>> appends = this.writeDups(x$41, x$42, x$43, x$44, x$46, x$45);
            long startSize = log.size();
            this.cleaner().startup();
            long firstDirty = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$7) {
                    return x$7.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log, startSize, appends);
            int x$47 = 40;
            int x$48 = 3;
            Log x$49 = log;
            CompressionCodec x$50 = this.codec();
            byte x$51 = Message$.MODULE$.MagicValue_V0();
            int x$52 = this.writeDups$default$5();
            Seq<Tuple2<Object, String>> dupsV0 = this.writeDups(x$47, x$48, x$49, x$50, x$52, x$51);
            log.append(largeMessageSet2, true);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
            log.config_$eq(new LogConfig((java.util.Map)props));
            int x$53 = 30;
            int x$54 = 40;
            int x$55 = 3;
            Log x$56 = log;
            CompressionCodec x$57 = this.codec();
            byte x$58 = Message$.MODULE$.MagicValue_V1();
            Seq<Tuple2<Object, String>> dupsV1 = this.writeDups(x$54, x$55, x$56, x$57, x$53, x$58);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)largeMessageKey)), (Object)largeMessageValue2)})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple2<Object, String>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        int maxMessageSize = 192;
        int x$59 = 3;
        int x$60 = maxMessageSize;
        float x$61 = this.makeCleaner$default$2();
        int x$62 = this.makeCleaner$default$3();
        long x$63 = this.makeCleaner$default$5();
        Properties x$64 = this.makeCleaner$default$6();
        this.cleaner_$eq(this.makeCleaner(x$59, x$61, x$62, x$60, x$63, x$64));
        Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
        int x$65 = maxMessageSize;
        Properties x$66 = this.logConfigProperties$default$1();
        float x$67 = this.logConfigProperties$default$3();
        Properties props = this.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(x$66, x$65, x$67);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props));
        int x$68 = 2;
        int x$69 = 3;
        Log x$70 = log;
        CompressionCodec x$71 = this.codec();
        byte x$72 = Message$.MODULE$.MagicValue_V0();
        int x$73 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$68, x$69, x$70, x$71, x$73, x$72);
        int x$74 = 2;
        int x$75 = 3;
        int x$76 = 2;
        Log x$77 = log;
        CompressionCodec x$78 = this.codec();
        byte x$79 = Message$.MODULE$.MagicValue_V0();
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$74, x$76, x$77, x$78, x$75, x$79), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props));
        int x$80 = 4;
        int x$81 = 2;
        int x$82 = 2;
        Log x$83 = log;
        CompressionCodec x$84 = this.codec();
        byte x$85 = Message$.MODULE$.MagicValue_V1();
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$81, x$82, x$83, x$84, x$80, x$85);
        int x$86 = 4;
        int x$87 = 2;
        int x$88 = 2;
        Log x$89 = log;
        CompressionCodec x$90 = this.codec();
        byte x$91 = Message$.MODULE$.MagicValue_V1();
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$87, x$88, x$89, x$90, x$86, x$91), Seq$.MODULE$.canBuildFrom());
        int x$92 = 6;
        int x$93 = 2;
        int x$94 = 2;
        Log x$95 = log;
        CompressionCodec x$96 = this.codec();
        byte x$97 = Message$.MODULE$.MagicValue_V1();
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$93, x$94, x$95, x$96, x$92, x$97), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple2<Object, String>>)appends);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        LogCleaner qual$1 = this.cleaner();
        String x$98 = topic;
        int x$99 = partitionId;
        long x$100 = firstDirty;
        long x$101 = qual$1.awaitCleaned$default$4();
        qual$1.awaitCleaned(x$98, x$99, x$100, x$101);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().get((Object)new TopicAndPartition(topic, partitionId)).get());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log, long startSize, Seq<Tuple2<Object, String>> appends) {
        Iterable<Tuple2<Object, String>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change", (Object)appends.toMap(Predef$.MODULE$.$conforms()), (Object)read.toMap(Predef$.MODULE$.$conforms()));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, String>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;

            public final Iterable<Tuple2<Object, String>> apply(LogSegment segment) {
                return (Iterable)segment.log().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$readFromLog$1 $outer;

                    public final Iterator<Tuple2<Object, String>> apply(MessageAndOffset entry) {
                        return this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().kafka$log$LogCleanerIntegrationTest$$messageIterator$1(entry).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, String> apply(MessageAndOffset messageAndOffset) {
                                int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(messageAndOffset.message().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                                String value = TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)value);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, String>> writeDups(int numKeys, int numDups, Log log, CompressionCodec codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, codec, startKey, magicValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionCodec codec$1;
            private final int startKey$1;
            public final byte magicValue$1;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        byte[] x$102 = payload.toString().getBytes();
                        CompressionCodec x$103 = this.$outer.codec$1;
                        byte[] x$104 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        byte x$105 = this.$outer.magicValue$1;
                        long x$106 = TestUtils$.MODULE$.singleMessageSet$default$4();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singleMessageSet(x$102, x$103, x$104, x$106, x$105), true);
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.startKey$1 = startKey$1;
                this.magicValue$1 = magicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDups$default$5() {
        return 0;
    }

    private byte writeDups$default$6() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    private Seq<Tuple2<Object, String>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log, CompressionCodec codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, startKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$2;
            private final int startKey$2;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$2), this.startKey$2 + this.numKeys$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$2 = numKeys$2;
                this.startKey$2 = startKey$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq messages2 = (IndexedSeq)kvs.map((Function1)new Serializable(this, magicValue){
            public static final long serialVersionUID = 0L;
            private final byte magicValue$2;

            public final Message apply(Tuple2<Object, String> x0$1) {
                Tuple2<Object, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    String payload = (String)tuple2._2();
                    Message message = new Message(payload.toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), Message$.MODULE$.NoTimestamp(), this.magicValue$2);
                    return message;
                }
                throw new MatchError(tuple2);
            }
            {
                this.magicValue$2 = magicValue$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(codec, (Seq)messages2);
        log.append(messageSet, true);
        return kvs;
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private byte writeDupsSingleMessageSet$default$6() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    @After
    public void tearDown() {
        this.cleaner().shutdown();
        this.time().scheduler().shutdown();
        Utils.delete((File)this.logDir());
    }

    public Properties kafka$log$LogCleanerIntegrationTest$$logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(this.segmentSize()));
        props.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(this.deleteDelay()));
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.putAll((java.util.Map<?, ?>)propertyOverrides);
        return props;
    }

    private Properties logConfigProperties$default$1() {
        return new Properties();
    }

    private float logConfigProperties$default$3() {
        return 0.0f;
    }

    private LogCleaner makeCleaner(int parts, float minCleanableDirtyRatio, int numThreads, int maxMessageSize, long logCleanerBackOffMillis, Properties propertyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, minCleanableDirtyRatio, maxMessageSize, propertyOverrides, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final float minCleanableDirtyRatio$1;
            private final int maxMessageSize$1;
            private final Properties propertyOverrides$1;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                Log log = new Log(dir, new LogConfig((java.util.Map)this.$outer.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(this.propertyOverrides$1, this.maxMessageSize$1, this.minCleanableDirtyRatio$1)), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicAndPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.minCleanableDirtyRatio$1 = minCleanableDirtyRatio$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.propertyOverrides$1 = propertyOverrides$1;
                this.logs$1 = logs$1;
            }
        });
        int x$107 = numThreads;
        int x$108 = maxMessageSize / 2;
        int x$109 = maxMessageSize;
        long x$110 = logCleanerBackOffMillis;
        long x$111 = CleanerConfig$.MODULE$.apply$default$2();
        double x$112 = CleanerConfig$.MODULE$.apply$default$3();
        double x$113 = CleanerConfig$.MODULE$.apply$default$6();
        boolean x$114 = CleanerConfig$.MODULE$.apply$default$8();
        String x$115 = CleanerConfig$.MODULE$.apply$default$9();
        return new LogCleaner(new CleanerConfig(x$107, x$111, x$112, x$108, x$109, x$113, x$110, x$114, x$115), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    private float makeCleaner$default$2() {
        return 0.0f;
    }

    private int makeCleaner$default$3() {
        return 1;
    }

    private int makeCleaner$default$4() {
        return 128;
    }

    private long makeCleaner$default$5() {
        return 15000L;
    }

    private Properties makeCleaner$default$6() {
        return new Properties();
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        int x$21 = 1;
        Properties x$22 = logProps$1;
        long x$23 = 100L;
        float x$24 = this.makeCleaner$default$2();
        int x$25 = this.makeCleaner$default$3();
        int x$26 = this.makeCleaner$default$4();
        this.cleaner_$eq(this.makeCleaner(x$21, x$24, x$25, x$26, x$23, x$22));
        Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
        Seq<Tuple2<Object, String>> messages2 = this.writeDups(numKeys, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log, messages2);
    }

    private final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray(ClassTag$.MODULE$.Char()));
    }

    public final Iterator kafka$log$LogCleanerIntegrationTest$$messageIterator$1(MessageAndOffset entry) {
        CompressionCodec compressionCodec = entry.message().compressionCodec();
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        return !(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) ? Iterator$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{entry})) : ByteBufferMessageSet$.MODULE$.deepIterator(entry, ByteBufferMessageSet$.MODULE$.deepIterator$default$2());
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.codec = CompressionCodec$.MODULE$.getCompressionCodec(compressionCodec);
        this.time = new MockTime();
        this.segmentSize = 256;
        this.deleteDelay = 1000;
        this.logName = "log";
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.counter = 0;
        this.topics = (TopicAndPartition[])((Object[])new TopicAndPartition[]{new TopicAndPartition("log", 0), new TopicAndPartition("log", 1), new TopicAndPartition("log", 2)});
    }
}

