/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import kafka.log.SkimpyOffsetMap;
import kafka.log.SkimpyOffsetMap$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\tiqJ\u001a4tKRl\u0015\r\u001d+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\nuKN$()Y:jGZ\u000bG.\u001b3bi&|g\u000eF\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0011)f.\u001b;)\u0005]\t\u0003C\u0001\u0012%\u001b\u0005\u0019#BA\u0006\u000f\u0013\t)3E\u0001\u0003UKN$\b\"B\u0014\u0001\t\u0003I\u0012!\u0003;fgR\u001cE.Z1sQ\t1\u0013\u0005C\u0003+\u0001\u0011\u0005\u0011$A\buKN$x)\u001a;XQ\u0016tg)\u001e7mQ\tI\u0013\u0005C\u0003.\u0001\u0011\u0005a&A\u0002lKf$\"aL\u001c\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014a\u00018j_*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006[1\u0002\r\u0001\u000f\t\u00037eJ!A\u000f\u000f\u0003\t1{gn\u001a\u0005\u0006y\u0001!\t!P\u0001\fm\u0006d\u0017\u000eZ1uK6\u000b\u0007\u000fF\u0002?\u0003\u001a\u0003\"AF \n\u0005\u0001\u0013!aD*lS6\u0004\u0018p\u00144gg\u0016$X*\u00199\t\u000b\t[\u0004\u0019A\"\u0002\u000b%$X-\\:\u0011\u0005m!\u0015BA#\u001d\u0005\rIe\u000e\u001e\u0005\b\u000fn\u0002\n\u00111\u0001I\u0003)aw.\u00193GC\u000e$xN\u001d\t\u00037%K!A\u0013\u000f\u0003\r\u0011{WO\u00197f\u0011\u001da\u0005!%A\u0005\u00025\u000bQC^1mS\u0012\fG/Z'ba\u0012\"WMZ1vYR$#'F\u0001OU\tAujK\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+A\u0005v]\u000eDWmY6fI*\u0011Q\u000bH\u0001\u000bC:tw\u000e^1uS>t\u0017BA,S\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\u00063\nA\tAW\u0001\u000e\u001f\u001a47/\u001a;NCB$Vm\u001d;\u0011\u0005YYf!B\u0001\u0003\u0011\u0003a6cA.^AB\u00111DX\u0005\u0003?r\u0011a!\u00118z%\u00164\u0007CA\u000eb\u0013\t\u0011GD\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u00147\u0012\u0005A\rF\u0001[\u0011\u001517\f\"\u0001h\u0003\u0011i\u0017-\u001b8\u0015\u0005iA\u0007\"B5f\u0001\u0004Q\u0017\u0001B1sON\u00042aG6n\u0013\taGDA\u0003BeJ\f\u0017\u0010\u0005\u0002oc:\u00111d\\\u0005\u0003ar\ta\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000f\b\u0005\bkn\u000b\t\u0011\"\u0003w\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003]\u0004\"\u0001_>\u000e\u0003eT!A_\u001a\u0002\t1\fgnZ\u0005\u0003yf\u0014aa\u00142kK\u000e$\b")
public class OffsetMapTest
extends JUnitSuite {
    public static void main(String[] stringArray) {
        OffsetMapTest$.MODULE$.main(stringArray);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.map$1.put(this.$outer.key(i), (long)i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)this.map$1.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        map.clear();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)this.map$1.get(this.$outer.key(i)), (long)-1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assert.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assert.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)key)).toString().getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.map$2.put(this.$outer.key(i), (long)i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        boolean misses = false;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetMapTest $outer;
            private final SkimpyOffsetMap map$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)this.map$2.get(this.$outer.key(i)), (long)i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }
}

