/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.NoCompressionCodec$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\t!A_6\n\u0005]!\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001b\u0001\n\u0003y\u0012A\u0002:b]\u0012|W.F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003vi&d'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aAU1oI>l\u0007BB\u0015\u0001A\u0003%\u0001%A\u0004sC:$w.\u001c\u0011\t\u000f-\u0002\u0001\u0019!C\u0001Y\u00051An\\4ESJ,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\n!![8\n\u0005Iz#\u0001\u0002$jY\u0016Dq\u0001\u000e\u0001A\u0002\u0013\u0005Q'\u0001\u0006m_\u001e$\u0015N]0%KF$\"A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b{M\n\t\u00111\u0001.\u0003\rAH%\r\u0005\u0007\u007f\u0001\u0001\u000b\u0015B\u0017\u0002\u000f1|w\rR5sA!9\u0011\t\u0001a\u0001\n\u0003a\u0013a\u0003;pa&\u001cGj\\4ESJDqa\u0011\u0001A\u0002\u0013\u0005A)A\bu_BL7\rT8h\t&\u0014x\fJ3r)\t1T\tC\u0004>\u0005\u0006\u0005\t\u0019A\u0017\t\r\u001d\u0003\u0001\u0015)\u0003.\u00031!x\u000e]5d\u0019><G)\u001b:!\u0011\u001d\u0019\u0001\u00011A\u0005\u0002%+\u0012A\u0013\t\u00039-K!\u0001\u0014\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b\u001d\u0002\u0001\r\u0011\"\u0001P\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003mACq!P'\u0002\u0002\u0003\u0007!\n\u0003\u0004S\u0001\u0001\u0006KAS\u0001\bg\u0016\u0014h/\u001a:!\u0011\u001d!\u0006\u00011A\u0005\u0002U\u000bq\u0001\\8h'&TX-F\u0001W!\t9t+\u0003\u0002Yq\t\u0019\u0011J\u001c;\t\u000fi\u0003\u0001\u0019!C\u00017\u0006YAn\\4TSj,w\fJ3r)\t1D\fC\u0004>3\u0006\u0005\t\u0019\u0001,\t\ry\u0003\u0001\u0015)\u0003W\u0003!awnZ*ju\u0016\u0004\u0003b\u00021\u0001\u0001\u0004%\t!Y\u0001\u000fg&l\u0007\u000f\\3D_:\u001cX/\\3s+\u0005\u0011\u0007CA2g\u001b\u0005!'BA3\u0005\u0003!\u0019wN\\:v[\u0016\u0014\u0018BA4e\u00059\u0019\u0016.\u001c9mK\u000e{gn];nKJDq!\u001b\u0001A\u0002\u0013\u0005!.\u0001\ntS6\u0004H.Z\"p]N,X.\u001a:`I\u0015\fHC\u0001\u001cl\u0011\u001di\u0004.!AA\u0002\tDa!\u001c\u0001!B\u0013\u0011\u0017aD:j[BdWmQ8ogVlWM\u001d\u0011\t\u000f=\u0004\u0001\u0019!C\u0001a\u0006!A/[7f+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;\u0005\u0003\u0015)H/\u001b7t\u0013\t18O\u0001\u0003US6,\u0007b\u0002=\u0001\u0001\u0004%\t!_\u0001\ti&lWm\u0018\u0013fcR\u0011aG\u001f\u0005\b{]\f\t\u00111\u0001r\u0011\u0019a\b\u0001)Q\u0005c\u0006)A/[7fA!)a\u0010\u0001C!\u007f\u0006)1/\u001a;VaR\ta\u0007K\u0002~\u0003\u0007\u0001B!!\u0002\u0002\n5\u0011\u0011q\u0001\u0006\u0003\u00179IA!a\u0003\u0002\b\t1!)\u001a4pe\u0016Da!a\u0004\u0001\t\u0003z\u0018\u0001\u0003;fCJ$un\u001e8)\t\u00055\u00111\u0003\t\u0005\u0003\u000b\t)\"\u0003\u0003\u0002\u0018\u0005\u001d!!B!gi\u0016\u0014\bBBA\u000e\u0001\u0011\u0005q0A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5dQ\u0011\tI\"a\b\u0011\t\u0005\u0015\u0011\u0011E\u0005\u0005\u0003G\t9A\u0001\u0003UKN$\bBBA\u0014\u0001\u0011\u0005q0\u0001\u0010uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a'bi\u0016\u001cH\u000fV5nK\"\"\u0011QEA\u0010\u0011\u0019\ti\u0003\u0001C\u0001\u007f\u00069B/Z:u\u000b6\u0004H/\u001f'pON<U\r^(gMN,Go\u001d\u0015\u0005\u0003W\ty\u0002\u0003\u0004\u00024\u0001!\ta`\u0001\u0018i\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3O_^DC!!\r\u0002 !1\u0011\u0011\b\u0001\u0005\u0002}\f\u0001\u0005^3ti\u001e+Go\u00144gg\u0016$8OQ3g_J,W)\u0019:mS\u0016\u001cH\u000fV5nK\"\"\u0011qGA\u0010\u0011\u0019\ty\u0004\u0001C\u0001\u007f\u0006iC/Z:u\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014XmV5uQ\u000eC\u0017M\\4j]\u001e\u001cVmZ7f]R\u001c\u0016N_3)\t\u0005u\u0012q\u0004\u0005\u0007\u0003\u000b\u0002A\u0011A@\u0002UQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001c()\u001a4pe\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h'\u0016<W.\u001a8ug\"\"\u00111IA\u0010\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\n!c\u0019:fCR,'I]8lKJ\u001cuN\u001c4jOR!\u0011qJA+!\r\t\u0013\u0011K\u0005\u0004\u0003'\u0012#A\u0003)s_B,'\u000f^5fg\"9\u0011qKA%\u0001\u00041\u0016A\u00028pI\u0016LE\rC\u0004\u0002\\\u0001!I!!\u0018\u0002\u0013\u001d,G\u000fT8h\t&\u0014H#A\u0017")
public class LogOffsetTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final Random random;
    private File logDir;
    private File topicLogDir;
    private KafkaServer server;
    private int logSize;
    private SimpleConsumer simpleConsumer;
    private Time time;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogOffsetTest logOffsetTest = this;
        synchronized (logOffsetTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Random random() {
        return this.random;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public File topicLogDir() {
        return this.topicLogDir;
    }

    public void topicLogDir_$eq(File x$1) {
        this.topicLogDir = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int logSize() {
        return this.logSize;
    }

    public void logSize_$eq(int x$1) {
        this.logSize = x$1;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public void simpleConsumer_$eq(SimpleConsumer x$1) {
        this.simpleConsumer = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties config = this.createBrokerConfig(1);
        String logDirPath = config.getProperty("log.dir");
        this.logDir_$eq(new File(logDirPath));
        this.time_$eq(new MockTime());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), this.time()));
        KafkaServer qual$1 = this.server();
        SecurityProtocol x$1 = qual$1.boundPort$default$1();
        this.simpleConsumer_$eq(new SimpleConsumer("localhost", qual$1.boundPort(x$1), 1000000, 65536, ""));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumer().close();
        this.server().shutdown();
        Utils.delete((File)this.logDir());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("foo", 0);
        OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 10))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        OffsetResponse offsetResponse = this.simpleConsumer().getOffsetsBefore(request);
        Assert.assertEquals((long)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (long)((PartitionOffsetsResponse)offsetResponse.partitionErrorAndOffsets().apply((Object)topicAndPartition)).error());
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)0)).toString();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        int part = Integer.valueOf((String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part, logManager){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int part$1;
            private final LogManager logManager$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.logManager$1.getLog(new TopicAndPartition(this.topic$1, this.part$1)).isDefined();
            }
            {
                this.topic$1 = topic$1;
                this.part$1 = part$1;
                this.logManager$1 = logManager$1;
            }
        }, "Log for partition [topic,0] should be created", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Log log = (Log)logManager.getLog(new TopicAndPartition(topic, part)).get();
        Message message = new Message(Integer.toString(42).getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log, message){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final Message message$1;

            public final LogAppendInfo apply(int i) {
                return this.log$1.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.message$1})), this.log$1.append$default$2());
            }
            {
                this.log$1 = log$1;
                this.message$1 = message$1;
            }
        });
        log.flush();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), OffsetRequest$.MODULE$.LatestTime(), 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$1;
            private final int part$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$1, this.part$1, this.$outer.server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.part$1 = part$1;
            }
        }, "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 15))}));
        int x$3 = 0;
        short x$4 = OffsetRequest$.MODULE$.apply$default$2();
        int x$5 = OffsetRequest$.MODULE$.apply$default$3();
        String x$6 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$2, x$4, x$5, x$6, x$3);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchResponse fetchResponse = this.simpleConsumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, BoxesRunTime.unboxToLong((Object)consumerOffsets.head()), 307200).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(topic, 0).iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(10))).toString();
        String topicPartitionPath = new StringBuilder().append((Object)this.getLogDir().getAbsolutePath()).append((Object)"/").append((Object)topicPartition).toString();
        this.topicLogDir_$eq(new File(topicPartitionPath));
        this.topicLogDir().mkdir();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), TestUtils$.MODULE$.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)new Serializable(this, topic, offsetChanged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$2;
            private final BooleanRef offsetChanged$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$2, 0);
                OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.EarliestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                Seq consumerOffsets = ((PartitionOffsetsResponse)this.$outer.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
                if (BoxesRunTime.unboxToLong((Object)consumerOffsets.head()) == 1L) {
                    this.offsetChanged$1.elem = true;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.offsetChanged$1 = offsetChanged$1;
            }
        });
        Assert.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(3))).toString();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        int part = Integer.valueOf((String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.createLog(new TopicAndPartition(topic, part), logManager.defaultConfig());
        Message message = new Message(Integer.toString(42).getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log, message){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final Message message$2;

            public final LogAppendInfo apply(int i) {
                return this.log$2.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.message$2})), this.log$2.append$default$2());
            }
            {
                this.log$2 = log$2;
                this.message$2 = message$2;
            }
        });
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$3;
            private final int part$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$3, this.part$2, this.$outer.server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.part$2 = part$2;
            }
        }, "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(now, 15))}));
        int x$8 = 0;
        short x$9 = OffsetRequest$.MODULE$.apply$default$2();
        int x$10 = OffsetRequest$.MODULE$.apply$default$3();
        String x$11 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$7, x$9, x$10, x$11, x$8);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(3))).toString();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        int part = Integer.valueOf((String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.createLog(new TopicAndPartition(topic, part), logManager.defaultConfig());
        Message message = new Message(Integer.toString(42).getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log, message){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message message$3;

            public final LogAppendInfo apply(int i) {
                return this.log$3.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.message$3})), this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
                this.message$3 = message$3;
            }
        });
        log.flush();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), OffsetRequest$.MODULE$.EarliestTime(), 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$4;
            private final int part$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$4, this.part$3, this.$outer.server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.part$3 = part$3;
            }
        }, "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.EarliestTime(), 10))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(this){
            private final AtomicLong value;

            private AtomicLong value() {
                return this.value;
            }

            public long answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicLong(0L);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        Seq logSegments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        this.server().apis().fetchOffsetsBefore(log, System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(this, logSegment){
            public final LogSegment logSegment$1;

            public Object answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$3 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.class.companion((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.class.seq((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.class.thisCollection((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.class.toCollection((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.class.foreach((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.class.forall((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.class.exists((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.class.find((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.class.isEmpty((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.class.foldRight((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.class.reduceRight((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.class.toIterable((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.class.toIterator((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.class.head((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.class.slice((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.class.take((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.class.drop((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.class.takeWhile((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size2) {
                        return IterableLike.class.grouped((IterableLike)this, (int)size2);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size2) {
                        return IterableLike.class.sliding((IterableLike)this, (int)size2);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size2, int step) {
                        return IterableLike.class.sliding((IterableLike)this, (int)size2, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.class.takeRight((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.class.dropRight((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start2, int len) {
                        IterableLike.class.copyToArray((IterableLike)this, (Object)xs, (int)start2, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.class.zip((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.class.zipAll((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.class.zipWithIndex((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.class.sameElements((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.class.toStream((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.class.canEqual((IterableLike)this, (Object)that);
                    }

                    public Object view() {
                        return IterableLike.class.view((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.class.view((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.class.newBuilder((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.class.genericBuilder((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.class.unzip((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.class.unzip3((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.class.flatten((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.class.transpose((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.class.repr((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.class.isTraversableAgain((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.class.parCombiner((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.class.hasDefiniteSize((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.map((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.flatMap((TraversableLike)this, f, bf);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.class.filter((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.class.filterNot((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.collect((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.class.partition((TraversableLike)this, p);
                    }

                    public <K> Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.class.groupBy((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.class.scan((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.scanLeft((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.scanRight((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.class.headOption((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.class.tail((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.class.last((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.class.lastOption((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.class.init((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.class.sliceWithKnownDelta((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.class.sliceWithKnownBound((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.class.dropWhile((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.class.span((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.class.splitAt((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.class.tails((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.class.inits((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.class.toTraversable((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.class.to((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.class.toString((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.class.stringPrefix((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.class.withFilter((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.class.par((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start2) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start2, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.$outer.logSegment$1}))).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Parallelizable.class.$init$((Parallelizable)this);
                        TraversableLike.class.$init$((TraversableLike)this);
                        GenericTraversableTemplate.class.$init$((GenericTraversableTemplate)this);
                        GenTraversable.class.$init$((GenTraversable)this);
                        Traversable.class.$init$((Traversable)this);
                        GenIterable.class.$init$((GenIterable)this);
                        IterableLike.class.$init$((IterableLike)this);
                        Iterable.class.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        this.server().apis().fetchOffsetsBefore(log, System.currentTimeMillis(), 100);
    }

    /*
     * WARNING - void declaration
     */
    private Properties createBrokerConfig(int nodeId) {
        void var2_2;
        Properties props = new Properties();
        props.put("broker.id", ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString());
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())).toString());
        props.put("log.dir", this.getLogDir().getAbsolutePath());
        props.put("log.flush.interval.messages", "1");
        props.put("enable.zookeeper", "false");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)300000)).toString());
        props.put("log.segment.bytes", ((Object)BoxesRunTime.boxToInteger((int)this.logSize())).toString());
        props.put("zookeeper.connect", this.zkConnect().toString());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private File getLogDir() {
        void var1_1;
        File dir = TestUtils$.MODULE$.tempDir();
        return var1_1;
    }

    public LogOffsetTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.random = new Random();
        this.logDir = null;
        this.topicLogDir = null;
        this.server = null;
        this.logSize = 100;
        this.simpleConsumer = null;
        this.time = new MockTime();
    }
}

