/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.PartitionFetchInfo;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011qbU5na2,g)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A\u0001T8oO\"1!\u0004\u0001Q\u0001\nY\tAC]3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005q\u0002CA\u0005 \u0013\t\u0001#BA\u0002J]RDaA\t\u0001!\u0002\u0013q\u0012A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000f\u0011\u0002!\u0019!C\u0001+\u0005)\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\bB\u0002\u0014\u0001A\u0003%a#\u0001\fsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:!\u0011\u001dA\u0003A1A\u0005\u0002%\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#A\u0003)s_B,'\u000f^5fg\"11\u0007\u0001Q\u0001\n)\n\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001m\u000591m\u001c8gS\u001e\u001cX#A\u001c\u0011\u0007aZT(D\u0001:\u0015\tQ$\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001P\u001d\u0003\u0007M+\u0017\u000f\u0005\u0002\u0013}%\u0011qH\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004B\u0001\u0001\u0006IaN\u0001\tG>tg-[4tA!91\t\u0001b\u0001\n\u0003!\u0015\u0001\u0002;j[\u0016,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\tQ!\u001e;jYNL!AS$\u0003\u00115{7m\u001b+j[\u0016Da\u0001\u0014\u0001!\u0002\u0013)\u0015!\u0002;j[\u0016\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\u0006URKW.Z\u000b\u0002!B\u0011\u0011KW\u0007\u0002%*\u0011\u0001j\u0015\u0006\u0003)V\u000baaY8n[>t'BA\u0003W\u0015\t9\u0006,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0006\u0019qN]4\n\u0005)\u0013\u0006B\u0002/\u0001A\u0003%\u0001+\u0001\u0004k)&lW\r\t\u0005\b=\u0002\u0011\r\u0011\"\u0001`\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u0019\t\u0003C\u000el\u0011A\u0019\u0006\u0003=NK!\u0001\u001a2\u0003\u000f5+GO]5dg\"1a\r\u0001Q\u0001\n\u0001\f\u0001\"\\3ue&\u001c7\u000f\t\u0005\bQ\u0002\u0011\r\u0011\"\u0001\u0016\u0003%aW-\u00193fe2+u\n\u0003\u0004k\u0001\u0001\u0006IAF\u0001\u000bY\u0016\fG-\u001a:M\u000b>\u0003\u0003b\u00027\u0001\u0005\u0004%\t!F\u0001\fM>dGn\\<fe2+u\n\u0003\u0004o\u0001\u0001\u0006IAF\u0001\rM>dGn\\<fe2+u\n\t\u0005\ba\u0002\u0011\r\u0011\"\u0001\u001e\u0003-\u0001\u0018M\u001d;ji&|g\u000eS,\t\rI\u0004\u0001\u0015!\u0003\u001f\u00031\u0001\u0018M\u001d;ji&|g\u000eS,!\u0011\u001d!\bA1A\u0005\u0002u\t\u0011BZ3uG\"\u001c\u0016N_3\t\rY\u0004\u0001\u0015!\u0003\u001f\u0003)1W\r^2i'&TX\r\t\u0005\bq\u0002\u0011\r\u0011\"\u0001z\u00031iWm]:bO\u0016\u001cHk\u001c%X+\u0005Q\bCA>\u007f\u001b\u0005a(BA?\u0005\u0003\u001diWm]:bO\u0016L!a ?\u0003\u000f5+7o]1hK\"9\u00111\u0001\u0001!\u0002\u0013Q\u0018!D7fgN\fw-Z:U_\";\u0006\u0005\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001z\u00035iWm]:bO\u0016\u001cHk\u001c'F\u001f\"9\u00111\u0002\u0001!\u0002\u0013Q\u0018AD7fgN\fw-Z:U_2+u\n\t\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#\tQ\u0001^8qS\u000e,\"!a\u0005\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007/\u0003\u0011a\u0017M\\4\n\t\u0005u\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003'\ta\u0001^8qS\u000e\u0004\u0003\u0002CA\u0013\u0001\t\u0007I\u0011A\u000f\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003S\u0001\u0001\u0015!\u0003\u001f\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty#A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:,\"!!\r\u0011\t\u0005M\u0012qG\u0007\u0003\u0003kQ!\u0001\u0016\u0003\n\t\u0005e\u0012Q\u0007\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002CA\u001f\u0001\u0001\u0006I!!\r\u0002%Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0001\u0003\u0007\n\u0011BZ3uG\"LeNZ8\u0016\u0005\u0005\u0015\u0003\u0003\u0002\u001d<\u0003\u000f\u0002r!CA%\u0003c\ti%C\u0002\u0002L)\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005MC!A\u0002ba&LA!a\u0016\u0002R\t\u0011\u0002+\u0019:uSRLwN\u001c$fi\u000eD\u0017J\u001c4p\u0011!\tY\u0006\u0001Q\u0001\n\u0005\u0015\u0013A\u00034fi\u000eD\u0017J\u001c4pA!I\u0011q\f\u0001A\u0002\u0013\u0005\u0011\u0011M\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0007E\u0002\u0013\u0003KJ1!a\u001a\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0011\"a\u001b\u0001\u0001\u0004%\t!!\u001c\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003_\n)\bE\u0002\n\u0003cJ1!a\u001d\u000b\u0005\u0011)f.\u001b;\t\u0015\u0005]\u0014\u0011NA\u0001\u0002\u0004\t\u0019'A\u0002yIEB\u0001\"a\u001f\u0001A\u0003&\u00111M\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015!B:fiV\u0003HCAA8Q\u0011\ti(!\"\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#Y\u0003\u0015QWO\\5u\u0013\u0011\ty)!#\u0003\r\t+gm\u001c:f\u0011\u001d\t\u0019\n\u0001C\u0001\u0003\u0003\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003#\u000b9\n\u0005\u0003\u0002\b\u0006e\u0015\u0002BAN\u0003\u0013\u0013Q!\u00114uKJDq!a(\u0001\t\u0003\t\t)A\buKN$(+Z1e\rJ|W\u000eT8hQ\u0011\ti*a)\u0011\t\u0005\u001d\u0015QU\u0005\u0005\u0003O\u000bII\u0001\u0003UKN$\b")
public class SimpleFetchTest {
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final long replicaLagMaxMessages;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final kafka.utils.MockTime time;
    private final MockTime jTime;
    private final Metrics metrics;
    private final long leaderLEO;
    private final long followerLEO;
    private final int partitionHW;
    private final int fetchSize;
    private final Message messagesToHW;
    private final Message messagesToLEO;
    private final String topic;
    private final int partitionId;
    private final TopicAndPartition topicAndPartition;
    private final Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> fetchInfo;
    private ReplicaManager replicaManager;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public kafka.utils.MockTime time() {
        return this.time;
    }

    public MockTime jTime() {
        return this.jTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public long leaderLEO() {
        return this.leaderLEO;
    }

    public long followerLEO() {
        return this.followerLEO;
    }

    public int partitionHW() {
        return this.partitionHW;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public Message messagesToHW() {
        return this.messagesToHW;
    }

    public Message messagesToLEO() {
        return this.messagesToLEO;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        EasyMock.replay((Object[])new Object[]{zkUtils});
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        EasyMock.replay((Object[])new Object[]{scheduler});
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLEO())).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(this.leaderLEO(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(0L, this.fetchSize(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.partitionHW())), true)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (MessageSet)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messagesToHW()})), FetchDataInfo$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(0L, this.fetchSize(), (Option)None$.MODULE$, true)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (MessageSet)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messagesToLEO()})), FetchDataInfo$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(this.topicAndPartition())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), zkUtils, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$10()));
        Partition partition = this.replicaManager().getOrCreatePartition(this.topic(), this.partitionId());
        Replica leaderReplica = new Replica(((KafkaConfig)this.configs().head()).brokerId(), partition, (kafka.utils.Time)this.time(), 0L, (Option)new Some((Object)log));
        leaderReplica.highWatermark_$eq(new LogOffsetMetadata((long)this.partitionHW(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
        Replica followerReplica = new Replica(((KafkaConfig)this.configs().apply(1)).brokerId(), partition, (kafka.utils.Time)this.time(), Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
        LogOffsetMetadata leo = new LogOffsetMetadata(this.followerLEO(), 0L, (int)this.followerLEO());
        followerReplica.updateLogReadResult(new LogReadResult(new FetchDataInfo(leo, (MessageSet)MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3()), -1L, -1, true, LogReadResult$.MODULE$.$lessinit$greater$default$5()));
        List allReplicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica x$2) {
                return this.partition$1.addReplicaIfNotExists(x$2);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testReadFromLog() {
        long initialTopicCount = BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.topic()).totalFetchRequestRate().count();
        long initialAllTopicsCount = BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().totalFetchRequestRate().count();
        Assert.assertEquals((String)"Reading committed data should return messages only up to high watermark", (Object)this.messagesToHW(), (Object)((MessageAndOffset)((LogReadResult)((Tuple2)this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, true, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().head()).message());
        Assert.assertEquals((String)"Reading any data can return messages up to the end of the log", (Object)this.messagesToLEO(), (Object)((MessageAndOffset)((LogReadResult)((Tuple2)this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, false, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$4) {
                Object object = x$4._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().head()).message());
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialTopicCount + 2L), (long)BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.topic()).totalFetchRequestRate().count());
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialAllTopicsCount + 2L), (long)BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().totalFetchRequestRate().count());
    }

    public SimpleFetchTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.replicaLagMaxMessages = 10L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.time = new kafka.utils.MockTime();
        this.jTime = new MockTime();
        this.metrics = new Metrics();
        this.leaderLEO = 20L;
        this.followerLEO = 15L;
        this.partitionHW = 5;
        this.fetchSize = 100;
        this.messagesToHW = new Message("messageToHW".getBytes());
        this.messagesToLEO = new Message("messageToLEO".getBytes());
        this.topic = "test-topic";
        this.partitionId = 0;
        this.topicAndPartition = new TopicAndPartition(this.topic(), this.partitionId());
        this.fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition()), (Object)new PartitionFetchInfo(0L, this.fetchSize()))}));
        this.replicaManager = null;
    }
}

