/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.Topic$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class AdminUtils$
implements Logging,
AdminUtilities {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final String EntityConfigChangeZnodePrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public String EntityConfigChangeZnodePrefix() {
        return this.EntityConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map;
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("number of partitions must be larger than 0");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("replication factor must be larger than 0");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factor: ", " larger than available brokers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicationFactor), BoxesRunTime.boxToInteger((int)brokerMetadatas.size())})));
        }
        if (brokerMetadatas.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BrokerMetadata x$1) {
                return x$1.rack().isEmpty();
            }
        })) {
            map = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Seq<Object>)((Seq)brokerMetadatas.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(BrokerMetadata x$2) {
                    return x$2.id();
                }
            }, Seq$.MODULE$.canBuildFrom())), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(BrokerMetadata x$3) {
                    return x$3.rack().isEmpty();
                }
            })) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment");
            }
            map = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)new Serializable(replicationFactor, ret, brokerArray, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$1;
            private final scala.collection.mutable.Map ret$1;
            public final int[] brokerArray$1;
            private final int startIndex$1;
            private final IntRef currentPartitionId$1;
            public final IntRef nextReplicaShift$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$1.elem > 0 && this.currentPartitionId$1.elem % this.brokerArray$1.length == 0) {
                    ++this.nextReplicaShift$1.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$1.elem + this.startIndex$1) % this.brokerArray$1.length;
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerArray$1[firstReplicaIndex]}));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$1 - 1).foreach((Function1)new Serializable(this, firstReplicaIndex, replicaBuffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackUnaware.1 $outer;
                    private final int firstReplicaIndex$1;
                    private final ArrayBuffer replicaBuffer$1;

                    public final ArrayBuffer<Object> apply(int j) {
                        return this.replicaBuffer$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.$outer.brokerArray$1[AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$1, this.$outer.nextReplicaShift$1.elem, j, this.$outer.brokerArray$1.length)]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$1 = firstReplicaIndex$1;
                        this.replicaBuffer$1 = replicaBuffer$1;
                    }
                });
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)this.currentPartitionId$1.elem), (Object)replicaBuffer);
                ++this.currentPartitionId$1.elem;
            }
            {
                this.replicationFactor$1 = replicationFactor$1;
                this.ret$1 = ret$1;
                this.brokerArray$1 = brokerArray$1;
                this.startIndex$1 = startIndex$1;
                this.currentPartitionId$1 = currentPartitionId$1;
                this.nextReplicaShift$1 = nextReplicaShift$1;
            }
        });
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((TraversableOnce)brokerMetadatas.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.x();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)rack);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)new Serializable(replicationFactor, brokerRackMap, numRacks, arrangedBrokerList, numBrokers, ret, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$2;
            public final scala.collection.immutable.Map brokerRackMap$1;
            public final int numRacks$1;
            public final IndexedSeq arrangedBrokerList$1;
            public final int numBrokers$1;
            private final scala.collection.mutable.Map ret$2;
            private final int startIndex$2;
            private final IntRef currentPartitionId$2;
            public final IntRef nextReplicaShift$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$2.elem > 0 && this.currentPartitionId$2.elem % this.arrangedBrokerList$1.size() == 0) {
                    ++this.nextReplicaShift$2.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$2.elem + this.startIndex$2) % this.arrangedBrokerList$1.size();
                int leader = BoxesRunTime.unboxToInt((Object)this.arrangedBrokerList$1.apply(firstReplicaIndex));
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                scala.collection.mutable.Set racksWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.brokerRackMap$1.apply((Object)BoxesRunTime.boxToInteger((int)leader))}));
                scala.collection.mutable.Set brokersWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                IntRef k = IntRef.create((int)0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$2 - 1).foreach$mVc$sp((Function1)new Serializable(this, firstReplicaIndex, replicaBuffer, racksWithReplicas, brokersWithReplicas, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackAware.1 $outer;
                    private final int firstReplicaIndex$2;
                    private final ArrayBuffer replicaBuffer$2;
                    private final scala.collection.mutable.Set racksWithReplicas$1;
                    private final scala.collection.mutable.Set brokersWithReplicas$1;
                    private final IntRef k$1;

                    public final void apply(int _) {
                        this.apply$mcVI$sp(_);
                    }

                    public void apply$mcVI$sp(int _) {
                        boolean done = false;
                        while (!done) {
                            int broker = BoxesRunTime.unboxToInt((Object)this.$outer.arrangedBrokerList$1.apply(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$2, this.$outer.nextReplicaShift$2.elem * this.$outer.numRacks$1, this.k$1.elem, this.$outer.arrangedBrokerList$1.size())));
                            String rack = (String)this.$outer.brokerRackMap$1.apply((Object)BoxesRunTime.boxToInteger((int)broker));
                            if (!(this.racksWithReplicas$1.contains((Object)rack) && this.racksWithReplicas$1.size() != this.$outer.numRacks$1 || this.brokersWithReplicas$1.contains((Object)BoxesRunTime.boxToInteger((int)broker)) && this.brokersWithReplicas$1.size() != this.$outer.numBrokers$1)) {
                                this.replicaBuffer$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                                this.racksWithReplicas$1.$plus$eq((Object)rack);
                                this.brokersWithReplicas$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                                done = true;
                            }
                            ++this.k$1.elem;
                        }
                        return;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$2 = firstReplicaIndex$2;
                        this.replicaBuffer$2 = replicaBuffer$2;
                        this.racksWithReplicas$1 = racksWithReplicas$1;
                        this.brokersWithReplicas$1 = brokersWithReplicas$1;
                        this.k$1 = k$1;
                    }
                });
                this.ret$2.put((Object)BoxesRunTime.boxToInteger((int)this.currentPartitionId$2.elem), (Object)replicaBuffer);
                ++this.currentPartitionId$2.elem;
            }
            {
                this.replicationFactor$2 = replicationFactor$2;
                this.brokerRackMap$1 = brokerRackMap$1;
                this.numRacks$1 = numRacks$1;
                this.arrangedBrokerList$1 = arrangedBrokerList$1;
                this.numBrokers$1 = numBrokers$1;
                this.ret$2 = ret$2;
                this.startIndex$2 = startIndex$2;
                this.currentPartitionId$2 = currentPartitionId$2;
                this.nextReplicaShift$2 = nextReplicaShift$2;
            }
        });
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterator<Object>> apply(Tuple2<String, Seq<Object>> x0$1) {
                Tuple2<String, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String rack = (String)tuple2._1();
                    Seq brokers = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)rack, (Object)brokers.toIterator());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class))).sorted((Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((TraversableLike)brokerRackMap.toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    String rack = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)rack, (Object)BoxesRunTime.boxToInteger((int)id));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String rack;
                    String string = rack = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Seq<Tuple2<String, Object>>> x0$4) {
                Tuple2<String, Seq<Tuple2<String, Object>>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String rack = (String)tuple2._1();
                    Seq rackAndIdList = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)rack, ((SeqLike)rackAndIdList.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<String, Object> x0$5) {
                            Tuple2<String, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                int id;
                                int n = id = tuple2._2$mcI$sp();
                                return n;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public void addPartitions(ZkUtils zkUtils, String topic, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable, RackAwareMode rackAwareMode) {
        block6: {
            existingPartitionsReplicaList = zkUtils.getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
            if (existingPartitionsReplicaList.isEmpty()) {
                throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("The topic %s does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            var9_8 = existingPartitionsReplicaList.find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                    return ((TopicAndPartition)p._1()).partition() == 0;
                }
            });
            if (None$.MODULE$.equals(var9_8)) {
                throw new AdminOperationException("the topic does not have partition with id 0, it should never happen");
            }
            if (!(var9_8 instanceof Some)) break block6;
            var11_9 = (Some)var9_8;
            headPartitionReplica = (Tuple2)var11_9.x();
            existingReplicaListForPartitionZero = var10_11 = (Seq)headPartitionReplica._2();
            partitionsToAdd = numPartitions - existingPartitionsReplicaList.size();
            if (partitionsToAdd <= 0) {
                throw new AdminOperationException("The number of partitions for a topic can only be increased");
            }
            brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
            if (replicaAssignmentStr == null) ** GOTO lbl-1000
            v0 = replicaAssignmentStr;
            var16_15 = "";
            if (!(v0 != null ? v0.equals(var16_15) == false : var16_15 != null)) lbl-1000:
            // 2 sources

            {
                startIndex = package$.MODULE$.max(0, brokerMetadatas.indexWhere((Function1)new Serializable(existingReplicaListForPartitionZero){
                    public static final long serialVersionUID = 0L;
                    private final Seq existingReplicaListForPartitionZero$1;

                    public final boolean apply(BrokerMetadata x$4) {
                        return x$4.id() >= BoxesRunTime.unboxToInt((Object)this.existingReplicaListForPartitionZero$1.head());
                    }
                    {
                        this.existingReplicaListForPartitionZero$1 = existingReplicaListForPartitionZero$1;
                    }
                }));
                v1 = this.assignReplicasToBrokers(brokerMetadatas, partitionsToAdd, existingReplicaListForPartitionZero.size(), startIndex, existingPartitionsReplicaList.size());
            } else {
                v1 = this.getManualReplicaAssignment(replicaAssignmentStr, (Set<Object>)((TraversableOnce)brokerMetadatas.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BrokerMetadata x$5) {
                        return x$5.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet(), existingPartitionsReplicaList.size(), checkBrokerAvailable);
            }
            newPartitionReplicaList = v1;
            unmatchedRepFactorList = (Iterable)newPartitionReplicaList.values().filter((Function1)new Serializable(existingReplicaListForPartitionZero){
                public static final long serialVersionUID = 0L;
                private final Seq existingReplicaListForPartitionZero$1;

                public final boolean apply(Seq<Object> p) {
                    return p.size() != this.existingReplicaListForPartitionZero$1.size();
                }
                {
                    this.existingReplicaListForPartitionZero$1 = existingReplicaListForPartitionZero$1;
                }
            });
            if (unmatchedRepFactorList.nonEmpty()) {
                throw new AdminOperationException(new StringBuilder().append((Object)"The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic ").append((Object)BoxesRunTime.boxToInteger((int)existingReplicaListForPartitionZero.size())).toString());
            }
            this.info((Function0<String>)new Serializable(topic, newPartitionReplicaList){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final Map newPartitionReplicaList$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Add partition list for %s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.newPartitionReplicaList$1}));
                }
                {
                    this.topic$1 = topic$1;
                    this.newPartitionReplicaList$1 = newPartitionReplicaList$1;
                }
            });
            partitionReplicaList = (scala.collection.mutable.Map)existingPartitionsReplicaList.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((TopicAndPartition)p._1()).partition())), p._2());
                }
            }, Map$.MODULE$.canBuildFrom());
            partitionReplicaList.$plus$plus$eq(newPartitionReplicaList);
            x$17 = zkUtils;
            x$18 = topic;
            x$19 = partitionReplicaList;
            x$20 = true;
            x$21 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$17, x$18, (Map<Object, Seq<Object>>)x$19, x$21, x$20);
            return;
        }
        throw new MatchError((Object)var9_8);
    }

    public int addPartitions$default$3() {
        return 1;
    }

    public String addPartitions$default$4() {
        return "";
    }

    public boolean addPartitions$default$5() {
        return true;
    }

    public RackAwareMode addPartitions$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Map<Object, List<Object>> getManualReplicaAssignment(String replicaAssignmentList, Set<Object> availableBrokerList, int startPartitionId, boolean checkBrokerAvailable) {
        ObjectRef partitionList = ObjectRef.create((Object)replicaAssignmentList.split(","));
        HashMap ret = new HashMap();
        IntRef partitionId = IntRef.create((int)startPartitionId);
        partitionList.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).takeRight(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).size() - partitionId.elem);
        Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).indices().foreach$mVc$sp((Function1)new Serializable(availableBrokerList, startPartitionId, checkBrokerAvailable, partitionList, ret, partitionId){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerList$1;
            private final int startPartitionId$1;
            private final boolean checkBrokerAvailable$1;
            private final ObjectRef partitionList$1;
            private final HashMap ret$3;
            private final IntRef partitionId$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.partitionList$1.elem)[i].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s) {
                        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                if (Predef$.MODULE$.intArrayOps(brokerList).isEmpty()) {
                    throw new AdminOperationException("replication factor must be larger than 0");
                }
                if (Predef$.MODULE$.intArrayOps(brokerList).size() != Predef$.MODULE$.intArrayOps(brokerList).toSet().size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"duplicate brokers in replica assignment: ").append((Object)brokerList).toString());
                }
                if (this.checkBrokerAvailable$1 && !Predef$.MODULE$.intArrayOps(brokerList).toSet().subsetOf((GenSet)this.availableBrokerList$1)) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"some specified brokers not available. specified brokers: ").append((Object)brokerList.toString()).append((Object)"available broker:").append((Object)this.availableBrokerList$1.toString()).toString());
                }
                this.ret$3.put((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1.elem), (Object)Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$3.apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1.elem))).size() != ((SeqLike)this.ret$3.apply((Object)BoxesRunTime.boxToInteger((int)this.startPartitionId$1))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"partition ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" has different replication factor: ").append((Object)brokerList).toString());
                }
                ++this.partitionId$1.elem;
            }
            {
                this.availableBrokerList$1 = availableBrokerList$1;
                this.startPartitionId$1 = startPartitionId$1;
                this.checkBrokerAvailable$1 = checkBrokerAvailable$1;
                this.partitionList$1 = partitionList$1;
                this.ret$3 = ret$3;
                this.partitionId$1 = partitionId$1;
            }
        });
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getManualReplicaAssignment$default$4() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTopic(ZkUtils zkUtils, String topic) {
        if (!this.topicExists(zkUtils, topic)) throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        try {
            zkUtils.createPersistentPath(ZkUtils$.MODULE$.getDeleteTopicPath(topic), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public boolean isConsumerGroupActive(ZkUtils zkUtils, String group) {
        return zkUtils.getConsumersInGroup(group).nonEmpty();
    }

    public boolean deleteConsumerGroupInZK(ZkUtils zkUtils, String group) {
        boolean bl;
        if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupDirs dir = new ZKGroupDirs(group);
            zkUtils.deletePathRecursive(dir.consumerGroupDir());
            bl = true;
        }
        return bl;
    }

    public boolean deleteConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String group, String topic) {
        boolean bl;
        Seq<String> topics;
        Seq<String> seq = topics = zkUtils.getTopicsByConsumerGroup(group);
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        if (!(seq != null ? !seq.equals((Object)genTraversable) : genTraversable != null)) {
            bl = this.deleteConsumerGroupInZK(zkUtils, group);
        } else if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
            zkUtils.deletePathRecursive(dir.consumerOwnerDir());
            zkUtils.deletePathRecursive(dir.consumerOffsetDir());
            bl = true;
        }
        return bl;
    }

    public void deleteAllConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String topic) {
        Set<String> groups = zkUtils.getAllConsumerGroupsForTopic(topic);
        groups.foreach((Function1)new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final String topic$3;

            public final boolean apply(String group) {
                return AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils$1, group, this.topic$3);
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.topic$3 = topic$3;
            }
        });
    }

    public boolean topicExists(ZkUtils zkUtils, String topic) {
        return zkUtils.zkClient().exists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(ZkUtils zkUtils, RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = zkUtils.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1)new Serializable(allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$1;

            public final Seq<Broker> apply(Seq<Object> brokerIds) {
                return (Seq)this.allBrokers$1.filter((Function1)new Serializable(this, brokerIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq brokerIds$1;

                    public final boolean apply(Broker b) {
                        return this.brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)b.id()));
                    }
                    {
                        this.brokerIds$1 = brokerIds$1;
                    }
                });
            }
            {
                this.allBrokers$1 = allBrokers$1;
            }
        }).getOrElse((Function0)new Serializable(allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$1;

            public final Seq<Broker> apply() {
                return this.allBrokers$1;
            }
            {
                this.allBrokers$1 = allBrokers$1;
            }
        });
        Seq brokersWithRack = (Seq)brokers.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Broker x$6) {
                return x$6.rack().nonEmpty();
            }
        });
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), broker.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$7) {
                return x$7.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$2() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$3() {
        return None$.MODULE$;
    }

    public void createTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        Topic$.MODULE$.validate(topic);
        String topicPath = ZkUtils$.MODULE$.getTopicPath(topic);
        if (!update) {
            Seq<String> allTopics;
            Seq collidingTopics;
            if (zkUtils.zkClient().exists(topicPath)) {
                throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            if (Topic$.MODULE$.hasCollisionChars(topic) && (collidingTopics = (Seq)(allTopics = zkUtils.getAllTopics()).filter((Function1)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$2;

                public final boolean apply(String t) {
                    return Topic$.MODULE$.hasCollision(this.topic$2, t);
                }
                {
                    this.topic$2 = topic$2;
                }
            })).nonEmpty()) {
                throw new InvalidTopicException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" collides with existing topics: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, collidingTopics.mkString(", ")})));
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1)new Serializable(partitionReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final Map partitionReplicaAssignment$1;

            public final void apply(Seq<Object> reps) {
                if (reps.size() != reps.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)"Duplicate replica assignment found: ").append((Object)this.partitionReplicaAssignment$1).toString());
                }
            }
            {
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        if (!update) {
            LogConfig$.MODULE$.validate(config);
            this.writeEntityConfig(zkUtils, ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic), config);
        }
        this.writeTopicPartitionAssignment(zkUtils, topic, partitionReplicaAssignment, update);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    private void writeTopicPartitionAssignment(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update) {
        try {
            String zkPath = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData = zkUtils.replicaAssignmentZkData((Map<String, Seq<Object>>)((Map)replicaAssignment.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> e) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)e._1$mcI$sp())).toString()), e._2());
                }
            }, scala.collection.Map$.MODULE$.canBuildFrom())));
            if (update) {
                this.info((Function0<String>)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic update ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                });
                zkUtils.updatePersistentPath(zkPath, jsonPartitionData, zkUtils.updatePersistentPath$default$3());
            } else {
                this.info((Function0<String>)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic creation ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                });
                zkUtils.createPersistentPath(zkPath, jsonPartitionData, zkUtils.createPersistentPath$default$3());
            }
            this.debug((Function0<String>)new Serializable(zkPath, jsonPartitionData){
                public static final long serialVersionUID = 0L;
                private final String zkPath$1;
                private final String jsonPartitionData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkPath$1, this.jsonPartitionData$1}));
                }
                {
                    this.zkPath$1 = zkPath$1;
                    this.jsonPartitionData$1 = jsonPartitionData$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("topic %s already exists")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    @Override
    public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.kafka$admin$AdminUtils$$changeEntityConfig(zkUtils, ConfigType$.MODULE$.Client(), clientId, configs);
    }

    @Override
    public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.kafka$admin$AdminUtils$$changeEntityConfig(zkUtils, ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    @Override
    public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        if (this.topicExists(zkUtils, topic)) {
            LogConfig$.MODULE$.validate(configs);
            this.kafka$admin$AdminUtils$$changeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    @Override
    public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokers, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        brokers.foreach((Function1)new Serializable(zkUtils, configs){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;
            private final Properties configs$1;

            public final void apply(int broker) {
                this.apply$mcVI$sp(broker);
            }

            public void apply$mcVI$sp(int broker) {
                AdminUtils$.MODULE$.kafka$admin$AdminUtils$$changeEntityConfig(this.zkUtils$2, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), this.configs$1);
            }
            {
                this.zkUtils$2 = zkUtils$2;
                this.configs$1 = configs$1;
            }
        });
    }

    public void kafka$admin$AdminUtils$$changeEntityConfig(ZkUtils zkUtils, String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder().append((Object)rootEntityType).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)fullSanitizedEntityName).toString();
        String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, fullSanitizedEntityName);
        this.writeEntityConfig(zkUtils, entityConfigPath, configs);
        String seqNode = new StringBuilder().append((Object)ZkUtils$.MODULE$.EntityConfigChangesPath()).append((Object)"/").append((Object)this.EntityConfigChangeZnodePrefix()).toString();
        String content = Json$.MODULE$.encode(this.getConfigChangeZnodeData(sanitizedEntityPath));
        zkUtils.zkClient().createPersistentSequential(seqNode, (Object)content);
    }

    public Map<String, Object> getConfigChangeZnodeData(String sanitizedEntityPath) {
        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_path"), (Object)sanitizedEntityPath)}));
    }

    private void writeEntityConfig(ZkUtils zkUtils, String entityPath, Properties config) {
        scala.collection.mutable.Map configMap = JavaConversions$.MODULE$.propertiesAsScalaMap(config);
        Map map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)configMap)}));
        zkUtils.updatePersistentPath(entityPath, Json$.MODULE$.encode(map), zkUtils.updatePersistentPath$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Properties fetchEntityConfig(ZkUtils zkUtils, String rootEntityType, String sanitizedEntityName) {
        void var5_5;
        void var4_4;
        block4: {
            block5: {
                Properties props;
                block2: {
                    Some some;
                    Object config;
                    Some some2;
                    Object mapAnon;
                    Option<Object> option;
                    String str;
                    String entityConfigPath;
                    block3: {
                        entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, sanitizedEntityName);
                        str = (String)zkUtils.zkClient().readData(entityConfigPath, true);
                        props = new Properties();
                        if (str == null) break block2;
                        option = Json$.MODULE$.parseFull(str);
                        if (!None$.MODULE$.equals(option)) break block3;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block2;
                    }
                    if (!(option instanceof Some) || !((mapAnon = (some2 = (Some)option).x()) instanceof Map)) break block4;
                    Map map = (Map)mapAnon;
                    Map map2 = (Map)map.collect((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 != null) {
                                Object k = A1._1();
                                Object v = A1._2();
                                if (k instanceof String) {
                                    String string = (String)k;
                                    if (v instanceof Object) {
                                        Object object2 = v;
                                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), object2);
                                        return (B1)object;
                                    }
                                }
                            }
                            object = function1.apply(x2);
                            return (B1)object;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Tuple2<Object, Object> x2) {
                            Tuple2<Object, Object> tuple2 = x2;
                            if (tuple2 == null) return false;
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            if (!(k instanceof String)) return false;
                            if (!(v instanceof Object)) return false;
                            return true;
                        }
                    }, scala.collection.Map$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.require(BoxesRunTime.equals((Object)map2.apply((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)));
                    Option option2 = map2.get((Object)"config");
                    if (!(option2 instanceof Some) || !((config = (some = (Some)option2).x()) instanceof Map)) break block5;
                    Map map3 = (Map)config;
                    map3.foreach((Function1)new Serializable(entityConfigPath, str, props){
                        public static final long serialVersionUID = 0L;
                        private final String entityConfigPath$1;
                        private final String str$1;
                        private final Properties props$1;

                        public final Object apply(Tuple2<Object, Object> configTup) {
                            Tuple2<Object, Object> tuple2 = configTup;
                            if (tuple2 != null) {
                                Object k = tuple2._1();
                                Object v = tuple2._2();
                                if (k instanceof String) {
                                    String string = (String)k;
                                    if (v instanceof String) {
                                        String string2 = (String)v;
                                        Object object = this.props$1.setProperty(string, string2);
                                        return object;
                                    }
                                }
                            }
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", " config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entityConfigPath$1, this.str$1})));
                        }
                        {
                            this.entityConfigPath$1 = entityConfigPath$1;
                            this.str$1 = str$1;
                            this.props$1 = props$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                }
                return props;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", " config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4, var5_5})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected value in config:(", "), entity_config_path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5, var4_4})));
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkUtils zkUtils) {
        return ((TraversableOnce)zkUtils.getAllTopics().map((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2((Object)topic, (Object)AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$3, ConfigType$.MODULE$.Topic(), topic));
            }
            {
                this.zkUtils$3 = zkUtils$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(ZkUtils zkUtils, String entityType) {
        return ((TraversableOnce)zkUtils.getAllEntitiesWithConfig(entityType).map((Function1)new Serializable(zkUtils, entityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$4;
            private final String entityType$1;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2((Object)entity, (Object)AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$4, this.entityType$1, entity));
            }
            {
                this.zkUtils$4 = zkUtils$4;
                this.entityType$1 = entityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(ZkUtils zkUtils, String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.kafka$admin$AdminUtils$$entityPaths$1(zkUtils, (Option)None$.MODULE$, rootEntityType).flatMap((Function1)new Serializable(zkUtils, rootEntityType, childEntityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final String rootEntityType$1;
            private final String childEntityType$1;

            public final Seq<String> apply(String entity) {
                return AdminUtils$.MODULE$.kafka$admin$AdminUtils$$entityPaths$1(this.zkUtils$5, (Option)new Some((Object)new StringBuilder().append((Object)entity).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)this.childEntityType$1).toString()), this.rootEntityType$1);
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.rootEntityType$1 = rootEntityType$1;
                this.childEntityType$1 = childEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(zkUtils, rootEntityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final String rootEntityType$1;

            public final Tuple2<String, Properties> apply(String entityPath) {
                return new Tuple2((Object)entityPath, (Object)AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$5, this.rootEntityType$1, entityPath));
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.rootEntityType$1 = rootEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public MetadataResponse.TopicMetadata fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils) {
        return this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, zkUtils, (HashMap<Object, Broker>)new HashMap(), this.fetchTopicMetadataFromZk$default$4());
    }

    public Set<MetadataResponse.TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkUtils zkUtils) {
        return this.fetchTopicMetadataFromZk(topics, zkUtils, SecurityProtocol.PLAINTEXT);
    }

    public Set<MetadataResponse.TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkUtils zkUtils, SecurityProtocol protocol) {
        HashMap cachedBrokerInfo = new HashMap();
        return (Set)topics.map((Function1)new Serializable(zkUtils, protocol, cachedBrokerInfo){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$7;
            private final SecurityProtocol protocol$2;
            private final HashMap cachedBrokerInfo$2;

            public final MetadataResponse.TopicMetadata apply(String topic) {
                return AdminUtils$.MODULE$.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, this.zkUtils$7, (HashMap<Object, Broker>)this.cachedBrokerInfo$2, this.protocol$2);
            }
            {
                this.zkUtils$7 = zkUtils$7;
                this.protocol$2 = protocol$2;
                this.cachedBrokerInfo$2 = cachedBrokerInfo$2;
            }
        }, scala.collection.Set$.MODULE$.canBuildFrom());
    }

    public MetadataResponse.TopicMetadata kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils, HashMap<Object, Broker> cachedBrokerInfo, SecurityProtocol protocol) {
        MetadataResponse.TopicMetadata topicMetadata;
        if (zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic))) {
            Map topicPartitionAssignment = (Map)zkUtils.getPartitionAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic).get();
            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                }
            });
            List partitionMetadata = (List)sortedPartitions.map((Function1)new Serializable(topic, zkUtils, cachedBrokerInfo, protocol){
                public static final long serialVersionUID = 0L;
                public final String topic$4;
                private final ZkUtils zkUtils$6;
                private final HashMap cachedBrokerInfo$1;
                public final SecurityProtocol protocol$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final MetadataResponse.PartitionMetadata apply(Tuple2<Object, Seq<Object>> partitionMap) {
                    MetadataResponse.PartitionMetadata partitionMetadata;
                    int partition = partitionMap._1$mcI$sp();
                    Seq replicas = (Seq)partitionMap._2();
                    Seq<Object> inSyncReplicas = this.zkUtils$6.getInSyncReplicasForPartition(this.topic$4, partition);
                    Option<Object> leader = this.zkUtils$6.getLeaderForPartition(this.topic$4, partition);
                    AdminUtils$.MODULE$.debug((Function0<String>)new Serializable(this, replicas, inSyncReplicas, leader){
                        public static final long serialVersionUID = 0L;
                        private final Seq replicas$1;
                        private final Seq inSyncReplicas$1;
                        private final Option leader$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"replicas = ").append((Object)this.replicas$1).append((Object)", in sync replicas = ").append((Object)this.inSyncReplicas$1).append((Object)", leader = ").append((Object)this.leader$1).toString();
                        }
                        {
                            this.replicas$1 = replicas$1;
                            this.inSyncReplicas$1 = inSyncReplicas$1;
                            this.leader$1 = leader$1;
                        }
                    });
                    Node leaderInfo = Node.noNode();
                    ObjectRef replicaInfo = ObjectRef.create((Object)Nil$.MODULE$);
                    ObjectRef isrInfo = ObjectRef.create((Object)Nil$.MODULE$);
                    try {
                        Node node;
                        Option<Object> option = leader;
                        if (!(option instanceof Some)) {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader exists for partition ").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
                        }
                        Some some = (Some)option;
                        int l = BoxesRunTime.unboxToInt((Object)some.x());
                        leaderInfo = node = this.liftedTree1$1(partition, l);
                        try {
                            replicaInfo.elem = (Seq)AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$6, (scala.collection.mutable.Map<Object, Broker>)this.cachedBrokerInfo$1, (Seq<Object>)replicas).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.19 $outer;

                                public final Node apply(Broker x$9) {
                                    return x$9.getNode(this.$outer.protocol$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            isrInfo.elem = (Seq)AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$6, (scala.collection.mutable.Map<Object, Broker>)this.cachedBrokerInfo$1, inSyncReplicas).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.19 $outer;

                                public final Node apply(Broker x$10) {
                                    return x$10.getNode(this.$outer.protocol$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                        }
                        catch (Throwable throwable) {
                            throw new ReplicaNotAvailableException(throwable);
                        }
                        if (((Seq)replicaInfo.elem).size() < replicas.size()) {
                            throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"Replica information not available for following brokers: ").append((Object)((TraversableOnce)replicas.filterNot((Function1)new Serializable(this, replicaInfo){
                                public static final long serialVersionUID = 0L;
                                private final ObjectRef replicaInfo$1;

                                public final boolean apply(int x$12) {
                                    return this.apply$mcZI$sp(x$12);
                                }

                                public boolean apply$mcZI$sp(int x$12) {
                                    return ((SeqLike)((Seq)this.replicaInfo$1.elem).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Node x$11) {
                                            return x$11.id();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)x$12));
                                }
                                {
                                    this.replicaInfo$1 = replicaInfo$1;
                                }
                            })).mkString(",")).toString());
                        }
                        if (((Seq)isrInfo.elem).size() < inSyncReplicas.size()) {
                            throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"In Sync Replica information not available for following brokers: ").append((Object)((TraversableOnce)inSyncReplicas.filterNot((Function1)new Serializable(this, isrInfo){
                                public static final long serialVersionUID = 0L;
                                private final ObjectRef isrInfo$1;

                                public final boolean apply(int x$14) {
                                    return this.apply$mcZI$sp(x$14);
                                }

                                public boolean apply$mcZI$sp(int x$14) {
                                    return ((SeqLike)((Seq)this.isrInfo$1.elem).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Node x$13) {
                                            return x$13.id();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)x$14));
                                }
                                {
                                    this.isrInfo$1 = isrInfo$1;
                                }
                            })).mkString(",")).toString());
                        }
                        partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, partition, leaderInfo, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaInfo.elem).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)isrInfo.elem).asJava());
                        return partitionMetadata;
                    }
                    catch (Throwable throwable) {
                        AdminUtils$.MODULE$.debug((Function0<String>)new Serializable(this, partition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.19 $outer;
                            private final int partition$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Error while fetching metadata for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$1 = partition$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$1;

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = e$1;
                            }
                        });
                        partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.forException((Throwable)throwable), partition, leaderInfo, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaInfo.elem).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)isrInfo.elem).asJava());
                    }
                    return partitionMetadata;
                }

                private final Node liftedTree1$1(int partition$1, int l$1) {
                    try {
                        return ((Broker)AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$6, (scala.collection.mutable.Map<Object, Broker>)this.cachedBrokerInfo$1, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{l$1}))).head()).getNode(this.protocol$1);
                    }
                    catch (Throwable throwable) {
                        throw new LeaderNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Leader not available for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)partition$1)})), throwable);
                    }
                }
                {
                    this.topic$4 = topic$4;
                    this.zkUtils$6 = zkUtils$6;
                    this.cachedBrokerInfo$1 = cachedBrokerInfo$1;
                    this.protocol$1 = protocol$1;
                }
            }, List$.MODULE$.canBuildFrom());
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic$.MODULE$.isInternal(topic), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionMetadata).asJava());
        } else {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        return topicMetadata;
    }

    private SecurityProtocol fetchTopicMetadataFromZk$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Broker> kafka$admin$AdminUtils$$getBrokerInfoFromCache(ZkUtils zkUtils, scala.collection.mutable.Map<Object, Broker> cachedBrokerInfo, Seq<Object> brokerIds) {
        ObjectRef failedBrokerIds = ObjectRef.create((Object)new ListBuffer());
        Seq brokerMetadata = (Seq)brokerIds.map((Function1)new Serializable(zkUtils, cachedBrokerInfo, failedBrokerIds){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$8;
            private final scala.collection.mutable.Map cachedBrokerInfo$3;
            private final ObjectRef failedBrokerIds$1;

            public final Option<Broker> apply(int id) {
                Option option;
                block4: {
                    Option<Broker> option2;
                    block7: {
                        Some some;
                        block3: {
                            None$ none$;
                            block6: {
                                block5: {
                                    block2: {
                                        Option optionalBrokerInfo = this.cachedBrokerInfo$3.get((Object)BoxesRunTime.boxToInteger((int)id));
                                        option = optionalBrokerInfo;
                                        if (!(option instanceof Some)) break block2;
                                        Some some2 = (Some)option;
                                        Broker brokerInfo = (Broker)some2.x();
                                        some = new Some((Object)brokerInfo);
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    option2 = this.zkUtils$8.getBrokerInfo(id);
                                    if (!(option2 instanceof Some)) break block5;
                                    Some some3 = (Some)option2;
                                    Broker brokerInfo = (Broker)some3.x();
                                    this.cachedBrokerInfo$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)brokerInfo));
                                    none$ = new Some((Object)brokerInfo);
                                    break block6;
                                }
                                if (!None$.MODULE$.equals(option2)) break block7;
                                ((ListBuffer)this.failedBrokerIds$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)id));
                                none$ = None$.MODULE$;
                            }
                            some = none$;
                        }
                        return some;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkUtils$8 = zkUtils$8;
                this.cachedBrokerInfo$3 = cachedBrokerInfo$3;
                this.failedBrokerIds$1 = failedBrokerIds$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)brokerMetadata.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Broker> x$15) {
                return x$15.isDefined();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Option<Broker> x$16) {
                return (Broker)x$16.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public final Seq kafka$admin$AdminUtils$$entityPaths$1(ZkUtils zkUtils, Option rootPath, String rootEntityType$1) {
        Option option;
        block4: {
            Option option2;
            block7: {
                Seq seq;
                block6: {
                    Seq entityNames;
                    block5: {
                        String string;
                        block3: {
                            block2: {
                                option = rootPath;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String path = (String)some.x();
                                string = new StringBuilder().append((Object)rootEntityType$1).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)path).toString();
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string = rootEntityType$1;
                        }
                        String root = string;
                        entityNames = zkUtils.getAllEntitiesWithConfig(root);
                        option2 = rootPath;
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String path = (String)some.x();
                        seq = (Seq)entityNames.map((Function1)new Serializable(path){
                            public static final long serialVersionUID = 0L;
                            private final String path$1;

                            public final String apply(String entityName) {
                                return new StringBuilder().append((Object)this.path$1).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)entityName).toString();
                            }
                            {
                                this.path$1 = path$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    seq = entityNames;
                }
                return seq;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
        this.EntityConfigChangeZnodePrefix = "config_change_";
    }
}

