/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.util.List;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.log.LogValidatorTest$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005\u0001C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2)\u00051\u0002CA\u0005\u0018\u0013\tA\"B\u0001\u0003V]&$\bFA\n\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0005I\u0005y2\r[3dW2{w-\u00119qK:$G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3\u0015\u0005Y)\u0003\"\u0002\u0014#\u0001\u00049\u0013!B7bO&\u001c\u0007CA\u0005)\u0013\tI#B\u0001\u0003CsR,\u0007\"B\u0016\u0001\t\u0003)\u0012\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-JBQ!\f\u0001\u0005\u0002U\tA\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bNU3d_6\u0004(/Z:tS>tg+\r\u0015\u0003YiAQ\u0001\r\u0001\u0005\nE\n1e\u00195fG.dunZ!qa\u0016tG\rV5nK^KG\u000f\u001b*fG>l\u0007O]3tg&|g\u000e\u0006\u0002\u0017e!)1g\fa\u0001O\u0005YA/\u0019:hKRl\u0015mZ5d\u0011\u0015)\u0004\u0001\"\u0001\u0016\u0003\u0011\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]Z\u0013\u0004F\u0001\u001b\u001b\u0011\u0015A\u0004\u0001\"\u0001\u0016\u0003\u001d\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|gNV\u0019)\u0005]R\u0002\"B\u001e\u0001\t\u0013a\u0014AJ2iK\u000e\\Gj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]R\u0011a#\u0010\u0005\u0006Mi\u0002\ra\n\u0005\u0006\u007f\u0001!\t!F\u0001(i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i_V$(+Z2p[B\u0014Xm]:j_:4&\u0007\u000b\u0002?5!)!\t\u0001C\u0001+\u0005\u0019B/Z:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3Wc!\u0012\u0011I\u0007\u0005\u0006\u000b\u0002!IAR\u0001\u0013G\",7m\u001b(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0002\u0017\u000f\")a\u0005\u0012a\u0001O!)\u0011\n\u0001C\u0001+\u0005\u0019B/Z:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u0012\u0001J\u0007\u0005\u0006\u0019\u0002!\t!F\u0001\u0014i\u0016\u001cHOU3d_6\u0004(/Z:tS>tg+\r\u0015\u0003\u0017jAQa\u0014\u0001\u0005\nA\u000b!c\u00195fG.\u0014VmY8naJ,7o]5p]R\u0011a#\u0015\u0005\u0006M9\u0003\ra\n\u0005\u0006'\u0002!\t!F\u0001\u0014i\u0016\u001cHOU3d_6\u0004(/Z:tS>tgK\r\u0015\u0003%jAQA\u0016\u0001\u0005\u0002U\t\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0006\u0007V8Wc!\u0012QK\u0007\u0005\u00063\u0002!IAW\u0001\"G\",7m[\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8Ge>lg\u000b\r\u000b\u0003-mCQ\u0001\u0018-A\u0002\u001d\nq\u0001^8NC\u001eL7\rC\u0003_\u0001\u0011\u0005Q#\u0001\u0011uKN$8I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u0013\u0004FA/\u001b\u0011\u0015\t\u0007\u0001\"\u0001\u0016\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o-F\"vN\u0016\u001a)\u0005\u0001T\u0002\"\u00023\u0001\t\u0003)\u0012\u0001\u0005;fgR\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\t\u0019'\u0004C\u0003h\u0001\u0011%\u0001.A\bdQ\u0016\u001c7nQ8naJ,7o]3e)\t1\u0012\u000eC\u0003'M\u0002\u0007q\u0005C\u0003l\u0001\u0011\u0005Q#\u0001\tuKN$8i\\7qe\u0016\u001c8/\u001a3We!\u0012!N\u0007\u0005\u0006]\u0002!\t!F\u0001%i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3Wc!\"QN\u00079r\u0003!)\u0007\u0010]3di\u0016$7%\u0001:\u0011\u0005M\\X\"\u0001;\u000b\u0005U4\u0018AB3se>\u00148O\u0003\u0002xq\u000611m\\7n_:T!!B=\u000b\u0005it\u0012AB1qC\u000eDW-\u0003\u0002}i\nI\u0012J\u001c<bY&$G+[7fgR\fW\u000e]#yG\u0016\u0004H/[8o\u0011\u0015q\b\u0001\"\u0001\u0016\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u0013\u0004\u0006B?\u001baFDa!a\u0001\u0001\t\u0003)\u0012!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u000b\u0004&BA\u00015A\f\bBBA\u0005\u0001\u0011\u0005Q#A\u0011uKN$\u0018J\u001c<bY&$7I]3bi\u0016$\u0016.\\3D_6\u0004(/Z:tK\u00124&\u0007K\u0003\u0002\bi\u0001\u0018\u000f\u0003\u0004\u0002\u0010\u0001!\t!F\u0001*i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\u00055!\u0004\u0003\u0004\u0002\u0016\u0001!\t!F\u0001'i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$\u0007fAA\n5!1\u00111\u0004\u0001\u0005\u0002U\t1\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004\u00033Q\u0002BBA\u0011\u0001\u0011\u0005Q#A\u0016uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r\tyB\u0007\u0005\u0007\u0003O\u0001A\u0011A\u000b\u0002QQ,7\u000f\u001e*fY\u0006$\u0018N^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007\u0005\u0015\"\u0004\u0003\u0004\u0002.\u0001!\t!F\u0001)i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004\u0003WQ\u0002BBA\u001a\u0001\u0011\u0005Q#\u0001\u001duKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,2\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\u0005E\"\u0004\u0003\u0004\u0002:\u0001!\t!F\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We9{gnQ8naJ,7o]3eQ\r\t9D\u0007\u0005\u0007\u0003\u007f\u0001A\u0011A\u000b\u0002kQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-F\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0003{Q\u0002BBA#\u0001\u0011\u0005Q#A\u001buKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,3\u0007>l\u0007O]3tg\u0016$\u0007fAA\"5!1\u00111\n\u0001\u0005\u0002U\tq\u0005^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:eg:{G/\u00117m_^,GM\u0012:p[\u000ec\u0017.\u001a8ug\"2\u0011\u0011\n\u000eq\u0003\u001f\u001a#!!\u0015\u0011\t\u0005M\u0013\u0011L\u0007\u0003\u0003+R1!a\u0016w\u0003\u0019\u0011XmY8sI&!\u00111LA+\u0005YIeN^1mS\u0012\u0014VmY8sI\u0016C8-\u001a9uS>t\u0007BBA0\u0001\u0011\u0005Q#A\u0010uKN$8i\u001c8ue>d'+Z2pe\u0012\u001chj\u001c;D_6\u0004(/Z:tK\u0012D3!!\u0018\u001b\u0011\u0019\t)\u0007\u0001C\u0001+\u0005QD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-F\"vN\u0016\u0019O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0003GR\u0002BBA6\u0001\u0011\u0005Q#A\u001cuKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tg+\r+p-B\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0003SR\u0002BBA9\u0001\u0011\u0005Q#\u0001\u001duKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\u0005=$\u0004\u0003\u0004\u0002x\u0001!\t!F\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0016\u0007V8We\r{W\u000e\u001d:fgN,G\rK\u0002\u0002viAa!! \u0001\t\u0003)\u0012A\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4&\u0007V8Wc9{gnQ8naJ,7o]3eQ\r\tYH\u0007\u0005\u0007\u0003\u0007\u0003A\u0011A\u000b\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016gQ8naJ,7o]3eQ\r\t\tI\u0007\u0005\u0007\u0003\u0013\u0003A\u0011A\u000b\u0002iQ,7\u000f\u001e#po:\u001cuN\u001c<feNLwN\\(g)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\r\u000b\u0004\u0002\bj\u0001\u0018QR\u0012\u0003\u0003\u001f\u00032a]AI\u0013\r\t\u0019\n\u001e\u0002%+:\u001cX\u000f\u001d9peR,GMR8s\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;Fq\u000e,\u0007\u000f^5p]\"1\u0011q\u0013\u0001\u0005\u0002U\t\u0011\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3\u0017\nZ3na>$XM\u001c;SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\r\u000b\u0004\u0002\u0016j\u0001\u0018Q\u0012\u0005\u0007\u0003;\u0003A\u0011A\u000b\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0006GT8o\u0007>l\u0007O]3tg\u0016$\u0007fAAN5!1\u00111\u0015\u0001\u0005\u0002U\tq\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,1\u0007>l\u0007O]3tg\u0016$\u0007fAAQ5!1\u0011\u0011\u0016\u0001\u0005\u0002U\tA\u0004^3ti&sg/\u00197jI&sg.\u001a:NC\u001eL7MV3sg&|g\u000e\u000b\u0004\u0002(j\u0001\u0018q\n\u0005\b\u0003_\u0003A\u0011BAY\u00035\u0019'/Z1uKJ+7m\u001c:egRA\u00111WA]\u0003{\u000b9\r\u0005\u0003\u0002T\u0005U\u0016\u0002BA\\\u0003+\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\b\"CA^\u0003[\u0003\n\u00111\u0001(\u0003)i\u0017mZ5d-\u0006dW/\u001a\u0005\u000b\u0003\u007f\u000bi\u000b%AA\u0002\u0005\u0005\u0017!\u0003;j[\u0016\u001cH/Y7q!\rI\u00111Y\u0005\u0004\u0003\u000bT!\u0001\u0002'p]\u001eD!\"!3\u0002.B\u0005\t\u0019AAf\u0003\u0015\u0019w\u000eZ3d!\u0011\t\u0019&!4\n\t\u0005=\u0017Q\u000b\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0017\u0001D2iK\u000e\\wJ\u001a4tKR\u001cH#\u0002\f\u0002X\u0006m\u0007\u0002CAm\u0003#\u0004\r!a-\u0002\u000fI,7m\u001c:eg\"A\u0011Q\\Ai\u0001\u0004\t\t-\u0001\u0006cCN,wJ\u001a4tKRDq!!9\u0001\t\u0013\t\u0019/\u0001\u000fsK\u000e|'\u000fZ:XSRD\u0017J\u001c<bY&$\u0017J\u001c8fe6\u000bw-[2\u0015\t\u0005M\u0016Q\u001d\u0005\t\u0003O\fy\u000e1\u0001\u0002B\u0006i\u0011N\\5uS\u0006dwJ\u001a4tKRDq!a;\u0001\t\u0003\ti/A\fnCf\u0014Wm\u00115fG.\u0014\u0015m]3US6,7\u000f^1naR)a#a<\u0002r\"9\u0001/!;A\u0002\u0005\u0005\u0007\u0002CAz\u0003S\u0004\r!!>\u0002\u000b\t\fGo\u00195\u0011\t\u0005M\u0013q_\u0005\u0005\u0003s\f)FA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007bBA\u007f\u0001\u0011\u0005\u0011q`\u0001\u0016m\u0006d\u0017\u000eZ1uK2{w-\u00119qK:$G+[7f)\u001d1\"\u0011\u0001B\u0003\u0005\u0013A\u0001Ba\u0001\u0002|\u0002\u0007\u0011\u0011Y\u0001\u0016Kb\u0004Xm\u0019;fI2{w-\u00119qK:$G+[7f\u0011!\u00119!a?A\u0002\u0005\u0005\u0017!F3ya\u0016\u001cG/\u001a3CCN,G+[7fgR\fW\u000e\u001d\u0005\t\u0003g\fY\u00101\u0001\u0002v\"I!Q\u0002\u0001\u0012\u0002\u0013%!qB\u0001\u0018GJ,\u0017\r^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIE*\"A!\u0005+\u0007\u001d\u0012\u0019b\u000b\u0002\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011!C;oG\",7m[3e\u0015\r\u0011yBC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0012\u00053\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00119\u0003AI\u0001\n\u0013\u0011I#A\fde\u0016\fG/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0006\u0016\u0005\u0003\u0003\u0014\u0019\u0002C\u0005\u00030\u0001\t\n\u0011\"\u0003\u00032\u000592M]3bi\u0016\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u0005gQC!a3\u0003\u0014\u0001")
public class LogValidatorTest {
    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$1;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$1, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$8 = 0;
        CompressionType x$9 = CompressionType.GZIP;
        long x$10 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$8, x$10, x$9);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$2;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$2, -1L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$2 = now$2;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$3;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$3, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$3 = now$3;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true);
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, isTransactional2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$1;
                private final long producerId$1;
                private final short producerEpoch$1;
                private final int baseSequence$1;
                private final boolean isTransactional$1;
                private final int partitionLeaderEpoch$1;
                public final IntRef i$1;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$2) {
                            return x$2.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$1, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$1, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$1, (long)batch.baseSequence());
                    Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
                    Assert.assertEquals((long)this.partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkNonCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$1.apply(this.$outer.i$1.elem)), (long)record.timestamp());
                            ++this.$outer.i$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$1 = timestampSeq$1;
                    this.producerId$1 = producerId$1;
                    this.producerEpoch$1 = producerEpoch$1;
                    this.baseSequence$1 = baseSequence$1;
                    this.isTransactional$1 = isTransactional$1;
                    this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                    this.i$1 = i$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true);
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$2;
                private final long producerId$2;
                private final short producerEpoch$2;
                private final int baseSequence$2;
                private final int partitionLeaderEpoch$2;
                public final IntRef i$2;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$2.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$4) {
                            return x$4.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$2, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$2, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$2, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkRecompression$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$2.apply(this.$outer.i$2.elem)), (long)record.timestamp());
                            ++this.$outer.i$2.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$2 = timestampSeq$2;
                    this.producerId$2 = producerId$2;
                    this.producerEpoch$2 = producerEpoch$2;
                    this.baseSequence$2 = baseSequence$2;
                    this.partitionLeaderEpoch$2 = partitionLeaderEpoch$2;
                    this.i$2 = i$2;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        MemoryRecords records2;
        byte x$11 = 0;
        CompressionType x$12 = CompressionType.GZIP;
        long x$13 = this.createRecords$default$2();
        MemoryRecords x$14 = records2 = this.createRecords(x$11, x$13, x$12);
        kafka.common.LongRef x$15 = new kafka.common.LongRef(0L);
        long x$16 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$17 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$18 = DefaultCompressionCodec$.MODULE$;
        byte x$19 = toMagic;
        boolean x$20 = false;
        TimestampType x$21 = TimestampType.CREATE_TIME;
        long x$22 = 1000L;
        int x$23 = -1;
        boolean x$24 = true;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$14, x$15, x$16, (CompressionCodec)x$17, (CompressionCodec)x$18, x$20, x$19, x$21, x$22, x$23, x$24);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
                Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        MemoryRecords records2;
        long timestamp = System.currentTimeMillis();
        byte x$25 = 1;
        CompressionType x$26 = CompressionType.GZIP;
        long x$27 = timestamp;
        MemoryRecords x$28 = records2 = this.createRecords(x$25, x$27, x$26);
        kafka.common.LongRef x$29 = new kafka.common.LongRef(0L);
        long x$30 = timestamp;
        DefaultCompressionCodec$ x$31 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$32 = DefaultCompressionCodec$.MODULE$;
        byte x$33 = 2;
        boolean x$34 = false;
        TimestampType x$35 = TimestampType.CREATE_TIME;
        long x$36 = 1000L;
        int x$37 = -1;
        boolean x$38 = true;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$28, x$29, x$30, (CompressionCodec)x$31, (CompressionCodec)x$32, x$34, x$33, x$35, x$36, x$37, x$38);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long timestamp$1;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(this.timestamp$1, (RecordBatch)batch);
                Assert.assertEquals((long)this.timestamp$1, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
            }
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            MemoryRecords records2;
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords x$39 = records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            kafka.common.LongRef x$40 = new kafka.common.LongRef(0L);
            long x$41 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$42 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$43 = DefaultCompressionCodec$.MODULE$;
            byte x$44 = magic;
            boolean x$45 = false;
            TimestampType x$46 = TimestampType.CREATE_TIME;
            long x$47 = 1000L;
            int x$48 = partitionLeaderEpoch2;
            boolean x$49 = true;
            LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$39, x$40, x$41, (CompressionCodec)x$42, (CompressionCodec)x$43, x$45, x$44, x$46, x$47, x$48, x$49);
            MemoryRecords validatedRecords = validatedResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$3;
                private final long producerId$3;
                private final short producerEpoch$3;
                private final int baseSequence$3;
                private final int partitionLeaderEpoch$3;
                public final IntRef i$3;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$3.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$6) {
                            return x$6.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$3, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$3, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$3, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$3.apply(this.$outer.i$3.elem)), (long)record.timestamp());
                            ++this.$outer.i$3.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$3 = timestampSeq$3;
                    this.producerId$3 = producerId$3;
                    this.producerEpoch$3 = producerEpoch$3;
                    this.baseSequence$3 = baseSequence$3;
                    this.partitionLeaderEpoch$3 = partitionLeaderEpoch$3;
                    this.i$3 = i$3;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatedResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, true);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, true);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV1() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$50 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$51 = new kafka.common.LongRef(0L);
        long x$52 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$53 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$54 = DefaultCompressionCodec$.MODULE$;
        byte x$55 = 1;
        boolean x$56 = false;
        TimestampType x$57 = TimestampType.CREATE_TIME;
        long x$58 = 1000L;
        int x$59 = -1;
        boolean x$60 = true;
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$50, x$51, x$52, (CompressionCodec)x$53, (CompressionCodec)x$54, x$56, x$55, x$57, x$58, x$59, x$60);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV2() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$61 = records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$62 = new kafka.common.LongRef(0L);
        long x$63 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$64 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$65 = DefaultCompressionCodec$.MODULE$;
        byte x$66 = 1;
        boolean x$67 = false;
        TimestampType x$68 = TimestampType.CREATE_TIME;
        long x$69 = 1000L;
        int x$70 = -1;
        boolean x$71 = true;
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$61, x$62, x$63, (CompressionCodec)x$64, (CompressionCodec)x$65, x$67, x$66, x$68, x$69, x$70, x$71);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$72 = 0;
        CompressionType x$73 = CompressionType.NONE;
        long x$74 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$72, x$74, x$73);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$75 = records2;
        kafka.common.LongRef x$76 = new kafka.common.LongRef((long)offset);
        long x$77 = System.currentTimeMillis();
        NoCompressionCodec$ x$78 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$79 = NoCompressionCodec$.MODULE$;
        byte x$80 = 0;
        boolean x$81 = false;
        TimestampType x$82 = TimestampType.CREATE_TIME;
        long x$83 = 1000L;
        int x$84 = -1;
        boolean x$85 = true;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$75, x$76, x$77, (CompressionCodec)x$78, (CompressionCodec)x$79, x$81, x$80, x$82, x$83, x$84, x$85).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$86 = 0;
        CompressionType x$87 = CompressionType.GZIP;
        long x$88 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$86, x$88, x$87);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$89 = 0;
        CompressionType x$90 = CompressionType.NONE;
        long x$91 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$89, x$91, x$90);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$92 = 0;
        CompressionType x$93 = CompressionType.NONE;
        long x$94 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$92, x$94, x$93);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$95 = 0;
        CompressionType x$96 = CompressionType.GZIP;
        long x$97 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$95, x$97, x$96);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$98 = 0;
        CompressionType x$99 = CompressionType.GZIP;
        long x$100 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$98, x$100, x$99);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true);
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator.ValidationAndOffsetAssignResult result = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, false);
        List batches = TestUtils.toList((Iterable)result.validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertFalse((boolean)batch.isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$101 = 1;
        CompressionType x$102 = CompressionType.NONE;
        long x$103 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$101, x$103, x$102);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$104 = 1;
        CompressionType x$105 = CompressionType.GZIP;
        long x$106 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$104, x$106, x$105);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidInnerMagicVersion() {
        int offset = 1234567;
        MemoryRecords records2 = this.recordsWithInvalidInnerMagic(offset);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), System.currentTimeMillis(), (CompressionCodec)SnappyCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true);
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private byte createRecords$default$1() {
        return 2;
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private CompressionType createRecords$default$3() {
        return CompressionType.NONE;
    }

    public void checkOffsets(MemoryRecords records2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(Record entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    private MemoryRecords recordsWithInvalidInnerMagic(long initialOffset) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$7) {
                return x$7.sizeInBytes();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$2;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$2.elem, record);
                ++this.offset$2.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$2 = offset$2;
            }
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        RecordBatch recordBatch = batch;
        if (recordBatch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)recordBatch;
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected base timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expected, (long)defaultRecordBatch.baseTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected max timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, expectedLogAppendTime){
            public static final long serialVersionUID = 0L;
            private final long expectedLogAppendTime$1;

            public final void apply(Record record) {
                Assert.assertTrue((boolean)record.isValid());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected timestamp of record ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})), (long)this.expectedLogAppendTime$1, (long)record.timestamp());
            }
            {
                this.expectedLogAppendTime$1 = expectedLogAppendTime$1;
            }
        });
    }
}

