/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerIdEntry;
import kafka.log.ProducerIdEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.DuplicateSequenceNumberException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001A\u0002\u0013\u0005\u0011$\u0001\u0004m_\u001e$\u0015N]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\n!\u0002\\8h\t&\u0014x\fJ3r)\t)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bb\u0002\u0017#\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004B\u0002\u0018\u0001A\u0003&!$A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000fA\u0002\u0001\u0019!C\u0001c\u0005a1\u000f^1uK6\u000bg.Y4feV\t!\u0007\u0005\u0002\u0017g%\u0011AG\u0001\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000fY\u0002\u0001\u0019!C\u0001o\u0005\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0003KaBq\u0001L\u001b\u0002\u0002\u0003\u0007!\u0007\u0003\u0004;\u0001\u0001\u0006KAM\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002}A\u0011q(R\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0019%B\u0001#\u000f\u0003\u0019\t\u0007/Y2iK&\u0011a\t\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019A\u0005\u0001)A\u0005}\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006Q\u0001O]8ek\u000e,'/\u00133\u0016\u00031\u0003\"AJ'\n\u00059;#\u0001\u0002'p]\u001eDa\u0001\u0015\u0001!\u0002\u0013a\u0015a\u00039s_\u0012,8-\u001a:JI\u0002BqA\u0015\u0001C\u0002\u0013\u00051+\u0001\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001bX#\u0001+\u0011\u0005\u0019*\u0016B\u0001,(\u0005\rIe\u000e\u001e\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\u0002'5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\t\u000fi\u0003!\u0019!C\u00017\u0006!A/[7f+\u0005a\u0006CA/a\u001b\u0005q&BA0A\u0003\u0015)H/\u001b7t\u0013\t\tgL\u0001\u0005N_\u000e\\G+[7f\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006)A/[7fA!)Q\r\u0001C\u0001M\u0006)1/\u001a;VaR\tQ\u0005\u000b\u0002eQB\u0011\u0011n[\u0007\u0002U*\u00111BD\u0005\u0003Y*\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u00031\u0017\u0001\u0003;fCJ$un\u001e8)\u00055\u0004\bCA5r\u0013\t\u0011(NA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005a-\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007FA:w!\tIw/\u0003\u0002yU\n!A+Z:u\u0011\u0015Q\b\u0001\"\u0001g\u0003y!Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK^\u0013\u0018\r]!s_VtG\r\u000b\u0002zm\")Q\u0010\u0001C\u0001M\u0006)C/Z:u!J|G-^2feN+\u0017/^3oG\u0016LeN^1mS\u0012<&/\u00199Be>,h\u000e\u001a\u0015\u0006yZ|\u0018\u0011A\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002!\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\ti!a\u0002\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0011\u0019\t\t\u0002\u0001C\u0001M\u0006QC/Z:u\u001d>4\u0016\r\\5eCRLwN\\(o\r&\u00148\u000f^#oiJLx\u000b[3o\u0019>\fG-\u001b8h\u0019><\u0007fAA\bm\"1\u0011q\u0003\u0001\u0005\u0002\u0019\f1\u0004^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:e\u0005Vl\u0007o]#q_\u000eD\u0007fAA\u000bm\"1\u0011Q\u0004\u0001\u0005\u0002\u0019\f\u0001\u0005^3tiRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006\u001c\u0015m\u00195fI\"\u001a\u00111\u0004<\t\r\u0005\r\u0002\u0001\"\u0001g\u00039\"Xm\u001d;O_:l\u0015\r^2iS:<G\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018MT8u\u0007\u0006\u001c\u0007.\u001a3)\u0007\u0005\u0005b\u000f\u0003\u0004\u0002*\u0001!\tAZ\u0001\u001fkB$\u0017\r^3Qe>$WoY3s)J\fgn]1di&|gn\u0015;bi\u0016D3!a\nw\u0011\u0019\ty\u0003\u0001C\u0001M\u0006aC/Z:u\u001fV$xJZ*fcV,gnY3BMR,'oQ8oiJ|GNU3d_J$W\t]8dQ\n+X\u000e\u001d\u0015\u0007\u0003[1x0!\u0001\t\r\u0005U\u0002\u0001\"\u0001g\u0003A\"Xm\u001d;O_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0003\b/\u001a8e/&$\bn\u00148h_&tw\r\u0016:b]N\f7\r^5p]\"2\u00111\u0007<\u0000\u0003s\u0019#!a\u000f\u0011\t\u0005\u0015\u0011QH\u0005\u0005\u0003\u007f\t9A\u0001\rJ]Z\fG.\u001b3Uq:\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:Da!a\u0011\u0001\t\u00031\u0017a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bfAA!m\"1\u0011\u0011\n\u0001\u0005\u0002\u0019\f\u0001\u0003^3tiR\u000b7.Z*oCB\u001c\bn\u001c;)\u0007\u0005\u001dc\u000f\u0003\u0004\u0002P\u0001!\tAZ\u0001\u0018i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_RD3!!\u0014w\u0011\u0019\t)\u0006\u0001C\u0001M\u0006iB/Z:u%\u0016lwN^3FqBL'/\u001a3QS\u0012\u001cxJ\u001c*fY>\fG\r\u000b\u0004\u0002TY|\u0018\u0011\u0001\u0005\u0007\u00037\u0002A\u0011\u00014\u00023Q,7\u000f\u001e#fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u0015\u0004\u000332\bBBA1\u0001\u0011\u0005a-\u0001\u0007uKN$HK];oG\u0006$X\rK\u0002\u0002`YDa!a\u001a\u0001\t\u00031\u0017A\n;fgR4\u0015N]:u+:\u001cH/\u00192mK>3gm]3u\u0003\u001a$XM\u001d+sk:\u001c\u0017\r^5p]\"\u001a\u0011Q\r<\t\r\u00055\u0004\u0001\"\u0001g\u0003\u0011\"Xm\u001d;GSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G/\u00114uKJ,e/[2uS>t\u0007fAA6m\"1\u00111\u000f\u0001\u0005\u0002\u0019\f\u0001\u0003^3tiR\u0013XO\\2bi\u0016DU-\u00193)\u0007\u0005Ed\u000f\u0003\u0004\u0002z\u0001!\tAZ\u00010i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;SK6|g/Z:O_:\u0014V\r^1j]\u0016$\u0007K]8ek\u000e,'o\u001d\u0015\u0004\u0003o2\bBBA@\u0001\u0011\u0005a-A\u0011uKN$8k[5q':\f\u0007o\u001d5pi&3wJ\u001a4tKR,fn\u00195b]\u001e,G\rK\u0002\u0002~YDa!!\"\u0001\t\u00031\u0017a\u0004;fgR\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007\u0005\re\u000f\u0003\u0004\u0002\f\u0002!\tAZ\u0001\u0019i\u0016\u001cH\u000fU5e\u000bb\u0004\u0018N]1uS>tG+[7f_V$\bFBAEm~\f\t\u0001\u0003\u0004\u0002\u0012\u0002!\tAZ\u0001\u0018i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKRD3!a$w\u0011\u0019\t9\n\u0001C\u0001M\u0006qC/Z:u!J|G-^2feN<\u0016\u000e\u001e5P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t7\u000fR8oi\u0016C\b/\u001b:fQ\r\t)J\u001e\u0005\u0007\u0003;\u0003A\u0011\u00014\u0002[Q,7\u000f^*fcV,gnY3O_R4\u0016\r\\5eCR,GMR8s\u000fJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7\rK\u0002\u0002\u001cZDa!a)\u0001\t\u00031\u0017\u0001\b;fgR|E\u000eZ#q_\u000eDgi\u001c:D_:$(o\u001c7SK\u000e|'\u000f\u001a\u0015\u0007\u0003C3x0a*$\u0005\u0005%\u0006\u0003BA\u0003\u0003WKA!!,\u0002\b\t9\u0002K]8ek\u000e,'OR3oG\u0016$W\t_2faRLwN\u001c\u0005\u0007\u0003c\u0003A\u0011\u00014\u0002-Q,7\u000f^\"p_J$\u0017N\\1u_J4UM\\2j]\u001eD3!a,w\u0011\u0019\t9\f\u0001C\u0001M\u0006\u0001C/Z:u\u0007>|'\u000fZ5oCR|'OR3oG\u0016$\u0017I\u001a;feJ+Gn\\1eQ\u0019\t)L^@\u0002<\u000e\u0012\u0011Q\u0018\t\u0005\u0003\u000b\ty,\u0003\u0003\u0002B\u0006\u001d!!\n+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ#yG\u0016\u0004H/[8o\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f\f!#\u00199qK:$WI\u001c3Uq:l\u0015M]6feR\u0001\u0012\u0011ZAk\u00033\fY.!:\u0002v\u0006e\u0018Q \t\u0007M\u0005-\u0017q\u001a'\n\u0007\u00055wE\u0001\u0004UkBdWM\r\t\u0004-\u0005E\u0017bAAj\u0005\ta1i\\7qY\u0016$X\r\u001a+y]\"9\u0011q[Ab\u0001\u0004\u0011\u0014aB7baBLgn\u001a\u0005\u0007\u0015\u0006\r\u0007\u0019\u0001'\t\u0011\u0005u\u00171\u0019a\u0001\u0003?\fQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007c\u0001\u0014\u0002b&\u0019\u00111]\u0014\u0003\u000bMCwN\u001d;\t\u0011\u0005\u001d\u00181\u0019a\u0001\u0003S\f1bY8oiJ|G\u000eV=qKB!\u00111^Ay\u001b\t\tiOC\u0002\u0002p\u0002\u000baA]3d_J$\u0017\u0002BAz\u0003[\u0014\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u001d\t90a1A\u00021\u000baa\u001c4gg\u0016$\b\"CA~\u0003\u0007\u0004\n\u00111\u0001U\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0005\u0002\u0000\u0006\r\u0007\u0013!a\u0001\u0019\u0006IA/[7fgR\fW\u000e\u001d\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0003\u0019\t\u0007\u000f]3oIR\tREa\u0002\u0003\n\t-!Q\u0002B\t\u0005'\u0011)Ba\b\t\rA\u0012\t\u00011\u00013\u0011\u0019Q%\u0011\u0001a\u0001\u0019\"A\u0011Q\u001cB\u0001\u0001\u0004\ty\u000eC\u0004\u0003\u0010\t\u0005\u0001\u0019\u0001+\u0002\u0007M,\u0017\u000fC\u0004\u0002x\n\u0005\u0001\u0019\u0001'\t\u0013\u0005}(\u0011\u0001I\u0001\u0002\u0004a\u0005B\u0003B\f\u0005\u0003\u0001\n\u00111\u0001\u0003\u001a\u0005y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eE\u0002'\u00057I1A!\b(\u0005\u001d\u0011un\u001c7fC:D!B!\t\u0003\u0002A\u0005\t\u0019\u0001B\r\u0003AI7\u000fT8bI&twM\u0012:p[2{w\rC\u0004\u0003&\u0001!IAa\n\u0002-\r,(O]3oiNs\u0017\r]:i_R|eMZ:fiN,\"A!\u000b\u0011\u000b\t-\"Q\u0007'\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\tMr%\u0001\u0006d_2dWm\u0019;j_:LAAa\u000e\u0003.\t\u00191+\u001a;\t\u0013\tm\u0002!%A\u0005\n\tu\u0012\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yDK\u0002M\u0005\u0003Z#Aa\u0011\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001b:\u0013AC1o]>$\u0018\r^5p]&!!\u0011\u000bB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005+\u0002\u0011\u0013!C\u0005\u0005/\n\u0001#\u00199qK:$G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\te#\u0006\u0002B\r\u0005\u0003B\u0011B!\u0018\u0001#\u0003%IAa\u0016\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012B\u0004\"\u0003B1\u0001E\u0005I\u0011\u0002B2\u0003q\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIY*\"A!\u001a+\u0007Q\u0013\t\u0005C\u0005\u0003j\u0001\t\n\u0011\"\u0003\u0003>\u0005a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u0012:\u0004")
public class ProducerStateManagerTest
extends JUnitSuite {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 1, 0L, 1L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(DuplicateSequenceNumberException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 5, 0L, 2L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$17 = this.stateManager();
        long x$18 = this.producerId();
        short x$19 = epoch;
        int x$20 = sequence;
        long x$21 = offset;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        boolean x$24 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$17, x$18, x$19, x$20, x$21, x$23, x$24, x$22);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerIdEntry lastEntry = (ProducerIdEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$25 = this.stateManager();
        long x$26 = this.producerId();
        short x$27 = epoch;
        int x$28 = sequence;
        long x$29 = offset;
        boolean x$30 = true;
        long x$31 = this.append$default$6();
        boolean x$32 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$25, x$26, x$27, x$28, x$29, x$31, x$32, x$30);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = epoch;
        int x$36 = sequence;
        long x$37 = offset;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        boolean x$40 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$33, x$34, x$35, x$36, x$37, x$39, x$40, x$38);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerIdEntry lastEntry = (ProducerIdEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
            long lastStableOffset = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
            CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
            long lastStableOffset2 = tuple23._2$mcJ$sp();
            Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
            Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
            Assert.assertEquals((long)2L, (long)lastStableOffset2);
            Assert.assertTrue((boolean)completedTxn2.isAborted());
            Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
            Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
            Assert.assertTrue((boolean)maybeLastEntry.isDefined());
            ProducerIdEntry lastEntry = (ProducerIdEntry)maybeLastEntry.get();
            Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
            Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
            Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
            this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(ProducerIdEntry x$2) {
                    return x$2.firstSeq();
                }
            }));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerIdEntry$.MODULE$.Empty(), true, false);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)logOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testNonMatchingTxnFirstOffsetMetadataNotCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerIdEntry$.MODULE$.Empty(), true, false);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset - 23429L, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), false);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), 20L, true);
        ProducerIdEntry lastEntry = appendInfo.lastEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 30L, true);
        lastEntry = appendInfo.lastEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)6L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)26L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.lastEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)10L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)40L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)40L, (long)lastEntry.lastOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), bumpedEpoch, 2, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$41 = this.stateManager();
        long x$42 = this.producerId();
        short x$43 = epoch;
        int x$44 = 0;
        long x$45 = 0L;
        boolean x$46 = true;
        long x$47 = this.append$default$6();
        boolean x$48 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$41, x$42, x$43, x$44, x$45, x$47, x$46, x$48);
        ProducerStateManager x$49 = this.stateManager();
        long x$50 = this.producerId();
        short x$51 = epoch;
        int x$52 = 1;
        long x$53 = 1L;
        boolean x$54 = false;
        long x$55 = this.append$default$6();
        boolean x$56 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$49, x$50, x$51, x$52, x$53, x$55, x$54, x$56);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)Predef$.MODULE$.refArrayOps((Object[])this.logDir().list()).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$57 = this.stateManager();
        long x$58 = this.producerId();
        short x$59 = epoch;
        int x$60 = sequence;
        long x$61 = 99L;
        boolean x$62 = true;
        long x$63 = this.append$default$6();
        boolean x$64 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$57, x$58, x$59, x$60, x$61, x$63, x$62, x$64);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$3) {
                return x$3.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$4) {
                return x$4.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$5) {
                return x$5.messageOffset();
            }
        }));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$6) {
                return x$6.messageOffset();
            }
        }));
    }

    @Test
    public void testFirstUnstableOffsetAfterEviction() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$65 = this.stateManager();
        long x$66 = this.producerId();
        short x$67 = epoch;
        int x$68 = sequence;
        long x$69 = 99L;
        boolean x$70 = true;
        long x$71 = this.append$default$6();
        boolean x$72 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$65, x$66, x$67, x$68, x$69, x$71, x$70, x$72);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$7) {
                return x$7.messageOffset();
            }
        }));
        ProducerStateManager x$73 = this.stateManager();
        long x$74 = 2L;
        short x$75 = epoch;
        int x$76 = 0;
        long x$77 = 106L;
        boolean x$78 = true;
        long x$79 = this.append$default$6();
        boolean x$80 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$73, x$74, x$75, x$76, x$77, x$79, x$78, x$80);
        this.stateManager().truncateHead(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)106)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$8) {
                return x$8.messageOffset();
            }
        }));
    }

    @Test
    public void testTruncateHead() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        long anotherPid = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), anotherPid, epoch, 0, 2L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), anotherPid, epoch, 1, 3L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        this.stateManager().truncateHead(2L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        Option maybeEntry = this.stateManager().lastEntry(anotherPid);
        Assert.assertTrue((boolean)maybeEntry.isDefined());
        Assert.assertEquals((long)3L, (long)((ProducerIdEntry)maybeEntry.get()).lastOffset());
        this.stateManager().truncateHead(3L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.currentSnapshotOffsets());
        Assert.assertEquals((long)4L, (long)this.stateManager().mapEndOffset());
        this.stateManager().truncateHead(5L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        Assert.assertEquals((long)5L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testLoadFromSnapshotRemovesNonRetainedProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(pid1));
        Option entry = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerIdEntry)entry.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerIdEntry)entry.get()).lastOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.intercept((Function0)new Serializable(this, epoch, pid2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$2;
            private final long pid2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager recoveredMapping = new ProducerStateManager(this.$outer.partition(), this.$outer.logDir(), this.$outer.maxPidExpirationMs());
                recoveredMapping.truncateAndReload(0L, 1L, this.$outer.time().milliseconds());
                this.$outer.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.pid2$1, this.epoch$2, 1, 4L, 5L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$2 = epoch$2;
                this.pid2$1 = pid2$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$81 = this.stateManager();
        long x$82 = this.producerId();
        short x$83 = epoch;
        int x$84 = sequence;
        long x$85 = 99L;
        boolean x$86 = true;
        long x$87 = this.append$default$6();
        boolean x$88 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$81, x$82, x$83, x$84, x$85, x$87, x$86, x$88);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$9) {
                return x$9.messageOffset();
            }
        }));
        long anotherPid = 2L;
        ProducerStateManager x$89 = this.stateManager();
        long x$90 = anotherPid;
        short x$91 = epoch;
        int x$92 = sequence;
        long x$93 = 105L;
        boolean x$94 = true;
        long x$95 = this.append$default$6();
        boolean x$96 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$89, x$90, x$91, x$92, x$93, x$95, x$94, x$96);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$10) {
                return x$10.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$11) {
                return x$11.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$12) {
                return x$12.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$13) {
                return x$13.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$14) {
                return x$14.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$15) {
                return x$15.messageOffset();
            }
        }));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$97 = this.stateManager();
        long x$98 = this.producerId();
        short x$99 = epoch;
        int x$100 = sequence;
        long x$101 = 99L;
        boolean x$102 = true;
        long x$103 = this.append$default$6();
        boolean x$104 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$97, x$98, x$99, x$100, x$101, x$103, x$102, x$104);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$105 = stateManager;
        long x$106 = this.producerId();
        short x$107 = epoch;
        int x$108 = -1;
        long x$109 = 99L;
        boolean x$110 = true;
        long x$111 = this.append$default$6();
        boolean x$112 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$105, x$106, x$107, x$108, x$109, x$111, x$110, x$112);
        ProducerStateManager x$113 = stateManager;
        long x$114 = this.producerId();
        short x$115 = epoch;
        int x$116 = -1;
        long x$117 = 100L;
        boolean x$118 = true;
        long x$119 = this.append$default$6();
        boolean x$120 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$113, x$114, x$115, x$116, x$117, x$119, x$118, x$120);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$121 = this.stateManager();
        long x$122 = this.producerId();
        short x$123 = epoch;
        int x$124 = sequence;
        long x$125 = 99L;
        boolean x$126 = true;
        long x$127 = this.append$default$6();
        boolean x$128 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$121, x$122, x$123, x$124, x$125, x$127, x$126, x$128);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$129 = this.stateManager();
        long x$130 = this.producerId();
        short x$131 = epoch;
        int x$132 = sequence;
        long x$133 = 99L;
        boolean x$134 = true;
        long x$135 = this.append$default$6();
        boolean x$136 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$129, x$130, x$131, x$132, x$133, x$135, x$134, x$136);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ProducerIdEntry x$16) {
                return x$16.coordinatorEpoch();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw this.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$137 = this.stateManager();
        long x$138 = this.producerId();
        short x$139 = producerEpoch;
        int x$140 = 0;
        long x$141 = 99L;
        boolean x$142 = true;
        long x$143 = this.append$default$6();
        boolean x$144 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$137, x$138, x$139, x$140, x$141, x$143, x$142, x$144);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, false);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    public void kafka$log$ProducerStateManagerTest$$append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isLoadingFromLog) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isLoadingFromLog);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$7() {
        return false;
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$8() {
        return false;
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFilename(file.getName());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet();
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

