/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON$\u0012A\u0006\t\u0004/y\u0001S\"\u0001\r\u000b\u0005eQ\u0012!C5n[V$\u0018M\u00197f\u0015\tYB$\u0001\u0006d_2dWm\u0019;j_:T\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?a\u0011A\u0001T5tiB\u0011!#I\u0005\u0003E\t\u00111bS1gW\u0006\u001cuN\u001c4jO\")A\u0005\u0001C\u0001K\u0005\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0002MA\u0011q\u0005K\u0007\u00029%\u0011\u0011\u0006\b\u0002\u0005+:LG\u000f\u000b\u0002$WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002a\u0005\u0019qN]4\n\u0005Ij#\u0001\u0002+fgRDQ\u0001\u000e\u0001\u0005\nU\nQ\u0003^3tiF+x\u000e^1D_:4\u0017nZ\"iC:<W\rF\u0003'm}\n5\tC\u00038g\u0001\u0007\u0001(\u0001\u0003vg\u0016\u0014\bCA\u001d=\u001d\t9#(\u0003\u0002<9\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tYD\u0004C\u0003Ag\u0001\u0007\u0001(\u0001\u0005dY&,g\u000e^%e\u0011\u0015\u00115\u00071\u00019\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016DQ\u0001R\u001aA\u0002a\n\u0001cY8oM&<WI\u001c;jift\u0015-\\3\t\u000b\u0019\u0003A\u0011A\u0013\u0002;Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#!R\u0016\t\u000b%\u0003A\u0011A\u0013\u00023Q,7\u000f^+tKJ\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003\u0011.BQ\u0001\u0014\u0001\u0005\u0002\u0015\n1\u0004^3tiV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018m\u00115b]\u001e,\u0007FA&,\u0011\u0015y\u0005\u0001\"\u0001&\u0003\u0011\"Xm\u001d;EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001(,\u0011\u0015\u0011\u0006\u0001\"\u0001&\u0003\u0001\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u0014\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005E[\u0003\"B+\u0001\t\u0003)\u0013\u0001\u000b;fgR$UMZ1vYR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001+,\u0011\u0015A\u0006\u0001\"\u0001&\u0003]!Xm\u001d;Rk>$\u0018-\u00138ji&\fG.\u001b>bi&|g\u000e\u000b\u0002XW!)1\f\u0001C\u0001K\u0005\u0011C/Z:u\u0007>tg-[4DQ\u0006tw-Z(o\u001d>tW\t_5ti&tw\rV8qS\u000eD#AW\u0016\t\u000by\u0003A\u0011A0\u0002/Q,7\u000f\u001e)s_\u000e,7o\u001d(pi&4\u0017nY1uS>tW#\u0001\u0014)\u0005u[\u0003\"\u00022\u0001\t\u0003y\u0016!J:i_VdG\rU1sg\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018\r\u0015:pa\u0016\u0014H/[3tQ\t\t7\u0006C\u0003f\u0001\u0011\u0005q,A\u0017tQ>,H\u000e\u001a)beN,w+\u001b7eG\u0006\u0014HMU3qY&\u001c\u0017\r^5p]F+x\u000e^1Qe>\u0004XM\u001d;jKND#\u0001Z\u0016\t\u000b!\u0004A\u0011A0\u0002AMDw.\u001e7e!\u0006\u00148/\u001a*fa2L7-\u0019;j_:\fVo\u001c;b%\u0016\u001cX\r\u001e\u0015\u0003O.BQa\u001b\u0001\u0005\u0002\u0015\nQf\u001d5pk2$\u0007+\u0019:tKJ+w-\u0019:eY\u0016\u001c8o\u00144XQ&$Xm\u001d9bG\u0016\f%o\\;oIZ\u000bG.^3tQ\tQ7\u0006C\u0003o\u0001\u0011\u0005q.A\u0003qCJ\u001cX\r\u0006\u0003q\u007f\u0006%\u0001cA9zy:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0005ad\u0012a\u00029bG.\fw-Z\u0005\u0003un\u00141aU3r\u0015\tAH\u0004\u0005\u0002({&\u0011a\u0010\b\u0002\u0004\u0013:$\bbBA\u0001[\u0002\u0007\u00111A\u0001\u000eG>tg-[4IC:$G.\u001a:\u0011\u0007I\t)!C\u0002\u0002\b\t\u0011!\u0003V8qS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fe\"1\u00111B7A\u0002a\nQA^1mk\u0016\u0004")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()))}));
    }

    @Test
    public void testConfigChange() {
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), tp.topic(), 1, 1, logProps, AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, oldVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final Long oldVal$1;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option logOpt = ((KafkaServer)this.$outer.servers().head()).logManager().getLog(this.tp$1);
                Assert.assertTrue((boolean)logOpt.isDefined());
                Assert.assertEquals((Object)this.oldVal$1, (Object)((Log)logOpt.get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oldVal$1 = oldVal$1;
                this.tp$1 = tp$1;
            }
        });
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, newVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final Long newVal$1;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((Object)this.newVal$1, (Object)((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(this.tp$1).get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newVal$1 = newVal$1;
                this.tp$1 = tp$1;
            }
        });
    }

    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)new StringBuilder().append((Object)"Should contain a ConfigHandler for ").append((Object)rootEntityType).toString(), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).apis().quotas();
        String string = rootEntityType;
        String string2 = ConfigType$.MODULE$.Client();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, user, clientId, quotaManagers){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String clientId$1;
            private final QuotaFactory.QuotaManagers quotaManagers$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Quota overrideProducerQuota = this.quotaManagers$1.produce().quota(this.user$1, this.clientId$1);
                Quota overrideConsumerQuota = this.quotaManagers$1.fetch().quota(this.user$1, this.clientId$1);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden producer quota of 1000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1})), (Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden consumer quota of 2000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1})), (Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota);
            }
            {
                this.user$1 = user$1;
                this.clientId$1 = clientId$1;
                this.quotaManagers$1 = quotaManagers$1;
            }
        });
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = rootEntityType;
        String string5 = ConfigType$.MODULE$.Client();
        String string6 = string4;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, user, clientId, quotaManagers, defaultProducerQuota, defaultConsumerQuota){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String clientId$1;
            private final QuotaFactory.QuotaManagers quotaManagers$1;
            private final double defaultProducerQuota$1;
            private final double defaultConsumerQuota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Quota producerQuota = this.quotaManagers$1.produce().quota(this.user$1, this.clientId$1);
                Quota consumerQuota = this.quotaManagers$1.fetch().quota(this.user$1, this.clientId$1);
                Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset producer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1}))).append((Object)BoxesRunTime.boxToDouble((double)this.defaultProducerQuota$1)).toString(), (Object)Quota.upperBound((double)this.defaultProducerQuota$1), (Object)producerQuota);
                Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset consumer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1}))).append((Object)BoxesRunTime.boxToDouble((double)this.defaultConsumerQuota$1)).toString(), (Object)Quota.upperBound((double)this.defaultConsumerQuota$1), (Object)consumerQuota);
            }
            {
                this.user$1 = user$1;
                this.clientId$1 = clientId$1;
                this.quotaManagers$1 = quotaManagers$1;
                this.defaultProducerQuota$1 = defaultProducerQuota$1;
                this.defaultConsumerQuota$1 = defaultConsumerQuota$1;
            }
        });
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "overriddenClientId", clientIdProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "overriddenUser", userProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkUtils().getChildren(ZkUtils$.MODULE$.ConfigChangesPath()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;

            public final boolean apply(String p) {
                return this.$outer.zkUtils().deletePath(new StringBuilder().append((Object)ZkUtils$.MODULE$.ConfigChangesPath()).append((Object)"/").append((Object)p).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.apis().quotas();
        Assert.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
            AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), topic, logProps);
            throw this.fail("Should fail with AdminOperationException for topic doesn't exist", new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testProcessNotification() {
        Properties props = new Properties();
        props.put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json");
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
            throw this.fail(new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString(), new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }
        catch (Throwable throwable) {
            try {
                Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                throw this.fail(new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString(), new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            }
            catch (Throwable throwable2) {
                try {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                    throw this.fail(new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString(), new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
                }
                catch (Throwable throwable3) {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                    EasyMock.verify((Object[])new Object[]{handler});
                    return;
                }
            }
        }
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }
}

