/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=h!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\nW\u0001\u0001\r\u00111A\u0005\n1\n\u0001bY8ogVlWM]\u000b\u0002[A!afN\u001d:\u001b\u0005y#BA\u00161\u0015\t\t$'A\u0004dY&,g\u000e^:\u000b\u0005\u0015\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\rQ4(P\u0007\u0002A%\u0011A\b\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003uyJ!a\u0010\u0011\u0003\t\tKH/\u001a\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\t\u000bAbY8ogVlWM]0%KF$\"a\u0011$\u0011\u0005i\"\u0015BA#!\u0005\u0011)f.\u001b;\t\u000f\u001d\u0003\u0015\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\r%\u0003\u0001\u0015)\u0003.\u0003%\u0019wN\\:v[\u0016\u0014\b\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A'\u0011\u00079\u001bV+D\u0001P\u0015\t\u0001\u0016+A\u0004nkR\f'\r\\3\u000b\u0005I\u0003\u0013AC2pY2,7\r^5p]&\u0011Ak\u0014\u0002\u0007\u0005V4g-\u001a:\u0011\tYK\u0016(O\u0007\u0002/*\u0011\u0001\fM\u0001\taJ|G-^2fe&\u0011!l\u0016\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\rq\u0003\u0001\u0015!\u0003N\u0003)\u0001(o\u001c3vG\u0016\u00148\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0005`\u0003\u0015!x\u000e]5d+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u0007'R\u0014\u0018N\\4\t\r%\u0004\u0001\u0015!\u0003a\u0003\u0019!x\u000e]5dA!91\u000e\u0001b\u0001\n\u0013a\u0017A\u00038v[J+7m\u001c:egV\tQ\u000e\u0005\u0002;]&\u0011q\u000e\t\u0002\u0004\u0013:$\bBB9\u0001A\u0003%Q.A\u0006ok6\u0014VmY8sIN\u0004\u0003\"B:\u0001\t\u0003\"\u0018!B:fiV\u0003H#A\")\u0005I4\bCA<{\u001b\u0005A(BA=6\u0003\u0015QWO\\5u\u0013\tY\bP\u0001\u0004CK\u001a|'/\u001a\u0005\u0006{\u0002!\t\u0005^\u0001\ti\u0016\f'\u000fR8x]\"\u0012Ap \t\u0004o\u0006\u0005\u0011bAA\u0002q\n)\u0011I\u001a;fe\"9\u0011q\u0001\u0001\u0005\u0012\u0005%\u0011AD2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u000b\n+\u0006-\u00111DA\u0010\u0003SA\u0001\"!\u0004\u0002\u0006\u0001\u0007\u0011qB\u0001\u000bEJ|7.\u001a:MSN$\b\u0003BA\t\u0003/q1AOA\n\u0013\r\t)\u0002I\u0001\u0007!J,G-\u001a4\n\u0007\u001d\fIBC\u0002\u0002\u0016\u0001B\u0011\"!\b\u0002\u0006A\u0005\t\u0019A7\u0002\u000fI,GO]5fg\"Q\u0011\u0011EA\u0003!\u0003\u0005\r!a\t\u0002\u00111LgnZ3s\u001bN\u00042AOA\u0013\u0013\r\t9\u0003\t\u0002\u0005\u0019>tw\r\u0003\u0006\u0002,\u0005\u0015\u0001\u0013!a\u0001\u0003[\tQ\u0001\u001d:paN\u0004RAOA\u0018\u0003gI1!!\r!\u0005\u0019y\u0005\u000f^5p]B!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u0011\fA!\u001e;jY&!\u0011QHA\u001c\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003\u0003\u0002A\u0011CA\"\u0003A\u0011XmZ5ti\u0016\u0014\bK]8ek\u000e,'\u000fF\u0002V\u0003\u000bBa\u0001WA \u0001\u0004)\u0006bBA%\u0001\u0011%\u00111J\u0001\u0014a>dG.\u00168uS2tU/\u001c*fG>\u0014Hm\u001d\u000b\u0005\u0003\u001b\n)\u0006\u0005\u0003\u0018C\u0005=\u0003#\u0002\u0018\u0002ReJ\u0014bAA*_\tq1i\u001c8tk6,'OU3d_J$\u0007BB6\u0002H\u0001\u0007Q\u000e\u0003\u0004\u0002Z\u0001!\t\u0001^\u0001\u000fi\u0016\u001cHoU3oI>3gm]3uQ\u0011\t9&!\u0018\u0011\u0007]\fy&C\u0002\u0002ba\u0014A\u0001V3ti\"1\u0011Q\r\u0001\u0005\u0002Q\fq\u0005^3tiN+g\u000eZ\"p[B\u0014Xm]:fI6+7o]1hK^KG\u000f[\"sK\u0006$X\rV5nK\"\"\u00111MA/\u0011\u0019\tY\u0007\u0001C\u0001i\u0006QC/Z:u'\u0016tGMT8o\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0007J,\u0017\r^3US6,\u0007\u0006BA5\u0003;Bq!!\u001d\u0001\t#\t\u0019(A\u0007tK:$\u0017I\u001c3WKJLg-\u001f\u000b\b\u0007\u0006U\u0014qOA=\u0011\u0019A\u0016q\u000ea\u0001+\"A1.a\u001c\u0011\u0002\u0003\u0007Q\u000e\u0003\u0006\u0002|\u0005=\u0004\u0013!a\u0001\u0003G\t\u0011\u0002^5nK>,H/T:\t\u000f\u0005}\u0004\u0001\"\u0005\u0002\u0002\u000612/\u001a8e\u0003:$g+\u001a:jMf$\u0016.\\3ti\u0006l\u0007\u000fF\u0003D\u0003\u0007\u000b)\t\u0003\u0004Y\u0003{\u0002\r!\u0016\u0005\t\u0003\u000f\u000bi\b1\u0001\u0002\n\u0006iA/[7fgR\fW\u000e\u001d+za\u0016\u0004B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0004\u0003'\u0013\u0014AB2p[6|g.\u0003\u0003\u0002\u0018\u00065%!\u0004+j[\u0016\u001cH/Y7q)f\u0004X\r\u0003\u0004\u0002\u001c\u0002!\t\u0001^\u0001\ni\u0016\u001cHo\u00117pg\u0016DC!!'\u0002^!1\u0011\u0011\u0015\u0001\u0005\u0002Q\f1\u0003^3tiN+g\u000e\u001a+p!\u0006\u0014H/\u001b;j_:DC!a(\u0002^!1\u0011q\u0015\u0001\u0005\u0002Q\f\u0001\u0006^3tiN+g\u000e\u001a\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d)beRLG/[8o\u000bb\u0004\u0018M\\:j_:DC!!*\u0002^!1\u0011Q\u0016\u0001\u0005\u0002Q\f\u0011\u0002^3ti\u001acWo\u001d5)\t\u0005-\u0016Q\f\u0005\u0007\u0003g\u0003A\u0011\u0001;\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[\u000e\u000bG\u000e\\3s)\"\u0014X-\u00193)\t\u0005E\u0016Q\f\u0005\u0007\u0003s\u0003A\u0011\u0001;\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[N+g\u000eZ3s)\"\u0014X-\u00193)\t\u0005]\u0016Q\f\u0005\n\u0003\u007f\u0003\u0011\u0013!C\t\u0003\u0003\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019MK\u0002n\u0003\u000b\\#!a2\u0011\t\u0005%\u00171[\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#\u0004\u0013AC1o]>$\u0018\r^5p]&!\u0011Q[Af\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u00033\u0004\u0011\u0013!C\t\u00037\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiN\u000b\u0003\u0002$\u0005\u0015\u0007\"CAq\u0001E\u0005I\u0011CAr\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003KTC!!\f\u0002F\"I\u0011\u0011\u001e\u0001\u0012\u0002\u0013E\u0011\u0011Y\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIIB\u0011\"!<\u0001#\u0003%\t\"a7\u0002/M,g\u000eZ!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\u001a\u0004")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1$lzycompute(int x$1, VolatileObjectRef x$2) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$2.elem != null) return (BaseProducerSendTest$callback$3$)x$2.elem;
            x$2.elem = new BaseProducerSendTest$callback$3$(this, x$1);
            return (BaseProducerSendTest$callback$3$)x$2.elem;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2$lzycompute(TimestampType x$1, int x$2, long x$3, long x$4, VolatileObjectRef x$5) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$5.elem != null) return (BaseProducerSendTest$callback$4$)x$5.elem;
            x$5.elem = new BaseProducerSendTest$callback$4$(this, x$1, x$2, x$3, x$4);
            return (BaseProducerSendTest$callback$4$)x$5.elem;
        }
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$19 = numServers;
        String x$20 = this.zkConnect();
        boolean x$21 = false;
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$19, x$20, x$21, x$25, (Option<SecurityProtocol>)x$22, x$23, x$24, x$26, x$27, x$28, x$29, x$30).map((Function1)new Serializable(this, overridingProps){
            public static final long serialVersionUID = 0L;
            private final Properties overridingProps$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps$1);
            }
            {
                this.overridingProps$1 = overridingProps$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer() {
        return this.kafka$api$BaseProducerSendTest$$consumer;
    }

    private void kafka$api$BaseProducerSendTest$$consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$31 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$32 = SecurityProtocol.PLAINTEXT;
        String x$33 = TestUtils$.MODULE$.createNewConsumer$default$2();
        String x$34 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$35 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$36 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$37 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$38 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$39 = TestUtils$.MODULE$.createNewConsumer$default$9();
        Option<Properties> x$40 = TestUtils$.MODULE$.createNewConsumer$default$10();
        this.kafka$api$BaseProducerSendTest$$consumer_$eq(TestUtils$.MODULE$.createNewConsumer(x$31, x$33, x$34, x$35, x$36, x$37, x$32, x$38, x$39, x$40));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$api$BaseProducerSendTest$$consumer().close();
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int retries, long lingerMs, Option<Properties> props) {
        String x$41 = brokerList;
        SecurityProtocol x$42 = this.securityProtocol();
        Option<File> x$43 = this.trustStoreFile();
        Option<Properties> x$44 = this.clientSaslProperties();
        int x$45 = retries;
        long x$46 = lingerMs;
        Option<Properties> x$47 = props;
        int x$48 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$49 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$50 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$51 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$52 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$53 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$41, x$48, x$49, x$50, x$45, x$46, x$51, x$42, x$43, x$44, x$52, x$53, x$47);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public long createProducer$default$3() {
        return 0L;
    }

    public Option<Properties> createProducer$default$4() {
        return None$.MODULE$;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<ConsumerRecord<byte[], byte[]>> kafka$api$BaseProducerSendTest$$pollUntilNumRecords(int numRecords) {
        void var2_2;
        ArrayBuffer records2 = new ArrayBuffer();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final int numRecords$1;
            private final ArrayBuffer records$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.$outer.kafka$api$BaseProducerSendTest$$consumer().poll(50L)).asScala());
                return this.records$1.size() == this.numRecords$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
                this.records$1 = records$1;
            }
        }, (Function0<String>)new Serializable(this, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final int numRecords$1;
            private final ArrayBuffer records$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout, but expected ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size()), BoxesRunTime.boxToInteger((int)this.numRecords$1)}));
            }
            {
                this.numRecords$1 = numRecords$1;
                this.records$1 = records$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return var2_2;
    }

    @Test
    public void testSendOffset() {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, partition, record0, callback$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$1;
                    private final int partition$1;
                    private final ProducerRecord record0$1;
                    private final VolatileObjectRef callback$module$1;

                    public final Future<RecordMetadata> apply(int _) {
                        return this.producer$1.send(this.record0$1, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$1(this.partition$1, this.callback$module$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.partition$1 = partition$1;
                        this.record0$1 = record0$1;
                        this.callback$module$1 = callback$module$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.kafka$api$BaseProducerSendTest$$numRecords() + 4))).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$54 = this.brokerList();
        long x$55 = Long.MAX_VALUE;
        Some x$56 = new Some((Object)producerProps);
        int x$57 = this.createProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$54, x$57, x$55, (Option<Properties>)x$56);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        String x$58 = this.brokerList();
        long x$59 = Long.MAX_VALUE;
        int x$60 = this.createProducer$default$2();
        Option<Properties> x$61 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$58, x$60, x$59, x$61);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1)new Serializable(this, producer, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$3;
                private final int partition$2;

                public final Future<RecordMetadata> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$2), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
                    return this.producer$3.send(record);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$3 = producer$3;
                    this.partition$2 = partition$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(timeoutMs, TimeUnit.MILLISECONDS);
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$2;

                public final int apply(int offset, Future<RecordMetadata> future) {
                    RecordMetadata recordMetadata = future.get();
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition$2, (long)recordMetadata.partition());
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    return offset + 1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$2 = partition$2;
                }
            }));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
            return;
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$2;
                private final TimestampType timestampType$1;
                private final int partition$3;
                private final long baseTimestamp$1;
                private final long startTime$1;
                private final VolatileObjectRef callback$module$2;

                public final Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$3), Predef$.MODULE$.long2Long(this.baseTimestamp$1 + (long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
                    return new Tuple2((Object)record, (Object)this.producer$2.send(record, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$2(this.timestampType$1, this.partition$3, this.baseTimestamp$1, this.startTime$1, this.callback$module$2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.timestampType$1 = timestampType$1;
                    this.partition$3 = partition$3;
                    this.baseTimestamp$1 = baseTimestamp$1;
                    this.startTime$1 = startTime$1;
                    this.callback$module$2 = callback$module$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(20000L, TimeUnit.MILLISECONDS);
            recordAndFutures.foreach((Function1)new Serializable(this, timestampType, startTime){
                public static final long serialVersionUID = 0L;
                private final TimestampType timestampType$1;
                private final long startTime$1;

                public final void apply(Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> x0$1) {
                    Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        ProducerRecord record = (ProducerRecord)tuple2._1();
                        Future future = (Future)tuple2._2();
                        RecordMetadata recordMetadata = (RecordMetadata)future.get();
                        TimestampType timestampType = this.timestampType$1;
                        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                        if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                            Assert.assertTrue((recordMetadata.timestamp() >= this.startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.timestampType$1 = timestampType$1;
                    this.startTime$1 = startTime$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have offset ", " but only successfully sent ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords()), BoxesRunTime.boxToLong((long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset())})), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$4;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int _) {
                    return this.producer$4.send(this.record0$2);
                }
                {
                    this.producer$4 = producer$4;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendToPartition() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$5;
                private final int partition$4;
                private final long now$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$5.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$4), Predef$.MODULE$.long2Long(this.now$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$5 = producer$5;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                    return x$3.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$1) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;

                public final void apply(Tuple2<RecordMetadata, Object> x$4) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition$4, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                }
            });
            this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records2 = this.kafka$api$BaseProducerSendTest$$pollUntilNumRecords(this.kafka$api$BaseProducerSendTest$$numRecords());
            ((IterableLike)records2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;
                private final long now$1;

                public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$2) {
                    Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        ConsumerRecord record = (ConsumerRecord)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)record.topic());
                        Assert.assertEquals((long)this.partition$4, (long)record.partition());
                        Assert.assertEquals((long)i, (long)record.offset());
                        Assert.assertNull((Object)record.key());
                        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), (Object)new String((byte[])record.value()));
                        Assert.assertEquals((long)this.now$1, (long)record.timestamp());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final KafkaProducer producer$6;
            private final int partition0$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$6 = producer$6;
                this.partition0$1 = partition0$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$5) {
                return x$5.get(30L, TimeUnit.SECONDS);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$2) {
                Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final int partition0$1;

            public final void apply(Tuple2<RecordMetadata, Object> x$6) {
                Tuple2<RecordMetadata, Object> tuple2 = x$6;
                if (tuple2 != null) {
                    RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$1 = partition0$1;
            }
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8)));
            throw this.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        }
        catch (KafkaException kafkaException) {
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic(), 2, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$6;
                private final int partition1$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition1$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$6 = producer$6;
                    this.partition1$1 = partition1$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                    return x$7.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$3) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition1$1;

                public final void apply(Tuple2<RecordMetadata, Object> x$8) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$8;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition1$1, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition1$1 = partition1$1;
                }
            });
            futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$6;
                private final int partition0$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$6 = producer$6;
                    this.partition0$1 = partition0$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                    return x$9.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$4) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition0$1;

                public final void apply(Tuple2<RecordMetadata, Object> x$10) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$10;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition0$1 = partition0$1;
                }
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlush() {
        String x$62 = this.brokerList();
        long x$63 = Long.MAX_VALUE;
        int x$64 = this.createProducer$default$2();
        Option<Properties> x$65 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$62, x$64, x$63, x$65);
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, producer, record){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                public final KafkaProducer producer$7;
                public final ProducerRecord record$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFlush$1 $outer;

                        public final Future<RecordMetadata> apply(int x$11) {
                            return this.$outer.producer$7.send(this.$outer.record$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$12) {
                            return !x$12.isDone();
                        }
                    }));
                    this.producer$7.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$13) {
                            return x$13.isDone();
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$7 = producer$7;
                    this.record$1 = record$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_5;
            var1_5.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, record0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record0$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                String x$66 = this.$outer.brokerList();
                long x$67 = Long.MAX_VALUE;
                int x$68 = this.$outer.createProducer$default$2();
                Option<Properties> x$69 = this.$outer.createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(x$66, x$68, x$67, x$69);
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;
                    private final KafkaProducer producer$8;

                    public final Future<RecordMetadata> apply(int x$14) {
                        return this.producer$8.send(this.$outer.record0$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$8 = producer$8;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$15) {
                        return !x$15.isDone();
                    }
                }));
                producer.close(0L, TimeUnit.MILLISECONDS);
                responses.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;

                    public final void apply(Future<RecordMetadata> future) {
                        try {
                            future.get();
                            throw this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer().fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
                        }
                        catch (Exception exception) {
                            Assert.assertEquals((Object)"java.lang.IllegalStateException: Producer is closed forcefully.", (Object)exception.getMessage());
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.$outer.kafka$api$BaseProducerSendTest$$consumer().poll(50L).count());
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record0$3 = record0$3;
            }
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record$2;

            /*
             * WARNING - void declaration
             */
            public final Seq<ConsumerRecord<byte[], byte[]>> apply(int i) {
                Seq<ConsumerRecord<byte[], byte[]>> seq;
                String x$70 = this.$outer.brokerList();
                long x$71 = Long.MAX_VALUE;
                int x$72 = this.$outer.createProducer$default$2();
                Option<Properties> x$73 = this.$outer.createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(x$70, x$72, x$71, x$73);
                try {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromSenderThread$1 $outer;
                        private final KafkaProducer producer$9;

                        public final Future<RecordMetadata> apply(int i) {
                            public class Kafka_api_BaseProducerSendTest$CloseCallback$1
                            implements Callback {
                                public final KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$CloseCallback$$producer;
                                private final boolean sendRecords;
                                public final /* synthetic */ BaseProducerSendTest $outer;
                                public final ProducerRecord record$2;

                                public void onCompletion(RecordMetadata metadata, Exception exception) {
                                    if (this.sendRecords) {
                                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$CloseCallback$$$outer().kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Kafka_api_BaseProducerSendTest$CloseCallback$1 $outer;

                                            public final Future<RecordMetadata> apply(int x$16) {
                                                return this.$outer.kafka$api$BaseProducerSendTest$CloseCallback$$producer.send(this.$outer.record$2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(0L, TimeUnit.MILLISECONDS);
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
                                }

                                public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$CloseCallback$$$outer() {
                                    return this.$outer;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest $outer, KafkaProducer<byte[], byte[]> producer, boolean sendRecords2) {
                                    void var4_4;
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer = producer;
                                    this.sendRecords = sendRecords2;
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.record$2 = var4_4;
                                }
                            }
                            return this.producer$9.send(this.$outer.record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1(this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer(), this.producer$9, i == 0, this.$outer.record$2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.producer$9 = producer$9;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$17) {
                            return !x$17.isDone();
                        }
                    }));
                    producer.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$18) {
                            return x$18.isDone();
                        }
                    }));
                    seq = this.$outer.kafka$api$BaseProducerSendTest$$pollUntilNumRecords(this.$outer.kafka$api$BaseProducerSendTest$$numRecords());
                }
                catch (Throwable throwable) {
                    void var2_6;
                    var2_6.close();
                    throw throwable;
                }
                producer.close();
                return seq;
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        });
    }

    public final BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1(int partition$1, VolatileObjectRef callback$module$1) {
        return callback$module$1.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$1$lzycompute(partition$1, callback$module$1) : (BaseProducerSendTest$callback$3$)callback$module$1.elem;
    }

    public final BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, VolatileObjectRef callback$module$2) {
        return callback$module$2.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$2$lzycompute(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2) : (BaseProducerSendTest$callback$4$)callback$module$2.elem;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

