/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.junit.Assert;
import org.junit.Test;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001\u001d\u00111#\u00123hK\u000e\u000b7/\u001a*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u001b)\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAQ\u0001\u0006\u0001\u0005\u0002U\tqbZ3oKJ\fG/Z\"p]\u001aLwm\u001d\u000b\u0002-A\u0019qC\b\u0011\u000e\u0003aQ!!\u0007\u000e\u0002\u0013%lW.\u001e;bE2,'BA\u000e\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\u0007\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002\u0013C%\u0011!E\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003%\u0001\u0011%Q%\u0001\u0007t_\u000e\\W\r^*feZ,'/F\u0001'!\t9#&D\u0001)\u0015\tIC!A\u0004oKR<xN]6\n\u0005-B#\u0001D*pG.,GoU3sm\u0016\u0014\b\"B\u0017\u0001\t\u0013q\u0013aB2p]:,7\r\u001e\u000b\u0004_]J\u0004C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\rqW\r\u001e\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014G\u0001\u0004T_\u000e\\W\r\u001e\u0005\bq1\u0002\n\u00111\u0001'\u0003\u0005\u0019\bb\u0002\u001e-!\u0003\u0005\raO\u0001\taJ|Go\\2pYB\u0011A(R\u0007\u0002{)\u0011!H\u0010\u0006\u0003\u007f\u0001\u000baaY8n[>t'BA\u0003B\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019k$\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0011\u0015A\u0005\u0001\"\u0003J\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t)s\u0005\u000b\u0017\t\u0003\u00172k\u0011\u0001H\u0005\u0003\u001br\u0011A!\u00168ji\")qj\u0012a\u0001_\u000511o\\2lKRDQ!U$A\u0002I\u000bqA]3rk\u0016\u001cH\u000fE\u0002L'VK!\u0001\u0016\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-3\u0016BA,\u001d\u0005\u0011\u0011\u0015\u0010^3\t\u000fe;\u0005\u0013!a\u00015\u0006\u0011\u0011\u000e\u001a\t\u0004\u0017nk\u0016B\u0001/\u001d\u0005\u0019y\u0005\u000f^5p]B\u00111JX\u0005\u0003?r\u0011Qa\u00155peRDQ!\u0019\u0001\u0005\n\t\fqB]3dK&4XMU3ta>t7/\u001a\u000b\u0003%\u000eDQa\u00141A\u0002=BQ!\u001a\u0001\u0005\n\u0019\f\u0011C]3rk\u0016\u001cH/\u00118e%\u0016\u001cW-\u001b<f)\r\u0011v\r\u001b\u0005\u0006#\u0012\u0004\rA\u0015\u0005\b3\u0012\u0004\n\u00111\u0001[\u0011\u0015Q\u0007\u0001\"\u0003l\u0003I\u0011X-];fgRDU-\u00193fe\nKH/Z:\u0015\u000bIcg\u000e]=\t\u000b5L\u0007\u0019A/\u0002\r\u0005\u0004\u0018nS3z\u0011\u0015y\u0017\u000e1\u0001^\u0003)\t\u0007/\u001b,feNLwN\u001c\u0005\bc&\u0004\n\u00111\u0001s\u0003!\u0019G.[3oi&#\u0007CA:w\u001d\tYE/\u0003\u0002v9\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)H\u0004C\u0004{SB\u0005\t\u0019A>\u0002\u001b\r|'O]3mCRLwN\\%e!\tYE0\u0003\u0002~9\t\u0019\u0011J\u001c;\t\r}\u0004A\u0011BA\u0001\u0003A1XM]5gs\u0012K7oY8o]\u0016\u001cG\u000fF\u0002K\u0003\u0007AQ!\u0015@A\u0002ICq!a\u0002\u0001\t\u0003\tI!\u0001\u0012uKN$\bK]8ek\u000e,'+Z9vKN$x+\u001b;i\u001dVdGn\u00117jK:$\u0018\n\u001a\u000b\u0002\u0015\"\"\u0011QAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\u0007\u0006)!.\u001e8ji&!\u0011qCA\t\u0005\u0011!Vm\u001d;\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\n\u0005)B/Z:u\u0011\u0016\fG-\u001a:P]2L(+Z9vKN$\b\u0006BA\r\u0003\u001bAq!!\t\u0001\t\u0003\tI!\u0001\ruKN$\u0018J\u001c<bY&$\u0017\t]5LKf\u0014V-];fgRDC!a\b\u0002\u000e!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0011\u0001\b;fgRLeN^1mS\u0012\f\u0005/\u001b,feNLwN\u001c*fcV,7\u000f\u001e\u0015\u0005\u0003K\ti\u0001C\u0004\u0002.\u0001!\t!!\u0003\u00025Q,7\u000f^'bY\u001a|'/\\3e\u0011\u0016\fG-\u001a:SKF,Xm\u001d;)\t\u0005-\u0012Q\u0002\u0005\n\u0003g\u0001\u0011\u0013!C\u0005\u0003k\t\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9DK\u0002'\u0003sY#!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000bb\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011JA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0005\u0003\u001f\n\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tFK\u0002<\u0003sA\u0011\"!\u0016\u0001#\u0003%I!a\u0016\u0002+M,g\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\f\u0016\u00045\u0006e\u0002\"CA/\u0001E\u0005I\u0011BA,\u0003m\u0011X-];fgR\fe\u000e\u001a*fG\u0016Lg/\u001a\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011\r\u0001\u0012\u0002\u0013%\u00111M\u0001\u001de\u0016\fX/Z:u\u0011\u0016\fG-\u001a:CsR,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)GK\u0002s\u0003sA\u0011\"!\u001b\u0001#\u0003%I!a\u001b\u00029I,\u0017/^3ti\"+\u0017\rZ3s\u0005f$Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u000e\u0016\u0004w\u0006e\u0002")
public class EdgeCaseRequestTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(props)}));
    }

    private SocketServer socketServer() {
        return ((KafkaServer)this.servers().head()).socketServer();
    }

    private Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
    }

    private SocketServer connect$default$1() {
        return this.socketServer();
    }

    private SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request, Option<Object> id) {
        Option<Object> option;
        block4: {
            DataOutputStream outgoing;
            block3: {
                block2: {
                    outgoing = new DataOutputStream(socket.getOutputStream());
                    option = id;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    short id2 = BoxesRunTime.unboxToShort((Object)some.x());
                    outgoing.writeInt(request.length + 2);
                    outgoing.writeShort(id2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                outgoing.writeInt(request.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            outgoing.write(request);
            outgoing.flush();
            return;
        }
        throw new MatchError(option);
    }

    private Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] requestAndReceive(byte[] request, Option<Object> id) {
        byte[] byArray;
        Socket plainSocket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendRequest(plainSocket, request, id);
            byArray = this.receiveResponse(plainSocket);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        plainSocket.close();
        return byArray;
    }

    private Option<Object> requestAndReceive$default$2() {
        return None$.MODULE$;
    }

    private byte[] requestHeaderBytes(short apiKey, short apiVersion, String clientId, int correlationId) {
        int size2 = 8 + Type.NULLABLE_STRING.sizeOf((Object)clientId);
        ByteBuffer buffer = ByteBuffer.allocate(size2);
        buffer.putShort(apiKey);
        buffer.putShort(apiVersion);
        buffer.putInt(correlationId);
        Type.NULLABLE_STRING.write(buffer, (Object)clientId);
        return buffer.array();
    }

    private String requestHeaderBytes$default$3() {
        return "";
    }

    private int requestHeaderBytes$default$4() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDisconnect(byte[] request) {
        Socket plainSocket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendRequest(plainSocket, this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()), this.sendRequest$default$3());
            Assert.assertEquals((String)"The server should disconnect", (long)-1L, (long)plainSocket.getInputStream().read());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        plainSocket.close();
    }

    @Test
    public void testProduceRequestWithNullClientId() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int correlationId = -1;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        short version = 2;
        byte[] headerBytes = this.requestHeaderBytes(ApiKeys.PRODUCE.id, ApiKeys.PRODUCE.latestVersion(), null, correlationId);
        MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("message".getBytes())});
        ProduceRequest request = (ProduceRequest)new ProduceRequest.Builder(2, 1, 10000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records2)}))).asJava()).build();
        ByteBuffer byteBuffer = ByteBuffer.allocate(headerBytes.length + request.toStruct().sizeOf());
        byteBuffer.put(headerBytes);
        request.toStruct().writeTo(byteBuffer);
        byte[] serializedBytes = byteBuffer.array();
        byte[] response = this.requestAndReceive(serializedBytes, this.requestAndReceive$default$2());
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer);
        ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)responseBuffer, (short)version);
        Assert.assertEquals((String)"The response should parse completely", (long)0L, (long)responseBuffer.remaining());
        Assert.assertEquals((String)"The correlationId should match request", (long)correlationId, (long)responseHeader.correlationId());
        Assert.assertEquals((String)"One partition response should be returned", (long)1L, (long)produceResponse.responses().size());
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)produceResponse.responses().get(topicPartition);
        Assert.assertNotNull((Object)partitionResponse);
        Assert.assertEquals((String)"There should be no error", (Object)Errors.NONE, (Object)partitionResponse.error);
    }

    @Test
    public void testHeaderOnlyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiKeyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiVersionRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)-1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testMalformedHeaderRequest() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putShort(ApiKeys.PRODUCE.id);
        buffer.putShort((short)1);
        byte[] serializedBytes = buffer.array();
        this.verifyDisconnect(serializedBytes);
    }
}

