/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u000f\t\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\bCCN,'+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005AB/Z:u'&l\u0007\u000f\\3Qe>$WoY3SKF,Xm\u001d;\u0015\u0003M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011A!\u00168ji\"\u0012\u0001C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011\u0002\u0013\u0002K\r\u0014X-\u0019;f)>\u0004\u0018nY!oI\u001aKg\u000e\u001a)beRLG/[8o/&$\b\u000eT3bI\u0016\u0014HCA\u0013,!\u0011!b\u0005\u000b\u0015\n\u0005\u001d*\"A\u0002+va2,'\u0007\u0005\u0002\u0015S%\u0011!&\u0006\u0002\u0004\u0013:$\b\"\u0002\u0017#\u0001\u0004i\u0013!\u0002;pa&\u001c\u0007C\u0001\u00182\u001d\t!r&\u0003\u00021+\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001T\u0003C\u00036\u0001\u0011\u0005!#\u0001\u000fuKN$8i\u001c:skB$HJ\u001f\u001bQe>$WoY3SKF,Xm\u001d;)\u0005QR\u0002\"\u0002\u001d\u0001\t\u0013I\u0014AE:f]\u0012\u0004&o\u001c3vG\u0016\u0014V-];fgR$2AO#H!\tY4)D\u0001=\u0015\tid(\u0001\u0005sKF,Xm\u001d;t\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0005S!A\u0011\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!EHA\bQe>$WoY3SKN\u0004xN\\:f\u0011\u00151u\u00071\u0001)\u0003!aW-\u00193fe&#\u0007\"\u0002%8\u0001\u0004I\u0015a\u0002:fcV,7\u000f\u001e\t\u0003w)K!a\u0013\u001f\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0002")
public class ProduceRequestTest
extends BaseRequestTest {
    @Test
    public void testSimpleProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader2);
            int partition2 = sp3._1$mcI$sp();
            int leader3 = sp3._2$mcI$sp();
            this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, partition2, leader3);
            this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, partition2, leader3);
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        return (Tuple2)partitionToLeader.collectFirst((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    int leader2 = A1._2$mcI$sp();
                    if (leader2 != -1) {
                        object = new Tuple2.mcII.sp(partition, leader2);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int leader2;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (leader2 = tuple2._2$mcI$sp()) != -1;
                return bl;
            }
        }).getOrElse((Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProduceRequestTest $outer;
            private final String topic$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No leader elected for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1})), new Position("ProduceRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    @Test
    public void testCorruptLz4ProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader2);
            int partition2 = sp3._1$mcI$sp();
            int leader3 = sp3._2$mcI$sp();
            int timestamp = 1000000;
            MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
            int lz4ChecksumOffset = 6;
            memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
            TopicPartition topicPartition = new TopicPartition("topic", partition2);
            scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
            ProduceResponse produceResponse = this.sendProduceRequest(leader3, (ProduceRequest)new ProduceRequest.Builder(2, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava()).build());
            Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
            Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
            if (tuple22 != null) {
                Tuple2 tuple23;
                TopicPartition tp = (TopicPartition)tuple22._1();
                ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
                TopicPartition tp2 = (TopicPartition)tuple24._1();
                ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
                Assert.assertEquals((Object)topicPartition, (Object)tp2);
                Assert.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)partitionResponse2.error);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)new ProduceRequest.Builder(2, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava()).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition tp = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
            TopicPartition tp2 = (TopicPartition)tuple23._1();
            ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
            Assert.assertEquals((Object)topicPartition, (Object)tp2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
            Assert.assertEquals((long)expectedOffset, (long)partitionResponse2.baseOffset);
            Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
            return partitionResponse2;
        }
        throw new MatchError((Object)tuple2);
    }
}

