/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerIdEntry;
import kafka.log.ProducerIdEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r-t!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003\u001fA\u0013x\u000eZ;dKJLE-\u00128uefDq!a\u0007{\u0001\u0004\ti\"\u0001\u0003gS2,\u0007\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB%\u0001\u0002j_&!\u0011qEA\u0011\u0005\u00111\u0015\u000e\\3\t\u000f\u0005-\u0012\u0002\"\u0003\u0002.\u0005iqO]5uKNs\u0017\r]:i_R$b!a\f\u00026\u0005]\u0002cA\u0007\u00022%\u0019\u00111\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\tI\u00031\u0001\u0002\u001e!A\u0011\u0011HA\u0015\u0001\u0004\tY$A\u0004f]R\u0014\u0018.Z:\u0011\u0011\u0005u\u0012qIA&\u0003'i!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\b[V$\u0018M\u00197f\u0015\r\t)ED\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u007f\u00111!T1q!\ri\u0011QJ\u0005\u0004\u0003\u001fr!\u0001\u0002'p]\u001eDq!a\u0015\n\t\u0013\t)&\u0001\bjgNs\u0017\r]:i_R4\u0015\u000e\\3\u0015\t\u0005]\u0013Q\f\t\u0004\u001b\u0005e\u0013bAA.\u001d\t9!i\\8mK\u0006t\u0007\u0002CA0\u0003#\u0002\r!!\u0019\u0002\t9\fW.\u001a\t\u0005\u0003G\nIGD\u0002\u000e\u0003KJ1!a\u001a\u000f\u0003\u0019\u0001&/\u001a3fM&\u0019q%a\u001b\u000b\u0007\u0005\u001dd\u0002C\u0005\u0002p%\t\n\u0011\"\u0001\u0002r\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\u001d+\u0007U\u000b)h\u000b\u0002\u0002xA!\u0011\u0011PAB\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014!C;oG\",7m[3e\u0015\r\t\tID\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAC\u0003w\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\r\u0015Q!\u0001AAE'\u0015\t9\tDAF!\u0011\ti)a%\u000e\u0005\u0005=%bAAI\t\u0005)Q\u000f^5mg&!\u0011QSAH\u0005\u001daunZ4j]\u001eD1\"!'\u0002\b\n\u0015\r\u0011\"\u0001\u0002\u001c\u0006qAo\u001c9jGB\u000b'\u000f^5uS>tWCAAO!\u0011\ty*!)\u000e\u0003-L1!a)l\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D1\"a*\u0002\b\n\u0005\t\u0015!\u0003\u0002\u001e\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0006\u0002,\u0006\u001d%Q1A\u0005\u0002\u00055\u0016A\u00027pO\u0012K'/\u0006\u0002\u0002\u001e!Y\u0011\u0011WAD\u0005\u0003\u0005\u000b\u0011BA\u000f\u0003\u001dawn\u001a#je\u0002B!\"!.\u0002\b\n\u0015\r\u0011\"\u0001U\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\t\u0015\u0005e\u0016q\u0011B\u0001B\u0003%Q+\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004\u0014\u0003\u000f#\t!!0\u0015\u0011\u0005}\u0016\u0011YAb\u0003\u000b\u00042\u0001CAD\u0011!\tI*a/A\u0002\u0005u\u0005\u0002CAV\u0003w\u0003\r!!\b\t\u0013\u0005U\u00161\u0018I\u0001\u0002\u0004)\u0006BCAe\u0003\u000f\u0013\r\u0011\"\u0003\u0002L\u00069b/\u00197jI\u0006$XmU3rk\u0016t7-\u001a(v[\n,'o]\u000b\u0003\u0003/B\u0011\"a4\u0002\b\u0002\u0006I!a\u0016\u00021Y\fG.\u001b3bi\u0016\u001cV-];f]\u000e,g*^7cKJ\u001c\b\u0005\u0003\u0006\u0002T\u0006\u001d%\u0019!C\u0005\u0003+\f\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u0005\u0005m\u0002\"CAm\u0003\u000f\u0003\u000b\u0011BA\u001e\u0003)\u0001(o\u001c3vG\u0016\u00148\u000f\t\u0005\u000b\u0003;\f9\t1A\u0005\n\u0005}\u0017!\u00047bgRl\u0015\r](gMN,G/\u0006\u0002\u0002L!Q\u00111]AD\u0001\u0004%I!!:\u0002#1\f7\u000f^'ba>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005\u001d\bBCAu\u0003C\f\t\u00111\u0001\u0002L\u0005\u0019\u0001\u0010J\u0019\t\u0013\u00055\u0018q\u0011Q!\n\u0005-\u0013A\u00047bgRl\u0015\r](gMN,G\u000f\t\u0005\u000b\u0003c\f9\t1A\u0005\n\u0005}\u0017A\u00047bgR\u001cf.\u00199PM\u001a\u001cX\r\u001e\u0005\u000b\u0003k\f9\t1A\u0005\n\u0005]\u0018A\u00057bgR\u001cf.\u00199PM\u001a\u001cX\r^0%KF$B!a\f\u0002z\"Q\u0011\u0011^Az\u0003\u0003\u0005\r!a\u0013\t\u0013\u0005u\u0018q\u0011Q!\n\u0005-\u0013a\u00047bgR\u001cf.\u00199PM\u001a\u001cX\r\u001e\u0011\t\u0015\t\u0005\u0011q\u0011b\u0001\n\u0013\u0011\u0019!A\u0006p]\u001e|\u0017N\\4Uq:\u001cXC\u0001B\u0003!!\u00119A!\u0004\u0002L\tEQB\u0001B\u0005\u0015\r\u0011Y\u0001J\u0001\u0005kRLG.\u0003\u0003\u0003\u0010\t%!a\u0002+sK\u0016l\u0015\r\u001d\t\u0004\u0011\tM\u0011b\u0001B\u000b\u0005\tYA\u000b\u001f8NKR\fG-\u0019;b\u0011%\u0011I\"a\"!\u0002\u0013\u0011)!\u0001\u0007p]\u001e|\u0017N\\4Uq:\u001c\b\u0005\u0003\u0006\u0003\u001e\u0005\u001d%\u0019!C\u0005\u0005\u0007\t\u0001#\u001e8sKBd\u0017nY1uK\u0012$\u0006P\\:\t\u0013\t\u0005\u0012q\u0011Q\u0001\n\t\u0015\u0011!E;oe\u0016\u0004H.[2bi\u0016$G\u000b\u001f8tA!A!QEAD\t\u0003\u00119#A\ngSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G/\u0006\u0002\u0003*A)QBa\u000b\u00030%\u0019!Q\u0006\b\u0003\r=\u0003H/[8o!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"b\u0001B\u001b\t\u000511/\u001a:wKJLAA!\u000f\u00034\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u0011\tu\u0012q\u0011C\u0001\u0005\u007f\tac\u001c8IS\u001eDw+\u0019;fe6\f'o[+qI\u0006$X\r\u001a\u000b\u0005\u0003_\u0011\t\u0005\u0003\u0005\u0003D\tm\u0002\u0019AA&\u00035A\u0017n\u001a5XCR,'/\\1sW\"A!qIAD\t\u0003\u0011I%\u0001\u000bgSJ\u001cH/\u00168eK\u000eLG-\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0005\u0017\u0002R!\u0004B\u0016\u0003\u0017B\u0001Ba\u0014\u0002\b\u0012\u0005\u0011q\\\u0001\r[\u0006\u0004XI\u001c3PM\u001a\u001cX\r\u001e\u0005\t\u0005'\n9\t\"\u0001\u0003V\u0005y\u0011m\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148/\u0006\u0002\u0003XAA!\u0011\fB0\u0003\u0017\n\u0019\"\u0004\u0002\u0003\\)!!QLA\"\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002J\tm\u0003\u0002\u0003B2\u0003\u000f#\t!a3\u0002\u000f%\u001cX)\u001c9us\"A!qMAD\t\u0013\u0011I'\u0001\tm_\u0006$gI]8n':\f\u0007o\u001d5piR1\u0011q\u0006B6\u0005_B\u0001B!\u001c\u0003f\u0001\u0007\u00111J\u0001\u000fY><7\u000b^1si>3gm]3u\u0011!\u0011\tH!\u001aA\u0002\u0005-\u0013aC2veJ,g\u000e\u001e+j[\u0016D\u0011B!\u001e\u0002\b\u0012\u0005!Aa\u001e\u0002#1|\u0017\r\u001a)s_\u0012,8-\u001a:F]R\u0014\u0018\u0010\u0006\u0003\u00020\te\u0004\u0002\u0003B>\u0005g\u0002\r!a\u0005\u0002\u000b\u0015tGO]=\t\u0011\t}\u0014q\u0011C\u0005\u0005\u0003\u000b\u0011#[:Qe>$WoY3s\u000bb\u0004\u0018N]3e)\u0019\t9Fa!\u0003\b\"A!Q\u0011B?\u0001\u0004\tY%A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\u0005\t\u0005\u0013\u0013i\b1\u0001\u0002\u0014\u0005y\u0001O]8ek\u000e,'/\u00133F]R\u0014\u0018\u0010\u0003\u0005\u0003\u000e\u0006\u001dE\u0011\u0001BH\u0003Y\u0011X-\\8wK\u0016C\b/\u001b:fIB\u0013x\u000eZ;dKJ\u001cH\u0003BA\u0018\u0005#C\u0001B!\"\u0003\f\u0002\u0007\u00111\n\u0005\t\u0005+\u000b9\t\"\u0001\u0003\u0018\u0006\tBO];oG\u0006$X-\u00118e%\u0016dw.\u00193\u0015\u0011\u0005=\"\u0011\u0014BN\u0005?C\u0001B!\u001c\u0003\u0014\u0002\u0007\u00111\n\u0005\t\u0005;\u0013\u0019\n1\u0001\u0002L\u0005aAn\\4F]\u0012|eMZ:fi\"A!Q\u0011BJ\u0001\u0004\tY\u0005\u0003\u0005\u0003$\u0006\u001dE\u0011\u0001BS\u00035\u0001(/\u001a9be\u0016,\u0006\u000fZ1uKR1!q\u0015BW\u0005c\u00032\u0001\u0003BU\u0013\r\u0011YK\u0001\u0002\u0013!J|G-^2fe\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0003\u0005\u00030\n\u0005\u0006\u0019AA&\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\t\u0005g\u0013\t\u000b1\u0001\u0002X\u0005a\u0011n\u001d$s_6\u001cE.[3oi\"A!qWAD\t\u0003\u0011I,\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003_\u0011Y\f\u0003\u0005\u0003>\nU\u0006\u0019\u0001BT\u0003)\t\u0007\u000f]3oI&sgm\u001c\u0005\t\u0005\u0003\f9\t\"\u0001\u0003D\u0006\u0011R\u000f\u001d3bi\u0016l\u0015\r]#oI>3gm]3u)\u0011\tyC!2\t\u0011\t\u001d'q\u0018a\u0001\u0003\u0017\n!\u0002\\1ti>3gm]3u\u0011!\u0011Y-a\"\u0005\u0002\t5\u0017!\u00037bgR,e\u000e\u001e:z)\u0011\u0011yM!5\u0011\u000b5\u0011Y#a\u0005\t\u0011\t=&\u0011\u001aa\u0001\u0003\u0017B\u0001B!6\u0002\b\u0012\u0005!q[\u0001\ri\u0006\\Wm\u00158baNDw\u000e\u001e\u000b\u0003\u0003_A\u0001Ba7\u0002\b\u0012\u0005!\u0011J\u0001\u0015Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\t\u0011\t}\u0017q\u0011C\u0001\u0005\u0013\nAc\u001c7eKN$8K\\1qg\"|Go\u00144gg\u0016$\b\u0002\u0003Br\u0003\u000f#IA!:\u0002%%\u001c\bK]8ek\u000e,'OU3uC&tW\r\u001a\u000b\u0007\u0003/\u00129O!;\t\u0011\t%%\u0011\u001da\u0001\u0003'A\u0001B!\u001c\u0003b\u0002\u0007\u00111\n\u0005\t\u0005[\f9\t\"\u0001\u0003p\u0006aAO];oG\u0006$X\rS3bIR!\u0011q\u0006By\u0011!\u0011iGa;A\u0002\u0005-\u0003\u0002\u0003B{\u0003\u000f#IAa>\u0002AI,Wn\u001c<f\u000bZL7\r^3e\u001f:<w.\u001b8h)J\fgn]1di&|gn\u001d\u000b\u0005\u0003_\u0011I\u0010\u0003\u0005\u0003|\nM\b\u0019\u0001B\u007f\u0003I)\u0007\u0010]5sK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:\u0011\r\t}8\u0011AA&\u001b\t\t\u0019%\u0003\u0003\u0004\u0004\u0005\r#aA*fi\"A1qAAD\t\u0013\u0019I!\u0001\u0010sK6|g/Z+oe\u0016\u0004H.[2bi\u0016$GK]1og\u0006\u001cG/[8ogR!\u0011qFB\u0006\u0011!\u0019ia!\u0002A\u0002\u0005-\u0013AB8gMN,G\u000f\u0003\u0005\u0004\u0012\u0005\u001dE\u0011\u0001Bl\u0003!!(/\u001e8dCR,\u0007\u0002CB\u000b\u0003\u000f#\taa\u0006\u0002\u0017\r|W\u000e\u001d7fi\u0016$\u0006P\u001c\u000b\u0005\u0003\u0017\u001aI\u0002\u0003\u0005\u0004\u001c\rM\u0001\u0019AB\u000f\u00031\u0019w.\u001c9mKR,G\r\u0016=o!\rA1qD\u0005\u0004\u0007C\u0011!\u0001D\"p[BdW\r^3e)bt\u0007\u0002CB\u0013\u0003\u000f#\taa\n\u0002+\u0011,G.\u001a;f':\f\u0007o\u001d5piN\u0014UMZ8sKR!\u0011qFB\u0015\u0011!\u0019iaa\tA\u0002\u0005-\u0003\u0006BB\u0012\u0007[\u0001B!!$\u00040%!1\u0011GAH\u0005)!\bN]3bIN\fg-\u001a\u0005\t\u0007k\t9\t\"\u0003\u00048\u0005\tB.[:u':\f\u0007o\u001d5pi\u001aKG.Z:\u0016\u0005\re\u0002#\u0002@\u0004<\u0005u\u0011\u0002BB\u001f\u0003#\u0011A\u0001T5ti\"A1\u0011IAD\t\u0013\u0019\u0019%\u0001\npY\u0012,7\u000f^*oCB\u001c\bn\u001c;GS2,WCAB#!\u0015i!1FA\u000f\u0011!\u0019I%a\"\u0005\n\r\r\u0013A\u00057bi\u0016\u001cHo\u00158baNDw\u000e\u001e$jY\u0016D\u0001b!\u0014\u0002\b\u0012%1qJ\u0001\u0014I\u0016dW\r^3T]\u0006\u00048\u000f[8u\r&dWm\u001d\u000b\u0005\u0003_\u0019\t\u0006\u0003\u0006\u0004T\r-\u0003\u0013!a\u0001\u0007+\n\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\u000f5\u00199&a\u0013\u0002X%\u00191\u0011\f\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004BCB/\u0003\u000f\u000b\n\u0011\"\u0003\u0004`\u0005iB-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004b)\"1QKA;Q\u0011\t9i!\u001a\u0011\t\u000555qM\u0005\u0005\u0007S\nyIA\u0007o_:$\bN]3bIN\fg-\u001a")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private final File logDir;
    private final int maxProducerIdExpirationMs;
    private final boolean validateSequenceNumbers;
    private final Map<Object, ProducerIdEntry> producers;
    private long kafka$log$ProducerStateManager$$lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerIdEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private boolean validateSequenceNumbers() {
        return this.validateSequenceNumbers;
    }

    private Map<Object, ProducerIdEntry> producers() {
        return this.producers;
    }

    public long kafka$log$ProducerStateManager$$lastMapOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset;
    }

    private void kafka$log$ProducerStateManager$$lastMapOffset_$eq(long x$1) {
        this.kafka$log$ProducerStateManager$$lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    public TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns() {
        return this.kafka$log$ProducerStateManager$$ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public Option<LogOffsetMetadata> firstUnstableOffset() {
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$1) {
                return x$1.getValue().firstOffset();
            }
        });
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$2) {
                return x$2.getValue().firstOffset();
            }
        });
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : unreplicatedFirstOffset));
    }

    public void onHighWatermarkUpdated(long highWatermark2) {
        this.removeUnreplicatedTransactions(highWatermark2);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Map.Entry<Object, TxnMetadata> x$3) {
                return x$3.getValue().firstOffset().messageOffset();
            }
        });
    }

    public long mapEndOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerIdEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<File> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            Some some = (Some)option;
            File file = (File)some.x();
            try {
                this.info((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file '", "' for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.$outer.topicPartition()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.file$1 = file$1;
                    }
                });
                Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1)new Serializable(this, logStartOffset, currentTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;
                    private final long logStartOffset$3;
                    private final long currentTime$1;

                    public final boolean apply(ProducerIdEntry producerEntry) {
                        return this.$outer.kafka$log$ProducerStateManager$$isProducerRetained(producerEntry, this.logStartOffset$3) && !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTime$1, producerEntry);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logStartOffset$3 = logStartOffset$3;
                        this.currentTime$1 = currentTime$1;
                    }
                });
                loadedProducers.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;

                    public final void apply(ProducerIdEntry entry2) {
                        this.$outer.loadProducerEntry(entry2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFilename(file.getName()));
                this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException corruptSnapshotException) {
                void var7_5;
                this.warn((Function0<String>)new Serializable(this, (File)var7_5, corruptSnapshotException){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;
                    private final CorruptSnapshotException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.e$1.getMessage()}));
                    }
                    {
                        this.file$1 = file$1;
                        this.e$1 = e$1;
                    }
                });
                boolean bl = Files.deleteIfExists(var7_5.toPath());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerIdEntry entry2) {
        long producerId = entry2.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry2);
        entry2.currentTxnFirstOffset().foreach((Function1)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long producerId$1;

            public final TxnMetadata apply(long offset2) {
                return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)offset2), new TxnMetadata(this.producerId$1, offset2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerId$1 = producerId$1;
            }
        });
    }

    public boolean kafka$log$ProducerStateManager$$isProducerExpired(long currentTimeMs, ProducerIdEntry producerIdEntry) {
        return producerIdEntry.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerIdEntry.timestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2)new Serializable(this, currentTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long currentTimeMs$1;

            public final boolean apply(long x0$2, ProducerIdEntry x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
                if (tuple2 != null) {
                    ProducerIdEntry lastEntry2 = (ProducerIdEntry)tuple2._2();
                    boolean bl = !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTimeMs$1, lastEntry2);
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTimeMs$1 = currentTimeMs$1;
            }
        });
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset2, long currentTimeMs) {
        this.deleteSnapshotFiles((Function1<Object, Object>)new Serializable(this, logStartOffset, logEndOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;
            private final long logEndOffset$1;

            public final boolean apply(long snapOffset) {
                return this.apply$mcZJ$sp(snapOffset);
            }

            public boolean apply$mcZJ$sp(long snapOffset) {
                return snapOffset > this.logEndOffset$1 || snapOffset <= this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
                this.logEndOffset$1 = logEndOffset$1;
            }
        });
        if (logEndOffset2 != this.mapEndOffset()) {
            this.producers().clear();
            this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        return new ProducerAppendInfo(producerId, (ProducerIdEntry)this.lastEntry(producerId).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ProducerIdEntry apply() {
                return ProducerIdEntry$.MODULE$.Empty();
            }
        }), this.validateSequenceNumbers(), isFromClient);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())})));
        }
        this.trace((Function0<String>)new Serializable(this, appendInfo){
            public static final long serialVersionUID = 0L;
            private final ProducerAppendInfo appendInfo$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.appendInfo$1.producerId()), this.appendInfo$1}));
            }
            {
                this.appendInfo$1 = appendInfo$1;
            }
        });
        ProducerIdEntry entry2 = appendInfo.lastEntry();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)entry2);
        appendInfo.startedTransactions().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;

            public final TxnMetadata apply(TxnMetadata txn) {
                return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), txn);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateMapEndOffset(long lastOffset) {
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerIdEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() > this.lastSnapOffset()) {
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.kafka$log$ProducerStateManager$$lastMapOffset());
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot for partition ", " at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition(), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$ProducerStateManager$$lastMapOffset())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.kafka$log$ProducerStateManager$$lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFilename(file.getName());
            }
        });
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFilename(file.getName());
            }
        });
    }

    public boolean kafka$log$ProducerStateManager$$isProducerRetained(ProducerIdEntry producerIdEntry, long logStartOffset) {
        return producerIdEntry.lastOffset() >= logStartOffset;
    }

    public void truncateHead(long logStartOffset) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1)new Serializable(this, logStartOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long logStartOffset$2;

            public final boolean apply(Tuple2<Object, ProducerIdEntry> x0$3) {
                Tuple2<Object, ProducerIdEntry> tuple2 = x0$3;
                if (tuple2 != null) {
                    ProducerIdEntry producerIdEntry = (ProducerIdEntry)tuple2._2();
                    boolean bl = !this.$outer.kafka$log$ProducerStateManager$$isProducerRetained(producerIdEntry, this.logStartOffset$2);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logStartOffset$2 = logStartOffset$2;
            }
        });
        Set evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq((TraversableOnce)evictedProducerIds);
        this.removeEvictedOngoingTransactions((Set<Object>)evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() < logStartOffset) {
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)new Serializable(this, logStartOffset){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$2;
            }
            {
                this.logStartOffset$2 = logStartOffset$2;
            }
        })));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator2 = this.kafka$log$ProducerStateManager$$ongoingTxns().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator2.next();
            if (!expiredProducerIds.contains((Object)BoxesRunTime.boxToLong((long)txnEntry.getValue().producerId()))) continue;
            iterator2.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset2) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator2 = this.unreplicatedTxns().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator2.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)new Serializable(this, offset2){
                public static final long serialVersionUID = 0L;
                private final long offset$2;

                public final boolean apply(long x$4) {
                    return this.apply$mcZJ$sp(x$4);
                }

                public boolean apply$mcZJ$sp(long x$4) {
                    return x$4 < this.offset$2;
                }
                {
                    this.offset$2 = offset$2;
                }
            })) continue;
            iterator2.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        this.deleteSnapshotFiles(this.deleteSnapshotFiles$default$1());
        this.lastSnapOffset_$eq(0L);
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public long completeTxn(CompletedTxn completedTxn) {
        void var3_3;
        TxnMetadata txnMetadata = this.kafka$log$ProducerStateManager$$ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException("Attempted to complete a transaction which was not started");
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        long lastStableOffset2 = BoxesRunTime.unboxToLong((Object)this.firstUndecidedOffset().getOrElse((Function0)new Serializable(this, completedTxn){
            public static final long serialVersionUID = 0L;
            private final CompletedTxn completedTxn$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.completedTxn$1.lastOffset() + 1L;
            }
            {
                this.completedTxn$1 = completedTxn$1;
            }
        }));
        return (long)var3_3;
    }

    public void deleteSnapshotsBefore(long offset2) {
        this.deleteSnapshotFiles((Function1<Object, Object>)new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$5) {
                return this.apply$mcZJ$sp(x$5);
            }

            public boolean apply$mcZJ$sp(long x$5) {
                return x$5 < this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    private List<File> listSnapshotFiles() {
        return this.logDir().exists() && this.logDir().isDirectory() ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File f) {
                return f.isFile() && ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$isSnapshotFile(f.getName());
            }
        })).toList() : List$.MODULE$.empty();
    }

    private Option<File> oldestSnapshotFile() {
        List<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFilename(file.getName());
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        List<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFilename(file.getName());
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private void deleteSnapshotFiles(Function1<Object, Object> predicate) {
        ((List)this.listSnapshotFiles().filter((Function1)new Serializable(this, predicate){
            public static final long serialVersionUID = 0L;
            private final Function1 predicate$1;

            public final boolean apply(File file) {
                return this.predicate$1.apply$mcZJ$sp(Log$.MODULE$.offsetFromFilename(file.getName()));
            }
            {
                this.predicate$1 = predicate$1;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return Files.deleteIfExists(file.toPath());
            }
        });
    }

    private Function1<Object, Object> deleteSnapshotFiles$default$1() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$6) {
                return this.apply$mcZJ$sp(x$6);
            }

            public boolean apply$mcZJ$sp(long x$6) {
                return true;
            }
        };
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging$class.$init$(this);
        String string = topicPartition.topic();
        String string2 = "__consumer_offsets";
        this.validateSequenceNumbers = string != null ? !string.equals(string2) : string2 != null;
        this.producers = Map$.MODULE$.empty();
        this.kafka$log$ProducerStateManager$$lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.kafka$log$ProducerStateManager$$ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

