/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminTest$;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentStatus;
import kafka.admin.ReplicaDistributions;
import kafka.api.PartitionStateInfo;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\"\u00113nS:$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001a\u0001\n\u0003q\u0012aB:feZ,'o]\u000b\u0002?A\u0019\u0001EK\u0017\u000f\u0005\u0005:cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0007\u0003\u0019a$o\\8u}%\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)S\u00059\u0001/Y2lC\u001e,'\"\u0001\u0014\n\u0005-b#aA*fc*\u0011\u0001&\u000b\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\t1$\b\u0005\u00028q5\t\u0011&\u0003\u0002:S\t!QK\\5u\u0011\u001dY4'!AA\u0002}\t1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005?\u0005A1/\u001a:wKJ\u001c\b\u0005C\u0003@\u0001\u0011\u0005\u0003)\u0001\u0005uK\u0006\u0014Hi\\<o)\u00051\u0004F\u0001 C!\t\u0019\u0005*D\u0001E\u0015\t)e)A\u0003kk:LGOC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0012\u0013Q!\u00114uKJDQa\u0013\u0001\u0005\u0002\u0001\u000bQ\u0003^3tiJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002K\u001bB\u00111IT\u0005\u0003\u001f\u0012\u0013A\u0001V3ti\")\u0011\u000b\u0001C\u0001\u0001\u0006YB/Z:u\u001b\u0006tW/\u00197SKBd\u0017nY1BgNLwM\\7f]RD#\u0001U'\t\u000bQ\u0003A\u0011\u0001!\u0002+Q,7\u000f\u001e+pa&\u001c7I]3bi&|g.\u00138[\u0017\"\u00121+\u0014\u0005\u0006/\u0002!\t\u0001Q\u0001\u001fi\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0007>dG.[:j_:D#AV'\t\u000bi\u0003A\u0011\u0001!\u00027Q,7\u000f^\"p]\u000e,(O]3oiR{\u0007/[2De\u0016\fG/[8oQ\tIV\nC\u0003^\u0001\u0011%a,\u0001\u000ehKR\u0014%o\\6feN<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\u0012K'\u000f\u0006\u0003`Q2,\bc\u00011dK6\t\u0011M\u0003\u0002cS\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011\f'aA*fiB\u0011qGZ\u0005\u0003O&\u00121!\u00138u\u0011\u0015iB\f1\u0001j!\r\u0001#.L\u0005\u0003W2\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\u0006[r\u0003\rA\\\u0001\u0006i>\u0004\u0018n\u0019\t\u0003_Jt!a\u000e9\n\u0005EL\u0013A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!]\u0015\t\u000bYd\u0006\u0019A3\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0006q\u0002!\t\u0001Q\u00011i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGoV5uQ2+\u0017\rZ3s\u0013:tUm\u001e*fa2L7-Y:)\u0005]l\u0005\"B>\u0001\t\u0003\u0001\u0015a\r;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R<\u0016\u000e\u001e5MK\u0006$WM\u001d(pi&sg*Z<SKBd\u0017nY1tQ\tQX\nC\u0003\u007f\u0001\u0011\u0005\u0001)A\u0018uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$hj\u001c8Pm\u0016\u0014H.\u00199qS:<'+\u001a9mS\u000e\f7\u000f\u000b\u0002~\u001b\"1\u00111\u0001\u0001\u0005\u0002\u0001\u000b1\u0005^3tiJ+\u0017m]:jO:Lgn\u001a(p]\u0016C\u0018n\u001d;j]\u001e\u0004\u0016M\u001d;ji&|g\u000eK\u0002\u0002\u00025Ca!!\u0003\u0001\t\u0003\u0001\u0015a\f;fgR\u0014Vm];nKB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oiRC\u0017\r^,bg\u000e{W\u000e\u001d7fi\u0016$\u0007fAA\u0004\u001b\"1\u0011q\u0002\u0001\u0005\u0002\u0001\u000bA\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f'j]8o\t\u0006$\u0018\rK\u0002\u0002\u000e5Ca!!\u0006\u0001\t\u0003\u0001\u0015!\t;fgR\u0014\u0015m]5d!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006,E.Z2uS>t\u0007fAA\n\u001b\"1\u00111\u0004\u0001\u0005\u0002\u0001\u000b!\u0003^3tiNCW\u000f\u001e3po:\u0014%o\\6fe\"\u001a\u0011\u0011D'\t\r\u0005\u0005\u0002\u0001\"\u0001A\u0003U!Xm\u001d;U_BL7mQ8oM&<7\t[1oO\u0016D3!a\bN\u0011\u0019\t9\u0003\u0001C\u0001\u0001\u0006\u00193\u000f[8vY\u0012\u0004&o\u001c9bO\u0006$X\rR=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\bfAA\u0013\u001b\"1\u0011Q\u0006\u0001\u0005\u0002\u0001\u000b1\u0004^3ti\n{w\u000e^:ue\u0006\u00048\t\\5f]RLEmQ8oM&<\u0007fAA\u0016\u001b\"1\u00111\u0007\u0001\u0005\u0002\u0001\u000ba\u0003^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0015\u0004\u0003ci\u0005")
public class AdminTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testReplicaAssignment() {
        IndexedSeq brokerMetadatas = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$1) {
                return new BrokerMetadata(x$1, (Option)None$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0)new Serializable(this, brokerMetadatas){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq brokerMetadatas$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerMetadatas$1, 10, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.intercept((Function0)new Serializable(this, brokerMetadatas){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq brokerMetadatas$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerMetadatas$1, 10, 6, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Map expectedAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerMetadatas, 10, 3, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", assignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        scala.collection.mutable.Map found = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkUtils(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaList = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])leaderForPartitionMap.keys().toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$1;

            public final Tuple2<Object, Seq<Object>> apply(int p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p)), (Object)this.$outer.zkUtils().getReplicasForPartition(this.topic$1, p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaList.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaList.size()).foreach$mVc$sp((Function1)new Serializable(this, expectedReplicaAssignment, actualReplicaList){
            public static final long serialVersionUID = 0L;
            private final Map expectedReplicaAssignment$1;
            private final scala.collection.immutable.Map actualReplicaList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)this.expectedReplicaAssignment$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)this.actualReplicaList$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.actualReplicaList$1 = actualReplicaList$1;
            }
        });
        this.intercept((Function0)new Serializable(this, expectedReplicaAssignment, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Map expectedReplicaAssignment$1;
            private final String topic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), this.topic$1, this.expectedReplicaAssignment$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.topic$1 = topic$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.intercept((Function0)new Serializable(this, collidingTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String collidingTopic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createTopic(this.$outer.zkUtils(), this.collidingTopic$1, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.collidingTopic$1 = collidingTopic$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test.topic";
        ZkUtils zkMock = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/brokers/topics/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic}))))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)zkMock.getAllTopics()).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        EasyMock.replay((Object[])new Object[]{zkMock});
        this.intercept((Function0)new Serializable(this, topic, zkMock){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final ZkUtils zkMock$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.zkMock$1, this.topic$2, (Map)Map$.MODULE$.empty(), new Properties(), false);
            }
            {
                this.topic$2 = topic$2;
                this.zkMock$1 = zkMock$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
    }

    public Set<Object> kafka$admin$AdminTest$$getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1)new Serializable(this, topic, partitionId){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final int partitionId$1;

            public final boolean apply(KafkaServer server) {
                return new File((String)server.config().logDirs().head(), new StringBuilder().append((Object)this.topic$3).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1)).toString()).exists();
            }
            {
                this.topic$3 = topic$3;
                this.partitionId$1 = partitionId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$2) {
                return x$2.config().brokerId();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$1;
            private final TopicAndPartition topicAndPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$3) {
                        return x$3.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$1, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$1), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$1 = newReplicas$1;
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment should complete";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$4;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.$outer.servers(), this.topic$4, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$1.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.newReplicas$1 = newReplicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "New replicas should exist on brokers";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$2;
            private final TopicAndPartition topicAndPartition$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$4) {
                        return x$4.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$2, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$2), (Object)this.newReplicas$2)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$2 = newReplicas$2;
                this.topicAndPartition$2 = topicAndPartition$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment should complete";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$5;
            private final Seq newReplicas$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.$outer.servers(), this.topic$5, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$2.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
                this.newReplicas$2 = newReplicas$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "New replicas should exist on brokers";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$3;
            private final TopicAndPartition topicAndPartition$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$5) {
                        return x$5.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$3, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$3), (Object)this.newReplicas$3)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$3 = newReplicas$3;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment should complete";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$6;
            private final Seq newReplicas$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.$outer.servers(), this.topic$6, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$3.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$6 = topic$6;
                this.newReplicas$3 = newReplicas$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "New replicas should exist on brokers";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        Assert.assertFalse((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        Map reassignedPartitions = this.zkUtils().getPartitionsBeingReassigned();
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1());
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !TestUtils$.MODULE$.checkIfReassignPartitionPathExists(this.$outer.zkUtils());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment should complete";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$7;
            private final Seq newReplicas$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.$outer.servers(), this.topic$7, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$4.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$7 = topic$7;
                this.newReplicas$4 = newReplicas$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "New replicas should exist on brokers";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPreferredReplicaJsonData() {
        Set partitionsForPreferredReplicaElection = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test", 1), new TopicAndPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkUtils(), partitionsForPreferredReplicaElection);
        String preferredReplicaElectionZkData = (String)this.zkUtils().readData(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath())._1();
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(preferredReplicaElectionZkData);
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        int preferredReplica = 0;
        Map brokerRack = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        int x$16 = 3;
        String x$17 = this.zkConnect();
        boolean x$18 = false;
        Map x$19 = brokerRack;
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$16, x$17, x$18, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, (Map<Object, String>)x$19).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        ZkUtils x$28 = this.zkUtils();
        String x$29 = topic;
        int x$30 = partition;
        None$ x$31 = None$.MODULE$;
        long x$32 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$33 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$28, x$29, x$30, x$32, (Option<Object>)x$31, x$33);
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkUtils(), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        ZkUtils x$34 = this.zkUtils();
        String x$35 = topic;
        int x$36 = partition;
        Some x$37 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$38 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$39 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$34, x$35, x$36, x$38, (Option<Object>)x$37, x$39);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }

    @Test
    public void testShutdownBroker() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = this.zkUtils().getController();
        KafkaController controller = ((KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer p) {
                return p.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        }).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Serializable controlledShutdownCallback = new Serializable(this, resultQueue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue resultQueue$1;

            public final void apply(Try<Set<TopicAndPartition>> controlledShutdownResult) {
                this.resultQueue$1.put(controlledShutdownResult);
            }
            {
                this.resultQueue$1 = resultQueue$1;
            }
        };
        controller.shutdownBroker(2, (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != 2;
            }
        })));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, activeServers){
            public static final long serialVersionUID = 0L;
            public final String topic$8;
            public final int partition$1;
            private final ObjectRef activeServers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Seq)this.activeServers$1.elem).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testShutdownBroker$1 $outer;

                    public final boolean apply(KafkaServer x$6) {
                        return ((PartitionStateInfo)x$6.apis().metadataCache().getPartitionInfo(this.$outer.topic$8, this.$outer.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().isr().size() != 3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topic$8 = topic$8;
                this.partition$1 = partition$1;
                this.activeServers$1 = activeServers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Topic test not created after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        PartitionStateInfo partitionStateInfo = (PartitionStateInfo)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr().size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr());
        controller.shutdownBroker(1, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == 0;
            }
        });
        partitionStateInfo = (PartitionStateInfo)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final String topic$8;
            private final int partition$1;

            public final boolean apply(KafkaServer x$7) {
                return ((PartitionStateInfo)x$7.apis().metadataCache().getPartitionInfo(this.topic$8, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
            }
            {
                this.topic$8 = topic$8;
                this.partition$1 = partition$1;
            }
        }));
        controller.shutdownBroker(0, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final String topic$8;
            private final int partition$1;

            public final boolean apply(KafkaServer x$8) {
                return ((PartitionStateInfo)x$8.apis().metadataCache().getPartitionInfo(this.topic$8, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
            }
            {
                this.topic$8 = topic$8;
                this.partition$1 = partition$1;
            }
        }));
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminUtils$.MODULE$.createTopic(server.zkUtils(), topic, partitions, 1, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"), AdminUtils$.MODULE$.createTopic$default$6());
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        this.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(server.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, new Properties());
        this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$9) {
                return TestUtils$.MODULE$.createServer(x$9, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        long limit = 1000000L;
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString())})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString())})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)new Serializable(this, newLimit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final long newLimit$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(((KafkaServer)this.$outer.servers().apply(brokerId)).zkUtils(), ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()))).toInt());
                Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()))).toInt());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newLimit$1 = newLimit$1;
            }
        });
        AdminUtils$.MODULE$.changeBrokerConfig(((KafkaServer)this.servers().apply(0)).zkUtils(), brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        Map configMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)"2000")}));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)configMap)}));
        ZkUtils qual$1 = this.zkUtils();
        String x$40 = ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Client(), clientId);
        String x$41 = Json$.MODULE$.encode((Object)map);
        java.util.List x$42 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$40, x$41, x$42);
        Map configInZk = AdminUtils$.MODULE$.fetchAllEntityConfigs(this.zkUtils(), ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overriden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.apis().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.apis().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkUtils());
        Seq processedMetadatas1 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$10) {
                return x$10.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$11) {
                return x$11.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq processedMetadatas2 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Safe$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$12) {
                return x$12.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$13) {
                return x$13.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final Seq<BrokerMetadata> apply() {
                return AdminUtils$.MODULE$.getBrokerMetadatas(this.$outer.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$14) {
                return x$14.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(BrokerMetadata x$15) {
                return Option$.MODULE$.option2Iterable(x$15.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        ZkUtils x$43 = this.zkUtils();
        String x$44 = "foo";
        int x$45 = numPartitions;
        int x$46 = 2;
        RackAwareMode.Safe$ x$47 = RackAwareMode.Safe$.MODULE$;
        Properties x$48 = AdminUtils$.MODULE$.createTopic$default$5();
        AdminUtils$.MODULE$.createTopic(x$43, x$44, x$45, x$46, x$48, (RackAwareMode)x$47);
        scala.collection.mutable.Map assignment = this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    private final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    public final void kafka$admin$AdminTest$$checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Assert.assertTrue((boolean)actual.isEmpty());
        } else {
            Assert.assertEquals((Object)Predef$.MODULE$.refArrayOps((Object[])expected.split(",")).toSeq(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
        }
    }

    private final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$9, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, partitions$1, topic$9, server$1, messageSize, retentionMs, throttledLeaders, throttledFollowers, quotaManagerIsThrottled){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final int partitions$1;
            public final String topic$9;
            public final KafkaServer server$1;
            public final int messageSize$1;
            public final long retentionMs$1;
            public final String throttledLeaders$1;
            public final String throttledFollowers$1;
            public final boolean quotaManagerIsThrottled$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitions$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$1$1 $outer;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.$outer.topic$9, part);
                        Option log2 = this.$outer.server$1.logManager().getLog(tp);
                        Assert.assertTrue((boolean)log2.isDefined());
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)this.$outer.retentionMs$1), (Object)((Log)log2.get()).config().retentionMs());
                        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.$outer.messageSize$1), (Object)((Log)log2.get()).config().maxMessageSize());
                        this.$outer.kafka$admin$AdminTest$$anonfun$$$outer().kafka$admin$AdminTest$$checkList$1(((Log)log2.get()).config().LeaderReplicationThrottledReplicas(), this.$outer.throttledLeaders$1);
                        this.$outer.kafka$admin$AdminTest$$anonfun$$$outer().kafka$admin$AdminTest$$checkList$1(((Log)log2.get()).config().FollowerReplicationThrottledReplicas(), this.$outer.throttledFollowers$1);
                        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.server$1.quotaManagers().leader().isThrottled(tp)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ AdminTest kafka$admin$AdminTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$1 = partitions$1;
                this.topic$9 = topic$9;
                this.server$1 = server$1;
                this.messageSize$1 = messageSize$1;
                this.retentionMs$1 = retentionMs$1;
                this.throttledLeaders$1 = throttledLeaders$1;
                this.throttledFollowers$1 = throttledFollowers$1;
                this.quotaManagerIsThrottled$1 = quotaManagerIsThrottled$1;
            }
        });
    }

    private final void checkConfig$2(long limit) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, limit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            public final long limit$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.servers().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$2$1 $outer;

                    public final void apply(KafkaServer server) {
                        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().leader().upperBound());
                        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().follower().upperBound());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.limit$1 = limit$1;
            }
        });
    }

    public AdminTest() {
        RackAwareTest$class.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

