/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.Map;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rud!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0001\u0013\u0003\u001d)\u0007o]5m_:,\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\t>,(\r\\3\t\ri\u0001\u0001\u0015!\u0003\u0014\u0003!)\u0007o]5m_:\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u0003y\u0001\"\u0001F\u0010\n\u0005\u0001*\"aA%oi\"1!\u0005\u0001Q\u0001\ny\ta\u0002\u001d:pIV\u001cWM]\"pk:$\b\u0005C\u0004%\u0001\t\u0007I\u0011A\u000f\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u0011\u00191\u0003\u0001)A\u0005=\u0005q1m\u001c8tk6,'oQ8v]R\u0004\u0003b\u0002\u0015\u0001\u0005\u0004%\t!H\u0001\fg\u0016\u0014h/\u001a:D_VtG\u000f\u0003\u0004+\u0001\u0001\u0006IAH\u0001\rg\u0016\u0014h/\u001a:D_VtG\u000f\t\u0005\bY\u0001\u0011\r\u0011\"\u0001.\u0003\u0015!x\u000e]5d+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011a\u0017M\\4\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u0007'R\u0014\u0018N\\4\t\r]\u0002\u0001\u0015!\u0003/\u0003\u0019!x\u000e]5dA!9\u0011\b\u0001b\u0001\n\u0003i\u0012\u0001\u00029beRDaa\u000f\u0001!\u0002\u0013q\u0012!\u00029beR\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAP\u0001\u0003iB,\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000baaY8n[>t'BA\u0003E\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0017\u0002\u0001\u000b\u0011B \u0002\u0007Q\u0004\b\u0005C\u0004N\u0001\t\u0007I\u0011A\u000f\u0002\u000bA\f'\u000f\u001e\u001a\t\r=\u0003\u0001\u0015!\u0003\u001f\u0003\u0019\u0001\u0018M\u001d;3A!9\u0011\u000b\u0001b\u0001\n\u0003q\u0014a\u0001;qe!11\u000b\u0001Q\u0001\n}\nA\u0001\u001e93A!)Q\u000b\u0001C!-\u0006)1/\u001a;VaR\tq\u000b\u0005\u0002\u00151&\u0011\u0011,\u0006\u0002\u0005+:LG\u000f\u000b\u0002U7B\u0011AlX\u0007\u0002;*\u0011aLR\u0001\u0006UVt\u0017\u000e^\u0005\u0003Av\u0013aAQ3g_J,\u0007\"\u00022\u0001\t\u00031\u0016!\u0006;fgR\u001c\u0016.\u001c9mK\u000e{gn];naRLwN\u001c\u0015\u0003C\u0012\u0004\"\u0001X3\n\u0005\u0019l&\u0001\u0002+fgRDQ\u0001\u001b\u0001\u0005\u0002Y\u000bq\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$bS2|g/\u001a:)\u0005\u001d$g\u0001B6\u0001\u00111\u0014\u0001\u0005V3ti\u000e{gn];nKJ\u0014V-Y:tS\u001etW.\u001a8u\u0019&\u001cH/\u001a8feN\u0019!.\u001c9\u0011\u0005=r\u0017BA81\u0005\u0019y%M[3diB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\tG>t7/^7fe*\u0011QoQ\u0001\bG2LWM\u001c;t\u0013\t9(OA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\b\"B\u0007k\t\u0003IH#\u0001>\u0011\u0005mTW\"\u0001\u0001\t\u000fuT\u0007\u0019!C\u0001;\u0005y1-\u00197mgR{\u0017i]:jO:,G\r\u0003\u0005\u0000U\u0002\u0007I\u0011AA\u0001\u0003M\u0019\u0017\r\u001c7t)>\f5o]5h]\u0016$w\fJ3r)\r9\u00161\u0001\u0005\t\u0003\u000bq\u0018\u0011!a\u0001=\u0005\u0019\u0001\u0010J\u0019\t\u000f\u0005%!\u000e)Q\u0005=\u0005\u00012-\u00197mgR{\u0017i]:jO:,G\r\t\u0005\t\u0003\u001bQ\u0007\u0019!C\u0001;\u0005q1-\u00197mgR{'+\u001a<pW\u0016$\u0007\"CA\tU\u0002\u0007I\u0011AA\n\u0003I\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012|F%Z9\u0015\u0007]\u000b)\u0002C\u0005\u0002\u0006\u0005=\u0011\u0011!a\u0001=!9\u0011\u0011\u00046!B\u0013q\u0012aD2bY2\u001cHk\u001c*fm>\\W\r\u001a\u0011\t\u000f\u0005u!\u000e\"\u0001\u0002 \u0005!rN\u001c)beRLG/[8og\u0006\u001b8/[4oK\u0012$2aVA\u0011\u0011!\t\u0019#a\u0007A\u0002\u0005\u0015\u0012A\u00039beRLG/[8ogB)\u0011qEA\u0017\u007f5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\u0011\u0014\u0001B;uS2LA!a\f\u0002*\tQ1i\u001c7mK\u000e$\u0018n\u001c8\t\u000f\u0005M\"\u000e\"\u0001\u00026\u0005\u0019rN\u001c)beRLG/[8ogJ+go\\6fIR\u0019q+a\u000e\t\u0011\u0005\r\u0012\u0011\u0007a\u0001\u0003KAq!a\u000f\u0001\t#\ti$A\u0006tK:$'+Z2pe\u0012\u001cH\u0003BA \u0003_\u0002b!!\u0011\u0002R\u0005]c\u0002BA\"\u0003\u001brA!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u00132\u0011A\u0002\u001fs_>$h(C\u0001\u0017\u0013\r\ty%F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u0007M+\u0017OC\u0002\u0002PU\u0001\u0002\"!\u0017\u0002`\u0005\r\u00141M\u0007\u0003\u00037R1!!\u0018u\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BA1\u00037\u0012a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rE\u0003\u0015\u0003K\nI'C\u0002\u0002hU\u0011Q!\u0011:sCf\u00042\u0001FA6\u0013\r\ti'\u0006\u0002\u0005\u0005f$X\rC\u0004\u0002r\u0005e\u0002\u0019\u0001\u0010\u0002\u00159,XNU3d_J$7\u000fC\u0004\u0002<\u0001!\t\"!\u001e\u0015\r\u0005}\u0012qOA=\u0011\u001d\t\t(a\u001dA\u0002yAa!PA:\u0001\u0004y\u0004bBA\u001e\u0001\u0011E\u0011Q\u0010\u000b\t\u0003\u007f\ty(a\"\u0002\n\"A\u0011QLA>\u0001\u0004\t\t\t\u0005\u0005\u0002Z\u0005\r\u00151MA2\u0013\u0011\t))a\u0017\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d\t\t(a\u001fA\u0002yAa!PA>\u0001\u0004y\u0004bBAG\u0001\u0011E\u0011qR\u0001\u0018G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$\u0012cVAI\u00033\u000bY*a(\u0002$\u00065\u0016QXA`\u0011\u001d\u0019\u00181\u0012a\u0001\u0003'\u0003r!]AK\u0003G\n\u0019'C\u0002\u0002\u0018J\u0014\u0001bQ8ogVlWM\u001d\u0005\b\u0003c\nY\t1\u0001\u001f\u0011\u001d\ti*a#A\u0002y\tab\u001d;beRLgnZ(gMN,G\u000fC\u0005\u0002\"\u0006-\u0005\u0013!a\u0001=\u0005A2\u000f^1si&twmS3z\u0003:$g+\u00197vK&sG-\u001a=\t\u0015\u0005\u0015\u00161\u0012I\u0001\u0002\u0004\t9+A\tti\u0006\u0014H/\u001b8h)&lWm\u001d;b[B\u00042\u0001FAU\u0013\r\tY+\u0006\u0002\u0005\u0019>tw\r\u0003\u0006\u00020\u0006-\u0005\u0013!a\u0001\u0003c\u000bQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]\u0016)\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003w\u000b)LA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\t{\u0005-\u0005\u0013!a\u0001\u007f!I\u0011\u0011YAF!\u0003\u0005\rAH\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0011\u001d\t)\r\u0001C\t\u0003\u000f\fabY8ogVlWMU3d_J$7/\u0006\u0004\u0002J\u0006\u0015\u0018\u0011 \u000b\t\u0003\u0017\fiP!\u0001\u0003\u0004A1\u0011QZAl\u00037l!!a4\u000b\t\u0005E\u00171[\u0001\b[V$\u0018M\u00197f\u0015\r\t).F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAm\u0003\u001f\u00141\"\u0011:sCf\u0014UO\u001a4feB9\u0011/!8\u0002b\u0006]\u0018bAApe\nq1i\u001c8tk6,'OU3d_J$\u0007\u0003BAr\u0003Kd\u0001\u0001\u0002\u0005\u0002h\u0006\r'\u0019AAu\u0005\u0005Y\u0015\u0003BAv\u0003c\u00042\u0001FAw\u0013\r\ty/\u0006\u0002\b\u001d>$\b.\u001b8h!\r!\u00121_\u0005\u0004\u0003k,\"aA!osB!\u00111]A}\t!\tY0a1C\u0002\u0005%(!\u0001,\t\u000fM\f\u0019\r1\u0001\u0002\u0000B9\u0011/!&\u0002b\u0006]\bbBA9\u0003\u0007\u0004\rA\b\u0005\n\u0003\u0003\f\u0019\r%AA\u0002yAqAa\u0002\u0001\t#\u0011I!A\nbo\u0006LGoQ8n[&$8)\u00197mE\u0006\u001c7.\u0006\u0004\u0003\f\tM!q\u0003\u000b\b/\n5!\u0011\u0004B8\u0011\u001d\u0019(Q\u0001a\u0001\u0005\u001f\u0001r!]AK\u0005#\u0011)\u0002\u0005\u0003\u0002d\nMA\u0001CAt\u0005\u000b\u0011\r!!;\u0011\t\u0005\r(q\u0003\u0003\t\u0003w\u0014)A1\u0001\u0002j\"A!1\u0004B\u0003\u0001\u0004\u0011i\"\u0001\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0011\u0007m\u0014yB\u0002\u0004\u0003\"\u0001A!1\u0005\u0002\u001c\u0007>,h\u000e^\"p]N,X.\u001a:D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0014\u000b\t}QN!\n\u0011\u0007E\u00149#C\u0002\u0003*I\u0014Ac\u00144gg\u0016$8i\\7nSR\u001c\u0015\r\u001c7cC\u000e\\\u0007bB\u0007\u0003 \u0011\u0005!Q\u0006\u000b\u0003\u0005;A\u0011B!\r\u0003 \u0001\u0007I\u0011A\u000f\u0002\u0019M,8mY3tg\u000e{WO\u001c;\t\u0015\tU\"q\u0004a\u0001\n\u0003\u00119$\u0001\ttk\u000e\u001cWm]:D_VtGo\u0018\u0013fcR\u0019qK!\u000f\t\u0013\u0005\u0015!1GA\u0001\u0002\u0004q\u0002\u0002\u0003B\u001f\u0005?\u0001\u000b\u0015\u0002\u0010\u0002\u001bM,8mY3tg\u000e{WO\u001c;!\u0011%\u0011\tEa\bA\u0002\u0013\u0005Q$A\u0005gC&d7i\\;oi\"Q!Q\tB\u0010\u0001\u0004%\tAa\u0012\u0002\u001b\u0019\f\u0017\u000e\\\"pk:$x\fJ3r)\r9&\u0011\n\u0005\n\u0003\u000b\u0011\u0019%!AA\u0002yA\u0001B!\u0014\u0003 \u0001\u0006KAH\u0001\u000bM\u0006LGnQ8v]R\u0004\u0003\u0002\u0003B)\u0005?!\tEa\u0015\u0002\u0015=t7i\\7qY\u0016$X\rF\u0003X\u0005+\u0012)\u0007\u0003\u0005\u0003X\t=\u0003\u0019\u0001B-\u0003\u001dygMZ:fiN\u0004r!a\n\u0003\\}\u0012y&\u0003\u0003\u0003^\u0005%\"aA'baB\u0019\u0011O!\u0019\n\u0007\t\r$OA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006D\u0001Ba\u001a\u0003P\u0001\u0007!\u0011N\u0001\nKb\u001cW\r\u001d;j_:\u0004B!!\u0011\u0003l%!!QNA+\u0005%)\u0005pY3qi&|g\u000eC\u0005\u0003r\t\u0015\u0001\u0013!a\u0001=\u0005)1m\\;oi\u001a1!Q\u000f\u0001\t\u0005o\u0012\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s'\u0011\u0011\u0019H!\u001f\u0011\t\tm$\u0011Q\u0007\u0003\u0005{R1Aa \u0005\u0003\u0015)H/\u001b7t\u0013\u0011\u0011\u0019I! \u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\u000bg\nM$\u0011!Q\u0001\n\u0005M\u0005b\u0003BE\u0005g\u0012\t\u0011)A\u0005\u0005\u0017\u000b\u0011\u0003^8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f!\u0019\t\tE!$\u0003\u0012&!!qRA+\u0005\u0011a\u0015n\u001d;\u0011\t\tM%\u0011\u0014\b\u0004)\tU\u0015b\u0001BL+\u00051\u0001K]3eK\u001aL1!\u000eBN\u0015\r\u00119*\u0006\u0005\b\u001b\tMD\u0011\u0001BP)\u0019\u0011\tKa)\u0003&B\u00191Pa\u001d\t\u000fM\u0014i\n1\u0001\u0002\u0014\"A!\u0011\u0012BO\u0001\u0004\u0011Y\t\u0003\u0006\u0003*\nM\u0004\u0019!C\u0005\u0005W\u000b1\u0003]1si&$\u0018n\u001c8BgNLwM\\7f]R,\"A!,\u0011\u000b\tM%qV \n\t\tE&1\u0014\u0002\u0004'\u0016$\bB\u0003B[\u0005g\u0002\r\u0011\"\u0003\u00038\u00069\u0002/\u0019:uSRLwN\\!tg&<g.\\3oi~#S-\u001d\u000b\u0004/\ne\u0006BCA\u0003\u0005g\u000b\t\u00111\u0001\u0003.\"I!Q\u0018B:A\u0003&!QV\u0001\u0015a\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0011)\t\tm&\u0011\u0019\t\u0004)\t\r\u0017b\u0001Bc+\tAao\u001c7bi&dW\r\u0003\u0006\u0003J\nM\u0004\u0019!C\u0005\u0005\u0017\f!\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]V\u0011!1\u0012\u0005\u000b\u0005\u001f\u0014\u0019\b1A\u0005\n\tE\u0017A\u0006;pa&\u001c7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:|F%Z9\u0015\u0007]\u0013\u0019\u000e\u0003\u0006\u0002\u0006\t5\u0017\u0011!a\u0001\u0005\u0017C\u0011Ba6\u0003t\u0001\u0006KAa#\u0002'Q|\u0007/[2t'V\u00147o\u0019:jaRLwN\u001c\u0011\t\u0015\tm'1\u000fa\u0001\n\u0013\u0011i.A\ntk\n\u001c8M]5qi&|gn\u00115b]\u001e,G-\u0006\u0002\u0003`B\u0019AC!9\n\u0007\t\rXCA\u0004C_>dW-\u00198\t\u0015\t\u001d(1\u000fa\u0001\n\u0013\u0011I/A\ftk\n\u001c8M]5qi&|gn\u00115b]\u001e,Gm\u0018\u0013fcR\u0019qKa;\t\u0015\u0005\u0015!Q]A\u0001\u0002\u0004\u0011y\u000eC\u0005\u0003p\nM\u0004\u0015)\u0003\u0003`\u0006!2/\u001e2tGJL\u0007\u000f^5p]\u000eC\u0017M\\4fI\u0002BCA!<\u0003B\"Q!Q\u001fB:\u0005\u0004%\tAa>\u0002#I,'-\u00197b]\u000e,G*[:uK:,'/\u0006\u0002\u0003zJ!!1`7q\r\u001d\u0011iPa@\u0001\u0005s\u0014A\u0002\u0010:fM&tW-\\3oizB\u0011b!\u0001\u0003t\u0001\u0006IA!?\u0002%I,'-\u00197b]\u000e,G*[:uK:,'\u000f\t\u0005\t\u0007\u000b\u0011\u0019\b\"\u0001\u0004\b\u0005\u00112m\u001c8tk6,'/Q:tS\u001etW.\u001a8u)\t\u0011i\u000b\u0003\u0005\u0004\f\tMD\u0011AB\u0007\u0003%\u0019XOY:de&\u0014W\rF\u0002X\u0007\u001fA\u0001b!\u0005\u0004\n\u0001\u0007!1R\u0001\u0015]\u0016<Hk\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\t\u0011\rU!1\u000fC\u0001\u0007/\t1$[:Tk\n\u001c8M]5cKJ+\u0017/^3tiB\u0013xnY3tg\u0016$GC\u0001Bp\u0011!\u0019YBa\u001d\u0005B\r]\u0011\u0001E5oSRL\u0017\r^3TQV$Hm\\<o\u0011\u001d\u0019yBa\u001d\u0005BY\u000ba\u0001Z8X_J\\\u0007bBB\u0012\u0001\u0011\u00051QE\u0001\u001bSN\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u-\u0006d\u0017\u000e\u001a\u000b\u0007\u0005?\u001c9c!\r\t\u0011\r%2\u0011\u0005a\u0001\u0007W\t1\"Y:tS\u001etW.\u001a8ugB1\u0011QZB\u0017\u0005[KAaa\f\u0002P\n1!)\u001e4gKJD\u0001\"a\t\u0004\"\u0001\u0007!Q\u0016\u0005\n\u0007k\u0001\u0011\u0013!C\t\u0007o\t\u0011eY8ogVlW-\u00118e-\u0016\u0014\u0018NZ=SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"a!\u000f+\u0007y\u0019Yd\u000b\u0002\u0004>A!1qHB%\u001b\t\u0019\tE\u0003\u0003\u0004D\r\u0015\u0013!C;oG\",7m[3e\u0015\r\u00199%F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB&\u0007\u0003\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019y\u0005AI\u0001\n#\u0019\t&A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$S'\u0006\u0002\u0004T)\"\u0011qUB\u001e\u0011%\u00199\u0006AI\u0001\n#\u0019I&A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0006\u0002\u0004\\)\"\u0011\u0011WB\u001e\u0011%\u0019y\u0006AI\u0001\n#\u0019\t'A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$s'\u0006\u0002\u0004d)\u001aqha\u000f\t\u0013\r\u001d\u0004!%A\u0005\u0012\r]\u0012!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012B\u0004\"CB6\u0001E\u0005I\u0011CB7\u0003u\tw/Y5u\u0007>lW.\u001b;DC2d'-Y2lI\u0011,g-Y;mi\u0012\u001aTCBB\u001c\u0007_\u001a\t\b\u0002\u0005\u0002h\u000e%$\u0019AAu\t!\tYp!\u001bC\u0002\u0005%\b\"CB;\u0001E\u0005I\u0011CB<\u0003a\u0019wN\\:v[\u0016\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0007\u0007o\u0019Iha\u001f\u0005\u0011\u0005\u001d81\u000fb\u0001\u0003S$\u0001\"a?\u0004t\t\u0007\u0011\u0011\u001e")
public abstract class BaseConsumerTest
extends IntegrationTestHarness {
    private final double epsilon;
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(2000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer0.partitionsFor("__consumer_offsets")).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        consumer0.poll(5000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords) {
        return this.sendRecords(numRecords, this.tp());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords, TopicPartition tp) {
        return this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords, tp);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            /*
             * WARNING - void declaration
             */
            public final ProducerRecord<byte[], byte[]> apply(int i) {
                void var2_2;
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.producer$1.send(record);
                return var2_2;
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records2;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records2 = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records2, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayBuffer records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records2 = new ArrayBuffer();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records2.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1)new Serializable(this, records2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer records$2;

                public final ArrayBuffer<ConsumerRecord<K, V>> apply(ConsumerRecord<K, V> record) {
                    return this.records$2.$plus$eq(record);
                }
                {
                    this.records$2 = records$2;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        return records2;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Set<TopicPartition> assignment) {
                return assignment.nonEmpty();
            }
        });
        if (allNonEmptyAssignments) {
            Set uniqueAssignedPartitions;
            int n = 0;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<TopicPartition> apply(Set<TopicPartition> x$5, Set<TopicPartition> x$6) {
                    return (Set)x$5.$plus$plus(x$6);
                }
            });
            Set<TopicPartition> set3 = partitions;
            return !(set2 != null ? !set2.equals(set3) : set3 != null);
        }
        return false;
    }

    public BaseConsumerTest() {
        this.epsilon = 0.1;
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

