/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaId;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0007\u0002I\tQ\"^:feB\u0013\u0018N\\2ja\u0006dW#A\n\u0011\u0005QQbBA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001c9\t11\u000b\u001e:j]\u001eT!!\u0007\f\t\u000by\u0001a\u0011A\u0010\u0002\u001fA\u0014x\u000eZ;dKJ\fVo\u001c;b\u0013\u0012,\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0011\taa]3sm\u0016\u0014\u0018BA\u0013#\u0005\u001d\tVo\u001c;b\u0013\u0012DQa\n\u0001\u0007\u0002}\tqbY8ogVlWM])v_R\f\u0017\n\u001a\u0005\u0006S\u00011\tAK\u0001\u000f_Z,'O]5eKF+x\u000e^1t)\u0011YcfM\u001b\u0011\u0005Ua\u0013BA\u0017\u0017\u0005\u0011)f.\u001b;\t\u000b=B\u0003\u0019\u0001\u0019\u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b!\t)\u0012'\u0003\u00023-\t!Aj\u001c8h\u0011\u0015!\u0004\u00061\u00011\u00035\u0019wN\\:v[\u0016\u0014\u0018+^8uC\")a\u0007\u000ba\u0001o\u0005a!/Z9vKN$\u0018+^8uCB\u0011Q\u0003O\u0005\u0003sY\u0011a\u0001R8vE2,\u0007\"B\u001e\u0001\r\u0003a\u0014\u0001\u0006:f[>4X-U;pi\u0006|e/\u001a:sS\u0012,7\u000fF\u0001,\u0011\u001dq\u0004A1A\u0005B}\n1b]3sm\u0016\u00148i\\;oiV\t\u0001\t\u0005\u0002\u0016\u0003&\u0011!I\u0006\u0002\u0004\u0013:$\bB\u0002#\u0001A\u0003%\u0001)\u0001\u0007tKJ4XM]\"pk:$\b\u0005C\u0004G\u0001\t\u0007I\u0011A \u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u\u0011\u0019A\u0005\u0001)A\u0005\u0001\u0006q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0003b\u0002&\u0001\u0005\u0004%\taP\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r1\u0003\u0001\u0015!\u0003A\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002BqA\u0014\u0001C\u0002\u0013%q(\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,\u0007B\u0002)\u0001A\u0003%\u0001)A\nqe>$WoY3s\u0005V4g-\u001a:TSj,\u0007\u0005C\u0004S\u0001\t\u0007I\u0011C*\u0002!A\u0014x\u000eZ;dKJ\u001cE.[3oi&#W#\u0001+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016\u0001\u00027b]\u001eT\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\u001c-\"1A\f\u0001Q\u0001\nQ\u000b\u0011\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133!\u0011\u001dq\u0006A1A\u0005\u0012M\u000b\u0001cY8ogVlWM]\"mS\u0016tG/\u00133\t\r\u0001\u0004\u0001\u0015!\u0003U\u0003E\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\r\t\u0005\bE\u0002\u0011\r\u0011\"\u0001@\u0003Q!WMZ1vYR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\"1A\r\u0001Q\u0001\n\u0001\u000bQ\u0003Z3gCVdG\u000f\u0015:pIV\u001cWM])v_R\f\u0007\u0005C\u0004g\u0001\t\u0007I\u0011A \u0002)\u0011,g-Y;mi\u000e{gn];nKJ\fVo\u001c;b\u0011\u0019A\u0007\u0001)A\u0005\u0001\u0006)B-\u001a4bk2$8i\u001c8tk6,'/U;pi\u0006\u0004\u0003b\u00026\u0001\u0005\u0004%\taP\u0001\u0014I\u00164\u0017-\u001e7u%\u0016\fX/Z:u#V|G/\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011\u0002!\u0002)\u0011,g-Y;miJ+\u0017/^3tiF+x\u000e^1!\u0011\u001dq\u0007\u00011A\u0005\u0002=\f!\u0002\\3bI\u0016\u0014hj\u001c3f+\u0005\u0001\bCA\u0011r\u0013\t\u0011(EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002;\u0001\u0001\u0004%\t!^\u0001\u000fY\u0016\fG-\u001a:O_\u0012,w\fJ3r)\tYc\u000fC\u0004xg\u0006\u0005\t\u0019\u00019\u0002\u0007a$\u0013\u0007\u0003\u0004z\u0001\u0001\u0006K\u0001]\u0001\fY\u0016\fG-\u001a:O_\u0012,\u0007\u0005C\u0004|\u0001\u0001\u0007I\u0011A8\u0002\u0019\u0019|G\u000e\\8xKJtu\u000eZ3\t\u000fu\u0004\u0001\u0019!C\u0001}\u0006\u0001bm\u001c7m_^,'OT8eK~#S-\u001d\u000b\u0003W}Dqa\u001e?\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u00029\u0002\u001b\u0019|G\u000e\\8xKJtu\u000eZ3!\u0011!\t9\u0001\u0001b\u0001\n\u0013\u0019\u0016A\u0002;pa&\u001c\u0017\u0007C\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002+\u0002\u000fQ|\u0007/[22A!1\u0011q\u0002\u0001\u0005Bq\nQa]3u+BDC!!\u0004\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!\u00026v]&$(BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\t9B\u0001\u0004CK\u001a|'/\u001a\u0005\u0007\u0003K\u0001A\u0011\u0001\u001f\u0002;Q,7\u000f\u001e+ie>$H\u000f\\3e!J|G-^2fe\u000e{gn];nKJDC!a\t\u0002*A!\u0011QCA\u0016\u0013\u0011\ti#a\u0006\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003c\u0001A\u0011\u0001\u001f\u0002OQ,7\u000f\u001e)s_\u0012,8-\u001a:D_:\u001cX/\\3s\u001fZ,'O]5eKVsG\u000f\u001b:piRdW\r\u001a\u0015\u0005\u0003_\tI\u0003\u0003\u0004\u00028\u0001!\t\u0001P\u0001\u0018i\u0016\u001cH/U;pi\u0006|e/\u001a:sS\u0012,G)\u001a7fi\u0016DC!!\u000e\u0002*!1\u0011Q\b\u0001\u0005\u0002q\nA\u0003^3tiRC'o\u001c;uY\u0016$'+Z9vKN$\b\u0006BA\u001e\u0003SAq!a\u0011\u0001\t\u0003\t)%A\u000bqe>$WoY3V]RLG\u000e\u00165s_R$H.\u001a3\u0015\u000b\u0001\u000b9%!\u001c\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\n\u0011\u0001\u001d\t\t\u0003\u001b\ni&!\u0019\u0002b5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0005qe>$WoY3s\u0015\u0011\t)&a\u0016\u0002\u000f\rd\u0017.\u001a8ug*\u0019Q!!\u0017\u000b\t\u0005m\u00131D\u0001\u0007CB\f7\r[3\n\t\u0005}\u0013q\n\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000bU\t\u0019'a\u001a\n\u0007\u0005\u0015dCA\u0003BeJ\f\u0017\u0010E\u0002\u0016\u0003SJ1!a\u001b\u0017\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005=\u0014\u0011\ta\u0001\u0001\u0006QQ.\u0019=SK\u000e|'\u000fZ:\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005)2m\u001c8tk6,WK\u001c;jYRC'o\u001c;uY\u0016$G#\u0002!\u0002x\u0005\u0015\u0005\u0002CA=\u0003c\u0002\r!a\u001f\u0002\u0011\r|gn];nKJ\u0004\u0002\"! \u0002\u0002\u0006\u0005\u0014\u0011M\u0007\u0003\u0003\u007fRA!!\u001f\u0002T%!\u00111QA@\u00055Y\u0015MZ6b\u0007>t7/^7fe\"9\u0011qNA9\u0001\u0004\u0001\u0005bBAE\u0001\u0011\u0005\u00111R\u0001\u0013o\u0006LGOR8s#V|G/Y+qI\u0006$X\rF\u0004,\u0003\u001b\u000by)!%\t\r=\n9\t1\u00011\u0011\u0019!\u0014q\u0011a\u0001a!1a'a\"A\u0002]Bq!!&\u0001\t\u0013\t9*\u0001\u0011wKJLg-\u001f)s_\u0012,8-\u001a:UQJ|G\u000f\u001e7f)&lW-T3ue&\u001cGcA\u0016\u0002\u001a\"A\u0011\u0011KAJ\u0001\u0004\tY\n\r\u0004\u0002\u001e\u0006\r\u0016q\u0017\t\t\u0003\u001b\ni&a(\u00026B!\u0011\u0011UAR\u0019\u0001!A\"!*\u0002\u001a\u0006\u0005\t\u0011!B\u0001\u0003O\u00131a\u0018\u00132#\u0011\tI+a,\u0011\u0007U\tY+C\u0002\u0002.Z\u0011qAT8uQ&tw\rE\u0002\u0016\u0003cK1!a-\u0017\u0005\r\te.\u001f\t\u0005\u0003C\u000b9\f\u0002\u0007\u0002:\u0006e\u0015\u0011!A\u0001\u0006\u0003\t9KA\u0002`IIBq!!0\u0001\t\u0013\ty,\u0001\u0011wKJLg-_\"p]N,X.\u001a:UQJ|G\u000f\u001e7f)&lW-T3ue&\u001cG#B\u0016\u0002B\u0006M\u0007\u0002CA=\u0003w\u0003\r!a11\r\u0005\u0015\u0017\u0011ZAh!!\ti(!!\u0002H\u00065\u0007\u0003BAQ\u0003\u0013$A\"a3\u0002B\u0006\u0005\t\u0011!B\u0001\u0003O\u00131a\u0018\u00134!\u0011\t\t+a4\u0005\u0019\u0005E\u0017\u0011YA\u0001\u0002\u0003\u0015\t!a*\u0003\u0007}#C\u0007\u0003\u0006\u0002V\u0006m\u0006\u0013!a\u0001\u0003/\fq\"\\1y)\"\u0014x\u000e\u001e;mKRKW.\u001a\t\u0005+\u0005ew'C\u0002\u0002\\Z\u0011aa\u00149uS>t\u0007bBAp\u0001\u0011%\u0011\u0011]\u0001\u0013i\"\u0014x\u000e\u001e;mK6+GO]5d\u001d\u0006lW\r\u0006\u0004\u0002d\u0006=\u0018\u0011 \t\u0005\u0003K\fY/\u0004\u0002\u0002h*!\u0011\u0011^A,\u0003\u0019\u0019w.\\7p]&!\u0011Q^At\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003c\fi\u000e1\u0001\u0002t\u0006I\u0011/^8uCRK\b/\u001a\t\u0004C\u0005U\u0018bAA|E\tI\u0011+^8uCRK\b/\u001a\u0005\b\u0003w\fi\u000e1\u0001!\u0003\u001d\tXo\u001c;b\u0013\u0012Dq!a@\u0001\t\u0003\u0011\t!\u0001\buQJ|G\u000f\u001e7f\u001b\u0016$(/[2\u0015\r\t\r!q\u0002B\t!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003O\fq!\\3ue&\u001c7/\u0003\u0003\u0003\u000e\t\u001d!aC&bM.\fW*\u001a;sS\u000eD\u0001\"!=\u0002~\u0002\u0007\u00111\u001f\u0005\b\u0003w\fi\u00101\u0001!\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/\ta\u0003\u001d:pIV\u001cWM\u001d+ie>$H\u000f\\3NKR\u0014\u0018nY\u000b\u0003\u0005\u0007AqAa\u0007\u0001\t\u0013\u00119\"\u0001\fd_:\u001cX/\\3s)\"\u0014x\u000e\u001e;mK6+GO]5d\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005/\tQdY8ogVlWM\u001d*fcV,7\u000f\u001e+ie>$H\u000f\\3NKR\u0014\u0018n\u0019\u0005\b\u0005G\u0001A\u0011\u0002B\f\u0003M)\u00070Z7qiJ+\u0017/^3ti6+GO]5d\u0011\u001d\u00119\u0003\u0001C\u0001\u0005S\tq\"];pi\u0006\u0004&o\u001c9feRLWm\u001d\u000b\t\u0005W\u00119D!\u000f\u0003<A!!Q\u0006B\u001a\u001b\t\u0011yCC\u0002\u00032a\u000bA!\u001e;jY&!!Q\u0007B\u0018\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007_\t\u0015\u0002\u0019\u0001\u0019\t\rQ\u0012)\u00031\u00011\u0011\u00191$Q\u0005a\u0001o!I!q\b\u0001\u0012\u0002\u0013%!\u0011I\u0001+m\u0016\u0014\u0018NZ=D_:\u001cX/\\3s)\"\u0014x\u000e\u001e;mKRKW.Z'fiJL7\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019E\u000b\u0003\u0002X\n\u00153F\u0001B$!\u0011\u0011IEa\u0015\u000e\u0005\t-#\u0002\u0002B'\u0005\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tEc#\u0001\u0006b]:|G/\u0019;j_:LAA!\u0016\u0003L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int serverCount;
    private final int producerCount;
    private final int consumerCount;
    private final int producerBufferSize;
    private final String producerClientId;
    private final String consumerClientId;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private final String topic1;

    public abstract String userPrincipal();

    public abstract QuotaId producerQuotaId();

    public abstract QuotaId consumerQuotaId();

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)producer, numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyProducerThrottleTimeMetric(producer);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)consumer, produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyConsumerThrottleTimeMetric(consumer, this.verifyConsumerThrottleTimeMetric$default$2());
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
        this.removeQuotaOverrides();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        ((KafkaConsumer)this.consumers().head()).seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords + produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testThrottledRequest() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!throttled && System.currentTimeMillis() < endTimeMs) {
            consumer.poll(100L);
            KafkaMetric throttleMetric = this.consumerRequestThrottleMetric();
            throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.verifyConsumerThrottleTimeMetric(consumer, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)this.exemptRequestMetric());
        Assert.assertTrue((String)"Exempt requests not recorded", (this.exemptRequestMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(KafkaProducer<byte[], byte[]> p, int maxRecords) {
        void var3_3;
        int numProduced = 0;
        boolean throttled = false;
        do {
            byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)numProduced)).toString().getBytes();
            p.send(new ProducerRecord(this.topic1(), null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic1(), null, null, true)).get();
            KafkaMetric throttleMetric = this.producerThrottleMetric();
            boolean bl = throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        } while (++numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int consumeUntilThrottled(KafkaConsumer<byte[], byte[]> consumer, int maxRecords) {
        void var3_3;
        consumer.subscribe(Collections.singleton(this.topic1()));
        int numConsumed = 0;
        boolean throttled = false;
        do {
            KafkaMetric throttleMetric;
            boolean bl = throttled = (throttleMetric = this.consumerThrottleMetric()) != null && throttleMetric.value() > 0.0;
        } while ((numConsumed += consumer.poll(100L).count()) < maxRecords && !throttled);
        if (throttled && numConsumed < maxRecords) {
            int minRecords = numConsumed + 1;
            while (numConsumed < minRecords) {
                numConsumed += consumer.poll(100L).count();
            }
        }
        return (int)var3_3;
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, producerQuota, consumerQuota, requestQuota){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQuotaTest $outer;
            private final long producerQuota$1;
            private final long consumerQuota$1;
            private final double requestQuota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QuotaFactory.QuotaManagers quotaManagers = this.$outer.leaderNode().apis().quotas();
                Quota overrideProducerQuota = quotaManagers.produce().quota(this.$outer.userPrincipal(), this.$outer.producerClientId());
                Quota overrideConsumerQuota = quotaManagers.fetch().quota(this.$outer.userPrincipal(), this.$outer.consumerClientId());
                Quota overrideProducerRequestQuota = quotaManagers.request().quota(this.$outer.userPrincipal(), this.$outer.producerClientId());
                Quota overrideConsumerRequestQuota = quotaManagers.request().quota(this.$outer.userPrincipal(), this.$outer.consumerClientId());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have producer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.producerQuota$1), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have consumer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.consumerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.consumerQuota$1), (Object)overrideConsumerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.requestQuota$1), (Object)overrideProducerRequestQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.consumerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.requestQuota$1), (Object)overrideConsumerRequestQuota);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerQuota$1 = producerQuota$1;
                this.consumerQuota$1 = consumerQuota$1;
                this.requestQuota$1 = requestQuota$1;
            }
        });
    }

    private void verifyProducerThrottleTimeMetric(KafkaProducer<?, ?> producer) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId());
        Metric avgMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        Metric maxMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$1;
            private final Metric maxMetric$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.avgMetric$1.value() > 0.0 && this.maxMetric$1.value() > 0.0;
            }
            {
                this.avgMetric$1 = avgMetric$1;
                this.maxMetric$1 = maxMetric$1;
            }
        }, (Function0<String>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$1;
            private final Metric maxMetric$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.avgMetric$1.value()), BoxesRunTime.boxToDouble((double)this.maxMetric$1.value())}));
            }
            {
                this.avgMetric$1 = avgMetric$1;
                this.maxMetric$1 = maxMetric$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void verifyConsumerThrottleTimeMetric(KafkaConsumer<?, ?> consumer, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId());
        Metric avgMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        Metric maxMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$2;
            private final Metric maxMetric$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.avgMetric$2.value() > 0.0 && this.maxMetric$2.value() > 0.0;
            }
            {
                this.avgMetric$2 = avgMetric$2;
                this.maxMetric$2 = maxMetric$2;
            }
        }, (Function0<String>)new Serializable(this, avgMetric, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric avgMetric$2;
            private final Metric maxMetric$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.avgMetric$2.value()), BoxesRunTime.boxToDouble((double)this.maxMetric$2.value())}));
            }
            {
                this.avgMetric$2 = avgMetric$2;
                this.maxMetric$2 = maxMetric$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        maxThrottleTime.foreach((Function1)new Serializable(this, maxMetric){
            public static final long serialVersionUID = 0L;
            private final Metric maxMetric$2;

            public final void apply(double max) {
                this.apply$mcVD$sp(max);
            }

            public void apply$mcVD$sp(double max) {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum consumer throttle too high: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.maxMetric$2.value())})), (this.maxMetric$2.value() <= max ? 1 : 0) != 0);
            }
            {
                this.maxMetric$2 = maxMetric$2;
            }
        });
    }

    private Option<Object> verifyConsumerThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    private MetricName throttleMetricName(QuotaType quotaType, QuotaId quotaId) {
        return this.leaderNode().metrics().metricName("throttle-time", quotaType.toString(), "Tracking throttle-time per user/client-id", new String[]{"user", (String)quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), "client-id", (String)quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })});
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, QuotaId quotaId) {
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(this.throttleMetricName(quotaType, quotaId));
    }

    private KafkaMetric producerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerQuotaId());
    }

    private KafkaMetric consumerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric consumerRequestThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode().metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(metricName);
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        return props;
    }

    public BaseQuotaTest() {
        this.serverCount = 2;
        this.producerCount = 1;
        this.consumerCount = 1;
        this.producerBufferSize = 300000;
        this.producerClientId = "QuotasTestProducer-1";
        this.consumerClientId = "QuotasTestConsumer-1";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "0");
        this.producerConfig().setProperty("buffer.memory", ((Object)BoxesRunTime.boxToInteger((int)this.producerBufferSize())).toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.leaderNode = null;
        this.followerNode = null;
        this.topic1 = "topic-1";
    }
}

