/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.GroupCoordinatorRequest;
import kafka.api.GroupCoordinatorRequest$;
import kafka.api.GroupCoordinatorResponse;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitRequest$;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.common.OffsetAndMetadata$;
import kafka.common.OffsetMetadata$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0001c\u00144gg\u0016$8i\\7nSR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0004sC:$w.\\\u000b\u0002-A\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0005kRLGNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002D\u0001\u0004SC:$w.\u001c\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\f\u0002\u000fI\fg\u000eZ8nA!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0013!B4s_V\u0004X#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u00027b]\u001eT\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t11\u000b\u001e:j]\u001eDa\u0001\f\u0001!\u0002\u0013\u0019\u0013AB4s_V\u0004\b\u0005C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002-I,G/\u001a8uS>t7\t[3dW&sG/\u001a:wC2,\u0012\u0001\r\t\u0003cIj\u0011AG\u0005\u0003gi\u0011A\u0001T8oO\"1Q\u0007\u0001Q\u0001\nA\nqC]3uK:$\u0018n\u001c8DQ\u0016\u001c7.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f]\u0002\u0001\u0019!C\u0001q\u00051An\\4ESJ,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y\u001d\n!![8\n\u0005yZ$\u0001\u0002$jY\u0016Dq\u0001\u0011\u0001A\u0002\u0013\u0005\u0011)\u0001\u0006m_\u001e$\u0015N]0%KF$\"AQ#\u0011\u0005E\u001a\u0015B\u0001#\u001b\u0005\u0011)f.\u001b;\t\u000f\u0019{\u0014\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\t\r!\u0003\u0001\u0015)\u0003:\u0003\u001dawn\u001a#je\u0002BqA\u0013\u0001A\u0002\u0013\u0005\u0001(A\u0006u_BL7\rT8h\t&\u0014\bb\u0002'\u0001\u0001\u0004%\t!T\u0001\u0010i>\u0004\u0018n\u0019'pO\u0012K'o\u0018\u0013fcR\u0011!I\u0014\u0005\b\r.\u000b\t\u00111\u0001:\u0011\u0019\u0001\u0006\u0001)Q\u0005s\u0005aAo\u001c9jG2{w\rR5sA!91\u0001\u0001a\u0001\n\u0003\u0011V#A*\u0011\u0005I!\u0016BA+\u0003\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000f]\u0003\u0001\u0019!C\u00011\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0005\tK\u0006b\u0002$W\u0003\u0003\u0005\ra\u0015\u0005\u00077\u0002\u0001\u000b\u0015B*\u0002\u000fM,'O^3sA!9Q\f\u0001a\u0001\n\u0003q\u0016a\u00027pONK'0Z\u000b\u0002?B\u0011\u0011\u0007Y\u0005\u0003Cj\u00111!\u00138u\u0011\u001d\u0019\u0007\u00011A\u0005\u0002\u0011\f1\u0002\\8h'&TXm\u0018\u0013fcR\u0011!)\u001a\u0005\b\r\n\f\t\u00111\u0001`\u0011\u00199\u0007\u0001)Q\u0005?\u0006AAn\\4TSj,\u0007\u0005C\u0004j\u0001\u0001\u0007I\u0011\u00016\u0002\u001dMLW\u000e\u001d7f\u0007>t7/^7feV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o\t\u0005A1m\u001c8tk6,'/\u0003\u0002q[\nq1+[7qY\u0016\u001cuN\\:v[\u0016\u0014\bb\u0002:\u0001\u0001\u0004%\ta]\u0001\u0013g&l\u0007\u000f\\3D_:\u001cX/\\3s?\u0012*\u0017\u000f\u0006\u0002Ci\"9a)]A\u0001\u0002\u0004Y\u0007B\u0002<\u0001A\u0003&1.A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011\u0015A\b\u0001\"\u0011z\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0005FA<|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)! \u0002\u0007\u0005\u00164wN]3\t\r\u0005%\u0001\u0001\"\u0011z\u0003!!X-\u0019:E_^t\u0007\u0006BA\u0004\u0003\u001b\u00012\u0001`A\b\u0013\r\t\t\" \u0002\u0006\u0003\u001a$XM\u001d\u0005\u0007\u0003+\u0001A\u0011A=\u0002#Q,7\u000f^+qI\u0006$Xm\u00144gg\u0016$8\u000f\u000b\u0003\u0002\u0014\u0005e\u0001c\u0001?\u0002\u001c%\u0019\u0011QD?\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003C\u0001A\u0011A=\u00023Q,7\u000f^\"p[6LG/\u00118e\r\u0016$8\r[(gMN,Go\u001d\u0015\u0005\u0003?\tI\u0002\u0003\u0004\u0002(\u0001!\t!_\u0001\u0019i\u0016\u001cH\u000fT1sO\u0016lU\r^1eCR\f\u0007+Y=m_\u0006$\u0007\u0006BA\u0013\u00033Aa!!\f\u0001\t\u0003I\u0018\u0001\u0006;fgR|eMZ:fi\u0016C\b/\u001b:bi&|g\u000e\u000b\u0003\u0002,\u0005e\u0001BBA\u001a\u0001\u0011\u0005\u00110\u0001\u0011uKN$hj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY(gMN,GoQ8n[&$\b\u0006BA\u0019\u00033Aa!!\u000f\u0001\t\u0003I\u0018a\t;fgR|eMZ:fiN$U\r\\3uK\u00063G/\u001a:U_BL7\rR3mKRLwN\u001c\u0015\u0005\u0003o\tI\u0002")
public class OffsetCommitTest
extends ZooKeeperTestHarness {
    private final Random random = new Random();
    private final String group;
    private final long retentionCheckInterval;
    private File logDir = null;
    private File topicLogDir = null;
    private KafkaServer server = null;
    private int logSize = 100;
    private SimpleConsumer simpleConsumer = null;

    public Random random() {
        return this.random;
    }

    public String group() {
        return this.group;
    }

    public long retentionCheckInterval() {
        return this.retentionCheckInterval;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public File topicLogDir() {
        return this.topicLogDir;
    }

    public void topicLogDir_$eq(File x$1) {
        this.topicLogDir = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int logSize() {
        return this.logSize;
    }

    public void logSize_$eq(int x$1) {
        this.logSize = x$1;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public void simpleConsumer_$eq(SimpleConsumer x$1) {
        this.simpleConsumer = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int x$1 = 1;
        String x$2 = this.zkConnect();
        boolean x$3 = true;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        int x$5 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties config = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        config.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        config.setProperty(KafkaConfig$.MODULE$.OffsetsRetentionCheckIntervalMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.retentionCheckInterval())).toString());
        String logDirPath = config.getProperty("log.dir");
        this.logDir_$eq(new File(logDirPath));
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM));
        this.simpleConsumer_$eq(new SimpleConsumer("localhost", TestUtils$.MODULE$.boundPort(this.server(), TestUtils$.MODULE$.boundPort$default$2()), 1000000, 65536, "test-client"));
        GroupCoordinatorRequest consumerMetadataRequest = new GroupCoordinatorRequest(this.group(), GroupCoordinatorRequest$.MODULE$.apply$default$2(), GroupCoordinatorRequest$.MODULE$.apply$default$3(), GroupCoordinatorRequest$.MODULE$.apply$default$4());
        package$.MODULE$.Stream().continually((Function0)new Serializable(this, consumerMetadataRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetCommitTest $outer;
            private final GroupCoordinatorRequest consumerMetadataRequest$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GroupCoordinatorResponse consumerMetadataResponse = this.$outer.simpleConsumer().send(this.consumerMetadataRequest$1);
                return consumerMetadataResponse.coordinatorOpt().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerMetadataRequest$1 = consumerMetadataRequest$1;
            }
        }).dropWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean success) {
                if (!success) {
                    Thread.sleep(1000L);
                }
                return !success;
            }
        });
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumer().close();
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        super.tearDown();
    }

    @Test
    public void testUpdateOffsets() {
        String topic = "topic";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)topicAndPartition).get());
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse = this.simpleConsumer().fetchOffsets(fetchRequest);
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).error());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).metadata());
        Assert.assertEquals((long)42L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).offset());
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(100L, "some metadata"))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse1 = this.simpleConsumer().commitOffsets(commitRequest1);
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse1.commitStatus().get((Object)topicAndPartition).get());
        OffsetFetchRequest fetchRequest1 = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse1 = this.simpleConsumer().fetchOffsets(fetchRequest1);
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).error());
        Assert.assertEquals((Object)"some metadata", (Object)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).metadata());
        Assert.assertEquals((long)100L, (long)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).offset());
        TopicAndPartition unknownTopicAndPartition = new TopicAndPartition("unknownTopic", 0);
        OffsetFetchRequest fetchRequest2 = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{unknownTopicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse2 = this.simpleConsumer().fetchOffsets(fetchRequest2);
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse2.requestInfo().get((Object)unknownTopicAndPartition).get());
        Assert.assertEquals((long)1L, (long)fetchResponse2.requestInfo().size());
    }

    @Test
    public void testCommitAndFetchOffsets() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        String topic4 = "topic-4";
        String topic5 = "topic-5";
        ZkUtils x$17 = this.zkUtils();
        String x$18 = topic1;
        Seq x$19 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$20 = 1;
        int x$21 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$22 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$17, x$18, x$20, x$21, (Seq<KafkaServer>)x$19, x$22);
        ZkUtils x$23 = this.zkUtils();
        String x$24 = topic2;
        Seq x$25 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$26 = 2;
        int x$27 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$28 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$23, x$24, x$26, x$27, (Seq<KafkaServer>)x$25, x$28);
        ZkUtils x$29 = this.zkUtils();
        String x$30 = topic3;
        Seq x$31 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$32 = 1;
        int x$33 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$34 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$29, x$30, x$32, x$33, (Seq<KafkaServer>)x$31, x$34);
        ZkUtils x$35 = this.zkUtils();
        String x$36 = topic4;
        Seq x$37 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$38 = 1;
        int x$39 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$40 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$35, x$36, x$38, x$39, (Seq<KafkaServer>)x$37, x$40);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest("test-group", (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic1, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(42L, "metadata one")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic2, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(43L, "metadata two")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic3, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(44L, "metadata three")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic2, 1)), (Object)OffsetAndMetadata$.MODULE$.apply(45L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic1, 0)).get());
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 0)).get());
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic3, 0)).get());
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 1)).get());
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic1, 0), new TopicAndPartition(topic2, 0), new TopicAndPartition(topic3, 0), new TopicAndPartition(topic2, 1), new TopicAndPartition(topic3, 1), new TopicAndPartition(topic4, 0), new TopicAndPartition(topic5, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse = this.simpleConsumer().fetchOffsets(fetchRequest);
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get());
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get());
        Assert.assertEquals((Object)Errors.NONE, (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get());
        Assert.assertEquals((Object)"metadata one", (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).metadata());
        Assert.assertEquals((Object)"metadata two", (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).metadata());
        Assert.assertEquals((Object)"metadata three", (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).metadata());
        Assert.assertEquals((long)42L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).offset());
        Assert.assertEquals((long)43L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).offset());
        Assert.assertEquals((long)44L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).offset());
        Assert.assertEquals((long)45L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).offset());
        Assert.assertEquals((long)OffsetMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).offset());
        Assert.assertEquals((long)OffsetMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).offset());
        Assert.assertEquals((long)OffsetMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).offset());
    }

    @Test
    public void testLargeMetadataPayload() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("large-metadata", 0);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicAndPartition.topic(), (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        OffsetCommitRequest commitRequest = new OffsetCommitRequest("test-group", (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L, this.random().nextString(Predef$.MODULE$.Integer2int(this.server().config().offsetMetadataMaxSize()))))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)topicAndPartition).get());
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L, this.random().nextString(Predef$.MODULE$.Integer2int(this.server().config().offsetMetadataMaxSize()) + 1)))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse1 = this.simpleConsumer().commitOffsets(commitRequest1);
        Assert.assertEquals((Object)Errors.OFFSET_METADATA_TOO_LARGE, (Object)commitResponse1.commitStatus().get((Object)topicAndPartition).get());
    }

    @Test
    public void testOffsetExpiration() {
        String topic = "topic";
        TopicAndPartition topicPartition = new TopicAndPartition(topic, 0);
        ZkUtils x$41 = this.zkUtils();
        String x$42 = topic;
        Seq x$43 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$44 = 1;
        int x$45 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$46 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$41, x$42, x$44, x$45, (Seq<KafkaServer>)x$43, x$46);
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetCommitRequest commitRequest0 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(1L, "metadata"))})), 0, OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.simpleConsumer().commitOffsets(commitRequest0).commitStatus().get((Object)topicPartition).get());
        Assert.assertEquals((long)-1L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        OffsetFetchRequest offsetFetchReq = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), 0, OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse offsetFetchResp = this.simpleConsumer().fetchOffsets(offsetFetchReq);
        Assert.assertEquals((long)1L, (long)((OffsetMetadataAndError)offsetFetchResp.requestInfo().get((Object)topicPartition).get()).offset());
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(2L, "metadata", -1L))})), 1, OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.simpleConsumer().commitOffsets(commitRequest1).commitStatus().get((Object)topicPartition).get());
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)2L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        OffsetCommitRequest commitRequest2 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(3L, "metadata", Time.SYSTEM.milliseconds() - 172800000L))})), 1, OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.simpleConsumer().commitOffsets(commitRequest2).commitStatus().get((Object)topicPartition).get());
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)-1L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        String x$47 = this.group();
        scala.collection.immutable.Map x$48 = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(4L, "metadata", -1L))}));
        short x$49 = 2;
        long x$50 = 3600000L;
        int x$51 = OffsetCommitRequest$.MODULE$.apply$default$4();
        String x$52 = OffsetCommitRequest$.MODULE$.apply$default$5();
        int x$53 = OffsetCommitRequest$.MODULE$.apply$default$6();
        String x$54 = OffsetCommitRequest$.MODULE$.apply$default$7();
        OffsetCommitRequest commitRequest3 = new OffsetCommitRequest(x$47, x$48, x$49, x$51, x$52, x$53, x$54, x$50);
        Assert.assertEquals((Object)Errors.NONE, (Object)this.simpleConsumer().commitOffsets(commitRequest3).commitStatus().get((Object)topicPartition).get());
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)4L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        String x$55 = "test-group";
        scala.collection.immutable.Map x$56 = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(5L, "metadata", -1L))}));
        short x$57 = 2;
        long x$58 = 0L;
        int x$59 = OffsetCommitRequest$.MODULE$.apply$default$4();
        String x$60 = OffsetCommitRequest$.MODULE$.apply$default$5();
        int x$61 = OffsetCommitRequest$.MODULE$.apply$default$6();
        String x$62 = OffsetCommitRequest$.MODULE$.apply$default$7();
        OffsetCommitRequest commitRequest4 = new OffsetCommitRequest(x$55, x$56, x$57, x$59, x$60, x$61, x$62, x$58);
        Assert.assertEquals((Object)Errors.NONE, (Object)this.simpleConsumer().commitOffsets(commitRequest4).commitStatus().get((Object)topicPartition).get());
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)-1L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
    }

    @Test
    public void testNonExistingTopicOffsetCommit() {
        String topic1 = "topicDoesNotExists";
        String topic2 = "topic-2";
        ZkUtils x$63 = this.zkUtils();
        String x$64 = topic2;
        Seq x$65 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$66 = 1;
        int x$67 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$68 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$63, x$64, x$66, x$67, (Seq<KafkaServer>)x$65, x$68);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic1, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(42L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic2, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(42L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic1, 0)).get());
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 0)).get());
    }

    @Test
    public void testOffsetsDeleteAfterTopicDeletion() {
        String topic = "topic";
        TopicAndPartition topicPartition = new TopicAndPartition(topic, 0);
        ZkUtils x$69 = this.zkUtils();
        String x$70 = topic;
        Seq x$71 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$72 = 1;
        int x$73 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$74 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$69, x$70, x$72, x$73, (Seq<KafkaServer>)x$71, x$74);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((Object)Errors.NONE, (Object)commitResponse.commitStatus().get((Object)topicPartition).get());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        Thread.sleep(this.retentionCheckInterval() * 2L);
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse offsetMetadataAndErrorMap = this.simpleConsumer().fetchOffsets(fetchRequest);
        OffsetMetadataAndError offsetMetadataAndError = (OffsetMetadataAndError)offsetMetadataAndErrorMap.requestInfo().apply((Object)topicPartition);
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)offsetMetadataAndError);
    }

    public OffsetCommitTest() {
        this.group = "test-group";
        this.retentionCheckInterval = 100L;
    }
}

