/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import kafka.common.KafkaStorageException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r5d\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005)\u0011N\u001c3fqV\t\u0001\u0006\u0005\u0002*U5\t!!\u0003\u0002,\u0005\tYqJ\u001a4tKRLe\u000eZ3y\u0011!i\u0003A!A!\u0002\u0013A\u0013AB5oI\u0016D\b\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0003%!\u0018.\\3J]\u0012,\u00070F\u00012!\tI#'\u0003\u00024\u0005\tIA+[7f\u0013:$W\r\u001f\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005QA/[7f\u0013:$W\r\u001f\u0011\t\u0011]\u0002!Q1A\u0005\u0002a\n\u0001\u0002\u001e=o\u0013:$W\r_\u000b\u0002sA\u0011\u0011FO\u0005\u0003w\t\u0011\u0001\u0003\u0016:b]N\f7\r^5p]&sG-\u001a=\t\u0011u\u0002!\u0011!Q\u0001\ne\n\u0011\u0002\u001e=o\u0013:$W\r\u001f\u0011\t\u0011}\u0002!Q1A\u0005\u0002\u0001\u000b!BY1tK>3gm]3u+\u0005\t\u0005CA\u0005C\u0013\t\u0019%B\u0001\u0003M_:<\u0007\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u0017\t\f7/Z(gMN,G\u000f\t\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\u0006\u0011\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3t+\u0005I\u0005CA\u0005K\u0013\tY%BA\u0002J]RD\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006I!S\u0001\u0014S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000f\t\u0005\t\u001f\u0002\u0011)\u0019!C\u0001\u0001\u0006a!o\u001c7m\u0015&$H/\u001a:Ng\"A\u0011\u000b\u0001B\u0001B\u0003%\u0011)A\u0007s_2d'*\u001b;uKJl5\u000f\t\u0005\t'\u0002\u0011\t\u0011)A\u0005)\u0006!A/[7f!\t)v+D\u0001W\u0015\t\t\"$\u0003\u0002Y-\n!A+[7f\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\u0019a\u0014N\\5u}QIA,\u00180`A\u0006\u00147\r\u001a\t\u0003S\u0001AQaA-A\u0002YAQAJ-A\u0002!BQaL-A\u0002EBQaN-A\u0002eBQaP-A\u0002\u0005CQaR-A\u0002%CQaT-A\u0002\u0005CQaU-A\u0002QCqA\u001a\u0001A\u0002\u0013%\u0001)A\u0004de\u0016\fG/\u001a3\t\u000f!\u0004\u0001\u0019!C\u0005S\u0006Y1M]3bi\u0016$w\fJ3r)\tQW\u000e\u0005\u0002\nW&\u0011AN\u0003\u0002\u0005+:LG\u000fC\u0004oO\u0006\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007\u0003\u0004q\u0001\u0001\u0006K!Q\u0001\tGJ,\u0017\r^3eA!9!\u000f\u0001a\u0001\n\u0013A\u0015\u0001\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\"9A\u000f\u0001a\u0001\n\u0013)\u0018\u0001\b2zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss~#S-\u001d\u000b\u0003UZDqA\\:\u0002\u0002\u0003\u0007\u0011\n\u0003\u0004y\u0001\u0001\u0006K!S\u0001\u001aEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\b\u0005C\u0004{\u0001\u0001\u0007I\u0011B>\u0002+I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1naV\tA\u0010E\u0002\n{\u0006K!A \u0006\u0003\r=\u0003H/[8o\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019!A\rs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9`I\u0015\fHc\u00016\u0002\u0006!9an`A\u0001\u0002\u0004a\bbBA\u0005\u0001\u0001\u0006K\u0001`\u0001\u0017e>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7qA!A\u0011Q\u0002\u0001A\u0002\u0013%\u0001)A\tnCb$\u0016.\\3ti\u0006l\u0007oU8GCJD\u0011\"!\u0005\u0001\u0001\u0004%I!a\u0005\u0002+5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR\u0019!.!\u0006\t\u00119\fy!!AA\u0002\u0005Cq!!\u0007\u0001A\u0003&\u0011)\u0001\nnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003\u0006BA\f\u0003;\u00012!CA\u0010\u0013\r\t\tC\u0003\u0002\tm>d\u0017\r^5mK\"A\u0011Q\u0005\u0001A\u0002\u0013%\u0001)\u0001\u000bpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\n\u0003S\u0001\u0001\u0019!C\u0005\u0003W\t\u0001d\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u0004x\fJ3r)\rQ\u0017Q\u0006\u0005\t]\u0006\u001d\u0012\u0011!a\u0001\u0003\"9\u0011\u0011\u0007\u0001!B\u0013\t\u0015!F8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000f\t\u0015\u0005\u0003_\ti\u0002\u0003\u0004[\u0001\u0011\u0005\u0011q\u0007\u000b\u00149\u0006e\u0012QJA)\u0003'\n9&!\u0017\u0002\\\u0005\u0015\u0014\u0011\u000e\u0005\t\u0003w\t)\u00041\u0001\u0002>\u0005\u0019A-\u001b:\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u000f\nAA[1wC&!\u00111JA!\u0005\u00111\u0015\u000e\\3\t\u000f\u0005=\u0013Q\u0007a\u0001\u0003\u0006Y1\u000f^1si>3gm]3u\u0011\u00199\u0015Q\u0007a\u0001\u0013\"9\u0011QKA\u001b\u0001\u0004I\u0015\u0001D7bq&sG-\u001a=TSj,\u0007BB(\u00026\u0001\u0007\u0011\t\u0003\u0004T\u0003k\u0001\r\u0001\u0016\u0005\u000b\u0003;\n)\u0004%AA\u0002\u0005}\u0013!\u00054jY\u0016\fEN]3bIf,\u00050[:ugB\u0019\u0011\"!\u0019\n\u0007\u0005\r$BA\u0004C_>dW-\u00198\t\u0013\u0005\u001d\u0014Q\u0007I\u0001\u0002\u0004I\u0015\u0001D5oSR4\u0015\u000e\\3TSj,\u0007BCA6\u0003k\u0001\n\u00111\u0001\u0002`\u0005Y\u0001O]3bY2|7-\u0019;f\u0011\u0019\ty\u0007\u0001C\u0001\u0011\u0006!1/\u001b>f\u0011\u001d\t\u0019\b\u0001C\u0001\u0003k\n!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$B!a\u0018\u0002x!9\u0011\u0011PA9\u0001\u0004\t\u0015AB8gMN,G\u000fC\u0004\u0002~\u0001!\t!a \u0002\r\u0005\u0004\b/\u001a8e)-Q\u0017\u0011QAC\u0003\u0013\u000bi)!%\t\u000f\u0005\r\u00151\u0010a\u0001\u0003\u0006Ya-\u001b:ti>3gm]3u\u0011\u001d\t9)a\u001fA\u0002\u0005\u000bQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bbBAF\u0003w\u0002\r!Q\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDq!a$\u0002|\u0001\u0007\u0011)A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\t\u0003'\u000bY\b1\u0001\u0002\u0016\u00069!/Z2pe\u0012\u001c\bcA\f\u0002\u0018&\u0019\u0011\u0011\u0014\r\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3tQ\u0011\tY(!(\u0011\u0007=\ty*C\u0002\u0002\"B\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007bBAS\u0001\u0011\u0005\u0011qU\u0001\u000fkB$\u0017\r^3Uq:Le\u000eZ3y)\u0015Q\u0017\u0011VAZ\u0011!\tY+a)A\u0002\u00055\u0016\u0001D2p[BdW\r^3e)bt\u0007cA\u0015\u00020&\u0019\u0011\u0011\u0017\u0002\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\u0005U\u00161\u0015a\u0001\u0003\u0006\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0005\u0003G\u000bi\nC\u0004\u0002<\u0002!I!!0\u0002'U\u0004H-\u0019;f!J|G-^2feN#\u0018\r^3\u0015\u000b)\fy,!3\t\u0011\u0005\u0005\u0017\u0011\u0018a\u0001\u0003\u0007\fA\u0003\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\bcA\u0015\u0002F&\u0019\u0011q\u0019\u0002\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0011!\tY-!/A\u0002\u00055\u0017!\u00022bi\u000eD\u0007cA\f\u0002P&\u0019\u0011\u0011\u001b\r\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\t\u0003+\u0004A\u0011\u0001\u0002\u0002X\u0006yAO]1og2\fG/Z(gMN,G\u000f\u0006\u0004\u0002Z\n\u0005!1\u0001\t\u0005\u00037\fYP\u0004\u0003\u0002^\u0006]h\u0002BAp\u0003ktA!!9\u0002t:!\u00111]Ay\u001d\u0011\t)/a<\u000f\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;\u0007\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002\u001f?%\u0011Q!H\u0005\u00037qI!!\u0007\u000e\n\u0007\u0005e\b$A\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0002BA\u007f\u0003\u007f\u0014\u0011\u0003T8h\u001f\u001a47/\u001a;Q_NLG/[8o\u0015\r\tI\u0010\u0007\u0005\b\u0003s\n\u0019\u000e1\u0001B\u0011%\u0011)!a5\u0011\u0002\u0003\u0007\u0011*\u0001\u000bti\u0006\u0014H/\u001b8h\r&dW\rU8tSRLwN\u001c\u0015\u0005\u0003'\u0014I\u0001E\u0002\u0010\u0005\u0017I1A!\u0004\u0011\u0005)!\bN]3bIN\fg-\u001a\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0003\u0011\u0011X-\u00193\u0015\u0019\tU!\u0011\u0005B\u0012\u0005O\u0011YCa\f\u0011\t\t]!QD\u0007\u0003\u00053Q1Aa\u0007\u0005\u0003\u0019\u0019XM\u001d<fe&!!q\u0004B\r\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"9\u0011q\nB\b\u0001\u0004\t\u0005b\u0002B\u0013\u0005\u001f\u0001\r\u0001`\u0001\n[\u0006DxJ\u001a4tKRDqA!\u000b\u0003\u0010\u0001\u0007\u0011*A\u0004nCb\u001c\u0016N_3\t\u0013\t5\"q\u0002I\u0001\u0002\u0004\t\u0015aC7bqB{7/\u001b;j_:D!B!\r\u0003\u0010A\u0005\t\u0019AA0\u00035i\u0017N\\(oK6+7o]1hK\"\"!q\u0002B\u0005\u0011\u001d\u00119\u0004\u0001C\u0001\u0005s\tQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000fF\u0003}\u0005w\u0011)\u0005\u0003\u0005\u0003>\tU\u0002\u0019\u0001B \u0003M\u0019H/\u0019:u\u001f\u001a47/\u001a;Q_NLG/[8o!\rI#\u0011I\u0005\u0004\u0005\u0007\u0012!AD(gMN,G\u000fU8tSRLwN\u001c\u0005\b\u0005\u000f\u0012)\u00041\u0001J\u0003%1W\r^2i'&TX\rC\u0004\u0003L\u0001!\tA!\u0014\u0002\u000fI,7m\u001c<feR)\u0011Ja\u0014\u0003R!A\u0011\u0011\u0019B%\u0001\u0004\t\u0019\r\u0003\u0006\u0003T\t%\u0003\u0013!a\u0001\u0005+\n\u0001\u0003\\3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3\u0011\t%i(q\u000b\t\u0005\u00053\u0012y&\u0004\u0002\u0003\\)!!Q\fB\r\u0003\u0015)\u0007o\\2i\u0013\u0011\u0011\tGa\u0017\u0003!1+\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007\u0006\u0002B%\u0003;CqAa\u001a\u0001\t\u0013\u0011I'\u0001\u000bm_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e\u001d\u000b\u0002U\"9!Q\u000e\u0001\u0005\u0002\t=\u0014AE2pY2,7\r^!c_J$X\r\u001a+y]N$bA!\u001d\u0003x\tm\u0004cA\u0015\u0003t%\u0019!Q\u000f\u0002\u0003)QCh.\u00138eKb\u001cV-\u0019:dQJ+7/\u001e7u\u0011\u001d\u0011IHa\u001bA\u0002\u0005\u000b1BZ3uG\"|eMZ:fi\"9!Q\u0010B6\u0001\u0004\t\u0015\u0001E;qa\u0016\u0014(i\\;oI>3gm]3u\u0011\u001d\u0011\t\t\u0001C!\u0005\u0007\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000b\u0003BAa\"\u0003\u000e6\u0011!\u0011\u0012\u0006\u0005\u0005\u0017\u000b)%\u0001\u0003mC:<\u0017\u0002\u0002BH\u0005\u0013\u0013aa\u0015;sS:<\u0007b\u0002BJ\u0001\u0011\u0005!QS\u0001\u000biJ,hnY1uKR{GcA%\u0003\u0018\"9\u0011\u0011\u0010BI\u0001\u0004\t\u0005\u0006\u0002BI\u0003;CqA!(\u0001\t\u0003\u0011y*\u0001\u0006oKb$xJ\u001a4tKR$\u0012!\u0011\u0015\u0005\u00057\u0013I\u0001C\u0004\u0003&\u0002!\tA!\u001b\u0002\u000b\u0019dWo\u001d5)\t\t\r&\u0011\u0002\u0005\b\u0005W\u0003A\u0011\u0001BW\u0003%)\b\u000fZ1uK\u0012K'\u000fF\u0002k\u0005_C\u0001\"a\u000f\u0003*\u0002\u0007\u0011Q\b\u0005\b\u0005g\u0003A\u0011\u0001B[\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\u000b)\u00149La2\t\u0011\te&\u0011\u0017a\u0001\u0005w\u000b\u0011b\u001c7e'V4g-\u001b=\u0011\t\tu&1\u0019\b\u0004\u0013\t}\u0016b\u0001Ba\u0015\u00051\u0001K]3eK\u001aLAAa$\u0003F*\u0019!\u0011\u0019\u0006\t\u0011\t%'\u0011\u0017a\u0001\u0005w\u000b\u0011B\\3x'V4g-\u001b=\t\u000f\t5\u0007\u0001\"\u0001\u0003j\u00059rN\u001c\"fG>lW-\u00138bGRLg/Z*fO6,g\u000e\u001e\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0003E!\u0018.\\3XC&$X\r\u001a$peJ{G\u000e\u001c\u000b\u0006\u0003\nU'\u0011\u001c\u0005\b\u0005/\u0014y\r1\u0001B\u0003\rqwn\u001e\u0005\b\u00057\u0014y\r1\u0001B\u0003AiWm]:bO\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0003`\u0002!\tA!9\u0002+\u0019Lg\u000eZ(gMN,GOQ=US6,7\u000f^1naR1!1\u001dBv\u0005_\u0004B!C?\u0003fB\u0019\u0011Fa:\n\u0007\t%(AA\bUS6,7\u000f^1na>3gm]3u\u0011\u001d\u0011iO!8A\u0002\u0005\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u0013\tE(Q\u001cI\u0001\u0002\u0004\t\u0015AD:uCJ$\u0018N\\4PM\u001a\u001cX\r\u001e\u0005\b\u0005k\u0004A\u0011\u0001B5\u0003\u0015\u0019Gn\\:f\u0011\u001d\u0011I\u0010\u0001C\u0001\u0005S\na\u0001Z3mKR,\u0007B\u0002B\u007f\u0001\u0011\u0005\u0001)\u0001\u0007mCN$Xj\u001c3jM&,G\r\u0003\u0004\u0002\f\u0002!\t\u0001\u0011\u0005\b\u0007\u0007\u0001A\u0011AB\u0003\u0003Aa\u0017m\u001d;N_\u0012Lg-[3e?\u0012*\u0017\u000f\u0006\u0003\u0004\b\r]\u0001\u0003BB\u0005\u0007'i!aa\u0003\u000b\t\r51qB\u0001\u0005M&dWM\u0003\u0003\u0004\u0012\u0005\u0015\u0013a\u00018j_&!1QCB\u0006\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\re1\u0011\u0001a\u0001\u0003\u0006\u0011Qn\u001d\u0005\n\u0007;\u0001\u0011\u0013!C\u0001\u0007?\taB]3bI\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\")\u001a\u0011ia\t,\u0005\r\u0015\u0002\u0003BB\u0014\u0007ci!a!\u000b\u000b\t\r-2QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\f\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007g\u0019ICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba\u000e\u0001#\u0003%\ta!\u000f\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u001111\b\u0016\u0005\u0003?\u001a\u0019\u0003C\u0005\u0004@\u0001\t\n\u0011\"\u0001\u0004B\u0005\t\"/Z2pm\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\r#\u0006\u0002B+\u0007GA\u0011ba\u0012\u0001#\u0003%\ta!\u0013\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0007\u0017R3!SB\u0012\u0011%\u0019y\u0005AI\u0001\n\u0003\u0019y\"A\u0010gS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9%I\u00164\u0017-\u001e7uIIB3\u0001AAO\u000f%\u0019)FAA\u0001\u0012\u0003\u00199&\u0001\u0006M_\u001e\u001cVmZ7f]R\u00042!KB-\r!\t!!!A\t\u0002\rm3cAB-\u0011!9!l!\u0017\u0005\u0002\r}CCAB,\u0011)\u0019\u0019g!\u0017\u0012\u0002\u0013\u00051\u0011H\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\t\u0015\r\u001d4\u0011LI\u0001\n\u0003\u0019I%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0007W\u001aI&%A\u0005\u0002\re\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\b")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final OffsetIndex index;
    private final TimeIndex timeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long kafka$log$LogSegment$$maxTimestampSoFar;
    private volatile long kafka$log$LogSegment$$offsetOfMaxTimestamp;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return LogSegment$.MODULE$.$lessinit$greater$default$9();
    }

    public static int $lessinit$greater$default$8() {
        return LogSegment$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return LogSegment$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileRecords log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    public long kafka$log$LogSegment$$maxTimestampSoFar() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar;
    }

    public void kafka$log$LogSegment$$maxTimestampSoFar_$eq(long x$1) {
        this.kafka$log$LogSegment$$maxTimestampSoFar = x$1;
    }

    public long kafka$log$LogSegment$$offsetOfMaxTimestamp() {
        return this.kafka$log$LogSegment$$offsetOfMaxTimestamp;
    }

    public void kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(long x$1) {
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = x$1;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset2) {
        return offset2 - this.baseOffset() <= Integer.MAX_VALUE;
    }

    public void append(long firstOffset, long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, firstOffset, largestTimestamp, shallowOffsetOfMaxTimestamp, records){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long firstOffset$1;
                private final long largestTimestamp$1;
                private final long shallowOffsetOfMaxTimestamp$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d with largest timestamp %d at shallow offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.firstOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes()), BoxesRunTime.boxToLong((long)this.largestTimestamp$1), BoxesRunTime.boxToLong((long)this.shallowOffsetOfMaxTimestamp$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.firstOffset$1 = firstOffset$1;
                    this.largestTimestamp$1 = largestTimestamp$1;
                    this.shallowOffsetOfMaxTimestamp$1 = shallowOffsetOfMaxTimestamp$1;
                    this.records$1 = records$1;
                }
            });
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            Predef$.MODULE$.require(this.canConvertToRelativeOffset(largestOffset), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "largest offset in message set can not be safely converted to relative offset.";
                }
            });
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)new Serializable(this, firstOffset, appendedBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long firstOffset$1;
                private final int appendedBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appended ", " to ", " at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.appendedBytes$1), this.$outer.log().file(), BoxesRunTime.boxToLong((long)this.firstOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.firstOffset$1 = firstOffset$1;
                    this.appendedBytes$1 = appendedBytes$1;
                }
            });
            if (largestTimestamp > this.kafka$log$LogSegment$$maxTimestampSoFar()) {
                this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(largestTimestamp);
                this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(firstOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset2) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)new Serializable(this, completedTxn, lastStableOffset2){
                public static final long serialVersionUID = 0L;
                private final CompletedTxn completedTxn$1;
                private final long lastStableOffset$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing aborted transaction ", " to transaction index, last stable offset is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.completedTxn$1, BoxesRunTime.boxToLong((long)this.lastStableOffset$1)}));
                }
                {
                    this.completedTxn$1 = completedTxn$1;
                    this.lastStableOffset$1 = lastStableOffset$1;
                }
            });
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset2));
        }
    }

    public void kafka$log$LogSegment$$updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1)new Serializable(this, producerStateManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$2;

                public final void apply(CompletedTxn completedTxn) {
                    long lastStableOffset2 = this.producerStateManager$2.completeTxn(completedTxn);
                    this.$outer.updateTxnIndex(completedTxn, lastStableOffset2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$2 = producerStateManager$2;
                }
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset2, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset2);
        return this.log().searchForOffsetWithSize(offset2, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Option<Object> option;
        block9: {
            int n;
            int adjustedMaxSize;
            LogOffsetMetadata offsetMetadata;
            int startPosition;
            FileRecords.LogOffsetPosition startOffsetAndSize;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    logSize = this.log().sizeInBytes();
                    startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startOffsetAndSize == null) {
                        return null;
                    }
                    startPosition = startOffsetAndSize.position;
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
                    int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
                    if (adjustedMaxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
                    }
                    option = maxOffset;
                    if (!None$.MODULE$.equals(option)) break block7;
                    n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset2 = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset2 < startOffset) {
                    return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
                }
                FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, startPosition);
                int endPosition = mapping == null ? logSize : mapping.position;
                n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
            }
            int fetchSize = n;
            return new FetchDataInfo(offsetMetadata, (Records)this.log().read(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
        }
        throw new MatchError(option);
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.index().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetPosition x$1) {
                return x$1.offset();
            }
        });
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochCache> leaderEpochCache) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().truncate();
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        this.txnIndex().truncate();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1)new Serializable(this, producerStateManager, leaderEpochCache, validBytes, lastIndexEntry){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$1;
                private final Option leaderEpochCache$1;
                private final IntRef validBytes$1;
                private final IntRef lastIndexEntry$1;

                public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                    batch.ensureValid();
                    if (batch.maxTimestamp() > this.$outer.kafka$log$LogSegment$$maxTimestampSoFar()) {
                        this.$outer.kafka$log$LogSegment$$maxTimestampSoFar_$eq(batch.maxTimestamp());
                        this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(batch.lastOffset());
                    }
                    if (this.validBytes$1.elem - this.lastIndexEntry$1.elem > this.$outer.indexIntervalBytes()) {
                        long startOffset = batch.baseOffset();
                        this.$outer.index().append(startOffset, this.validBytes$1.elem);
                        this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.$outer.timeIndex().maybeAppend$default$3());
                        this.lastIndexEntry$1.elem = this.validBytes$1.elem;
                    }
                    this.validBytes$1.elem += batch.sizeInBytes();
                    if (batch.magic() >= 2) {
                        this.leaderEpochCache$1.foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(LeaderEpochCache cache) {
                                if (this.batch$1.partitionLeaderEpoch() > cache.latestEpoch()) {
                                    cache.assign(this.batch$1.partitionLeaderEpoch(), this.batch$1.baseOffset());
                                }
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                        this.$outer.kafka$log$LogSegment$$updateProducerState(this.producerStateManager$1, (RecordBatch)batch);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$1 = producerStateManager$1;
                    this.leaderEpochCache$1 = leaderEpochCache$1;
                    this.validBytes$1 = validBytes$1;
                    this.lastIndexEntry$1 = lastIndexEntry$1;
                }
            });
        }
        catch (CorruptRecordException corruptRecordException) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes.elem), corruptRecordException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.logger().debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated ", " invalid bytes at the end of segment ", " during recovery"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)truncated), this.log().file().getAbsoluteFile()})));
        }
        this.log().truncateTo(validBytes.elem);
        this.index().trimToValidSize();
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.index().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset2) {
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset2);
        this.timeIndex().truncateTo(offset2);
        this.txnIndex().truncateTo(offset2);
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long nextOffset() {
        FetchDataInfo ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return ms == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms.records().batches()).asScala()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RecordBatch x$2) {
                return x$2.nextOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.baseOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
                this.$outer.timeIndex().flush();
                this.$outer.txnIndex().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.index().file_$eq(new File(dir, this.index().file().getName()));
        this.timeIndex().file_$eq(new File(dir, this.timeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        try {
            this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("log", iOException, oldSuffix, newSuffix);
        }
        try {
            this.index().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("index", iOException, oldSuffix, newSuffix);
        }
        try {
            this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("timeindex", iOException, oldSuffix, newSuffix);
        }
        try {
            this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
            return;
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("txnindex", iOException, oldSuffix, newSuffix);
        }
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp2, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp2);
        int position = this.index().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp2, position, startingOffset)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TimestampOffset apply(FileRecords.TimestampAndOffset timestampAndOffset) {
                return new TimestampOffset(timestampAndOffset.timestamp, timestampAndOffset.offset);
            }
        });
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        boolean deletedTimeIndex = this.timeIndex().delete();
        boolean deletedTxnIndex = this.txnIndex().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedTimeIndex && this.timeIndex().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of time index ").append((Object)this.timeIndex().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedTxnIndex && this.txnIndex().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of transaction index ").append((Object)this.txnIndex().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L ? this.kafka$log$LogSegment$$maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.index().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.timeIndex().file().toPath(), fileTime);
    }

    private final KafkaStorageException kafkaStorageException$1(String fileType, IOException e, String oldSuffix$1, String newSuffix$1) {
        return new KafkaStorageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change the ", " file suffix from ", " to ", " for log segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, oldSuffix$1, newSuffix$1, BoxesRunTime.boxToLong((long)this.baseOffset())})), e);
    }

    public LogSegment(FileRecords log, OffsetIndex index, TimeIndex timeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.index = index;
        this.timeIndex = timeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.kafka$log$LogSegment$$maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(FileRecords.open((File)Log$.MODULE$.logFile(dir, startOffset), (boolean)fileAlreadyExists, (int)initFileSize, (boolean)preallocate), new OffsetIndex(Log$.MODULE$.offsetIndexFile(dir, startOffset), startOffset, maxIndexSize, OffsetIndex$.MODULE$.$lessinit$greater$default$4()), new TimeIndex(Log$.MODULE$.timeIndexFile(dir, startOffset), startOffset, maxIndexSize, TimeIndex$.MODULE$.$lessinit$greater$default$4()), new TransactionIndex(startOffset, Log$.MODULE$.transactionIndexFile(dir, startOffset)), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

