/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t}h!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0003\u001d\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u0011\u001b\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011I\u0001!Q1A\u0005\u0002Q\t!!\u001b3\u0004\u0001U\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0002J]RD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\tQLW.\u001a\t\u0003A)j\u0011!\t\u0006\u0003E\r\nQ!\u001e;jYNT!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t)aE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005\u0011!\u0016.\\3\t\u00115\u0002!\u0011!Q\u0001\nU\ta\"\\1y%\u0016\fX/Z:u'&TX\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001C\u0019\n\u0005I\u0012!A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u0011YJ!a\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\t12(\u0003\u0002=/\t!Aj\u001c8h\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u0001!C\u001b\u0005\t%BA\u0002$\u0013\t\u0019\u0015I\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0002H\u00156\t\u0001J\u0003\u0002JG\u0005A\u0001O]8u_\u000e|G.\u0003\u0002L\u0011\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u000611m\u001c8gS\u001e\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0006KA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003\b\u0001\u0005\u0003\u0005\u000b\u0011B+\u0011\u0005YCV\"A,\u000b\u00059\u0019\u0013BA-X\u0005\u001diU\r\u001e:jGND\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001X\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0002^A6\taL\u0003\u0002`\t\u0005A1/Z2ve&$\u00180\u0003\u0002b=\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003\u0019a\u0014N\\5u}QaQMZ4iS*\\G.\u001c8paB\u0011\u0001\u0002\u0001\u0005\u0006%\t\u0004\r!\u0006\u0005\u0006=\t\u0004\ra\b\u0005\u0006[\t\u0004\r!\u0006\u0005\u0006_\t\u0004\r\u0001\r\u0005\u0006i\t\u0004\r!\u000e\u0005\u0006s\t\u0004\rA\u000f\u0005\u0006}\t\u0004\ra\u0010\u0005\u0006\u000b\n\u0004\rA\u0012\u0005\u0006\u001b\n\u0004\rA\u0014\u0005\u0006\u001d\t\u0004\r!\u0016\u0005\u00067\n\u0004\r\u0001X\u0004\u0006e\u0002AIa]\u0001\r\u0007>tg.Z2uS>t\u0017\n\u001a\t\u0003iVl\u0011\u0001\u0001\u0004\u0006m\u0002AIa\u001e\u0002\r\u0007>tg.Z2uS>t\u0017\nZ\n\u0004kb\\\bC\u0001\fz\u0013\tQxC\u0001\u0004B]f\u0014VM\u001a\t\u0003-qL!!`\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\r,H\u0011A@\u0015\u0003MDq!a\u0001v\t\u0003\t)!\u0001\u0006ge>l7\u000b\u001e:j]\u001e$B!a\u0002\u0002jB)a#!\u0003\u0002\u000e%\u0019\u00111B\f\u0003\r=\u0003H/[8o!\r!\u0018q\u0002\u0004\u0006m\u0002!\u0015\u0011C\n\u0007\u0003\u001fA\u00181C>\u0011\u0007Y\t)\"C\u0002\u0002\u0018]\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002\u001c\u0005=!Q3A\u0005\u0002\u0005u\u0011!\u00037pG\u0006d\u0007j\\:u+\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dbb\u0001\f\u0002$%\u0019\u0011QE\f\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)c\u0006\u0005\f\u0003_\tyA!E!\u0002\u0013\ty\"\u0001\u0006m_\u000e\fG\u000eS8ti\u0002B!\"a\r\u0002\u0010\tU\r\u0011\"\u0001\u0015\u0003%awnY1m!>\u0014H\u000f\u0003\u0006\u00028\u0005=!\u0011#Q\u0001\nU\t!\u0002\\8dC2\u0004vN\u001d;!\u0011-\tY$a\u0004\u0003\u0016\u0004%\t!!\b\u0002\u0015I,Wn\u001c;f\u0011>\u001cH\u000fC\u0006\u0002@\u0005=!\u0011#Q\u0001\n\u0005}\u0011a\u0003:f[>$X\rS8ti\u0002B!\"a\u0011\u0002\u0010\tU\r\u0011\"\u0001\u0015\u0003)\u0011X-\\8uKB{'\u000f\u001e\u0005\u000b\u0003\u000f\nyA!E!\u0002\u0013)\u0012a\u0003:f[>$X\rU8si\u0002BqaYA\b\t\u0003\tY\u0005\u0006\u0006\u0002\u000e\u00055\u0013qJA)\u0003'B\u0001\"a\u0007\u0002J\u0001\u0007\u0011q\u0004\u0005\b\u0003g\tI\u00051\u0001\u0016\u0011!\tY$!\u0013A\u0002\u0005}\u0001bBA\"\u0003\u0013\u0002\r!\u0006\u0005\t\u0003/\ny\u0001\"\u0011\u0002Z\u0005AAo\\*ue&tw\r\u0006\u0002\u0002 !Q\u0011QLA\b\u0003\u0003%\t!a\u0018\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003\u001b\t\t'a\u0019\u0002f\u0005\u001d\u0004BCA\u000e\u00037\u0002\n\u00111\u0001\u0002 !I\u00111GA.!\u0003\u0005\r!\u0006\u0005\u000b\u0003w\tY\u0006%AA\u0002\u0005}\u0001\"CA\"\u00037\u0002\n\u00111\u0001\u0016\u0011)\tY'a\u0004\u0012\u0002\u0013\u0005\u0011QN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyG\u000b\u0003\u0002 \u0005E4FAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ut#\u0001\u0006b]:|G/\u0019;j_:LA!!!\u0002x\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0015\u0015qBI\u0001\n\u0003\t9)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%%fA\u000b\u0002r!Q\u0011QRA\b#\u0003%\t!!\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011\u0011SA\b#\u0003%\t!a\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!Q\u0011QSA\b\u0003\u0003%\t%a&\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\t1\fgn\u001a\u0006\u0003\u0003G\u000bAA[1wC&!\u0011\u0011FAO\u0011%\tI+a\u0004\u0002\u0002\u0013\u0005A#\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0002.\u0006=\u0011\u0011!C\u0001\u0003_\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00022\u0006]\u0006c\u0001\f\u00024&\u0019\u0011QW\f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002:\u0006-\u0016\u0011!a\u0001+\u0005\u0019\u0001\u0010J\u0019\t\u0015\u0005u\u0016qBA\u0001\n\u0003\ny,A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\r\u0005\u0004\u0002D\u0006%\u0017\u0011W\u0007\u0003\u0003\u000bT1!a2\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\f)M\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\ty-a\u0004\u0002\u0002\u0013\u0005\u0011\u0011[\u0001\tG\u0006tW)];bYR!\u00111[Am!\r1\u0012Q[\u0005\u0004\u0003/<\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003s\u000bi-!AA\u0002\u0005E\u0006BCAo\u0003\u001f\t\t\u0011\"\u0011\u0002`\u0006A\u0001.Y:i\u0007>$W\rF\u0001\u0016\u0011)\t\u0019/a\u0004\u0002\u0002\u0013\u0005\u0013Q]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0017q\u001d\u0005\u000b\u0003s\u000b\t/!AA\u0002\u0005E\u0006\u0002CAv\u0003\u0003\u0001\r!a\b\u0002\u0003MD\u0011\"a<v\u0003\u0003%\t)!=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u00055\u00111_A{\u0003o\fI\u0010\u0003\u0005\u0002\u001c\u00055\b\u0019AA\u0010\u0011\u001d\t\u0019$!<A\u0002UA\u0001\"a\u000f\u0002n\u0002\u0007\u0011q\u0004\u0005\b\u0003\u0007\ni\u000f1\u0001\u0016\u0011%\ti0^A\u0001\n\u0003\u000by0A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005!\u0011\u0002\t\u0006-\u0005%!1\u0001\t\n-\t\u0015\u0011qD\u000b\u0002 UI1Aa\u0002\u0018\u0005\u0019!V\u000f\u001d7fi!Q!1BA~\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0003\u0007C\u0005\u0003\u0010\u0001\u0011\r\u0011\"\u0003\u0003\u0012\u0005qa.Z<D_:tWm\u0019;j_:\u001cXC\u0001B\n!\u0019\u0011)Ba\b\u0003$5\u0011!q\u0003\u0006\u0005\u00053\u0011Y\"\u0001\u0006d_:\u001cWO\u001d:f]RTAA!\b\u0002\"\u0006!Q\u000f^5m\u0013\u0011\u0011\tCa\u0006\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB!!Q\u0005B\u0018\u001b\t\u00119C\u0003\u0003\u0003*\t-\u0012\u0001C2iC:tW\r\\:\u000b\t\t5\u0012\u0011U\u0001\u0004]&|\u0017\u0002\u0002B\u0019\u0005O\u0011QbU8dW\u0016$8\t[1o]\u0016d\u0007\u0002\u0003B\u001b\u0001\u0001\u0006IAa\u0005\u0002\u001f9,woQ8o]\u0016\u001cG/[8og\u0002B\u0011B!\u000f\u0001\u0005\u0004%IAa\u000f\u0002#%tg\r\\5hQR\u0014Vm\u001d9p]N,7/\u0006\u0002\u0003>AA!q\bB#\u0003?\u0011I%\u0004\u0002\u0003B)!!1IAc\u0003\u001diW\u000f^1cY\u0016LAAa\u0012\u0003B\t\u0019Q*\u00199\u0011\t\t-#\u0011\u000b\b\u0004\u0011\t5\u0013b\u0001B(\u0005\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002\u0002B*\u0005+\u0012\u0001BU3ta>t7/\u001a\u0006\u0004\u0005\u001f\u0012\u0001\u0002\u0003B-\u0001\u0001\u0006IA!\u0010\u0002%%tg\r\\5hQR\u0014Vm\u001d9p]N,7\u000f\t\u0005\u000b\u0005;\u0002!\u0019!C\u0001\t\t}\u0013AC7fiJL7\rV1hgV\u0011!\u0011\r\t\t\u0005G\u0012)'!'\u0002\u001a6\u0011!1D\u0005\u0005\u0005\u000f\u0012Y\u0002\u0003\u0005\u0003j\u0001\u0001\u000b\u0011\u0002B1\u0003-iW\r\u001e:jGR\u000bwm\u001d\u0011\t\u0013\t5\u0004A1A\u0005\n\t=\u0014\u0001C:fY\u0016\u001cGo\u001c:\u0016\u0005\tE\u0004c\u0001!\u0003t%\u0019!QO!\u0003\u0011M+G.Z2u_JD\u0001B!\u001f\u0001A\u0003%!\u0011O\u0001\ng\u0016dWm\u0019;pe\u0002BqA! \u0001\t\u0003\u0012y(A\u0002sk:$\"A!!\u0011\u0007Y\u0011\u0019)C\u0002\u0003\u0006^\u0011A!\u00168ji\"9!\u0011\u0012\u0001\u0005\n\t}\u0014a\u00059s_\u000e,7o\u001d(foJ+7\u000f]8og\u0016\u001c\b\u0002\u0003BG\u0001\u0011E!Aa$\u0002\u0019M,g\u000e\u001a*fgB|gn]3\u0015\r\t\u0005%\u0011\u0013BK\u0011!\u0011\u0019Ja#A\u0002\t%\u0013\u0001\u0003:fgB|gn]3\t\u0011\t]%1\u0012a\u0001\u00053\u000bAB]3ta>t7/Z*f]\u0012\u00042\u0001\u0011BN\u0013\r\u0011i*\u0011\u0002\u0005'\u0016tG\rC\u0004\u0003\"\u0002!IAa \u0002\tA|G\u000e\u001c\u0005\b\u0005K\u0003A\u0011\u0002B@\u0003a\u0001(o\\2fgN\u001cu.\u001c9mKR,GMU3dK&4Xm\u001d\u0005\b\u0005S\u0003A\u0011\u0002B@\u0003U\u0001(o\\2fgN\u001cu.\u001c9mKR,GmU3oINDqA!,\u0001\t\u0013\u0011y+\u0001\u000bva\u0012\fG/\u001a*fcV,7\u000f^'fiJL7m\u001d\u000b\u0005\u0005\u0003\u0013\t\f\u0003\u0005\u00034\n-\u0006\u0019\u0001B[\u0003\u001d\u0011X-];fgR\u0004BAa\u0013\u00038&!!\u0011\u0018B+\u0005\u001d\u0011V-];fgRDqA!0\u0001\t\u0013\u0011y(A\nqe>\u001cWm]:ESN\u001cwN\u001c8fGR,G\rC\u0004\u0003B\u0002!\tAa1\u0002\r\u0005\u001c7-\u001a9u)\u0011\u0011\tI!2\t\u0011\t\u001d'q\u0018a\u0001\u0005G\tQb]8dW\u0016$8\t[1o]\u0016d\u0007b\u0002Bf\u0001\u0011%!qP\u0001\u0018G>tg-[4ve\u0016tUm^\"p]:,7\r^5p]NDqAa4\u0001\t\u0013\u0011y(\u0001\u0005dY>\u001cX-\u00117m\u0011!\u0011\u0019\u000e\u0001C\u0001\u0005\tU\u0017aB2iC:tW\r\u001c\u000b\u0005\u0005/\u0014y\u000eE\u0003\u0017\u0003\u0013\u0011I\u000eE\u0002A\u00057L1A!8B\u00051Y\u0015MZ6b\u0007\"\fgN\\3m\u0011!\u0011\tO!5A\u0002\u0005}\u0011\u0001D2p]:,7\r^5p]&#\u0007\u0002\u0003Bs\u0001\u0011\u0005!Aa:\u0002)=\u0004XM\\(s\u00072|7/\u001b8h\u0007\"\fgN\\3m)\u0011\u00119N!;\t\u0011\t\u0005(1\u001da\u0001\u0003?A\u0001B!<\u0001\t\u0003\u0011!q^\u0001\u0012]Vl7\u000b^1hK\u0012\u0014VmY3jm\u0016\u001cHcA\u000b\u0003r\"A!\u0011\u001dBv\u0001\u0004\ty\u0002C\u0004\u0003v\u0002!\tAa \u0002\r]\f7.Z;qQ\u0011\u0011\u0019P!?\u0011\t\u0005m%1`\u0005\u0005\u0005{\fiJ\u0001\u0005Pm\u0016\u0014(/\u001b3f\u0001")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final int id;
    public final Time kafka$network$Processor$$time;
    public final RequestChannel kafka$network$Processor$$requestChannel;
    public final ConnectionQuotas kafka$network$Processor$$connectionQuotas;
    public final ListenerName kafka$network$Processor$$listenerName;
    public final SecurityProtocol kafka$network$Processor$$securityProtocol;
    public final Metrics kafka$network$Processor$$metrics;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> kafka$network$Processor$$inflightResponses;
    private final java.util.Map<String, String> metricTags;
    private final Selector kafka$network$Processor$$selector;
    private volatile Processor$ConnectionId$ kafka$network$Processor$$ConnectionId$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Processor$ConnectionId$ kafka$network$Processor$$ConnectionId$lzycompute() {
        Processor processor = this;
        synchronized (processor) {
            if (this.kafka$network$Processor$$ConnectionId$module != null) return this.kafka$network$Processor$$ConnectionId$module;
            this.kafka$network$Processor$$ConnectionId$module = new Processor$ConnectionId$(this);
            return this.kafka$network$Processor$$ConnectionId$module;
        }
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    public int id() {
        return this.id;
    }

    public Processor$ConnectionId$ kafka$network$Processor$$ConnectionId() {
        return this.kafka$network$Processor$$ConnectionId$module == null ? this.kafka$network$Processor$$ConnectionId$lzycompute() : this.kafka$network$Processor$$ConnectionId$module;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    public scala.collection.mutable.Map<String, RequestChannel.Response> kafka$network$Processor$$inflightResponses() {
        return this.kafka$network$Processor$$inflightResponses;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public Selector kafka$network$Processor$$selector() {
        return this.kafka$network$Processor$$selector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.startupComplete();
        while (true) {
            if (this.isRunning()) ** GOTO lbl-1000
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Processor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Closing selector - processor ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.id())).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.swallowError((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Processor $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$network$Processor$$closeAll();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.shutdownComplete();
            return;
lbl-1000:
            // 1 sources

            {
                this.configureNewConnections();
                this.processNewResponses();
                this.poll();
                this.processCompletedReceives();
                this.processCompletedSends();
                this.processDisconnected();
                continue;
            }
            break;
        }
    }

    private void processNewResponses() {
        ObjectRef curr = ObjectRef.create((Object)this.kafka$network$Processor$$requestChannel.receiveResponse(this.id()));
        while ((RequestChannel.Response)curr.elem != null) {
            try {
                BoxedUnit boxedUnit;
                RequestChannel.ResponseAction responseAction = ((RequestChannel.Response)curr.elem).responseAction();
                if (RequestChannel$NoOpAction$.MODULE$.equals(responseAction)) {
                    BoxedUnit boxedUnit2;
                    this.kafka$network$Processor$$updateRequestMetrics(((RequestChannel.Response)curr.elem).request());
                    this.trace((Function0<String>)new Serializable(this, curr){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef curr$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Socket server received empty response to send, registering for read: ").append((Object)((RequestChannel.Response)this.curr$1.elem)).toString();
                        }
                        {
                            this.curr$1 = curr$1;
                        }
                    });
                    String channelId = ((RequestChannel.Response)curr.elem).request().connectionId();
                    if (this.kafka$network$Processor$$selector().channel(channelId) == null && this.kafka$network$Processor$$selector().closingChannel(channelId) == null) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.kafka$network$Processor$$selector().unmute(channelId);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (RequestChannel$SendAction$.MODULE$.equals(responseAction)) {
                    Send responseSend = (Send)((RequestChannel.Response)curr.elem).responseSend().getOrElse((Function0)new Serializable(this, curr){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef curr$1;

                        public final Nothing$ apply() {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"responseSend must be defined for SendAction, response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(RequestChannel.Response)this.curr$1.elem})));
                        }
                        {
                            this.curr$1 = curr$1;
                        }
                    });
                    this.sendResponse((RequestChannel.Response)curr.elem, responseSend);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$CloseConnectionAction$.MODULE$.equals(responseAction)) {
                    this.kafka$network$Processor$$updateRequestMetrics(((RequestChannel.Response)curr.elem).request());
                    this.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Closing socket connection actively according to the response code.";
                        }
                    });
                    this.close(this.kafka$network$Processor$$selector(), ((RequestChannel.Response)curr.elem).request().connectionId());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)responseAction);
            }
            finally {
                curr.elem = this.kafka$network$Processor$$requestChannel.receiveResponse(this.id());
                continue;
            }
            break;
        }
        return;
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().connectionId();
        this.trace((Function0<String>)new Serializable(this, response, connectionId){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Response response$1;
            private final String connectionId$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket server received response to send to ", ", registering for write and sending data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connectionId$2, this.response$1}));
            }
            {
                this.response$1 = response$1;
                this.connectionId$2 = connectionId$2;
            }
        });
        KafkaChannel channel = this.kafka$network$Processor$$selector().channel(connectionId);
        if (channel == null) {
            this.warn((Function0<String>)new Serializable(this, connectionId){
                public static final long serialVersionUID = 0L;
                private final String connectionId$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to send response via channel for which there is no open connection, connection id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connectionId$2}));
                }
                {
                    this.connectionId$2 = connectionId$2;
                }
            });
            response.request().updateRequestMetrics(0L);
        } else {
            this.kafka$network$Processor$$selector().send(responseSend);
            this.kafka$network$Processor$$inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        try {
            this.kafka$network$Processor$$selector().poll(300L);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing processor ", " due to illegal state or IO exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$Processor$$closeAll();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.shutdownComplete();
                throw throwable2;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().completedReceives()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(NetworkReceive receive) {
                Throwable throwable2;
                block2: {
                    try {
                        KafkaChannel openChannel = this.$outer.kafka$network$Processor$$selector().channel(receive.source());
                        KafkaChannel openOrClosingChannel2 = openChannel == null ? this.$outer.kafka$network$Processor$$selector().closingChannel(receive.source()) : openChannel;
                        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", openOrClosingChannel2.principal().getName()), openOrClosingChannel2.socketAddress());
                        RequestChannel.Request req = new RequestChannel.Request(this.$outer.id(), receive.source(), session, receive.payload(), this.$outer.kafka$network$Processor$$time.nanoseconds(), this.$outer.kafka$network$Processor$$listenerName, this.$outer.kafka$network$Processor$$securityProtocol);
                        this.$outer.kafka$network$Processor$$requestChannel.sendRequest(req);
                        this.$outer.kafka$network$Processor$$selector().mute(receive.source());
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        boolean bl = throwable3 instanceof InvalidRequestException ? true : throwable3 instanceof SchemaException;
                        if (!bl) break block2;
                        this.$outer.error((Function0<String>)new Serializable(this, receive){
                            public static final long serialVersionUID = 0L;
                            private final NetworkReceive receive$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing socket for ", " because of error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.receive$1.source()}));
                            }
                            {
                                this.receive$1 = receive$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable3){
                            public static final long serialVersionUID = 0L;
                            private final Throwable x5$1;

                            public final Throwable apply() {
                                return this.x5$1;
                            }
                            {
                                this.x5$1 = x5$1;
                            }
                        });
                        this.$outer.close(this.$outer.kafka$network$Processor$$selector(), receive.source());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw throwable2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().completedSends()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(Send send2) {
                RequestChannel.Response resp = (RequestChannel.Response)this.$outer.kafka$network$Processor$$inflightResponses().remove((Object)send2.destination()).getOrElse((Function0)new Serializable(this, send2){
                    public static final long serialVersionUID = 0L;
                    private final Send send$1;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Send for ", " completed, but not in `inflightResponses`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.send$1.destination()})));
                    }
                    {
                        this.send$1 = send$1;
                    }
                });
                this.$outer.kafka$network$Processor$$updateRequestMetrics(resp.request());
                this.$outer.kafka$network$Processor$$selector().unmute(send2.destination());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$network$Processor$$updateRequestMetrics(RequestChannel.Request request) {
        KafkaChannel channel = this.kafka$network$Processor$$selector().channel(request.connectionId());
        KafkaChannel openOrClosingChannel2 = channel == null ? this.kafka$network$Processor$$selector().closingChannel(request.connectionId()) : channel;
        long networkThreadTimeNanos = openOrClosingChannel2 == null ? 0L : openOrClosingChannel2.getAndResetNetworkThreadTimeNanos();
        request.updateRequestMetrics(networkThreadTimeNanos);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.kafka$network$Processor$$selector().disconnected().keySet()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(String connectionId) {
                String remoteHost = ((ConnectionId)this.$outer.kafka$network$Processor$$ConnectionId().fromString(connectionId).getOrElse((Function0)new Serializable(this, connectionId){
                    public static final long serialVersionUID = 0L;
                    private final String connectionId$4;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connectionId has unexpected format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connectionId$4})));
                    }
                    {
                        this.connectionId$4 = connectionId$4;
                    }
                })).remoteHost();
                this.$outer.kafka$network$Processor$$inflightResponses().remove((Object)connectionId).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$processDisconnected$1 $outer;

                    public final void apply(RequestChannel.Response response) {
                        this.$outer.kafka$network$Processor$$anonfun$$$outer().kafka$network$Processor$$updateRequestMetrics(response.request());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.kafka$network$Processor$$connectionQuotas.dec(InetAddress.getByName(remoteHost));
            }

            public /* synthetic */ Processor kafka$network$Processor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)new Serializable(this, channel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;
                    private final SocketChannel channel$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " listening to new connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id()), this.channel$2.socket().getRemoteSocketAddress()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.channel$2 = channel$2;
                    }
                });
                String localHost = channel.socket().getLocalAddress().getHostAddress();
                int localPort = channel.socket().getLocalPort();
                String remoteHost = channel.socket().getInetAddress().getHostAddress();
                int remotePort = channel.socket().getPort();
                String connectionId = this.kafka$network$Processor$$ConnectionId().apply(localHost, localPort, remoteHost, remotePort).toString();
                this.kafka$network$Processor$$selector().register(connectionId, channel);
                continue;
            }
            catch (Throwable throwable) {
                void var1_1;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                SocketAddress remoteAddress = var1_1.getRemoteAddress();
                this.close((SocketChannel)var1_1);
                this.error((Function0<String>)new Serializable(this, remoteAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;
                    private final SocketAddress remoteAddress$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " closed connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id()), this.remoteAddress$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.remoteAddress$1 = remoteAddress$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$3;

                    public final Throwable apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = e$3;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            break;
        }
        return;
    }

    public void kafka$network$Processor$$closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().channels()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(KafkaChannel channel) {
                this.$outer.close(this.$outer.kafka$network$Processor$$selector(), channel.id());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$network$Processor$$selector().close();
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.kafka$network$Processor$$selector().channel(connectionId));
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return this.channel(connectionId).orElse((Function0)new Serializable(this, connectionId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;
            private final String connectionId$3;

            public final Option<KafkaChannel> apply() {
                return Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$selector().closingChannel(this.connectionId$3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connectionId$3 = connectionId$3;
            }
        });
    }

    public int numStagedReceives(String connectionId) {
        return BoxesRunTime.unboxToInt((Object)this.openOrClosingChannel(connectionId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final int apply(KafkaChannel c) {
                return this.$outer.kafka$network$Processor$$selector().numStagedReceives(c);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    @Override
    public void wakeup() {
        this.kafka$network$Processor$$selector().wakeup();
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, ListenerName listenerName, SecurityProtocol securityProtocol2, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider) {
        this.id = id;
        this.kafka$network$Processor$$time = time;
        this.kafka$network$Processor$$requestChannel = requestChannel;
        this.kafka$network$Processor$$connectionQuotas = connectionQuotas;
        this.kafka$network$Processor$$listenerName = listenerName;
        this.kafka$network$Processor$$securityProtocol = securityProtocol2;
        this.kafka$network$Processor$$metrics = metrics;
        super(connectionQuotas);
        KafkaMetricsGroup$class.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.kafka$network$Processor$$inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener"), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge("IdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.metricTags()))).fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.0;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(KafkaMetric x$5) {
                        return x$5.value();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        this.kafka$network$Processor$$selector = new Selector(maxRequestSize, connectionsMaxIdleMs, metrics, time, "socket-server", this.metricTags(), false, true, ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (SecurityProtocol)securityProtocol2, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache()));
    }

    public class ConnectionId
    implements Product,
    Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "-", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localHost(), BoxesRunTime.boxToInteger((int)this.localPort()), this.remoteHost(), BoxesRunTime.boxToInteger((int)this.remotePort())}));
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 0: {
                    object = this.localHost();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

