/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.ConsumerGroupCommand;
import kafka.consumer.OldConsumer;
import kafka.consumer.Whitelist;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0002\u0005\u0003\u0015\tG-\\5o\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u001b)\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u00051\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011)H/\u001b7\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0010\u0001A\u0003%a#\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0013!\u0002;pa&\u001cW#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019R\u0012\u0001\u00027b]\u001eL!\u0001K\u0013\u0003\rM#(/\u001b8h\u0011\u0019Q\u0003\u0001)A\u0005G\u00051Ao\u001c9jG\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005Q&A\u0006u_BL7MR5mi\u0016\u0014X#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011\u0001C2p]N,X.\u001a:\n\u0005M\u0002$!C,iSR,G.[:u\u0011\u0019)\u0004\u0001)A\u0005]\u0005aAo\u001c9jG\u001aKG\u000e^3sA!9q\u0007\u0001b\u0001\n\u0003\u0011\u0013!B4s_V\u0004\bBB\u001d\u0001A\u0003%1%\u0001\u0004he>,\b\u000f\t\u0005\bw\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u0015\u0001(o\u001c9t\u0011\u0019i\u0004\u0001)A\u0005-\u00051\u0001O]8qg\u0002BQa\u0010\u0001\u0005B\u0001\u000bqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002\u0003B\u0019!\tT(\u000f\u0005\rKeB\u0001#H\u001b\u0005)%B\u0001$\u0007\u0003\u0019a$o\\8u}%\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u0017\u00069\u0001/Y2lC\u001e,'\"\u0001%\n\u00055s%aA*fc*\u0011!j\u0013\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0012\taa]3sm\u0016\u0014\u0018B\u0001+R\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000bY\u0003A\u0011I,\u0002\u000bM,G/\u00169\u0015\u0003a\u0003\"!\u0017.\u000e\u0003-K!aW&\u0003\tUs\u0017\u000e\u001e\u0015\u0003+v\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\u000b),h.\u001b;\u000b\u0003\t\f1a\u001c:h\u0013\t!wL\u0001\u0004CK\u001a|'/\u001a\u0005\u0006M\u0002!\taV\u0001!i\u0016\u001cH\u000fT5ti\u001e\u0013x.\u001e9XSRDgj\\#ySN$\u0018N\\4He>,\b\u000f\u000b\u0002fQB\u0011a,[\u0005\u0003U~\u0013A\u0001V3ti\")A\u000e\u0001C\u0001/\u0006YB/Z:u\u0019&\u001cHo\u0012:pkB<\u0016\u000e\u001e5T_6,wI]8vaND#a\u001b5")
public class ListConsumerGroupTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final String topic;
    private final Whitelist topicFilter = new Whitelist(this.topic());
    private final String group;
    private final Properties props = new Properties();

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic() {
        return this.topic;
    }

    public Whitelist topicFilter() {
        return this.topicFilter;
    }

    public String group() {
        return this.group;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListConsumerGroupTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.props().setProperty("group.id", this.group());
        this.props().setProperty("zookeeper.connect", this.zkConnect());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListGroupWithNoExistingGroup() {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect()}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        try {
            List $org_scalatest_assert_macro_left = consumerGroupCommand.listGroups();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        consumerGroupCommand.close();
    }

    @Test
    public void testListGroupWithSomeGroups() {
        OldConsumer consumer1Mock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        this.props().setProperty("group.id", "some.other.group");
        OldConsumer consumer2Mock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect()}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        EasyMock.replay((Object[])new Object[]{consumer1Mock});
        EasyMock.replay((Object[])new Object[]{consumer2Mock});
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                List groups = this.consumerGroupCommand$1.listGroups();
                return groups.size() == 2 && groups.contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$1 = consumerGroupCommand$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected a different list group results.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
        consumer1Mock.stop();
        consumer2Mock.stop();
    }

    public ListConsumerGroupTest() {
        this.topic = "foo";
        this.group = "test.group";
    }
}

