/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.nio.ByteBuffer;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetConfig;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.log.Log;
import kafka.log.LogAppendInfo$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B\u0001\u0003\u0001%\u0011\u0001d\u0012:pkBlU\r^1eCR\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002\u00011A\u0005\u0002]\tA\u0001^5nKV\t\u0001\u0004\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\r\u0005)Q\u000f^5mg&\u0011QD\u0007\u0002\t\u001b>\u001c7\u000eV5nK\"9q\u0004\u0001a\u0001\n\u0003\u0001\u0013\u0001\u0003;j[\u0016|F%Z9\u0015\u0005\u0005\"\u0003CA\u0006#\u0013\t\u0019CB\u0001\u0003V]&$\bbB\u0013\u001f\u0003\u0003\u0005\r\u0001G\u0001\u0004q\u0012\n\u0004BB\u0014\u0001A\u0003&\u0001$A\u0003uS6,\u0007\u0005C\u0004*\u0001\u0001\u0007I\u0011\u0001\u0016\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/\r\u000511/\u001a:wKJL!\u0001M\u0017\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"9!\u0007\u0001a\u0001\n\u0003\u0019\u0014A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"!\t\u001b\t\u000f\u0015\n\u0014\u0011!a\u0001W!1a\u0007\u0001Q!\n-\nqB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u0005\bq\u0001\u0001\r\u0011\"\u0001:\u0003Q9'o\\;q\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4feV\t!\b\u0005\u0002\u0015w%\u0011AH\u0001\u0002\u0015\u000fJ|W\u000f]'fi\u0006$\u0017\r^1NC:\fw-\u001a:\t\u000fy\u0002\u0001\u0019!C\u0001\u007f\u0005ArM]8va6+G/\u00193bi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0005\u0005\u0002\u0005bB\u0013>\u0003\u0003\u0005\rA\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u001e\u0002+\u001d\u0014x.\u001e9NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA!9A\t\u0001a\u0001\n\u0003)\u0015!C:dQ\u0016$W\u000f\\3s+\u00051\u0005CA\rH\u0013\tA%D\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\t\u000f)\u0003\u0001\u0019!C\u0001\u0017\u0006i1o\u00195fIVdWM]0%KF$\"!\t'\t\u000f\u0015J\u0015\u0011!a\u0001\r\"1a\n\u0001Q!\n\u0019\u000b!b]2iK\u0012,H.\u001a:!\u0011\u001d\u0001\u0006\u00011A\u0005\u0002E\u000bqA_6Vi&d7/F\u0001S!\tI2+\u0003\u0002U5\t9!l[+uS2\u001c\bb\u0002,\u0001\u0001\u0004%\taV\u0001\fu.,F/\u001b7t?\u0012*\u0017\u000f\u0006\u0002\"1\"9Q%VA\u0001\u0002\u0004\u0011\u0006B\u0002.\u0001A\u0003&!+\u0001\u0005{WV#\u0018\u000e\\:!\u0011\u001da\u0006\u00011A\u0005\u0002u\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003y\u0003\"a\u00182\u000e\u0003\u0001T!!\u0019\u0004\u0002\u000f\rdWo\u001d;fe&\u00111\r\u0019\u0002\n!\u0006\u0014H/\u001b;j_:Dq!\u001a\u0001A\u0002\u0013\u0005a-A\u0007qCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0003C\u001dDq!\n3\u0002\u0002\u0003\u0007a\f\u0003\u0004j\u0001\u0001\u0006KAX\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0003bB6\u0001\u0005\u0004%\t\u0001\\\u0001\bOJ|W\u000f]%e+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\u0011a\u0017M\\4\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u0007'R\u0014\u0018N\\4\t\rY\u0004\u0001\u0015!\u0003n\u0003!9'o\\;q\u0013\u0012\u0004\u0003b\u0002=\u0001\u0005\u0004%\t!_\u0001\u0011OJ|W\u000f\u001d)beRLG/[8o\u0013\u0012,\u0012A\u001f\t\u0003\u0017mL!\u0001 \u0007\u0003\u0007%sG\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA_\u0001\u0012OJ|W\u000f\u001d)beRLG/[8o\u0013\u0012\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011AA\u0002\u0003M9'o\\;q)>\u0004\u0018n\u0019)beRLG/[8o+\t\t)\u0001\u0005\u0003\u0002\b\u0005]QBAA\u0005\u0015\u0011\tY!!\u0004\u0002\r\r|W.\\8o\u0015\r9\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003+\t1a\u001c:h\u0013\u0011\tI\"!\u0003\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"A\u0011Q\u0004\u0001!\u0002\u0013\t)!\u0001\u000bhe>,\b\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\t\u0003C\u0001!\u0019!C\u0001Y\u0006a\u0001O]8u_\u000e|G\u000eV=qK\"9\u0011Q\u0005\u0001!\u0002\u0013i\u0017!\u00049s_R|7m\u001c7UsB,\u0007\u0005\u0003\u0005\u0002*\u0001\u0011\r\u0011\"\u0001z\u0003A\u0011XMY1mC:\u001cW\rV5nK>,H\u000fC\u0004\u0002.\u0001\u0001\u000b\u0011\u0002>\u0002#I,'-\u00197b]\u000e,G+[7f_V$\b\u0005\u0003\u0005\u00022\u0001\u0011\r\u0011\"\u0001z\u00039\u0019Xm]:j_:$\u0016.\\3pkRDq!!\u000e\u0001A\u0003%!0A\btKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\tQa]3u+B$\u0012!\t\u0015\u0005\u0003o\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\t)%a\u0005\u0002\u000b),h.\u001b;\n\t\u0005%\u00131\t\u0002\u0007\u0005\u00164wN]3\t\u000f\u00055\u0003\u0001\"\u0001\u0002<\u0005YB/Z:u\u0019>\fGm\u00144gg\u0016$8oV5uQ>,Ho\u0012:pkBDC!a\u0013\u0002RA!\u0011\u0011IA*\u0013\u0011\t)&a\u0011\u0003\tQ+7\u000f\u001e\u0005\b\u00033\u0002A\u0011AA\u001e\u0003!\"Xm\u001d;M_\u0006$GK]1og\u0006\u001cG/[8oC2|eMZ:fiN<\u0016\u000e\u001e5pkR<%o\\;qQ\u0011\t9&!\u0015\t\u000f\u0005}\u0003\u0001\"\u0001\u0002<\u0005qC/Z:u\t>tu\u000e\u001e'pC\u0012\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;tQ\u0011\ti&!\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002<\u0005\tC/Z:u\u000fJ|W\u000f\u001d'pC\u0012,GmV5uQB+g\u000eZ5oO\u000e{W.\\5ug\"\"\u00111MA)\u0011\u001d\tY\u0007\u0001C\u0001\u0003w\t\u0011\b^3ti2{\u0017\rZ,ji\"\u001cu.\\7jiR,G-\u00118e\u0003\n|'\u000f^3e)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LGo\u001d\u0015\u0005\u0003S\n\t\u0006C\u0004\u0002r\u0001!\t!a\u000f\u0002\u0007R,7\u000f\u001e'pC\u0012<\u0016\u000e\u001e5D_6l\u0017\u000e\u001e;fI\u0006sG-\u00112peR,G-\u00118e!\u0016tG-\u001b8h)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LGo\u001d\u0015\u0005\u0003_\n\t\u0006C\u0004\u0002x\u0001!\t!a\u000f\u0002oQ,7\u000f\u001e'pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;t\rJ|W.T;mi&\u0004H.\u001a)s_\u0012,8-\u001a:tQ\u0011\t)(!\u0015\t\u000f\u0005u\u0004\u0001\"\u0001\u0002<\u0005\u0011E/Z:u\u000fJ|W\u000f\u001d'pC\u0012<\u0016\u000e\u001e5D_:\u001cX/\\3s\u0003:$GK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5ug\u000e{gn];nKJ<\u0016N\\:)\t\u0005m\u0014\u0011\u000b\u0005\b\u0003\u0007\u0003A\u0011AA\u001e\u0003\u0015#Xm\u001d;He>,\b\u000fT8bI^KG\u000f[\"p]N,X.\u001a:B]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;t)J\fgn]1di&|gnV5og\"\"\u0011\u0011QA)\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017\u000b!$\u00199qK:$7i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSR$rA_AG\u0003;\u000b9\u000b\u0003\u0005\u0002\u0010\u0006\u001d\u0005\u0019AAI\u0003\u0019\u0011WO\u001a4feB!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018F\f1A\\5p\u0013\u0011\tY*!&\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0005\u0002 \u0006\u001d\u0005\u0019AAQ\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u0004\u0017\u0005\r\u0016bAAS\u0019\t!Aj\u001c8h\u0011!\tI+a\"A\u0002\u0005-\u0016aB8gMN,Go\u001d\t\t\u0003[\u000b\u0019,!\u0002\u0002\"6\u0011\u0011q\u0016\u0006\u0004\u0003cc\u0011AC2pY2,7\r^5p]&!\u0011QWAX\u0005\ri\u0015\r\u001d\u0005\b\u0003s\u0003A\u0011BA^\u0003\u0001\n\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e^:\u0015\u0017i\fi,a0\u0002D\u00065\u0017q\u001a\u0005\t\u0003\u001f\u000b9\f1\u0001\u0002\u0012\"A\u0011\u0011YA\\\u0001\u0004\t\t+\u0001\u0006qe>$WoY3s\u0013\u0012D\u0001\"!2\u00028\u0002\u0007\u0011qY\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007-\tI-C\u0002\u0002L2\u0011Qa\u00155peRD\u0001\"a(\u00028\u0002\u0007\u0011\u0011\u0015\u0005\t\u0003S\u000b9\f1\u0001\u0002,\"9\u00111\u001b\u0001\u0005\n\u0005U\u0017!I2p[BdW\r^3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$Hc\u0003>\u0002X\u0006e\u00171\\Ao\u0003?D\u0001\"a$\u0002R\u0002\u0007\u0011\u0011\u0013\u0005\t\u0003\u0003\f\t\u000e1\u0001\u0002\"\"A\u0011QYAi\u0001\u0004\t9\r\u0003\u0005\u0002 \u0006E\u0007\u0019AAQ\u0011!\t\t/!5A\u0002\u0005\r\u0018\u0001C5t\u0007>lW.\u001b;\u0011\u0007-\t)/C\u0002\u0002h2\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002l\u0002!\t!a\u000f\u0002;Q,7\u000f\u001e'pC\u0012|eMZ:fiN<\u0016\u000e\u001e5U_6\u00147\u000f^8oKNDC!!;\u0002R!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005m\u0012a\u0006;fgRdu.\u00193PM\u001a\u001cX\r^:B]\u0012<%o\\;qQ\u0011\ty/!\u0015\t\u000f\u0005]\b\u0001\"\u0001\u0002<\u0005QB/Z:u\u0019>\fGm\u0012:pkB<\u0016\u000e\u001e5U_6\u00147\u000f^8oK\"\"\u0011Q_A)\u0011\u001d\ti\u0010\u0001C\u0001\u0003w\t\u0001\u0005^3ti>3gm]3u/JLG/Z!gi\u0016\u0014xI]8vaJ+Wn\u001c<fI\"\"\u00111`A)\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003w\tA\u0006^3ti2{\u0017\rZ$s_V\u0004\u0018I\u001c3PM\u001a\u001cX\r^:Ge>lG)\u001b4gKJ,g\u000e^*fO6,g\u000e^:)\t\t\u0005\u0011\u0011\u000b\u0005\b\u0005\u0013\u0001A\u0011AA\u001e\u00031!Xm\u001d;BI\u0012<%o\\;qQ\u0011\u00119!!\u0015\t\u000f\t=\u0001\u0001\"\u0001\u0002<\u0005\u0019B/Z:u'R|'/Z#naRLxI]8va\"\"!QBA)\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003w\t!\u0004^3tiN#xN]3He>,\b/\u0012:s_Jl\u0015\r\u001d9j]\u001eDCAa\u0005\u0002R!9!1\u0004\u0001\u0005\n\tu\u0011\u0001H1tg\u0016\u0014Ho\u0015;pe\u0016<%o\\;q\u000bJ\u0014xN]'baBLgn\u001a\u000b\u0006C\t}!q\u0006\u0005\t\u0005C\u0011I\u00021\u0001\u0003$\u0005Y\u0011\r\u001d9f]\u0012,%O]8s!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0003\u0013\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005[\u00119C\u0001\u0004FeJ|'o\u001d\u0005\t\u0005c\u0011I\u00021\u0001\u0003$\u0005iQ\r\u001f9fGR,G-\u0012:s_JDqA!\u000e\u0001\t\u0003\tY$\u0001\fuKN$8\u000b^8sK:{g.R7qif<%o\\;qQ\u0011\u0011\u0019$!\u0015\t\u000f\tm\u0002\u0001\"\u0001\u0002<\u0005iC/Z:u'R|'/\u001a(p]\u0016k\u0007\u000f^=He>,\bo\u00165f]\u000e{wN\u001d3j]\u0006$xN\u001d%bg6{g/\u001a3)\t\te\u0012\u0011\u000b\u0005\b\u0005\u0003\u0002A\u0011AA\u001e\u0003A!Xm\u001d;D_6l\u0017\u000e^(gMN,G\u000f\u000b\u0003\u0003@\u0005E\u0003b\u0002B$\u0001\u0011\u0005\u00111H\u0001'i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006d7i\\7nSR|eMZ:fi\u000e{W.\\5ui\u0016$\u0007\u0006\u0002B#\u0003#BqA!\u0014\u0001\t\u0003\tY$\u0001\u0016uKN$HK]1og\u0006\u001cG/[8oC2\u001cu.\\7ji>3gm]3u\u0003B\u0004XM\u001c3GC&dWO]3)\t\t-\u0013\u0011\u000b\u0005\b\u0005'\u0002A\u0011AA\u001e\u0003\u0011\"Xm\u001d;Ue\u0006t7/Y2uS>t\u0017\r\\\"p[6LGo\u00144gg\u0016$\u0018IY8si\u0016$\u0007\u0006\u0002B)\u0003#BqA!\u0017\u0001\t\u0003\tY$A\u0014uKN$8i\\7nSR|eMZ:fi^CWM\\\"p_J$\u0017N\\1u_JD\u0015m]'pm\u0016$\u0007\u0006\u0002B,\u0003#BqAa\u0018\u0001\t\u0003\tY$A\fuKN$8i\\7nSR|eMZ:fi\u001a\u000b\u0017\u000e\\;sK\"\"!QLA)\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005O\na$Y:tKJ$8i\\7nSR|eMZ:fi\u0016\u0013(o\u001c:NCB\u0004\u0018N\\4\u0015\u000b\u0005\u0012IGa\u001b\t\u0011\t\u0005\"1\ra\u0001\u0005GA\u0001B!\r\u0003d\u0001\u0007!1\u0005\u0005\b\u0005_\u0002A\u0011AA\u001e\u0003A!Xm\u001d;FqBL'/Z(gMN,G\u000f\u000b\u0003\u0003n\u0005E\u0003b\u0002B;\u0001\u0011\u0005\u00111H\u0001\u0019i\u0016\u001cHo\u0012:pkBlU\r^1eCR\f'+Z7pm\u0006d\u0007\u0006\u0002B:\u0003#BqAa\u001f\u0001\t\u0003\tY$A\u0015uKN$xI]8va6+G/\u00193bi\u0006\u0014V-\\8wC2<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u0015\u0005\u0005s\n\t\u0006C\u0004\u0003\u0002\u0002!\t!a\u000f\u0002=Q,7\u000f^#ya&\u0014Xm\u0012:pkB<\u0016\u000e\u001e5PM\u001a\u001cX\r^:P]2L\b\u0006\u0002B@\u0003#BqAa\"\u0001\t\u0003\tY$\u0001\u0011uKN$X\t\u001f9je\u0016|eMZ:fiN<\u0016\u000e\u001e5BGRLg/Z$s_V\u0004\b\u0006\u0002BC\u0003#BqA!$\u0001\t\u0013\u0011y)\u0001\rbaB,g\u000eZ!oI\u000e\u000b\u0007\u000f^;sK\u000e\u000bG\u000e\u001c2bG.$\"A!%\u0011\r\tM%\u0011\u0014BO\u001b\t\u0011)J\u0003\u0003\u0003\u0018\u0006M\u0011\u0001C3bgflwnY6\n\t\tm%Q\u0013\u0002\b\u0007\u0006\u0004H/\u001e:f!\u0019Y!q\u0014BRC%\u0019!\u0011\u0015\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003CAW\u0003g\u000b)A!*\u0011\t\t\u001d&1\u001a\b\u0005\u0005S\u0013)M\u0004\u0003\u0003,\n\u0005g\u0002\u0002BW\u0005\u007fsAAa,\u0003>:!!\u0011\u0017B^\u001d\u0011\u0011\u0019L!/\u000e\u0005\tU&b\u0001B\\\u0011\u00051AH]8pizJ!!!\u0006\n\t\u0005E\u00111C\u0005\u0004\u000f\u0005=\u0011\u0002BA\u0006\u0003\u001bIAAa1\u0002\n\u0005A!/Z9vKN$8/\u0003\u0003\u0003H\n%\u0017a\u0004)s_\u0012,8-\u001a*fgB|gn]3\u000b\t\t\r\u0017\u0011B\u0005\u0005\u0005\u001b\u0014yMA\tQCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TAAa2\u0003J\"9!1\u001b\u0001\u0005\n\tU\u0017aE3ya\u0016\u001cG/\u00119qK:$W*Z:tC\u001e,GcA\u0011\u0003X\"A!\u0011\u001cBi\u0001\u0004\u0011\u0019#A\u0003feJ|'\u000fC\u0004\u0003^\u0002!IAa8\u0002A\t,\u0018\u000e\u001c3Ti\u0006\u0014G.Z$s_V\u0004(+Z2pe\u0012<\u0016\u000e\u001e5NK6\u0014WM\u001d\u000b\u0005\u0005C\u0014i\u000f\u0005\u0003\u0003d\n%XB\u0001Bs\u0015\u0011\u00119/!\u0003\u0002\rI,7m\u001c:e\u0013\u0011\u0011YO!:\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\t\u0011\t=(1\u001ca\u0001\u0005c\f\u0001\"\\3nE\u0016\u0014\u0018\n\u001a\t\u0005\u0005g\u0014IPD\u0002\f\u0005kL1Aa>\r\u0003\u0019\u0001&/\u001a3fM&\u0019AOa?\u000b\u0007\t]H\u0002C\u0004\u0003\u0000\u0002!Ia!\u0001\u0002/\u0015D\b/Z2u\u000fJ|W\u000f]'fi\u0006$\u0017\r^1M_\u0006$GcB\u0011\u0004\u0004\r\u001d11\u0002\u0005\t\u0007\u000b\u0011i\u00101\u0001\u0002\u0006\u0005YrM]8va6+G/\u00193bi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001b!\u0003\u0003~\u0002\u0007\u0011\u0011U\u0001\fgR\f'\u000f^(gMN,G\u000f\u0003\u0005\u0004\u000e\tu\b\u0019AB\b\u0003\u001d\u0011XmY8sIN\u0004BAa9\u0004\u0012%!11\u0003Bs\u00055iU-\\8ssJ+7m\u001c:eg\"9!q \u0001\u0005\n\r]A\u0003CAQ\u00073\u0019Ica\u000b\t\u0011\rm1Q\u0003a\u0001\u0007;\tq\u0001\\8h\u001b>\u001c7\u000e\u0005\u0003\u0004 \r\u0015RBAB\u0011\u0015\r\u0019\u0019CB\u0001\u0004Y><\u0017\u0002BB\u0014\u0007C\u00111\u0001T8h\u0011!\u0019Ia!\u0006A\u0002\u0005\u0005\u0006\u0002CB\u0007\u0007+\u0001\raa\u0004\t\u000f\r=\u0002\u0001\"\u0003\u00042\u0005a2M]3bi\u0016\u001cu.\\7jiR,Gm\u00144gg\u0016$(+Z2pe\u0012\u001cHCBB\u001a\u0007s\u0019i\u0004\u0005\u0004\u0002.\u000eU\"\u0011]\u0005\u0005\u0007o\tyKA\u0002TKFD\u0001ba\u000f\u0004.\u0001\u0007\u00111V\u0001\u0011G>lW.\u001b;uK\u0012|eMZ:fiND\u0011b[B\u0017!\u0003\u0005\rA!=\t\u000f\r\u0005\u0003\u0001\"\u0003\u0002<\u0005\u0001Rn\\2l\u000f\u0016$\b+\u0019:uSRLwN\u001c\u0005\n\u0007\u000b\u0002\u0011\u0013!C\u0005\u0007\u000f\nae\u0019:fCR,7i\\7nSR$X\rZ(gMN,GOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019IE\u000b\u0003\u0003r\u000e-3FAB'!\u0011\u0019ye!\u0017\u000e\u0005\rE#\u0002BB*\u0007+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r]C\"\u0001\u0006b]:|G/\u0019;j_:LAaa\u0017\u0004R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class GroupMetadataManagerTest {
    private MockTime time = null;
    private ReplicaManager replicaManager = null;
    private GroupMetadataManager groupMetadataManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private Partition partition = null;
    private final String groupId;
    private final int groupPartitionId;
    private final TopicPartition groupTopicPartition = new TopicPartition("__consumer_offsets", this.groupPartitionId());
    private final String protocolType;
    private final int rebalanceTimeout;
    private final int sessionTimeout;

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public GroupMetadataManager groupMetadataManager() {
        return this.groupMetadataManager;
    }

    public void groupMetadataManager_$eq(GroupMetadataManager x$1) {
        this.groupMetadataManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupPartitionId() {
        return this.groupPartitionId;
    }

    public TopicPartition groupTopicPartition() {
        return this.groupTopicPartition;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    @Before
    public void setUp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()));
        OffsetConfig offsetConfig = new OffsetConfig(Predef$.MODULE$.Integer2int(config.offsetMetadataMaxSize()), Predef$.MODULE$.Integer2int(config.offsetsLoadBufferSize()), (long)(Predef$.MODULE$.Integer2int(config.offsetsRetentionMinutes()) * 60) * 1000L, Predef$.MODULE$.Long2long(config.offsetsRetentionCheckIntervalMs()), Predef$.MODULE$.Integer2int(config.offsetsTopicPartitions()), Predef$.MODULE$.Integer2int(config.offsetsTopicSegmentBytes()), Predef$.MODULE$.Short2short(config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.offsetCommitTimeoutMs()), Predef$.MODULE$.Short2short(config.offsetCommitRequiredAcks()));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getTopicPartitionCount("__consumer_offsets")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.groupMetadataManager_$eq(new GroupMetadataManager(0, ApiVersion$.MODULE$.latestVersion(), offsetConfig, this.replicaManager(), this.zkUtils(), (Time)this.time()));
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
    }

    @Test
    public void testLoadOffsetsWithoutGroup() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])offsetCommitRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$1) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$1;

            public final void apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$1.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$2) {
                            return x$2.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$1 = group$1;
            }
        });
    }

    @Test
    public void testLoadTransactionalOffsetsWithoutGroup() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$3) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$2;

            public final void apply(Tuple2<TopicPartition, Object> x0$2) {
                Tuple2<TopicPartition, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$2.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$4) {
                            return x$4.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$2 = group$2;
            }
        });
    }

    @Test
    public void testDoNotLoadAbortedTransactionalOffsetCommits() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map abortedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)abortedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, false);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$5) {
            }
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
    }

    @Test
    public void testGroupLoadedWithPendingCommits() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map pendingOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)pendingOffsets);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$6) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)0L, (long)group.allOffsets().size());
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testLoadWithCommittedAndAbortedTransactionalOffsetCommits() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Map abortedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)231L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)4551L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)BoxesRunTime.boxToLong((long)89921L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)abortedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, false);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$7) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$3;

            public final void apply(Tuple2<TopicPartition, Object> x0$3) {
                Tuple2<TopicPartition, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$3.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$8) {
                            return x$8.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$3 = group$3;
            }
        });
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits() {
        int nextOffset;
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Map abortedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)231L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)4551L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)BoxesRunTime.boxToLong((long)89921L))}));
        Map pendingOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)2312L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)45512L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)899212L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int commitOffsetsLogPosition = nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)abortedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, false);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)pendingOffsets);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$9) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, commitOffsetsLogPosition, group){
            public static final long serialVersionUID = 0L;
            private final int commitOffsetsLogPosition$1;
            private final GroupMetadata group$4;

            public final void apply(Tuple2<TopicPartition, Object> x0$4) {
                Tuple2<TopicPartition, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$4.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$10) {
                            return x$10.offset();
                        }
                    }));
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.commitOffsetsLogPosition$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(this.group$4.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.commitOffsetsLogPosition$1 = commitOffsetsLogPosition$1;
                this.group$4 = group$4;
            }
        });
        Assert.assertTrue((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        this.groupMetadataManager().handleTxnCompletion(producerId, (Set)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{groupMetadataTopicPartition.partition()})).toSet(), true);
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        pendingOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$4;

            public final void apply(Tuple2<TopicPartition, Object> x0$5) {
                Tuple2<TopicPartition, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$4.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$11) {
                            return x$11.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$4 = group$4;
            }
        });
    }

    @Test
    public void testLoadTransactionalOffsetCommitsFromMultipleProducers() {
        long nextOffset;
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long firstProducerId = 1000L;
        short firstProducerEpoch = 2;
        long secondProducerId = 1001L;
        short secondProducerEpoch = 3;
        Map committedOffsetsFirstProducer = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Map committedOffsetsSecondProducer = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)231L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)4551L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)BoxesRunTime.boxToLong((long)89921L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        long firstProduceRecordOffset = nextOffset = 0L;
        nextOffset += (long)this.appendTransactionalOffsetCommits(buffer, firstProducerId, firstProducerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsetsFirstProducer);
        nextOffset += (long)this.completeTransactionalOffsetCommit(buffer, firstProducerId, firstProducerEpoch, nextOffset, true);
        long secondProducerRecordOffset = nextOffset;
        nextOffset += (long)this.appendTransactionalOffsetCommits(buffer, secondProducerId, secondProducerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsetsSecondProducer);
        nextOffset += (long)this.completeTransactionalOffsetCommit(buffer, secondProducerId, secondProducerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$12) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)(committedOffsetsFirstProducer.size() + committedOffsetsSecondProducer.size()), (long)group.allOffsets().size());
        committedOffsetsFirstProducer.foreach((Function1)new Serializable(this, firstProduceRecordOffset, group){
            public static final long serialVersionUID = 0L;
            private final long firstProduceRecordOffset$1;
            private final GroupMetadata group$5;

            public final void apply(Tuple2<TopicPartition, Object> x0$6) {
                Tuple2<TopicPartition, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$5.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$13) {
                            return x$13.offset();
                        }
                    }));
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)this.firstProduceRecordOffset$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(this.group$5.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.firstProduceRecordOffset$1 = firstProduceRecordOffset$1;
                this.group$5 = group$5;
            }
        });
        committedOffsetsSecondProducer.foreach((Function1)new Serializable(this, secondProducerRecordOffset, group){
            public static final long serialVersionUID = 0L;
            private final long secondProducerRecordOffset$1;
            private final GroupMetadata group$5;

            public final void apply(Tuple2<TopicPartition, Object> x0$7) {
                Tuple2<TopicPartition, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$5.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$14) {
                            return x$14.offset();
                        }
                    }));
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)this.secondProducerRecordOffset$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(this.group$5.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.secondProducerRecordOffset$1 = secondProducerRecordOffset$1;
                this.group$5 = group$5;
            }
        });
    }

    @Test
    public void testGroupLoadWithConsumerAndTransactionalOffsetCommitsConsumerWins() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map transactionalOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L))}));
        Map consumerOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)24L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)transactionalOffsetCommits);
        int consumerRecordOffset = nextOffset;
        nextOffset += this.appendConsumerOffsetCommit(buffer, nextOffset, (Map<TopicPartition, Object>)consumerOffsetCommits);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$15) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)1L, (long)group.allOffsets().size());
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((long)consumerOffsetCommits.size(), (long)group.allOffsets().size());
        consumerOffsetCommits.foreach((Function1)new Serializable(this, consumerRecordOffset, group){
            public static final long serialVersionUID = 0L;
            private final int consumerRecordOffset$1;
            private final GroupMetadata group$6;

            public final void apply(Tuple2<TopicPartition, Object> x0$8) {
                Tuple2<TopicPartition, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$6.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$16) {
                            return x$16.offset();
                        }
                    }));
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.consumerRecordOffset$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(this.group$6.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.consumerRecordOffset$1 = consumerRecordOffset$1;
                this.group$6 = group$6;
            }
        });
    }

    @Test
    public void testGroupLoadWithConsumerAndTransactionalOffsetCommitsTransactionWins() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map transactionalOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L))}));
        Map consumerOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)24L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendConsumerOffsetCommit(buffer, nextOffset, (Map<TopicPartition, Object>)consumerOffsetCommits);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)transactionalOffsetCommits);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$17) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)1L, (long)group.allOffsets().size());
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((long)consumerOffsetCommits.size(), (long)group.allOffsets().size());
        transactionalOffsetCommits.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$7;

            public final void apply(Tuple2<TopicPartition, Object> x0$9) {
                Tuple2<TopicPartition, Object> tuple2 = x0$9;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$7.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$18) {
                            return x$18.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$7 = group$7;
            }
        });
    }

    private int appendConsumerOffsetCommit(ByteBuffer buffer, long baseOffset, Map<TopicPartition, Object> offsets) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset);
        Seq<SimpleRecord> commitRecords = this.createCommittedOffsetRecords(offsets, this.createCommittedOffsetRecords$default$2());
        commitRecords.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        builder.build();
        return offsets.size();
    }

    private int appendTransactionalOffsetCommits(ByteBuffer buffer, long producerId, short producerEpoch, long baseOffset, Map<TopicPartition, Object> offsets) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)0, (boolean)true);
        Seq<SimpleRecord> commitRecords = this.createCommittedOffsetRecords(offsets, this.createCommittedOffsetRecords$default$2());
        commitRecords.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$2;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$2.append(x$1);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        builder.build();
        return offsets.size();
    }

    private int completeTransactionalOffsetCommit(ByteBuffer buffer, long producerId, short producerEpoch, long baseOffset, boolean isCommit) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (int)0, (boolean)true, (boolean)true, (int)-1);
        ControlRecordType controlRecordType = isCommit ? ControlRecordType.COMMIT : ControlRecordType.ABORT;
        builder.appendEndTxnMarker(this.time().milliseconds(), new EndTransactionMarker(controlRecordType, 0));
        builder.build();
        return 1;
    }

    @Test
    public void testLoadOffsetsWithTombstones() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        TopicPartition tombstonePartition = new TopicPartition("foo", 1);
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tombstonePartition), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        SimpleRecord tombstone = new SimpleRecord(GroupMetadataManager$.MODULE$.offsetCommitKey(this.groupId(), tombstonePartition, GroupMetadataManager$.MODULE$.offsetCommitKey$default$3()), null);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{tombstone})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$19) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)(committedOffsets.size() - 1), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, tombstonePartition, group){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tombstonePartition$1;
            private final GroupMetadata group$8;

            public final void apply(Tuple2<TopicPartition, Object> x0$10) {
                Tuple2<TopicPartition, Object> tuple2 = x0$10;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    TopicPartition topicPartition2 = topicPartition;
                    TopicPartition topicPartition3 = this.tombstonePartition$1;
                    if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group$8.offset(topicPartition));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$8.offset(topicPartition).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(OffsetAndMetadata x$20) {
                                return x$20.offset();
                            }
                        }));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.tombstonePartition$1 = tombstonePartition$1;
                this.group$8 = group$8;
            }
        });
    }

    @Test
    public void testLoadOffsetsAndGroup() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        String memberId = "98098230493";
        SimpleRecord groupMetadataRecord = this.buildStableGroupRecordWithMember(memberId);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$21) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Stable$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((Object)memberId, (Object)group.leaderId());
        Assert.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{memberId})), (Object)group.allMembers());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$9;

            public final void apply(Tuple2<TopicPartition, Object> x0$11) {
                Tuple2<TopicPartition, Object> tuple2 = x0$11;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$9.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$22) {
                            return x$22.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$9 = group$9;
            }
        });
    }

    @Test
    public void testLoadGroupWithTombstone() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        String memberId = "98098230493";
        SimpleRecord groupMetadataRecord = this.buildStableGroupRecordWithMember(memberId);
        SimpleRecord groupMetadataTombstone = new SimpleRecord(GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId()), null);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord, groupMetadataTombstone}))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$23) {
            }
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
    }

    @Test
    public void testOffsetWriteAfterGroupRemoved() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        String memberId = "98098230493";
        SimpleRecord groupMetadataRecord = this.buildStableGroupRecordWithMember(memberId);
        SimpleRecord groupMetadataTombstone = new SimpleRecord(GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId()), null);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord, groupMetadataTombstone}))).$plus$plus(offsetCommitRecords, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$24) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$10;

            public final void apply(Tuple2<TopicPartition, Object> x0$12) {
                Tuple2<TopicPartition, Object> tuple2 = x0$12;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$10.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$25) {
                            return x$25.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$10 = group$10;
            }
        });
    }

    @Test
    public void testLoadGroupAndOffsetsFromDifferentSegments() {
        long startOffset = 15L;
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("xxx", 0);
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)logMock));
        String segment1MemberId = "a";
        Map segment1Offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), (Object)BoxesRunTime.boxToLong((long)42L))}));
        MemoryRecords segment1Records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.createCommittedOffsetRecords((Map<TopicPartition, Object>)segment1Offsets, this.createCommittedOffsetRecords$default$2()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{this.buildStableGroupRecordWithMember(segment1MemberId)})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long segment1End = this.expectGroupMetadataLoad(logMock, startOffset, segment1Records);
        String segment2MemberId = "b";
        Map segment2Offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)33L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)8992L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), (Object)BoxesRunTime.boxToLong((long)10L))}));
        MemoryRecords segment2Records = MemoryRecords.withRecords((long)segment1End, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.createCommittedOffsetRecords((Map<TopicPartition, Object>)segment2Offsets, this.createCommittedOffsetRecords$default$2()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{this.buildStableGroupRecordWithMember(segment2MemberId)})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long segment2End = this.expectGroupMetadataLoad(logMock, segment1End, segment2Records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment2End)));
        EasyMock.replay((Object[])new Object[]{logMock, this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(this.groupTopicPartition(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$26) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Stable$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((String)"segment2 group record member should be elected", (Object)segment2MemberId, (Object)group.leaderId());
        Assert.assertEquals((String)"segment2 group record member should be only member", (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{segment2MemberId})), (Object)group.allMembers());
        Map committedOffsets = segment1Offsets.$plus$plus((GenTraversableOnce)segment2Offsets);
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$11;

            public final void apply(Tuple2<TopicPartition, Object> x0$13) {
                Tuple2<TopicPartition, Object> tuple2 = x0$13;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$11.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$27) {
                            return x$27.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$11 = group$11;
            }
        });
    }

    @Test
    public void testAddGroup() {
        GroupMetadata group = new GroupMetadata("foo", GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(group));
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(new GroupMetadata("foo", GroupMetadata$.MODULE$.$lessinit$greater$default$2())));
    }

    @Test
    public void testStoreEmptyGroup() {
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.empty(), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$1;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$1(error, this.maybeError$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$1 = maybeError$1;
            }
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
    }

    @Test
    public void testStoreGroupErrorMapping() {
        this.assertStoreGroupErrorMapping(Errors.NONE, Errors.NONE);
        this.assertStoreGroupErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR);
        this.assertStoreGroupErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.UNKNOWN_SERVER_ERROR);
        this.assertStoreGroupErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.UNKNOWN_SERVER_ERROR);
        this.assertStoreGroupErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.UNKNOWN_SERVER_ERROR);
        this.assertStoreGroupErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertStoreGroupErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(appendError);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.empty(), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$2;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$2(error, this.maybeError$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$2 = maybeError$2;
            }
        });
        Assert.assertEquals((Object)new Some((Object)expectedError), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testStoreNonEmptyGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$28) {
            }
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$3;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$3(error, this.maybeError$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$3 = maybeError$3;
            }
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testStoreNonEmptyGroupWhenCoordinatorHasMoved() {
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andReturn((Object)None$.MODULE$);
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$29) {
            }
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$4;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$4(error, this.maybeError$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$4 = maybeError$4;
            }
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffset() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$1 = this.groupMetadataManager();
        GroupMetadata x$44 = group;
        String x$45 = memberId;
        scala.collection.immutable.Map x$46 = offsets;
        Serializable x$47 = new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$1;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$5(errors, this.commitErrors$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$1 = commitErrors$1;
            }
        };
        long x$48 = qual$1.storeOffsets$default$5();
        short x$49 = qual$1.storeOffsets$default$6();
        qual$1.storeOffsets(x$44, x$45, x$46, (Function1)x$47, x$48, x$49);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)maybeError);
        Assert.assertTrue((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        Option maybePartitionResponse = cachedOffsets.get((Object)topicPartition);
        Assert.assertFalse((boolean)maybePartitionResponse.isEmpty());
        OffsetFetchResponse.PartitionData partitionResponse = (OffsetFetchResponse.PartitionData)maybePartitionResponse.get();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse.error);
        Assert.assertEquals((long)offset, (long)partitionResponse.offset);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testTransactionalCommitOffsetCommitted() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        long producerId = 232L;
        short producerEpoch = (short)0;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeOffsets(group, memberId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$2;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$6(errors, this.commitErrors$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$2 = commitErrors$2;
            }
        }, producerId, producerEpoch);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        group.completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)group.allOffsets().isEmpty());
        Assert.assertEquals((Object)new Some((Object)OffsetAndMetadata$.MODULE$.apply((long)offset)), (Object)group.offset(topicPartition));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testTransactionalCommitOffsetAppendFailure() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        long producerId = 232L;
        short producerEpoch = (short)0;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeOffsets(group, memberId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$3;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$7(errors, this.commitErrors$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$3 = commitErrors$3;
            }
        }, producerId, producerEpoch);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_ENOUGH_REPLICAS, 0L, -1L, 0L))})));
        Assert.assertFalse((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        group.completePendingTxnOffsetCommit(producerId, false);
        Assert.assertFalse((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testTransactionalCommitOffsetAborted() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        long producerId = 232L;
        short producerEpoch = (short)0;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeOffsets(group, memberId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$4;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$8(errors, this.commitErrors$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$4 = commitErrors$4;
            }
        }, producerId, producerEpoch);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        group.completePendingTxnOffsetCommit(producerId, false);
        Assert.assertFalse((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffsetWhenCoordinatorHasMoved() {
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andReturn((Object)None$.MODULE$);
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$2 = this.groupMetadataManager();
        GroupMetadata x$50 = group;
        String x$51 = memberId;
        scala.collection.immutable.Map x$52 = offsets;
        Serializable x$53 = new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$5;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$9(errors, this.commitErrors$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$5 = commitErrors$5;
            }
        };
        long x$54 = qual$2.storeOffsets$default$5();
        short x$55 = qual$2.storeOffsets$default$6();
        qual$2.storeOffsets(x$50, x$51, x$52, (Function1)x$53, x$54, x$55);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)maybeError);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffsetFailure() {
        this.assertCommitOffsetErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR);
        this.assertCommitOffsetErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertCommitOffsetErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$3 = this.groupMetadataManager();
        GroupMetadata x$56 = group;
        String x$57 = memberId;
        scala.collection.immutable.Map x$58 = offsets;
        Serializable x$59 = new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$6;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$10(errors, this.commitErrors$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$6 = commitErrors$6;
            }
        };
        long x$60 = qual$3.storeOffsets$default$5();
        short x$61 = qual$3.storeOffsets$default$6();
        qual$3.storeOffsets(x$56, x$57, x$58, (Function1)x$59, x$60, x$61);
        Assert.assertTrue((boolean)group.hasOffsets());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(appendError, 0L, -1L, 0L))})));
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)expectedError), (Object)maybeError);
        Assert.assertFalse((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$30) {
                return x$30.offset;
            }
        }));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireOffset() {
        String memberId = "";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        this.mockGetPartition();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$4 = this.groupMetadataManager();
        GroupMetadata x$62 = group;
        String x$63 = memberId;
        scala.collection.immutable.Map x$64 = offsets;
        Serializable x$65 = new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$7;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$11(errors, this.commitErrors$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$7 = commitErrors$7;
            }
        };
        long x$66 = qual$4.storeOffsets$default$5();
        short x$67 = qual$4.storeOffsets$default$6();
        qual$4.storeOffsets(x$62, x$63, x$64, (Function1)x$65, x$66, x$67);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(2L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.anyObject(MemoryRecords.class), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)group.offset(topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$31) {
                return x$31.offset();
            }
        }));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$32) {
                return x$32.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$33) {
                return x$33.offset;
            }
        }));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testGroupMetadataRemoval() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        group.generationId_$eq(5);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.mockGetPartition();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)recordsCapture.getValue()).batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertEquals((long)2L, (long)batch.magic());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            }
        });
        Assert.assertEquals((long)1L, (long)records2.size());
        Record metadataTombstone = (Record)records2.head();
        Assert.assertTrue((boolean)metadataTombstone.hasKey());
        Assert.assertFalse((boolean)metadataTombstone.hasValue());
        Assert.assertTrue((metadataTombstone.timestamp() > 0L ? 1 : 0) != 0);
        GroupMetadataKey groupKey = (GroupMetadataKey)GroupMetadataManager$.MODULE$.readMessageKey(metadataTombstone.key());
        Assert.assertEquals((Object)this.groupId(), (Object)groupKey.key());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$34) {
                return x$34.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$35) {
                return x$35.offset;
            }
        }));
    }

    @Test
    public void testGroupMetadataRemovalWithLogAppendTime() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        group.generationId_$eq(5);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.mockGetPartition();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)recordsCapture.getValue()).batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertEquals((long)2L, (long)batch.magic());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            }
        });
        Assert.assertEquals((long)1L, (long)records2.size());
        Record metadataTombstone = (Record)records2.head();
        Assert.assertTrue((boolean)metadataTombstone.hasKey());
        Assert.assertFalse((boolean)metadataTombstone.hasValue());
        Assert.assertTrue((metadataTombstone.timestamp() > 0L ? 1 : 0) != 0);
        GroupMetadataKey groupKey = (GroupMetadataKey)GroupMetadataManager$.MODULE$.readMessageKey(metadataTombstone.key());
        Assert.assertEquals((Object)this.groupId(), (Object)groupKey.key());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$36) {
                return x$36.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$37) {
                return x$37.offset;
            }
        }));
    }

    @Test
    public void testExpireGroupWithOffsetsOnly() {
        String memberId = "";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        this.mockGetPartition();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$5 = this.groupMetadataManager();
        GroupMetadata x$68 = group;
        String x$69 = memberId;
        scala.collection.immutable.Map x$70 = offsets;
        Serializable x$71 = new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$8;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$12(errors, this.commitErrors$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$8 = commitErrors$8;
            }
        };
        long x$72 = qual$5.storeOffsets$default$5();
        short x$73 = qual$5.storeOffsets$default$6();
        qual$5.storeOffsets(x$68, x$69, x$70, (Function1)x$71, x$72, x$73);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        Assert.assertEquals((long)2L, (long)records2.size());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;

            public final void apply(Record message) {
                Assert.assertTrue((boolean)message.hasKey());
                Assert.assertFalse((boolean)message.hasValue());
                OffsetKey offsetKey = (OffsetKey)GroupMetadataManager$.MODULE$.readMessageKey(message.key());
                Assert.assertEquals((Object)this.$outer.groupId(), (Object)offsetKey.key().group());
                Assert.assertEquals((Object)"foo", (Object)offsetKey.key().topicPartition().topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$38) {
                return x$38.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$39) {
                return x$39.offset;
            }
        }));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireOffsetsWithActiveGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$40) {
            }
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        this.mockGetPartition();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$6 = this.groupMetadataManager();
        GroupMetadata x$74 = group;
        String x$75 = memberId;
        scala.collection.immutable.Map x$76 = offsets;
        Serializable x$77 = new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$9;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Errors> errors) {
                this.$outer.kafka$coordinator$group$GroupMetadataManagerTest$$callback$13(errors, this.commitErrors$9);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$9 = commitErrors$9;
            }
        };
        long x$78 = qual$6.storeOffsets$default$5();
        short x$79 = qual$6.storeOffsets$default$6();
        qual$6.storeOffsets(x$74, x$75, x$76, (Function1)x$77, x$78, x$79);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.anyObject(MemoryRecords.class), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition2));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$41) {
                return x$41.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$42) {
                return x$42.offset;
            }
        }));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    /*
     * WARNING - void declaration
     */
    private Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> appendAndCaptureCallback() {
        void var1_1;
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        return var1_1;
    }

    private void expectAppendMessage(Errors error) {
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$1;

            public void answer() {
                ((Function1)this.capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$1 = capturedArgument$1;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
    }

    private SimpleRecord buildStableGroupRecordWithMember(String memberId) {
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        List memberProtocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", (Object)Array$.MODULE$.emptyByteArray())}));
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), "clientId", "clientHost", 30000, 10000, "consumer", memberProtocols);
        group.add(member);
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$43) {
            }
        });
        group.initNextGeneration();
        group.transitionTo((GroupState)Stable$.MODULE$);
        byte[] groupMetadataKey = GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId());
        byte[] groupMetadataValue = GroupMetadataManager$.MODULE$.groupMetadataValue(group, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})), GroupMetadataManager$.MODULE$.groupMetadataValue$default$3());
        return new SimpleRecord(groupMetadataKey, groupMetadataValue);
    }

    private void expectGroupMetadataLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records2) {
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        long endOffset = this.expectGroupMetadataLoad(logMock, startOffset, records2);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
    }

    private long expectGroupMetadataLoad(Log logMock, long startOffset, MemoryRecords records2) {
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size();
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)fileRecordsMock.readInto((ByteBuffer)EasyMock.anyObject(ByteBuffer.class), EasyMock.anyInt())).andReturn((Object)records2.buffer());
        EasyMock.replay((Object[])new Object[]{fileRecordsMock});
        return endOffset;
    }

    private Seq<SimpleRecord> createCommittedOffsetRecords(Map<TopicPartition, Object> committedOffsets, String groupId) {
        return ((TraversableOnce)committedOffsets.map((Function1)new Serializable(this, groupId){
            public static final long serialVersionUID = 0L;
            private final String groupId$1;

            public final SimpleRecord apply(Tuple2<TopicPartition, Object> x0$14) {
                Tuple2<TopicPartition, Object> tuple2 = x0$14;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset);
                    byte[] offsetCommitKey = GroupMetadataManager$.MODULE$.offsetCommitKey(this.groupId$1, topicPartition, GroupMetadataManager$.MODULE$.offsetCommitKey$default$3());
                    byte[] offsetCommitValue = GroupMetadataManager$.MODULE$.offsetCommitValue(offsetAndMetadata);
                    SimpleRecord simpleRecord = new SimpleRecord(offsetCommitKey, offsetCommitValue);
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
            {
                this.groupId$1 = groupId$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private String createCommittedOffsetRecords$default$2() {
        return this.groupId();
    }

    private void mockGetPartition() {
        EasyMock.expect((Object)this.replicaManager().getPartition(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)this.partition()));
        EasyMock.expect((Object)this.replicaManager().nonOfflinePartition(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)this.partition()));
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$1(Errors error, ObjectRef maybeError$1) {
        maybeError$1.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$2(Errors error, ObjectRef maybeError$2) {
        maybeError$2.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$3(Errors error, ObjectRef maybeError$3) {
        maybeError$3.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$4(Errors error, ObjectRef maybeError$4) {
        maybeError$4.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$5(scala.collection.immutable.Map errors, ObjectRef commitErrors$1) {
        commitErrors$1.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$6(scala.collection.immutable.Map errors, ObjectRef commitErrors$2) {
        commitErrors$2.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$7(scala.collection.immutable.Map errors, ObjectRef commitErrors$3) {
        commitErrors$3.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$8(scala.collection.immutable.Map errors, ObjectRef commitErrors$4) {
        commitErrors$4.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$9(scala.collection.immutable.Map errors, ObjectRef commitErrors$5) {
        commitErrors$5.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$10(scala.collection.immutable.Map errors, ObjectRef commitErrors$6) {
        commitErrors$6.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$11(scala.collection.immutable.Map errors, ObjectRef commitErrors$7) {
        commitErrors$7.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$12(scala.collection.immutable.Map errors, ObjectRef commitErrors$8) {
        commitErrors$8.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$group$GroupMetadataManagerTest$$callback$13(scala.collection.immutable.Map errors, ObjectRef commitErrors$9) {
        commitErrors$9.elem = new Some((Object)errors);
    }

    public GroupMetadataManagerTest() {
        this.groupId = "foo";
        this.groupPartitionId = 0;
        this.protocolType = "protocolType";
        this.rebalanceTimeout = 60000;
        this.sessionTimeout = 10000;
    }
}

