/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u000f\t!BK]1og\u0006\u001cG/[8o\u0013:$W\r\u001f+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0005\u0019\u0001\u0001\u0007\t\u0019!C\u00013\u0005!a-\u001b7f+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\tIwNC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"\u0001\u0002$jY\u0016D\u0011b\t\u0001A\u0002\u0003\u0007I\u0011\u0001\u0013\u0002\u0011\u0019LG.Z0%KF$\"!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bY\t\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007]\u0001\u0001\u000b\u0015\u0002\u000e\u0002\u000b\u0019LG.\u001a\u0011\t\u0013A\u0002\u0001\u0019!a\u0001\n\u0003\t\u0014!B5oI\u0016DX#\u0001\u001a\u0011\u0005Y\u0019\u0014B\u0001\u001b\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010C\u00057\u0001\u0001\u0007\t\u0019!C\u0001o\u0005I\u0011N\u001c3fq~#S-\u001d\u000b\u0003KaBq\u0001L\u001b\u0002\u0002\u0003\u0007!\u0007\u0003\u0004;\u0001\u0001\u0006KAM\u0001\u0007S:$W\r\u001f\u0011\t\u000fq\u0002!\u0019!C\u0001{\u00051qN\u001a4tKR,\u0012A\u0010\t\u0003M}J!\u0001Q\u0014\u0003\t1{gn\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002\u000f=4gm]3uA!)A\t\u0001C\u0001\u000b\u0006)1/\u001a;vaR\tQ\u0005\u000b\u0002D\u000fB\u0011\u0001JS\u0007\u0002\u0013*\u00111BD\u0005\u0003\u0017&\u0013aAQ3g_J,\u0007\"B'\u0001\t\u0003)\u0015\u0001\u0003;fCJ$wn\u001e8)\u00051{\u0005C\u0001%Q\u0013\t\t\u0016JA\u0003BMR,'\u000fC\u0003T\u0001\u0011\u0005Q)\u0001\u0012uKN$\bk\\:ji&|gnU3u\u0007>\u0014(/Z2uYf<\u0006.\u001a8Pa\u0016tW\r\u001a\u0015\u0003%V\u0003\"\u0001\u0013,\n\u0005]K%\u0001\u0002+fgRDQ!\u0017\u0001\u0005\u0002\u0015\u000bq\u0002^3tiN\u000bg.\u001b;z\u0007\",7m\u001b\u0015\u00051V[F,\u0001\u0005fqB,7\r^3eG\u0005i\u0006C\u00010g\u001d\tyFM\u0004\u0002aG6\t\u0011M\u0003\u0002c\r\u00051AH]8pizJ\u0011\u0001K\u0005\u0003K\u001e\nq\u0001]1dW\u0006<W-\u0003\u0002hQ\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005\u0015<\u0003\"\u00026\u0001\t\u0003)\u0015A\u0007;fgRd\u0015m\u001d;PM\u001a\u001cX\r^'vgRLen\u0019:fCN,\u0007\u0006B5V7rCQ!\u001c\u0001\u0005\u0002\u0015\u000bA\u0004^3ti2\u000b7\u000f^(gMN,GoQ1o]>$H)Z2sK\u0006\u001cX\r\u000b\u0003m+nc\u0006\"\u00029\u0001\t\u0003)\u0015A\b;fgR\u001cu\u000e\u001c7fGR\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8tQ\tyW\u000bC\u0003t\u0001\u0011\u0005Q)\u0001\u0007uKN$HK];oG\u0006$X\r\u000b\u0002s+\")a\u000f\u0001C\u0001\u000b\u0006\u0019B/Z:u\u0003\n|'\u000f^3e)bt7+\u001a:eK\"\u0012Q/\u0016\u0005\u0006s\u0002!\t!R\u0001\u0010i\u0016\u001cHOU3oC6,\u0017J\u001c3fq\"\u0012\u00010\u0016")
public class TransactionIndexTest
extends JUnitSuite {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @Before
    public void setup() {
        this.file_$eq(TestUtils$.MODULE$.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @After
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$1$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$1$1.append(abortedTxn);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assert.assertEquals((Object)abortedTxns.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{anotherAbortedTxn})), List$.MODULE$.canBuildFrom()), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSanityCheck() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$2$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$2$1.append(abortedTxn);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        reopenedIndex.sanityCheck();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 15L, 11L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
    }

    @Test
    public void testCollectAbortedTransactions() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$3$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$3$1.append(abortedTxn);
            }
            {
                this.eta$0$3$1 = eta$0$3$1;
            }
        });
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assert.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assert.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 2L), new AbortedTxn(1L, 5L, 15L, 16L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$4$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$4$1.append(abortedTxn);
            }
            {
                this.eta$0$4$1 = eta$0$4$1;
            }
        });
        this.index().truncateTo(51L);
        Assert.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncate();
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assert.assertEquals((long)AbortedTxn$.MODULE$.CurrentVersion(), (long)abortedTxn.version());
        Assert.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assert.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils$.MODULE$.tempFile();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assert.assertEquals((long)2L, (long)abortedTxns.size());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assert.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }
}

