/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511m\u001c8gS\u001e,\u0012\u0001\u000b\t\u0003%%J!A\u000b\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0004-\u0001\u0001\u0006I\u0001K\u0001\bG>tg-[4!\u0011\u001dq\u0003\u00011A\u0005\u0002=\nAB\\;n\u0007\u0006dGNY1dWN,\u0012\u0001\r\t\u0003\u0013EJ!A\r\u0006\u0003\u0007%sG\u000fC\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001\u001c:!\tIq'\u0003\u00029\u0015\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005ia.^7DC2d'-Y2lg\u0002BQA\u0010\u0001\u0005\u0002}\n\u0001bY1mY\n\f7m\u001b\u000b\u0003m\u0001CQ!Q\u001fA\u0002A\n1\u0002Z3mCf$\u0016.\\3Ng\")1\t\u0001C\u0001\t\u0006a!-\u001a4pe\u0016lU\r\u001e5pIR\ta\u0007\u000b\u0002C\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011jH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\"\u0013aAQ3g_J,\u0007\"B'\u0001\t\u0013q\u0015\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)%1t\nUAM\u0003;\u000b\t\u000bC\u0003'\u0019\u0002\u0007\u0001\u0006C\u0003R\u0019\u0002\u0007!+A\u0004dY&,g\u000e^\u0019\u0011\u0005M#V\"\u0001\u0001\u0007\tU\u0003AI\u0016\u0002\u000b+N,'o\u00117jK:$8\u0003\u0002+\t/j\u0003\"!\u0003-\n\u0005eS!a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013mK!\u0001\u0018\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y#&Q3A\u0005\u0002}\u000bA!^:feV\t\u0001\r\u0005\u0002bI:\u0011\u0011BY\u0005\u0003G*\ta\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111M\u0003\u0005\tQR\u0013\t\u0012)A\u0005A\u0006)Qo]3sA!A!\u000e\u0016BK\u0002\u0013\u0005q,\u0001\u0005dY&,g\u000e^%e\u0011!aGK!E!\u0002\u0013\u0001\u0017!C2mS\u0016tG/\u00133!\u0011!qGK!f\u0001\n\u0003y\u0017AC2p]\u001aLw-V:feV\t\u0001\u000fE\u0002\nc\u0002L!A\u001d\u0006\u0003\r=\u0003H/[8o\u0011!!HK!E!\u0002\u0013\u0001\u0018aC2p]\u001aLw-V:fe\u0002B\u0001B\u001e+\u0003\u0016\u0004%\ta\\\u0001\u000fG>tg-[4DY&,g\u000e^%e\u0011!AHK!E!\u0002\u0013\u0001\u0018aD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0011\t\u000b=!F\u0011\u0001>\u0015\u000bI[H0 @\t\u000byK\b\u0019\u00011\t\u000b)L\b\u0019\u00011\t\u000f9L\b\u0013!a\u0001a\"9a/\u001fI\u0001\u0002\u0004\u0001\bbBA\u0001)\u0012\u0005\u00111A\u0001\u0018g\u0006t\u0017\u000e^5{K\u0012\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012,\"!!\u0002\u0011\t%\t\u0018q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0011\u0001\u00026bm\u0006L1!ZA\u0006\u0011%\t9\u0002VA\u0001\n\u0003\tI\"\u0001\u0003d_BLH#\u0003*\u0002\u001c\u0005u\u0011qDA\u0011\u0011!q\u0016Q\u0003I\u0001\u0002\u0004\u0001\u0007\u0002\u00036\u0002\u0016A\u0005\t\u0019\u00011\t\u00119\f)\u0002%AA\u0002AD\u0001B^A\u000b!\u0003\u0005\r\u0001\u001d\u0005\n\u0003K!\u0016\u0013!C\u0001\u0003O\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002*)\u001a\u0001-a\u000b,\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000e\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\t\tDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0010U#\u0003%\t!a\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\t+\u0012\u0002\u0013\u0005\u0011QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t9EK\u0002q\u0003WA\u0011\"a\u0013U#\u0003%\t!!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!I\u0011q\n+\u0002\u0002\u0013\u0005\u0013\u0011K\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0001\u0002CA+)\u0006\u0005I\u0011A\u0018\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005eC+!A\u0005\u0002\u0005m\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\n\u0019\u0007E\u0002\n\u0003?J1!!\u0019\u000b\u0005\r\te.\u001f\u0005\tu\u0005]\u0013\u0011!a\u0001a!I\u0011q\r+\u0002\u0002\u0013\u0005\u0013\u0011N\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000e\t\u0007\u0003[\n\u0019(!\u0018\u000e\u0005\u0005=$bAA9\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0014q\u000e\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011\u0010+\u0002\u0002\u0013\u0005\u00111P\u0001\tG\u0006tW)];bYR!\u0011QPAB!\rI\u0011qP\u0005\u0004\u0003\u0003S!a\u0002\"p_2,\u0017M\u001c\u0005\nu\u0005]\u0014\u0011!a\u0001\u0003;B\u0011\"a\"U\u0003\u0003%\t%!#\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\r\u0005\n\u0003\u001b#\u0016\u0011!C!\u0003\u001f\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000fA\u0011\"a%U\u0003\u0003%\t%!&\u0002\r\u0015\fX/\u00197t)\u0011\ti(a&\t\u0013i\n\t*!AA\u0002\u0005u\u0003BBAN\u0019\u0002\u0007!+A\u0004dY&,g\u000e\u001e\u001a\t\r\u0005}E\n1\u0001S\u00031\u0011\u0018M\u001c3p[\u000ec\u0017.\u001a8u\u0011\u0019\t\u0019\u000b\u0014a\u0001%\u0006\u0019B-\u001a4bk2$8i\u001c8gS\u001e\u001cE.[3oi\"1\u0011q\u0015\u0001\u0005\u0002\u0011\u000b\u0001\u0004^3ti\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b!\u0006\u00148/\u001b8hQ\u0011\t)+a+\u0011\u0007\u001d\u000bi+C\u0002\u00020\"\u0013A\u0001V3ti\"1\u00111\u0017\u0001\u0005\u0002\u0011\u000bA\u0003^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<\u0007\u0006BAY\u0003WCa!!/\u0001\t\u0003!\u0015\u0001\b;fgR,6/\u001a:DY&,g\u000e^%e#V|G/\u0019)beNLgn\u001a\u0015\u0005\u0003o\u000bY\u000b\u0003\u0004\u0002@\u0002!\t\u0001R\u0001-i\u0016\u001cH/V:feF+x\u000e^1QCJ\u001c\u0018N\\4XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006DC!!0\u0002,\"1\u0011Q\u0019\u0001\u0005\u0002\u0011\u000bA\u0007^3tiV\u001bXM]\"mS\u0016tG/U;pi\u0006\u0004\u0016M]:j]\u001eLEmV5uQ\u0012+g-Y;mi\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;bQ\u0011\t\u0019-a+\t\r\u0005-\u0007\u0001\"\u0001E\u0003e!Xm\u001d;Rk>$\u0018mQ8oM&<\u0007K]3dK\u0012,gnY3)\t\u0005%\u00171\u0016\u0005\u0007\u0003#\u0004A\u0011\u0001#\u0002%Q,7\u000f^)v_R\fg+[8mCRLwN\u001c\u0015\u0005\u0003\u001f\fY\u000b\u0003\u0004\u0002X\u0002!\t\u0001R\u0001$i\u0016\u001cHOU3rk\u0016\u001cH\u000fU3sG\u0016tG/Y4f#V|G/\u0019,j_2\fG/[8oQ\u0011\t).a+\t\r\u0005u\u0007\u0001\"\u0001E\u0003q!Xm\u001d;FqBL'/\u001a+ie>$H\u000f\\3US6,7+\u001a8t_JDC!a7\u0002,\"1\u00111\u001d\u0001\u0005\u0002\u0011\u000ba\u0003^3ti\u0016C\b/\u001b:f#V|G/Y*f]N|'o\u001d\u0015\u0005\u0003C\fY\u000b\u0003\u0004\u0002j\u0002!\t\u0001R\u0001\u0019i\u0016\u001cHo\u00117jK:$\u0018\n\u001a(piN\u000bg.\u001b;ju\u0016$\u0007\u0006BAt\u0003WCq!a<\u0001\t\u0003\t\t0\u0001\u0006oK^lU\r\u001e:jGN,\"!a=\u0011\t\u0005U\u00181`\u0007\u0003\u0003oT1!!?\u001b\u0003\u001diW\r\u001e:jGNLA!!@\u0002x\n9Q*\u001a;sS\u000e\u001cx!\u0003B\u0001\u0001\u0005\u0005\t\u0012\u0002B\u0002\u0003))6/\u001a:DY&,g\u000e\u001e\t\u0004'\n\u0015a\u0001C+\u0001\u0003\u0003EIAa\u0002\u0014\u000b\t\u0015!\u0011\u0002.\u0011\u0013\t-!\u0011\u00031aaB\u0014VB\u0001B\u0007\u0015\r\u0011yAC\u0001\beVtG/[7f\u0013\u0011\u0011\u0019B!\u0004\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007C\u0004\u0010\u0005\u000b!\tAa\u0006\u0015\u0005\t\r\u0001BCAG\u0005\u000b\t\t\u0011\"\u0012\u0002\u0010\"Q!Q\u0004B\u0003\u0003\u0003%\tIa\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013I\u0013\tCa\t\u0003&\t\u001d\u0002B\u00020\u0003\u001c\u0001\u0007\u0001\r\u0003\u0004k\u00057\u0001\r\u0001\u0019\u0005\t]\nm\u0001\u0013!a\u0001a\"AaOa\u0007\u0011\u0002\u0003\u0007\u0001\u000f\u0003\u0006\u0003,\t\u0015\u0011\u0011!CA\u0005[\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u00030\t]\u0002\u0003B\u0005r\u0005c\u0001r!\u0003B\u001aA\u0002\u0004\b/C\u0002\u00036)\u0011a\u0001V;qY\u0016$\u0004\"\u0003B\u001d\u0005S\t\t\u00111\u0001S\u0003\rAH\u0005\r\u0005\u000b\u0005{\u0011)!%A\u0005\u0002\u0005\u0015\u0013aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\t\u0005#QAI\u0001\n\u0003\t)%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011)E!\u0002\u0012\u0002\u0013\u0005\u0011QI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0015\t%#QAI\u0001\n\u0003\t)%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e")
public class ClientQuotaManagerTest {
    private final MockTime kafka$server$ClientQuotaManagerTest$$time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;
    private volatile ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.kafka$server$ClientQuotaManagerTest$$UserClient$module != null) return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
            this.kafka$server$ClientQuotaManagerTest$$UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
        }
    }

    public MockTime kafka$server$ClientQuotaManagerTest$$time() {
        return this.kafka$server$ClientQuotaManagerTest$$time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(int delayTimeMs) {
        this.numCallbacks_$eq(this.numCallbacks() + 1);
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder().append((Object)"Default producer quota should be ").append((Object)BoxesRunTime.boxToLong((long)config.quotaBytesPerSecondDefault())).toString(), (Object)new Quota((double)config.quotaBytesPerSecondDefault(), true), (Object)clientMetrics.quota(randomClient.user(), randomClient.clientId()));
            Assert.assertEquals((String)"Should return the overridden value (2000)", (Object)new Quota(2000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            Assert.assertEquals((String)"Should return the overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota(client2.user(), client2.clientId()));
            int throttleTimeMs = clientMetrics.maybeRecordAndThrottle(client1.user(), client1.clientId(), (double)(2500 * config.numQuotaSamples()), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (Object)new Quota(3000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.maybeRecordAndThrottle(client1.user(), client1.clientId(), 0.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (Object)new Quota(500.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.maybeRecordAndThrottle(client1.user(), client1.clientId(), 0.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.maybeRecordAndThrottle(client1.user(), client1.clientId(), (double)(1000 * config.numQuotaSamples()), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.clientMetrics$1.maybeRecordAndThrottle("ANONYMOUS", "unknown", 400.0, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testQuotaViolation$1 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int sleepTime = clientMetrics.maybeRecordAndThrottle("ANONYMOUS", "unknown", 2300.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            Assert.assertEquals((long)1L, (long)((int)queueSizeMetric.value()));
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)sleepTime);
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            Assert.assertEquals((long)11L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.clientMetrics$1.maybeRecordAndThrottle("ANONYMOUS", "unknown", 400.0, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testQuotaViolation$2 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)clientMetrics.maybeRecordAndThrottle("ANONYMOUS", "unknown", 0.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRequestPercentageQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.quotaManager$2.maybeRecordAndThrottle("ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testRequestPercentageQuotaViolation$1 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int throttleTime = quotaManager.maybeRecordAndThrottle("ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(67.1), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            Assert.assertEquals((long)1L, (long)((int)queueSizeMetric.value()));
            quotaManager.throttledRequestReaper().doWork();
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)throttleTime);
            quotaManager.throttledRequestReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            Assert.assertEquals((long)11L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.quotaManager$2.maybeRecordAndThrottle("ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testRequestPercentageQuotaViolation$2 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)quotaManager.maybeRecordAndThrottle("ANONYMOUS", "test-client", 0.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            Assert.assertEquals((long)1000L, (long)quotaManager.maybeRecordAndThrottle("ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(500.0), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                    Assert.assertEquals((long)1000L, (long)this.quotaManager$2.maybeRecordAndThrottle("ANONYMOUS", "test-client", 0.0, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testRequestPercentageQuotaViolation$5 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)quotaManager.maybeRecordAndThrottle("ANONYMOUS", "test-client", 0.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireThrottleTimeSensor() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            clientMetrics.maybeRecordAndThrottle("ANONYMOUS", "client1", 100.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            metrics.removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = clientMetrics.maybeRecordAndThrottle("ANONYMOUS", "client1", 10000.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaSensors() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            clientMetrics.maybeRecordAndThrottle("ANONYMOUS", "client1", 100.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            metrics.removeSensor("ProduceThrottleTime-:client1");
            metrics.removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = clientMetrics.maybeRecordAndThrottle("ANONYMOUS", "client1", 10000.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientIdNotSanitized() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        String clientId = "client@#$%";
        try {
            clientMetrics.maybeRecordAndThrottle("ANONYMOUS", clientId, 100.0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Sensor throttleTimeSensor = metrics.getSensor(new StringBuilder().append((Object)"ProduceThrottleTime-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor(new StringBuilder().append((Object)"Produce-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    }

    public ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient() {
        return this.kafka$server$ClientQuotaManagerTest$$UserClient$module == null ? this.kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() : this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((Object)new Quota((double)expectedBound, true), (Object)quotaManager$1.quota(user, clientId));
        int throttleTimeMs = quotaManager$1.maybeRecordAndThrottle(user, clientId, (double)(value * this.config().numQuotaSamples()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManagerTest $outer;

            public final void apply(int delayTimeMs) {
                this.apply$mcVI$sp(delayTimeMs);
            }

            public void apply$mcVI$sp(int delayTimeMs) {
                this.$outer.callback(delayTimeMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (expectThrottle) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
    }

    public final double kafka$server$ClientQuotaManagerTest$$millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    String string = x;
                    String string2 = ConfigEntityName$.MODULE$.Default();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
                }
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = this.configClientId();
                    break;
                }
                case 2: {
                    object = this.configUser();
                    break;
                }
                case 1: {
                    object = this.clientId();
                    break;
                }
                case 0: {
                    object = this.user();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

