/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001cE\u0004\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013#\u0011\u001dQ\u0003\u00011A\u0005\n-\nA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001L\u0018\u0011\u0005\u0005j\u0013B\u0001\u0018#\u0005\u0011)f.\u001b;\t\u000fAJ\u0013\u0011!a\u0001'\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003\u0014\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u00035\u0001\u0011\u0005S'\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005a\u0003\"B\u001c\u0001\t\u0013A\u0014AE2sK\u0006$XMR3uG\"\u0014V-];fgR$R!O!G\u0011j\u0003\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0011I,\u0017/^3tiNT!A\u0010\r\u0002\r\r|W.\\8o\u0013\t\u00015H\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0003Cm\u0001\u00071)\u0001\tnCb\u0014Vm\u001d9p]N,')\u001f;fgB\u0011\u0011\u0005R\u0005\u0003\u000b\n\u00121!\u00138u\u0011\u00159e\u00071\u0001D\u0003Ei\u0017\r\u001f)beRLG/[8o\u0005f$Xm\u001d\u0005\u0006\u0013Z\u0002\rAS\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB\u00191j\u0015,\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002SE\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\r\u0019V-\u001d\u0006\u0003%\n\u0002\"a\u0016-\u000e\u0003uJ!!W\u001f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")1L\u000ea\u00019\u0006IqN\u001a4tKRl\u0015\r\u001d\t\u0005Au3v,\u0003\u0002_Q\t\u0019Q*\u00199\u0011\u0005\u0005\u0002\u0017BA1#\u0005\u0011auN\\4\t\u000b\r\u0004A\u0011\u00023\u0002%\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u000b\u0005KR,h\u000f\u0005\u0003gWZkW\"A4\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"A\\9\u000f\u0005iz\u0017B\u00019<\u000311U\r^2i%\u0016\fX/Z:u\u0013\t\u00118OA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0003anBQa\u00122A\u0002\rCQ!\u00132A\u0002)Cqa\u00172\u0011\u0002\u0003\u0007A\fC\u0003y\u0001\u0011%\u00110\u0001\ttK:$g)\u001a;dQJ+\u0017/^3tiR\u0019!0`@\u0011\u0005iZ\u0018B\u0001?<\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\")ap\u001ea\u0001\u0007\u0006AA.Z1eKJLE\r\u0003\u0004\u0002\u0002]\u0004\r!O\u0001\be\u0016\fX/Z:u\u0011\u0019\t)\u0001\u0001C\u0005k\u0005a\u0011N\\5u!J|G-^2fe\"1\u0011\u0011\u0002\u0001\u0005\u0002U\na\u0006^3ti\n\u0013xn[3s%\u0016\u001c\b/Z2ugB\u000b'\u000f^5uS>t7o\u0014:eKJ\fe\u000eZ*ju\u0016d\u0015.\\5ug\"\"\u0011qAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n7\u0005)!.\u001e8ji&!\u0011qCA\t\u0005\u0011!Vm\u001d;\t\r\u0005m\u0001\u0001\"\u00016\u0003\u0019\"Xm\u001d;GKR\u001c\u0007NU3rk\u0016\u001cHO\u0016\u001aXSRDwJ^3sg&TX\rZ'fgN\fw-\u001a\u0015\u0005\u00033\ti\u0001\u0003\u0004\u0002\"\u0001!\t!N\u00017i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gN\u0012:p[\n\u000bGo\u00195fIR{WK\u001c2bi\u000eDW\r\u001a*fgB,7\r^:PM\u001a\u001cX\r\u001e\u0015\u0005\u0003?\ti\u0001C\u0004\u0002(\u0001!I!!\u000b\u0002\u000fI,7m\u001c:egR!\u00111FA\u001d!\u0011Y5+!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r>\u0003\u0019\u0011XmY8sI&!\u0011qGA\u0019\u0005\u0019\u0011VmY8sI\"A\u00111HA\u0013\u0001\u0004\ti$A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003\u007f\t)ED\u0002;\u0003\u0003J1!a\u0011<\u000351U\r^2i%\u0016\u001c\bo\u001c8tK&\u0019!/a\u0012\u000b\u0007\u0005\r3\bC\u0004\u0002L\u0001!I!!\u0014\u0002%\rDWmY6GKR\u001c\u0007NU3ta>t7/\u001a\u000b\fY\u0005=\u00131KA,\u00033\nY\u0006C\u0004\u0002R\u0005%\u0003\u0019\u0001&\u0002%\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003+\nI\u00051\u0001{\u000351W\r^2i%\u0016\u001c\bo\u001c8tK\"1q)!\u0013A\u0002\rCaAQA%\u0001\u0004\u0019\u0005bBA/\u0003\u0013\u0002\raQ\u0001\u0018]VlW*Z:tC\u001e,7\u000fU3s!\u0006\u0014H/\u001b;j_:Dq!!\u0019\u0001\t\u0013\t\u0019'\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0005\u0002f\u0005\u001d\u00141NA8!\u0011\u0001SLV\"\t\u000f\u0005%\u0014q\fa\u0001\u0007\u0006Ia.^7U_BL7m\u001d\u0005\b\u0003[\ny\u00061\u0001D\u00035qW/\u001c)beRLG/[8og\"Q\u0011\u0011OA0!\u0003\u0005\r!a\u001d\u0002\u000f\r|gNZ5hgB!\u0001%X\u0010 \u0011\u001d\t9\b\u0001C\u0005\u0003s\n1\u0002\u001d:pIV\u001cW\rR1uCR1\u00111PAB\u0003\u0017\u0003BaS*\u0002~A)A#a  ?%\u0019\u0011\u0011Q\u000b\u0003\u001dA\u0013x\u000eZ;dKJ\u0014VmY8sI\"9\u0011*!\u001eA\u0002\u0005\u0015\u0005\u0003B&\u0002\bZK1!!#V\u0005!IE/\u001a:bE2,\u0007bBA/\u0003k\u0002\ra\u0011\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0005\u0003#\u000bAd\u0019:fCR,\u0007+\u0019:uSRLwN\\'ba\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0014*\u001aA,!&,\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!)#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!+\u0001#\u0003%I!a+\u0002-\r\u0014X-\u0019;f)>\u0004\u0018nY:%I\u00164\u0017-\u001e7uIM*\"!!,+\t\u0005M\u0014Q\u0013")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer = null;

    public KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer() {
        return this.kafka$server$FetchRequestTest$$producer;
    }

    private void kafka$server$FetchRequestTest$$producer_$eq(KafkaProducer<String, String> x$1) {
        this.kafka$server$FetchRequestTest$$producer = x$1;
    }

    @Override
    public void tearDown() {
        this.kafka$server$FetchRequestTest$$producer().close();
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1)new Serializable(this, maxPartitionBytes, offsetMap, partitionMap){
            public static final long serialVersionUID = 0L;
            private final int maxPartitionBytes$1;
            private final scala.collection.immutable.Map offsetMap$1;
            private final LinkedHashMap partitionMap$1;

            public final FetchRequest.PartitionData apply(TopicPartition tp) {
                return this.partitionMap$1.put(tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)this.offsetMap$1.getOrElse((Object)tp, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })), 0L, this.maxPartitionBytes$1));
            }
            {
                this.maxPartitionBytes$1 = maxPartitionBytes$1;
                this.offsetMap$1 = offsetMap$1;
                this.partitionMap$1 = partitionMap$1;
            }
        });
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private void initProducer() {
        String x$12 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$13 = 5;
        StringSerializer x$14 = new StringSerializer();
        StringSerializer x$15 = new StringSerializer();
        int x$16 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$17 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$18 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$19 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$20 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$21 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$22 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$23 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$24 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createNewProducer(x$12, x$16, x$17, x$18, x$13, x$19, x$20, x$21, x$22, x$23, x$14, x$15, x$24));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1)new Serializable(this, partitionsWithLargeMessages){
            public static final long serialVersionUID = 0L;
            private final Vector partitionsWithLargeMessages$1;

            public final boolean apply(Object elem) {
                return this.partitionsWithLargeMessages$1.contains(elem);
            }
            {
                this.partitionsWithLargeMessages$1 = partitionsWithLargeMessages$1;
            }
        });
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse3.responseData()).asScala()).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final int apply(FetchResponse.PartitionData partitionData) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$1) {
                        return x$1.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records(partitionData3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$2) {
                return x$2.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be smaller than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxPartitionBytes)})), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < partitionData3.records.sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Record x$3) {
                            return x$3.sizeInBytes();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData = (FetchResponse.PartitionData)tuple2._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$3) {
                        return x$3.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records(partitionData4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$4) {
                return x$4.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size4), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < partitionData4.records.sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
            FetchResponse fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes, (long)partitionData.records.sizeInBytes());
            Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records(partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$6) {
                    return x$6.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$25 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$26 = 5;
        StringSerializer x$27 = new StringSerializer();
        StringSerializer x$28 = new StringSerializer();
        long x$29 = 300000L;
        int x$30 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$31 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$32 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$33 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$34 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$35 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$36 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$37 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createNewProducer(x$25, x$30, x$31, x$32, x$26, x$29, x$33, x$34, x$35, x$36, x$27, x$28, x$37));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String topic = topicPartition2.topic();
            IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            firstBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$8) {
                    return x$8.get();
                }
            });
            secondBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                    return x$9.get();
                }
            });
            long x$38 = 3L;
            long x$39 = 3L;
            short x$40 = 1;
            int x$41 = 22;
            byte x$42 = 0;
            this.check$1(x$38, x$40, x$39, x$41, x$42, topicPartition2, leaderId2);
            long x$43 = 15L;
            long x$44 = 15L;
            short x$45 = 1;
            int x$46 = 10;
            byte x$47 = 0;
            this.check$1(x$43, x$45, x$44, x$46, x$47, topicPartition2, leaderId2);
            long x$48 = 3L;
            long x$49 = 3L;
            short x$50 = 3;
            int x$51 = 22;
            byte x$52 = 1;
            this.check$1(x$48, x$50, x$49, x$51, x$52, topicPartition2, leaderId2);
            long x$53 = 15L;
            long x$54 = 15L;
            short x$55 = 3;
            int x$56 = 10;
            byte x$57 = 1;
            this.check$1(x$53, x$55, x$54, x$56, x$57, topicPartition2, leaderId2);
            long x$58 = 3L;
            long x$59 = 0L;
            short x$60 = 4;
            int x$61 = 2;
            byte x$62 = 2;
            this.check$1(x$58, x$60, x$59, x$61, x$62, topicPartition2, leaderId2);
            long x$63 = 15L;
            long x$64 = 10L;
            short x$65 = 4;
            int x$66 = 1;
            byte x$67 = 2;
            this.check$1(x$63, x$65, x$64, x$66, x$67, topicPartition2, leaderId2);
            long x$68 = 10L;
            long x$69 = 10L;
            short x$70 = 4;
            int x$71 = 1;
            byte x$72 = 2;
            this.check$1(x$68, x$70, x$69, x$71, x$72, topicPartition2, leaderId2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partitionData.records.records()).asScala()).toIndexedSeq();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1)new Serializable(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final FetchResponse fetchResponse$1;
            private final int maxPartitionBytes$3;
            private final int numMessagesPerPartition$2;
            private final BooleanRef emptyResponseSeen$1;
            private final IntRef responseSize$1;
            private final IntRef responseBufferSize$1;

            public final void apply(TopicPartition tp) {
                FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.fetchResponse$1.responseData().get(tp);
                Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
                Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
                Records records2 = partitionData.records;
                this.responseBufferSize$1.elem += records2.sizeInBytes();
                IndexedSeq batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).toIndexedSeq();
                Assert.assertTrue((batches.size() < this.numMessagesPerPartition$2 ? 1 : 0) != 0);
                int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(RecordBatch x$10) {
                        return x$10.sizeInBytes();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.responseSize$1.elem += batchesSize;
                if (batchesSize == 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertEquals((long)0L, (long)records2.sizeInBytes());
                    this.emptyResponseSeen$1.elem = true;
                } else if (batchesSize != 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertTrue((batchesSize <= this.maxPartitionBytes$3 ? 1 : 0) != 0);
                    Assert.assertEquals((long)this.maxPartitionBytes$3, (long)records2.sizeInBytes());
                } else {
                    if (batchesSize != 0 && this.emptyResponseSeen$1.elem) {
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)batchesSize)})), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
                    }
                    if (records2.sizeInBytes() != 0 && this.emptyResponseSeen$1.elem) {
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition buffer with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)records2.sizeInBytes())})), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResponse$1 = fetchResponse$1;
                this.maxPartitionBytes$3 = maxPartitionBytes$3;
                this.numMessagesPerPartition$2 = numMessagesPerPartition$2;
                this.emptyResponseSeen$1 = emptyResponseSeen$1;
                this.responseSize$1 = responseSize$1;
                this.responseBufferSize$1 = responseBufferSize$1;
            }
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.topicConfig$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        });
        return ((TraversableOnce)topics.flatMap((Function1)new Serializable(this, numPartitions, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final int numPartitions$1;
            private final Properties topicConfig$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(String topic) {
                scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.$outer.zkUtils(), topic, this.numPartitions$1, 2, (Seq<KafkaServer>)this.$outer.servers(), this.topicConfig$1);
                return (scala.collection.immutable.Map)partitionToLeader.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$2;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            int leader2 = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$2, partition)), (Object)BoxesRunTime.boxToInteger((int)leader2));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$2 = topic$2;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numPartitions$1 = numPartitions$1;
                this.topicConfig$1 = topicConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records2 = (Seq)topicPartitions.toSeq().flatMap((Function1)new Serializable(this, numMessagesPerPartition){
            public static final long serialVersionUID = 0L;
            private final int numMessagesPerPartition$1;

            public final IndexedSeq<ProducerRecord<String, String>> apply(TopicPartition tp) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numMessagesPerPartition$1).map((Function1)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition tp$1;

                    public final ProducerRecord<String, String> apply(int messageIndex) {
                        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToInteger((int)messageIndex)}));
                        return new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
                    }
                    {
                        this.tp$1 = tp$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numMessagesPerPartition$1 = numMessagesPerPartition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final RecordMetadata apply(ProducerRecord<String, String> x$11) {
                return (RecordMetadata)this.$outer.kafka$server$FetchRequestTest$$producer().send(x$11).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$1, int leaderId$2) {
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$1), (Object)BoxesRunTime.boxToLong((long)fetchOffset))}))))).build(requestVersion);
        FetchResponse fetchResponse = this.sendFetchRequest(leaderId$2, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partitionData.records.batches()).asScala()).toBuffer();
        Assert.assertEquals((long)expectedNumBatches, (long)batches.size());
        RecordBatch batch = (RecordBatch)batches.head();
        Assert.assertEquals((long)expectedMagic, (long)batch.magic());
        Assert.assertEquals((long)expectedOffset, (long)batch.baseOffset());
    }
}

