/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.AdminClientIntegrationTest$;
import kafka.api.AdminClientIntegrationTest$$anonfun$testDescribeLogDirs$1$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012!D4m_\n\fG\u000eV5nK>,H/F\u0001\u001d!\tiB%D\u0001\u001f\u0015\ty\u0002%A\u0003sk2,7O\u0003\u0002\"E\u0005)!.\u001e8ji*\t1%A\u0002pe\u001eL!!\n\u0010\u0003\u000fQKW.Z8vi\"\u0012\u0011d\n\t\u0003Q%j\u0011\u0001I\u0005\u0003U\u0001\u0012AAU;mK\"9A\u0006\u0001a\u0001\n\u0003i\u0013AB2mS\u0016tG/F\u0001/!\tys'D\u00011\u0015\t\t$'A\u0003bI6LgN\u0003\u00024i\u000591\r\\5f]R\u001c(BA\u00036\u0015\t1$%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003qA\u00121\"\u00113nS:\u001cE.[3oi\"9!\b\u0001a\u0001\n\u0003Y\u0014AC2mS\u0016tGo\u0018\u0013fcR\u0011AH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0005+:LG\u000fC\u0004Ds\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006KAL\u0001\bG2LWM\u001c;!\u0011\u00159\u0005\u0001\"\u0011I\u0003\u0015\u0019X\r^+q)\u0005a\u0004F\u0001$K!\tA3*\u0003\u0002MA\t1!)\u001a4pe\u0016DQA\u0014\u0001\u0005B!\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u001bB\u0003\"\u0001K)\n\u0005I\u0003#!B!gi\u0016\u0014\bb\u0002+\u0001\u0005\u0004%\t!V\u0001\fEJ|7.\u001a:D_VtG/F\u0001W!\tit+\u0003\u0002Y}\t\u0019\u0011J\u001c;\t\ri\u0003\u0001\u0015!\u0003W\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011!a\u0006\u0001#b\u0001\n\u0003i\u0016\u0001D:feZ,'oQ8oM&<W#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001B;uS2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\nQ\u0001K]8qKJ$\u0018.Z:\t\u0011\u001d\u0004\u0001\u0012!Q!\ny\u000bQb]3sm\u0016\u00148i\u001c8gS\u001e\u0004\u0003\"B5\u0001\t\u0003Q\u0017\u0001D2sK\u0006$XmQ8oM&<G#A6\u0011\t}cg.^\u0005\u0003[\u0002\u00141!T1q!\ty'O\u0004\u0002>a&\u0011\u0011OP\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002r}A\u0011a/_\u0007\u0002o*\u0011\u0001PY\u0001\u0005Y\u0006tw-\u0003\u0002{o\n1qJ\u00196fGRDQ\u0001 \u0001\u0005\u0002u\fQb^1ji\u001a{'\u000fV8qS\u000e\u001cH#\u0002\u001f\u007f\u007f\u0006m\u0001\"\u0002\u0017|\u0001\u0004q\u0003bBA\u0001w\u0002\u0007\u00111A\u0001\u0010Kb\u0004Xm\u0019;fIB\u0013Xm]3oiB)\u0011QAA\u000b]:!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\r\u00051AH]8pizJ\u0011aP\u0005\u0004\u0003'q\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIBA\u0002TKFT1!a\u0005?\u0011\u001d\tib\u001fa\u0001\u0003\u0007\tq\"\u001a=qK\u000e$X\rZ'jgNLgn\u001a\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003}\t7o]3si\u001a+H/\u001e:f\u000bb\u001cW\r\u001d;j_:$\u0016\u0010]3FcV\fGn\u001d\u000b\u0006y\u0005\u0015\u0012Q\n\u0005\t\u0003O\ty\u00021\u0001\u0002*\u00051a-\u001e;ve\u0016\u0004D!a\u000b\u0002<A1\u0011QFA\u001a\u0003oi!!a\f\u000b\u0007\u0005EB'\u0001\u0004d_6lwN\\\u0005\u0005\u0003k\tyCA\u0006LC\u001a\\\u0017MR;ukJ,\u0007\u0003BA\u001d\u0003wa\u0001\u0001\u0002\u0007\u0002>\u0005\u0015\u0012\u0011!A\u0001\u0006\u0003\tyDA\u0002`IE\nB!!\u0011\u0002HA\u0019Q(a\u0011\n\u0007\u0005\u0015cHA\u0004O_RD\u0017N\\4\u0011\u0007u\nI%C\u0002\u0002Ly\u00121!\u00118z\u0011!\ty%a\bA\u0002\u0005E\u0013!B2mCjT\b\u0007BA*\u00037\u0002Ra\\A+\u00033J1!a\u0016u\u0005\u0015\u0019E.Y:t!\u0011\tI$a\u0017\u0005\u0019\u0005u\u0013QJA\u0001\u0002\u0003\u0015\t!a\u0018\u0003\u0007}##'\u0005\u0003\u0002B\u0005\u0005\u0004\u0003BA\u0003\u0003GJA!!\u001a\u0002\u001a\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\u0007\u0003S\u0002A\u0011\u0001%\u0002\u0013Q,7\u000f^\"m_N,\u0007\u0006BA4\u0003[\u00022\u0001KA8\u0013\r\t\t\b\t\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002v\u0001!\t\u0001S\u0001\u000ei\u0016\u001cH\u000fT5ti:{G-Z:)\t\u0005M\u0014Q\u000e\u0005\u0007\u0003w\u0002A\u0011\u0001%\u0002-Q,7\u000f^\"sK\u0006$X\rR3mKR,Gk\u001c9jGNDC!!\u001f\u0002n!1\u0011\u0011\u0011\u0001\u0005\u0002!\u000bA\u0004^3ti\u0012+7o\u0019:jE\u0016tuN\\#ySN$\u0018N\\4U_BL7\r\u000b\u0003\u0002\u0000\u00055\u0004BBAD\u0001\u0011\u0005\u0001*A\nuKN$H)Z:de&\u0014Wm\u00117vgR,'\u000f\u000b\u0003\u0002\u0006\u00065\u0004BBAG\u0001\u0011\u0005\u0001*A\nuKN$H)Z:de&\u0014W\rT8h\t&\u00148\u000f\u000b\u0003\u0002\f\u00065\u0004BBAJ\u0001\u0011\u0005\u0001*\u0001\u000euKN$H)Z:de&\u0014WMU3qY&\u001c\u0017\rT8h\t&\u00148\u000f\u000b\u0003\u0002\u0012\u00065\u0004BBAM\u0001\u0011\u0005\u0001*\u0001\u0016uKN$\u0018\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sg\n+gm\u001c:f)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\t\u0005]\u0015Q\u000e\u0005\u0007\u0003?\u0003A\u0011\u0001%\u00027Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012\fE\u000e^3s\u0007>tg-[4tQ\u0011\ti*!\u001c\t\r\u0005\u0015\u0006\u0001\"\u0001I\u0003Q!Xm\u001d;De\u0016\fG/\u001a)beRLG/[8og\"\"\u00111UA7\u0011\u0019\tY\u000b\u0001C\u0001\u0011\u00069B/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0005\u0003S\u000bi\u0007C\u0005\u00022\u0002\u0011\r\u0011\"\u0001\u00024\u0006!\u0011i\u0011'2+\t\t)\f\u0005\u0003\u00028\u0006uVBAA]\u0015\u0011\tY,a\f\u0002\u0007\u0005\u001cG.\u0003\u0003\u0002@\u0006e&AC!dY\nKg\u000eZ5oO\"A\u00111\u0019\u0001!\u0002\u0013\t),A\u0003B\u00072\u000b\u0004\u0005\u0003\u0004\u0002H\u0002!\t\u0001S\u0001\u0012i\u0016\u001cH/Q2m\u001fB,'/\u0019;j_:\u001c\b\u0006BAc\u0003[Ba!!4\u0001\t\u0003A\u0015\u0001\u0005;fgR$U\r\\1zK\u0012\u001cEn\\:fQ\u0011\tY-!\u001c\t\r\u0005M\u0007\u0001\"\u0001I\u00039!Xm\u001d;G_J\u001cWm\u00117pg\u0016DC!!5\u0002n!1\u0011\u0011\u001c\u0001\u0005\u0002!\u000b!\u0004^3ti6Kg.[7v[J+\u0017/^3tiRKW.Z8viNDC!a6\u0002n!9\u0011q\u001c\u0001\u0005B\u0005\u0005\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0005\u0005\r\bCBA\u0003\u0003+\t)\u000f\u0005\u0003\u0002h\u00065XBAAu\u0015\r\tY\u000fB\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005=\u0018\u0011\u001e\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004\u0002t\u0002!\t\u0001S\u0001\u0019i\u0016\u001cHoQ1mY&sg\t\\5hQR$\u0016.\\3pkR\u001c\b\u0006BAy\u0003[:q!!?\u0003\u0011\u0003\tY0\u0001\u000eBI6Lgn\u00117jK:$\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\u0019\u0003{4a!\u0001\u0002\t\u0002\u0005}8CBA\u007f\u0005\u0003\u00119\u0001E\u0002>\u0005\u0007I1A!\u0002?\u0005\u0019\te.\u001f*fMB\u0019QH!\u0003\n\u0007\t-aH\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004\u0016\u0003{$\tAa\u0004\u0015\u0005\u0005m\b\u0002\u0003B\n\u0003{$\tA!\u0006\u0002-\rDWmY6WC2LG-\u00117uKJ\u001cuN\u001c4jON$2\u0002\u0010B\f\u0005C\u0011iCa\f\u0003@!A!\u0011\u0004B\t\u0001\u0004\u0011Y\"A\u0004{WV#\u0018\u000e\\:\u0011\u0007=\u0011i\"C\u0002\u0003 A\u0011qAW6Vi&d7\u000f\u0003\u0005\u0003$\tE\u0001\u0019\u0001B\u0013\u0003\u001d\u0019XM\u001d<feN\u0004b!!\u0002\u0002\u0016\t\u001d\u0002\u0003BAt\u0005SIAAa\u000b\u0002j\nY1*\u00194lCN+'O^3s\u0011\u0019a#\u0011\u0003a\u0001]!A!\u0011\u0007B\t\u0001\u0004\u0011\u0019$\u0001\bu_BL7MU3t_V\u00148-Z\u0019\u0011\t\tU\"1H\u0007\u0003\u0005oQAA!\u000f\u00020\u000511m\u001c8gS\u001eLAA!\u0010\u00038\tq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007\u0002\u0003B!\u0005#\u0001\rAa\r\u0002\u001dQ|\u0007/[2SKN|WO]2fe!A!QIA\u007f\t\u0003\u00119%\u0001\rdQ\u0016\u001c7.\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jON$r\u0001\u0010B%\u0005\u0017\u0012i\u0005\u0003\u0005\u0003\u001a\t\r\u0003\u0019\u0001B\u000e\u0011!\u0011\u0019Ca\u0011A\u0002\t\u0015\u0002B\u0002\u0017\u0003D\u0001\u0007a\u0006\u0003\u0006\u0003R\u0005u\u0018\u0011!C\u0005\u0005'\n1B]3bIJ+7o\u001c7wKR\tQ\u000f")
public class AdminClientIntegrationTest
extends KafkaServerTestHarness {
    private AdminClient client = null;
    private final int brokerCount;
    private Properties serverConfig;
    private final AclBinding ACL1 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private volatile boolean bitmap$0;

    public static void checkInvalidAlterConfigs(ZkUtils zkUtils, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(zkUtils, seq, adminClient);
    }

    public static void checkValidAlterConfigs(ZkUtils zkUtils, Seq<KafkaServer> seq, AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(zkUtils, seq, adminClient, configResource, configResource2);
    }

    private Properties serverConfig$lzycompute() {
        AdminClientIntegrationTest adminClientIntegrationTest = this;
        synchronized (adminClientIntegrationTest) {
            if (!this.bitmap$0) {
                this.serverConfig = new Properties();
                this.bitmap$0 = true;
            }
            return this.serverConfig;
        }
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    public Properties serverConfig() {
        return this.bitmap$0 ? this.serverConfig : this.serverConfig$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final HashMap config$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.config$1.put((String)key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
            }
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, client, expectedPresent, expectedMissing){
            public static final long serialVersionUID = 0L;
            private final AdminClient client$1;
            private final Seq expectedPresent$1;
            private final Seq expectedMissing$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                java.util.Set topics = (java.util.Set)this.client$1.listTopics().names().get();
                return this.expectedPresent$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                }) && this.expectedMissing$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return !this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                });
            }
            {
                this.client$1 = client$1;
                this.expectedPresent$1 = expectedPresent$1;
                this.expectedMissing$1 = expectedMissing$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for topics";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz) {
        try {
            future.get();
            throw this.fail("Expected CompletableFuture.get to return an exception", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            Assert.assertTrue((String)new StringBuilder().append((Object)"Expected an exception of type ").append((Object)clazz.getName()).append((Object)"; got type ").append((Object)cause.getClass().getName()).toString(), (boolean)clazz.isInstance(cause));
            return;
        }
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(",")).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Node node) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$1) {
                return x$1.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$3) {
                return x$3.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicDescription topic1$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                TopicPartitionInfo partition = (TopicPartitionInfo)this.topic1$1.partitions().get(partitionId);
                Assert.assertEquals((long)partitionId, (long)partition.partition());
                Assert.assertEquals((long)3L, (long)partition.replicas().size());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCreateDeleteTopics$1 $outer;

                    public final void apply(Node replica) {
                        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                        Assert.assertTrue((replica.id() < this.$outer.kafka$api$AdminClientIntegrationTest$$anonfun$$$outer().brokerCount() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$5) {
                        return x$5.id();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).distinct()).size());
                Assert.assertEquals((long)3L, (long)partition.isr().size());
                Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
                Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
            }

            public /* synthetic */ AdminClientIntegrationTest kafka$api$AdminClientIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
            }
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$6) {
                return new NewTopic(x$6, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)this.intercept((Function0)new Serializable(this, nonExistingTopic, results){
            public static final long serialVersionUID = 0L;
            private final String nonExistingTopic$1;
            private final java.util.Map results$1;

            public final TopicDescription apply() {
                return (TopicDescription)((KafkaFuture)this.results$1.get(this.nonExistingTopic$1)).get();
            }
            {
                this.nonExistingTopic$1 = nonExistingTopic$1;
                this.results$1 = results$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkUtils().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Collection nodes = (Collection)this.client().describeCluster().nodes().get();
        String clusterId = (String)this.client().describeCluster().clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).apis().clusterId(), (Object)clusterId);
        Node controller = (Node)this.client().describeCluster().controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).apis().metadataCache().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)Predef$.MODULE$.refArrayOps((Object[])brokers).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1)new Serializable(this, brokers){
            public static final long serialVersionUID = 0L;
            private final String[] brokers$1;

            public final void apply(Node node) {
                String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)Predef$.MODULE$.refArrayOps((Object[])this.brokers$1).contains((Object)hostStr));
            }
            {
                this.brokers$1 = brokers$1;
            }
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 10, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int leaderId;
                    int n = leaderId = tuple2._2$mcI$sp();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(scala.collection.immutable.Map<Object, Object> x$7) {
                return x$7.keys().toSeq();
            }
        });
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$1) {
                return x$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this, topic, partitionsByBroker, logDirInfosByBroker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            public final String topic$1;
            private final scala.collection.immutable.Map partitionsByBroker$1;
            private final java.util.Map logDirInfosByBroker$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, brokerId){
                    public static final long serialVersionUID = 0L;
                    private final int brokerId$1;

                    public final boolean apply(KafkaServer x$8) {
                        return x$8.config().brokerId() == this.brokerId$1;
                    }
                    {
                        this.brokerId$1 = brokerId$1;
                    }
                }).get();
                Seq expectedPartitions = (Seq)this.partitionsByBroker$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
                java.util.Map logDirInfos = (java.util.Map)this.logDirInfosByBroker$1.get(BoxesRunTime.boxToInteger((int)brokerId));
                Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<TopicPartition, DescribeLogDirsResponse.ReplicaInfo> apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$3) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$3;
                        if (tuple2 != null) {
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                            return map;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDescribeLogDirs$1 $outer;

                    public final boolean apply(TopicPartition x$9) {
                        String string = x$9.topic();
                        String string2 = this.$outer.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(TopicPartition x$10) {
                        return x$10.partition();
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    public final KafkaServer server$1;

                    public final void apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$4) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String logDir = (String)tuple2._1();
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1)new Serializable(this, logDir){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeLogDirs$1$$anonfun$apply$mcVI$sp$4 $outer;
                                private final String logDir$1;

                                public final void apply(TopicPartition tp) {
                                    Assert.assertEquals((Object)((Log)this.$outer.server$1.logManager().getLog(tp).get()).dir().getParent(), (Object)this.logDir$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.logDir$1 = logDir$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.server$1 = server$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partitionsByBroker$1 = partitionsByBroker$1;
                this.logDirInfosByBroker$1 = logDirInfosByBroker$1;
            }
        });
        this.client().close();
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 10, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final TopicPartitionReplica apply(Tuple2<Object, Object> x0$5) {
                Tuple2<Object, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    int brokerId = tuple2._2$mcI$sp();
                    TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(this.topic$2, partition, brokerId);
                    return topicPartitionReplica;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> x0$6) {
                Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
                    DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
                    KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, topicPartitionReplica){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartitionReplica topicPartitionReplica$1;

                        public final boolean apply(KafkaServer x$11) {
                            return x$11.config().brokerId() == this.topicPartitionReplica$1.brokerId();
                        }
                        {
                            this.topicPartitionReplica$1 = topicPartitionReplica$1;
                        }
                    }).get();
                    TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
                    Assert.assertEquals((Object)((Log)server.logManager().getLog(tp).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.client().close();
    }

    @Test
    public void testAlterReplicaLogDirsBeforeTopicCreation() {
        AdminClient adminClient = AdminClient.create(this.createConfig());
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map replicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(Random$.MODULE$.nextInt(2))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)replicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(KafkaFuture<Void> future) {
                try {
                    future.get();
                    throw this.$outer.fail("Future should fail with ReplicaNotAvailableException", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((boolean)(executionException.getCause() instanceof ReplicaNotAvailableException));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, this.brokerCount(), (Seq<KafkaServer>)this.servers(), new Properties());
        this.servers().foreach((Function1)new Serializable(this, topic, tp, replicaAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final TopicPartition tp$1;
            private final scala.collection.immutable.Map replicaAssignment$1;

            public final void apply(KafkaServer server) {
                String logDir = ((Log)server.logManager().getLog(this.tp$1).get()).dir().getParent();
                Assert.assertEquals((Object)this.replicaAssignment$1.apply((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.replicaAssignment$1 = replicaAssignment$1;
            }
        });
        adminClient.close();
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertTrue((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertTrue((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertTrue((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.zkUtils(), (Seq<KafkaServer>)this.servers(), this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        String topic2 = "create-partitions-topic-2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 2, (Seq<KafkaServer>)this.servers(), new Properties());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$12) {
                return x$12.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$13) {
                return x$13.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1)new Serializable(this, topic1, topic2, alterResult, altered, newPartition2Assignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String topic1$2;
            private final String topic2$1;
            private final ObjectRef alterResult$1;
            private final ObjectRef altered$1;
            private final java.util.List newPartition2Assignments$1;

            public final void apply(CreatePartitionsOptions option) {
                String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is a decrease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                    this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
                    try {
                        ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when requesting a noop"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
                    }
                    catch (ExecutionException executionException2) {
                        Object object;
                        Object object2;
                        Assert.assertTrue((String)desc, (boolean)(executionException2.getCause() instanceof InvalidPartitionsException));
                        Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException2.getCause().getMessage());
                        Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)this.newPartition2Assignments$1))}))).asJava(), option);
                        try {
                            object2 = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                        }
                        catch (ExecutionException executionException3) {
                            Assert.assertTrue((String)desc, (boolean)(executionException3.getCause() instanceof InvalidPartitionsException));
                            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException3.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                            object2 = BoxedUnit.UNIT;
                        }
                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                        try {
                            object = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                        }
                        catch (ExecutionException executionException4) {
                            Assert.assertTrue((String)desc, (boolean)(executionException4.getCause() instanceof InvalidPartitionsException));
                            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException4.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                            object = BoxedUnit.UNIT;
                        }
                        String unknownTopic = "an-unknown-topic";
                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                        try {
                            ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(unknownTopic)).get();
                            throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidTopicException when using an unknown topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
                        }
                        catch (ExecutionException executionException5) {
                            Assert.assertTrue((String)desc, (boolean)(executionException5.getCause() instanceof UnknownTopicOrPartitionException));
                            Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)executionException5.getCause().getMessage());
                            this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                            try {
                                this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is invalid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
                            }
                            catch (ExecutionException executionException6) {
                                Assert.assertTrue((String)desc, (boolean)(executionException6.getCause() instanceof InvalidPartitionsException));
                                Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)executionException6.getCause().getMessage());
                                Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                try {
                                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                    throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when #brokers != replication factor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                                }
                                catch (ExecutionException executionException7) {
                                    Assert.assertTrue((String)desc, (boolean)(executionException7.getCause() instanceof InvalidReplicaAssignmentException));
                                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)executionException7.getCause().getMessage());
                                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                    this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                    try {
                                        this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
                                    }
                                    catch (ExecutionException executionException8) {
                                        Assert.assertTrue((String)desc, (boolean)(executionException8.getCause() instanceof InvalidReplicaAssignmentException));
                                        Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)executionException8.getCause().getMessage());
                                        Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                        try {
                                            this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                            throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
                                        }
                                        catch (ExecutionException executionException9) {
                                            Assert.assertTrue((String)desc, (boolean)(executionException9.getCause() instanceof InvalidReplicaAssignmentException));
                                            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)executionException9.getCause().getMessage());
                                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                            this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                            try {
                                                this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
                                            }
                                            catch (ExecutionException executionException10) {
                                                Assert.assertTrue((String)desc, (boolean)(executionException10.getCause() instanceof InvalidReplicaAssignmentException));
                                                Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)executionException10.getCause().getMessage());
                                                Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                                                try {
                                                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                    throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
                                                }
                                                catch (ExecutionException executionException11) {
                                                    Assert.assertTrue((String)desc, (boolean)(executionException11.getCause() instanceof InvalidReplicaAssignmentException));
                                                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)executionException11.getCause().getMessage());
                                                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                    this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                                                    try {
                                                        this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
                                                    }
                                                    catch (ExecutionException executionException12) {
                                                        Assert.assertTrue((String)desc, (boolean)(executionException12.getCause() instanceof InvalidReplicaAssignmentException));
                                                        Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)executionException12.getCause().getMessage());
                                                        Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.<T>emptyList()))}))).asJava(), option);
                                                        try {
                                                            this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                            throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
                                                        }
                                                        catch (ExecutionException executionException13) {
                                                            Assert.assertTrue((String)desc, (boolean)(executionException13.getCause() instanceof InvalidReplicaAssignmentException));
                                                            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)executionException13.getCause().getMessage());
                                                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                            return;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$2 = topic1$2;
                this.topic2$1 = topic2$1;
                this.alterResult$1 = alterResult$1;
                this.altered$1 = altered$1;
                this.newPartition2Assignments$1 = newPartition2Assignments$1;
            }
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            throw this.fail("Expect InvalidTopicException when the topic is queued for deletion", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)executionException.getCause().getMessage());
            return;
        }
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkUtils(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class);
        this.client().close();
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$14) {
                return new NewTopic(x$14, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(2L, TimeUnit.HOURS);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future2, TimeoutException.class);
        future.get();
        this.client().close(30L, TimeUnit.MINUTES);
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$15) {
                return new NewTopic(x$15, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(0L, TimeUnit.MILLISECONDS);
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$16) {
                return new NewTopic(x$16, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
        this.client().close();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$20 = this.brokerCount();
        String x$21 = this.zkConnect();
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        int x$25 = 2;
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$20, x$21, x$26, x$27, (Option<SecurityProtocol>)x$22, x$23, x$24, x$28, x$29, x$30, x$31, x$32, x$25);
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
                config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
                config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.$outer.listenerName().value());
                config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), this.$outer.securityProtocol().name})));
                config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
                return config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? BoxedUnit.UNIT : config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(Properties x$17) {
                Implicits$.MODULE$.PropertiesOps(x$17).$plus$plus$eq(this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Seq)cfgs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        KafkaAdminClient client = KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory);
        KafkaFuture future = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$18) {
                return new NewTopic(x$18, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        KafkaFuture future2 = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$19) {
                return new NewTopic(x$19, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        client.close();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    public final int kafka$api$AdminClientIntegrationTest$$numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    public AdminClientIntegrationTest() {
        this.brokerCount = 3;
    }
}

