/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u000f\t\u0019\u0012\t\u001a<feRL7/\u001a\"s_.,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0003u.L!!\u0004\u0006\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007I\u0011A\u000b\u0002\u000fM,'O^3sgV\ta\u0003E\u0002\u0018=\u0001j\u0011\u0001\u0007\u0006\u00033i\tq!\\;uC\ndWM\u0003\u0002\u001c9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003u\tQa]2bY\u0006L!a\b\r\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003%\u0005J!A\t\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u0011M,'O^3sg\u0002BqA\n\u0001C\u0002\u0013\u0005q%\u0001\u0005ce>\\WM]%e+\u0005A\u0003CA\u0015+\u001b\u0005a\u0012BA\u0016\u001d\u0005\rIe\u000e\u001e\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003\"B\u0018\u0001\t\u0003\u0002\u0014\u0001\u0003;fCJ$un\u001e8\u0015\u0003E\u0002\"!\u000b\u001a\n\u0005Mb\"\u0001B+oSRD#AL\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!\u00026v]&$(\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=o\t)\u0011I\u001a;fe\")a\b\u0001C\u0001a\u00051C/Z:u\u0005J|7.\u001a:BIZ,'\u000f^5tK\"{7\u000f\u001e(b[\u0016\fe\u000e\u001a)peR$vNW&)\u0005u\u0002\u0005C\u0001\u001cB\u0013\t\u0011uG\u0001\u0003UKN$\b\"\u0002#\u0001\t\u0003\u0001\u0014\u0001\t;fgR\u0014%o\\6fe\u0006#g/\u001a:uSN,G*[:uK:,'o\u001d+p5.CQA\u0012\u0001\u0005\u0002A\nq\u0006^3ti\n\u0013xn[3s\u0003\u00124XM\u001d;jg\u0016d\u0015n\u001d;f]\u0016\u00148oV5uQ\u000e+8\u000f^8n\u001d\u0006lWm\u001d+p5.\u0003")
public class AdvertiseBrokerTest
extends ZooKeeperTestHarness {
    private final ArrayBuffer<KafkaServer> servers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int brokerId;

    public ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
    }

    @Test
    public void testBrokerAdvertiseHostNameAndPortToZK() {
        String advertisedHostName = "routable-host1";
        int advertisedPort = 1234;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("advertised.host.name", advertisedHostName);
        props.put("advertised.port", ((Object)BoxesRunTime.boxToInteger((int)advertisedPort)).toString());
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkUtils().getBrokerInfo(this.brokerId()).get();
        Assert.assertEquals((long)1L, (long)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)advertisedHostName, (Object)endpoint.host());
        Assert.assertEquals((long)advertisedPort, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName().value());
    }

    public void testBrokerAdvertiseListenersToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("advertised.listeners", "PLAINTEXT://routable-listener:3334");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkUtils().getBrokerInfo(this.brokerId()).get();
        Assert.assertEquals((long)1L, (long)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)"routable-listener", (Object)endpoint.host());
        Assert.assertEquals((long)3334L, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName());
    }

    public void testBrokerAdvertiseListenersWithCustomNamesToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("listeners", "INTERNAL://:0,EXTERNAL://:0");
        props.put("advertised.listeners", "EXTERNAL://external-listener:9999,INTERNAL://internal-listener:10999");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,EXTERNAL:PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkUtils().getBrokerInfo(this.brokerId()).get();
        Assert.assertEquals((long)1L, (long)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)"external-listener", (Object)endpoint.host());
        Assert.assertEquals((long)9999L, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)"EXTERNAL", (Object)endpoint.listenerName().value());
        EndPoint endpoint2 = (EndPoint)brokerInfo.endPoints().apply(1);
        Assert.assertEquals((Object)"internal-listener", (Object)endpoint2.host());
        Assert.assertEquals((long)10999L, (long)endpoint2.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)"INTERNAL", (Object)endpoint2.listenerName());
    }

    public AdvertiseBrokerTest() {
        this.brokerId = 0;
    }
}

