/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tue\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\u0013E,x\u000e^1UsB,W#A\u0019\u0011\u0005a\u0011\u0014BA\u001a\u0003\u0005%\tVo\u001c;b)f\u0004X\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0003)\tXo\u001c;b)f\u0004X\r\t\u0005\to\u0001\u0011)\u0019!C\u0005q\u0005!A/[7f+\u0005I\u0004C\u0001\u001e=\u001b\u0005Y$BA\t$\u0013\ti4H\u0001\u0003US6,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000bQLW.\u001a\u0011\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000b\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005\r3eBA\u0005E\u0013\t)%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#\u000b\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0019a\u0014N\\5u}Q1A*\u0014(P!F\u0003\"\u0001\u0007\u0001\t\u000bUI\u0005\u0019A\f\t\u000byI\u0005\u0019\u0001\u0011\t\u000b=J\u0005\u0019A\u0019\t\u000b]J\u0005\u0019A\u001d\t\u000b\u0005K\u0005\u0019\u0001\"\t\u000fM\u0003!\u0019!C\u0005)\u0006yqN^3se&$G-\u001a8Rk>$\u0018-F\u0001V!\u00111Vl\u00182\u000e\u0003]S!\u0001W-\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002[7\u0006!Q\u000f^5m\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX,\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002\u0019A&\u0011\u0011M\u0001\u0002\b#V|G/Y%e!\t\t3-\u0003\u0002eE\t)\u0011+^8uC\"1a\r\u0001Q\u0001\nU\u000b\u0001c\u001c<feJLG\rZ3o#V|G/\u0019\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006I2\u000f^1uS\u000e\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b+\u0005\u0011\u0007BB6\u0001A\u0003%!-\u0001\u000eti\u0006$\u0018nY\"p]\u001aLwm\u00117jK:$\u0018\nZ)v_R\f\u0007\u0005C\u0004n\u0001\u0001\u0007I\u0011\u00028\u0002#E,x\u000e^1UsB,7/\u00128bE2,G-F\u0001p!\tI\u0001/\u0003\u0002r\u0015\t\u0019\u0011J\u001c;\t\u000fM\u0004\u0001\u0019!C\u0005i\u0006)\u0012/^8uCRK\b/Z:F]\u0006\u0014G.\u001a3`I\u0015\fHCA;y!\tIa/\u0003\u0002x\u0015\t!QK\\5u\u0011\u001dI(/!AA\u0002=\f1\u0001\u001f\u00132\u0011\u0019Y\b\u0001)Q\u0005_\u0006\u0011\u0012/^8uCRK\b/Z:F]\u0006\u0014G.\u001a3!Q\tQX\u0010\u0005\u0002\n}&\u0011qP\u0003\u0002\tm>d\u0017\r^5mK\"I\u00111\u0001\u0001C\u0002\u0013%\u0011QA\u0001\u0005Y>\u001c7.\u0006\u0002\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e]\u000bQ\u0001\\8dWNLA!!\u0005\u0002\f\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7\u000e\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\u0004\u0003\u0015awnY6!\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\"\u0001\u0006eK2\f\u00170U;fk\u0016,\"!!\b\u0011\u000bY\u000by\"a\t\n\u0007\u0005\u0005rK\u0001\u0006EK2\f\u00170U;fk\u0016\u00042\u0001GA\u0013\u0013\r\t9C\u0001\u0002\u0012)\"\u0014x\u000e\u001e;mK\u0012\u0014Vm\u001d9p]N,\u0007\u0002CA\u0016\u0001\u0001\u0006I!!\b\u0002\u0017\u0011,G.Y=Rk\u0016,X\r\t\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003c\tab]3og>\u0014\u0018iY2fgN|'/\u0006\u0002\u00024A\u0019\u0001$!\u000e\n\u0007\u0005]\"A\u0001\u0007TK:\u001cxN]!dG\u0016\u001c8\u000f\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001a\u0003=\u0019XM\\:pe\u0006\u001b7-Z:t_J\u0004\u0003BCA \u0001\t\u0007I\u0011\u0001\u0002\u0002B\u00051B\u000f\u001b:piRdW\r\u001a*fcV,7\u000f\u001e*fCB,'/\u0006\u0002\u0002DA!\u0011QIA$\u001b\u0005\u0001aABA%\u0001\u0001\tYE\u0001\fUQJ|G\u000f\u001e7fIJ+\u0017/^3tiJ+\u0017\r]3s'\u0011\t9%!\u0014\u0011\u0007=\ty%C\u0002\u0002RA\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"Y\u0011\u0011DA$\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t9&a\u0012\u0003\u0002\u0003\u0006IAQ\u0001\u0007aJ,g-\u001b=\t\u000f)\u000b9\u0005\"\u0001\u0002\\Q1\u00111IA/\u0003?B\u0001\"!\u0007\u0002Z\u0001\u0007\u0011Q\u0004\u0005\b\u0003/\nI\u00061\u0001C\u0011!\t\u0019'a\u0012\u0005B\u0005\u0015\u0014A\u00023p/>\u00148\u000eF\u0001v\u0011!\tI\u0007\u0001Q\u0001\n\u0005\r\u0013a\u0006;ie>$H\u000f\\3e%\u0016\fX/Z:u%\u0016\f\u0007/\u001a:!\u0011%\ti\u0007\u0001b\u0001\n\u0013\ty'\u0001\teK2\f\u00170U;fk\u0016\u001cVM\\:peV\u0011\u0011\u0011\u000f\t\u0004C\u0005M\u0014bAA;E\t11+\u001a8t_JD\u0001\"!\u001f\u0001A\u0003%\u0011\u0011O\u0001\u0012I\u0016d\u0017-_)vKV,7+\u001a8t_J\u0004\u0003bBA?\u0001\u0011%\u0011QM\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0003\u0003\u0003A\u0011AAB\u00035\tXo\u001c;bg\u0016s\u0017M\u00197fIV\u0011\u0011Q\u0011\t\u0004\u0013\u0005\u001d\u0015bAAE\u0015\t9!i\\8mK\u0006t\u0007bBAG\u0001\u0011\u0005\u0011qR\u0001\u0017[\u0006L(-\u001a*fG>\u0014H-\u00118e)\"\u0014x\u000e\u001e;mKRIq.!%\u0002\u0016\u0006e\u00151\u0015\u0005\b\u0003'\u000bY\t1\u0001C\u00035\u0019\u0018M\\5uSj,G-V:fe\"9\u0011qSAF\u0001\u0004\u0011\u0015\u0001C2mS\u0016tG/\u00133\t\u0011\u0005m\u00151\u0012a\u0001\u0003;\u000bQA^1mk\u0016\u00042!CAP\u0013\r\t\tK\u0003\u0002\u0007\t>,(\r\\3\t\u0011\u0005\u0015\u00161\u0012a\u0001\u0003O\u000b\u0001bY1mY\n\f7m\u001b\t\u0006\u0013\u0005%v.^\u0005\u0004\u0003WS!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u000b\u0011E]3d_J$\u0017I\u001c3UQJ|G\u000f\u001e7f\u001f:\fVo\u001c;b-&|G.\u0019;j_:$ra\\AZ\u0003{\u000by\f\u0003\u0005\u00026\u00065\u0006\u0019AA\\\u00035\u0019G.[3oiN+gn]8sgB\u0019\u0001$!/\n\u0007\u0005m&AA\u0007DY&,g\u000e^*f]N|'o\u001d\u0005\t\u00037\u000bi\u000b1\u0001\u0002\u001e\"A\u0011QUAW\u0001\u0004\t9\u000bC\u0004\u0002D\u0002!\t!!2\u0002!I,7m\u001c:e\u001d>$\u0006N]8ui2,G#B;\u0002H\u0006%\u0007\u0002CA[\u0003\u0003\u0004\r!a.\t\u0011\u0005m\u0015\u0011\u0019a\u0001\u0003;Cq!!4\u0001\t\u0013\ty-A\u0006rk>$\u0018-\u00128uSRLH\u0003CAi\u0003/\fI.a7\u0011\u0007a\t\u0019.C\u0002\u0002V\n\u00111\"U;pi\u0006,e\u000e^5us\"9\u00111SAf\u0001\u0004\u0011\u0005bBAL\u0003\u0017\u0004\rA\u0011\u0005\b\u0003;\fY\r1\u0001C\u0003E\u0019\u0018M\\5uSj,Gm\u00117jK:$\u0018\n\u001a\u0005\b\u0003C\u0004A\u0011BAr\u0003\t\nXo\u001c;b\u000b:$\u0018\u000e^=XSRDW*\u001e7uSBdW-U;pi\u0006dUM^3mgRA\u0011\u0011[As\u0003O\fI\u000fC\u0004\u0002\u0014\u0006}\u0007\u0019\u0001\"\t\u000f\u0005]\u0015q\u001ca\u0001\u0005\"9\u00111^Ap\u0001\u0004\u0011\u0015!E:b]&$\u0018N_3s\u00072LWM\u001c;JI\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\u0018!B9v_R\fG#\u00022\u0002t\u0006]\bbBA{\u0003[\u0004\rAQ\u0001\u0005kN,'\u000fC\u0004\u0002\u0018\u00065\b\u0019\u0001\"\t\u000f\u0005m\b\u0001\"\u0005\u0002~\u0006aA\u000f\u001b:piRdW\rV5nKR1\u0011q B\u0003\u0005\u001f\u00012!\u0003B\u0001\u0013\r\u0011\u0019A\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0003\b\u0005e\b\u0019\u0001B\u0005\u00031\u0019G.[3oi6+GO]5d!\r\t#1B\u0005\u0004\u0005\u001b\u0011#aC&bM.\fW*\u001a;sS\u000eDq!FA}\u0001\u0004\u0011\t\u0002E\u0002\"\u0005'I1A!\u0006#\u00051iU\r\u001e:jG\u000e{gNZ5h\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057\t\u0001#\\3bgV\u0014\u0018M\u00197f\u0003N\u0014\u0016\r^3\u0015\r\tu!\u0011\u0006B\u001b!\u0011\u0011yB!\n\u000e\u0005\t\u0005\"b\u0001B\u0012E\u0005)1\u000f^1ug&!!q\u0005B\u0011\u0005\u0011\u0011\u0016\r^3\t\u0011\t-\"q\u0003a\u0001\u0005[\tAA\\1nKB!!q\u0006B\u0019\u001b\u0005\u0019\u0013b\u0001B\u001aG\tQQ*\u001a;sS\u000et\u0015-\\3\t\u0011\t]\"q\u0003a\u0001\u0005s\t!\"\\3bgV\u0014\u0018M\u00197f!\r\t#1H\u0005\u0004\u0005{\u0011#AC'fCN,(/\u00192mK\"9!\u0011\t\u0001\u0005\u0002\t\r\u0013aF4fi>\u00138I]3bi\u0016\fVo\u001c;b'\u0016t7o\u001c:t)\u0019\t9L!\u0012\u0003H!9\u00111\u0013B \u0001\u0004\u0011\u0005bBAL\u0005\u007f\u0001\rA\u0011\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0003e9W\r\u001e+ie>$H\u000f\\3US6,7+\u001a8t_Jt\u0015-\\3\u0015\u0007\t\u0013y\u0005C\u0004\u0003R\t%\u0003\u0019A0\u0002\u000fE,x\u000e^1JI\"9!Q\u000b\u0001\u0005\n\t]\u0013AE4fiF+x\u000e^1TK:\u001cxN\u001d(b[\u0016$2A\u0011B-\u0011\u001d\u0011\tFa\u0015A\u0002}CqA!\u0018\u0001\t#\u0011y&\u0001\u000bhKR\fVo\u001c;b\u001b\u0016$(/[2D_:4\u0017n\u001a\u000b\u0005\u0005#\u0011\t\u0007C\u0004\u0002p\nm\u0003\u0019\u00012\t\u000f\t\u0015\u0004\u0001\"\u0005\u0003h\u0005\tr-\u001a;Pe\u000e\u0013X-\u0019;f'\u0016t7o\u001c:\u0015\r\u0005E$\u0011\u000eB7\u0011\u001d\u0011YGa\u0019A\u0002\t\u000b!b]3og>\u0014h*Y7f\u0011!\u0011yGa\u0019A\u0002\t5\u0012AC7fiJL7MT1nK\"9!1\u000f\u0001\u0005\u0002\tU\u0014aC;qI\u0006$X-U;pi\u0006$\u0012\"\u001eB<\u0005\u007f\u0012\tIa!\t\u0011\u0005M%\u0011\u000fa\u0001\u0005s\u0002B!\u0003B>\u0005&\u0019!Q\u0010\u0006\u0003\r=\u0003H/[8o\u0011!\t9J!\u001dA\u0002\te\u0004\u0002CAo\u0005c\u0002\rA!\u001f\t\u0011\u0005=(\u0011\u000fa\u0001\u0005\u000b\u0003B!\u0003B>E\"9!\u0011\u0012\u0001\u0005\u0012\t-\u0015\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0004\u0003.\t5%q\u0012\u0005\b\u0003'\u00139\t1\u0001C\u0011\u001d\t9Ja\"A\u0002\tCqAa%\u0001\t\u0013\u0011)*\u0001\nuQJ|G\u000f\u001e7f\u001b\u0016$(/[2OC6,G\u0003\u0002B\u0017\u0005/C\u0001\"!4\u0003\u0012\u0002\u0007\u0011\u0011\u001b\u0005\b\u00057\u0003A\u0011AA3\u0003!\u0019\b.\u001e;e_^t\u0007")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$quotaType;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private volatile int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$quotaType() {
        return this.kafka$server$ClientQuotaManager$$quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    private void start() {
        this.throttledRequestReaper().start();
    }

    public boolean quotasEnabled() {
        return this.quotaTypesEnabled() != QuotaTypes$.MODULE$.NoQuotas();
    }

    public int maybeRecordAndThrottle(String sanitizedUser, String clientId, double value2, Function1<Object, BoxedUnit> callback) {
        int n;
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(sanitizedUser, clientId);
            n = this.recordAndThrottleOnQuotaViolation(clientSensors, value2, callback);
        } else {
            int throttleTimeMs = 0;
            callback.apply$mcVI$sp(throttleTimeMs);
            n = throttleTimeMs;
        }
        return n;
    }

    public int recordAndThrottleOnQuotaViolation(ClientSensors clientSensors, double value2, Function1<Object, BoxedUnit> callback) {
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record(value2);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            QuotaEntity clientQuotaEntity = clientSensors.quotaEntity();
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = (int)this.throttleTime(clientMetric, this.getQuotaMetricConfig(clientQuotaEntity.quota()));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    public void recordNoThrottle(ClientSensors clientSensors, double value2) {
        clientSensors.quotaSensor().record(value2, this.time().milliseconds(), false);
    }

    public QuotaEntity kafka$server$ClientQuotaManager$$quotaEntity(String sanitizedUser, String clientId, String sanitizedClientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizedClientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, sanitizedClientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizedClientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizedClientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, sanitizedClientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId, sanitizedClientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId, String sanitizerClientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, sanitizerClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.kafka$server$ClientQuotaManager$$quotaEntity(Sanitizer.sanitize((String)user), clientId, Sanitizer.sanitize((String)clientId)).quota();
    }

    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Measurable measurable2 = measurable;
        if (measurable2 instanceof Rate) {
            Rate rate;
            Rate rate2 = rate = (Rate)measurable2;
            return rate2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
    }

    public ClientSensors getOrCreateQuotaSensors(String sanitizedUser, String clientId) {
        String sanitizedClientId = Sanitizer.sanitize((String)clientId);
        QuotaEntity clientQuotaEntity = this.kafka$server$ClientQuotaManager$$quotaEntity(sanitizedUser, clientId, sanitizedClientId);
        return new ClientSensors(clientQuotaEntity, this.sensorAccessor().getOrCreate(this.getQuotaSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricName apply() {
                return this.$outer.clientRateMetricName(this.clientQuotaEntity$1.sanitizedUser(), this.clientQuotaEntity$1.clientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<Option<MetricConfig>>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final Some<MetricConfig> apply() {
                return new Some((Object)this.$outer.getQuotaMetricConfig(this.clientQuotaEntity$1.quota()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rate apply() {
                return new Rate();
            }
        }), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricName apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$throttleMetricName(this.clientQuotaEntity$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<Option<MetricConfig>>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Avg apply() {
                return new Avg();
            }
        }));
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "ThrottleTime-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    public MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor getOrCreateSensor(String sensorName, MetricName metricName) {
        return this.sensorAccessor().getOrCreate(sensorName, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final MetricName metricName$1;

            public final MetricName apply() {
                return this.metricName$1;
            }
            {
                this.metricName$1 = metricName$1;
            }
        }, (Function0<Option<MetricConfig>>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rate apply() {
                return new Rate();
            }
        });
    }

    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<String> sanitizedClientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            Option<String> option;
            block13: {
                Option<String> option2;
                block17: {
                    Option<Quota> option3;
                    block25: {
                        String clientIdInfo;
                        String userInfo;
                        block24: {
                            Quota quota2;
                            QuotaId quotaId;
                            block18: {
                                Tuple2 tuple2;
                                block23: {
                                    block20: {
                                        block22: {
                                            block21: {
                                                block19: {
                                                    String string;
                                                    block15: {
                                                        block16: {
                                                            Some some;
                                                            boolean bl;
                                                            block14: {
                                                                String string2;
                                                                block11: {
                                                                    block12: {
                                                                        Some some2;
                                                                        boolean bl2;
                                                                        block10: {
                                                                            quotaId = new QuotaId(sanitizedUser, clientId, sanitizedClientId);
                                                                            bl2 = false;
                                                                            some2 = null;
                                                                            option = sanitizedUser;
                                                                            if (!(option instanceof Some)) break block10;
                                                                            bl2 = true;
                                                                            some2 = (Some)option;
                                                                            String string3 = (String)some2.x();
                                                                            String string4 = ConfigEntityName$.MODULE$.Default();
                                                                            String string5 = string3;
                                                                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block10;
                                                                            string2 = "default user ";
                                                                            break block11;
                                                                        }
                                                                        if (!bl2) break block12;
                                                                        String user = (String)some2.x();
                                                                        string2 = new StringBuilder().append((Object)"user ").append((Object)user).append((Object)" ").toString();
                                                                        break block11;
                                                                    }
                                                                    if (!None$.MODULE$.equals(option)) break block13;
                                                                    string2 = "";
                                                                }
                                                                userInfo = string2;
                                                                bl = false;
                                                                some = null;
                                                                option2 = clientId;
                                                                if (!(option2 instanceof Some)) break block14;
                                                                bl = true;
                                                                some = (Some)option2;
                                                                String string6 = (String)some.x();
                                                                String string7 = ConfigEntityName$.MODULE$.Default();
                                                                String string8 = string6;
                                                                if (string7 != null ? !string7.equals(string8) : string8 != null) break block14;
                                                                string = "default client-id";
                                                                break block15;
                                                            }
                                                            if (!bl) break block16;
                                                            String id = (String)some.x();
                                                            string = new StringBuilder().append((Object)"client-id ").append((Object)id).toString();
                                                            break block15;
                                                        }
                                                        if (!None$.MODULE$.equals(option2)) break block17;
                                                        string = "";
                                                    }
                                                    clientIdInfo = string;
                                                    option3 = quota;
                                                    if (!(option3 instanceof Some)) break block18;
                                                    Some some = (Some)option3;
                                                    Quota newQuota = (Quota)some.x();
                                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ".bound}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo, newQuota})));
                                                    this.overriddenQuota().put(quotaId, newQuota);
                                                    tuple2 = new Tuple2(sanitizedUser, clientId);
                                                    if (tuple2 == null) break block19;
                                                    Option option4 = (Option)tuple2._1();
                                                    Option option5 = (Option)tuple2._2();
                                                    if (!(option4 instanceof Some) || !(option5 instanceof Some)) break block19;
                                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block20;
                                                }
                                                if (tuple2 == null) break block21;
                                                Option option6 = (Option)tuple2._1();
                                                Option option7 = (Option)tuple2._2();
                                                if (!(option6 instanceof Some) || !None$.MODULE$.equals(option7)) break block21;
                                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block20;
                                            }
                                            if (tuple2 == null) break block22;
                                            Option option8 = (Option)tuple2._1();
                                            Option option9 = (Option)tuple2._2();
                                            if (!None$.MODULE$.equals(option8) || !(option9 instanceof Some)) break block22;
                                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block20;
                                        }
                                        if (tuple2 == null) break block23;
                                        Option option10 = (Option)tuple2._1();
                                        Option option11 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option10) || !None$.MODULE$.equals(option11)) break block23;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    quota2 = BoxedUnit.UNIT;
                                    break block24;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            if (!None$.MODULE$.equals(option3)) break block25;
                            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo})));
                            quota2 = this.overriddenQuota().remove(quotaId);
                        }
                        MetricName quotaMetricName = this.clientRateMetricName((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), (String)clientId.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }));
                        Map allMetrics = this.metrics().metrics();
                        int n = this.quotaTypesEnabled();
                        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == n ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n));
                        boolean bl3 = bl ? !sanitizedUser.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$1) {
                                String string = x$1;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() && !clientId.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$2) {
                                String string = x$2;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() : false;
                        boolean singleUpdate = bl3;
                        if (singleUpdate) {
                            KafkaMetric metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                            if (metric != null) {
                                QuotaEntity metricConfigEntity = this.kafka$server$ClientQuotaManager$$quotaEntity((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (String)clientId.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (String)sanitizedClientId.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }));
                                Quota newQuota = metricConfigEntity.quota();
                                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                metric.config(this.getQuotaMetricConfig(newQuota));
                            }
                        } else {
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allMetrics).asScala()).filterKeys((Function1)new Serializable(this, quotaMetricName){
                                public static final long serialVersionUID = 0L;
                                private final MetricName quotaMetricName$1;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(MetricName n) {
                                    String string = n.name();
                                    String string2 = this.quotaMetricName$1.name();
                                    if (string == null) {
                                        if (string2 != null) {
                                            return false;
                                        }
                                    } else if (!string.equals(string2)) return false;
                                    String string3 = n.group();
                                    String string4 = this.quotaMetricName$1.group();
                                    if (string3 == null) {
                                        if (string4 == null) return true;
                                        return false;
                                    } else {
                                        if (!string3.equals(string4)) return false;
                                        return true;
                                    }
                                }
                                {
                                    this.quotaMetricName$1 = quotaMetricName$1;
                                }
                            }).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ClientQuotaManager $outer;

                                public final void apply(Tuple2<MetricName, KafkaMetric> x0$1) {
                                    Tuple2<MetricName, KafkaMetric> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        BoxedUnit boxedUnit;
                                        MetricName metricName = (MetricName)tuple2._1();
                                        KafkaMetric metric = (KafkaMetric)tuple2._2();
                                        String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
                                        String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
                                        QuotaEntity metricConfigEntity = this.$outer.kafka$server$ClientQuotaManager$$quotaEntity(userTag, clientIdTag, Sanitizer.sanitize((String)clientIdTag));
                                        Quota quota = metricConfigEntity.quota();
                                        Quota quota2 = metric.config().quota();
                                        if (!(quota != null ? !quota.equals(quota2) : quota2 != null)) {
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            Quota newQuota = metricConfigEntity.quota();
                                            this.$outer.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                            metric.config(this.$outer.getQuotaMetricConfig(newQuota));
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        return;
                    }
                    throw new MatchError(option3);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    public MetricName kafka$server$ClientQuotaManager$$throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time, String threadNamePrefix) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$quotaType = quotaType;
        this.time = time;
        Logging$class.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess(this.lock(), metrics);
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue(), threadNamePrefix);
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)quotaType), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", quotaType.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
        this.start();
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
            if (response != null) {
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)new Serializable(this, response){
                    public static final long serialVersionUID = 0L;
                    private final ThrottledResponse response$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Response throttled for: ").append((Object)BoxesRunTime.boxToInteger((int)this.response$1.throttleTimeMs())).append((Object)" ms").toString();
                    }
                    {
                        this.response$1 = response$1;
                    }
                });
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue, String prefix) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ThrottledRequestReaper-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, $outer.kafka$server$ClientQuotaManager$$quotaType()})), false);
        }
    }
}

